# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""Test Suite for bzr-explorer"""

from bzrlib.tests import (
    TestCase,
    TestCaseInTempDir,
    TestCaseWithTransport,
    )
from bzrlib import trace


class TestCaseWithQt(TestCaseWithTransport):
    """Many GUI functions require a QApplication to be running.

    This class ensures a QtApplication is running during setUp.
    """

    _app = None

    def setUp(self):
        super(TestCaseWithQt, self).setUp()
        self.ensureApp()
        self.logger = self.createLogger()

    def ensureApp(self):
        if TestCaseWithQt._app is None:
            from PyQt4 import QtGui
            TestCaseWithQt._app = QtGui.QApplication(['bzr-explorer-test-app'])
            # It seems we can leave it running.

    def createLogger(self, *args):
        from PyQt4 import QtCore

        class ConnectionLogger(QtCore.QObject):

            def __init__(self, *args):
                QtCore.QObject.__init__(self, *args)
                # A log of actions that have occurrred
                self.log = []

            def createNamedSlot(self, signal_name):
                """Create a new slot, which tracks the signal name given.

                :param signal_name: The name of the signal we are connecting
                :return: A function that can be used as a signal to this logger.
                """
                def named_slot(*args):
                    self.log.append((signal_name,) + args)
                return named_slot

            def connectToNamedSlot(self, signal, source):
                """Create a new named slot, and connect the signal from source.

                :param signal: The value to pass to QtCore.SIGNAL, this will
                    also be the name logged when the signal is activated.
                :param source: An object that can generate the given signal.
                """
                slot = self.createNamedSlot(signal)
                QtCore.QObject.connect(source, QtCore.SIGNAL(signal), slot)

        return ConnectionLogger(*args)


def load_tests(basic_tests, module, loader):
    suite = loader.suiteClass()
    suite.addTests(basic_tests)

    mod_names = [__name__ + '.' + x for x in [
        'test_test_suite',
        'test_welcome',
    ]]
    for m in mod_names:
        try:
            suite.addTests(loader.loadTestsFromModuleName(m))
        except ImportError, e:
            if str(e).endswith('PyQt4'):
                trace.note('Explorer: skip module %s '
                    'because PyQt4 is not installed' % m)
            else:
                raise
    return suite
