// Dear Emacs, please note this is a -*-text-*- file. Thank you.
//
// Caudium - An extensible World Wide Web server
// Copyright  2000-2001 The Caudium Group
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: language.es,v 1.7.2.1 2001/07/10 17:49:34 kiwi Exp $
//

//
// The language template file format
// ---------------------------------
//
// Message definitions are formatted as follows:
//
// #define<TAB>NAME[<TAB>ID]<TAB>MESSAGE
//
// There MUST be only ONE tab character between the definition fields.
// Never enclose the message in double quotes! Below are few escape sequences
// you can use in the message text:
//
// \s - space (needed at the start and the end of message since the parser strips
//             both leading and trailing whitespace)
// \t - TAB (as above)
// \# - # sign (only needed at the start of message if you need it to start with #).
//      # used at the start of message makes this message a function invocation, and
//      not a string. It means that it won't be enclosed in the quotation marks in the
//      output.
//
// Comments starting with //! are "attached" to the message definition that follows them
// and output in the target file as an attachment of that same kind.
//
// The target file contains also another kind of entry market with the //#DIRECTIVE 
// comment. The following directives are defined:
//
//  ORIG - the line contains the original version of the string for change testing when
//         the translation and the template are combined.
//  FLAG - followed by several flags marks the state of this entry:
//           <changed>  - the entry has been changed in the original (default) file
//                        and the translation needs to be updated.
//           <new>      - new entry merged from the default file
//
//  Neither the attachment comment nor the directive comment should be edited by hand!!
//


// For the translation system internal usage. Not used by CAMAS.

//! Maintainer of this particular file
//#ORIG Xavier Beaudouin <kiwi@isdnet.net>
#define	TS_MAINTAINER	11111	Xavier Beaudouin <xbeaudouin@isdnet.net>

//! This file version
//#ORIG 1.0.0-dev
#define	TS_VERSION	11112	1.0.8-STABLE1

//! Output in camas_XX.pike as default message (translate it to your language)
//#ORIG \s** MISSING MESSAGE **\s
#define	TS_NOMSGFOUND	11113	\s** MISSING MESSAGE **\s

//! Native language name
//#ORIG English
#define	TS_LANGNAME	11114	Espaol

//! Language charset
//#ORIG iso-8859-1
#define	TS_CHARSET	11115	iso-8859-1

//! Character encodable in the above charset
//#ORIG ?
#define	TS_ENCCHAR	11116	?

//! CVS version of the file (leave set to $Id: language.es,v 1.7.2.1 2001/07/10 17:49:34 kiwi Exp $ if you don't use CVS)
//#ORIG $Id: language.es,v 1.7.2.1 2001/07/10 17:49:34 kiwi Exp $
#define	TS_CVSVER	11117	$Id: language.es,v 1.7.2.1 2001/07/10 17:49:34 kiwi Exp $

//! The copyright string put in the target .pike file
//#ORIG 2000 The Caudium Group
#define	TS_COPYRIGHT	11118	2000 The Caudium Group


// CAMAS Messages

//#ORIG Done
#define	M_SPELLDONE	Hecho

//#ORIG anywhere
#define	M_SEARCHANYWHERE	en todas las carpetas

//#ORIG Cancel
#define	M_CANCELSEND	Cancelar

//#ORIG Drafts
#define	M_BOXDRAFTS	Borradores

//#ORIG Mailbox (m/r/u/s)
#define	M_MBOXNAME	Carpeta (m/r/u/s)

//#ORIG Info
#define	M_INFO	Informacin

//#ORIG Subject
#define	M_SUBJECT	Asunto

//#ORIG Save draft
#define	M_SAVEDRAFT	Guardar borrador

//#ORIG From preferences
#define	M_SAVEDUSERINTERFACE	De las preferencias

//#ORIG Mark at least one mailbox.
#define	M_MBOXMARKONE	Marque al menos una carpeta.

//#ORIG \#sprintf("[Next %d >>]", @arg)
#define	M_FORWARDN	\#sprintf("[Siguientes %d >>]", @arg)

//#ORIG Show full headers
#define	M_SHOWFULLHEADERS	Mostrar todas las cabezeras

//#ORIG Edit the filter
#define	M_EDITFILTER	Edit the filter

//#ORIG \#sprintf("You have %d Kb available for upload.",@arg)
#define	M_AVAILSPACE	\#sprintf("Vd. tiene %d Kbytes disponibles para cargar.",@arg)

//#ORIG Inactive logout (minutes)
#define	M_PINACTIVELOGOUT	Cierre por inactividad (minutos)

//#ORIG Delay
#define	M_DELAY	Delay

//#ORIG Logout
#define	M_LOGOUT	Salir

//#ORIG Common addresses:
#define	M_GLOBALADDRESSES	Direcciones:

//#ORIG Index filter (click to edit)
#define	M_INDEXNAMEEDITFILTER	Index filter (click to edit)

//#ORIG Upload attachment
#define	M_UPLOADATTACHMENT	Cargar adjunto

//#ORIG \#sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg)
#define	M_NOTIFYTO	\#sprintf ("%s pidio un acusado de recepcion. Ud desea enviar uno?", @arg)

//#ORIG Date
#define	M_DATE	Fecha

//#ORIG Address
#define	M_ADDRESS	Direccin

//#ORIG Delete address
#define	M_DELETEADDRESS	Borrar direccin

//#ORIG \#sprintf("Find mail in mailbox <strong>%s</strong> which contains",arg[0])
#define	M_SEARCHMAILBOX	\#sprintf("Buscar mensaje en la carpeta <strong>%s</strong> que contiene",arg[0])

//#ORIG Mark all
#define	M_MARKALL	Marcar todos

//#ORIG Check inboxes
#define	M_CHECKACTIVEMAILBOXES	Comprobar carpetas

//#ORIG You must select a mailbox to rename and supply a new name.
#define	M_NOMBOXERROR	Ud tiene que seleccionar la carpeta que debe cambiar de nombre, y darle un nuevo nombre.

//#ORIG Suggestions
#define	M_SPELLSUGGESTIONS	Sugerencias

//#ORIG M
#define	M_MARKFLAG	M

//#ORIG No addresses
#define	M_NOADDRESSES	No hay direcciones

//#ORIG Default Bcc address
#define	M_PDEFAULTBCC	Direccin Ccc por defecto

//#ORIG Are you sure you want to delete the following mailboxes?
#define	M_MBOXREMOVEP	Est Vd. seguro de que desea eliminar las siguientes carpetas?

//#ORIG <b>You have been logged out.</b> Close this browser window to make sure no one can read your mail.<br /><br />Reload this page to login.
#define	M_LOGOUTMSG	Vd. ha sido despedido del sistema. Cierre esta ventana para asegurarse de que nadie podr leer sus mensajes.<br /><br />Recargue esta pgina para volver a acceder a su correo.

//#ORIG Delete marked
#define	M_DELETEMARKEDFILES	Borrar marcados

//#ORIG Save a copy
#define	M_SAVEMAILCOPY	Guardar una copia

//#ORIG Extra headers
#define	M_PHEADER	Otras cabezeras

//#ORIG Mail notification...
#define	M_MAILNOTIFYWINDOW	Aviso de nuevo mensaje...

//#ORIG Index field (click to select a field)
#define	M_INDEXNAMEFIELDFILTER	Index field (click to select a field)

//#ORIG Preferences
#define	M_PREFS	Preferencias

//#ORIG Type
#define	M_MIMETYPE	Tipo

//#ORIG \#sprintf("[<< Prev %d]", @arg)
#define	M_BACKN	\#sprintf("[<< Anteriores %d]", @arg)

//#ORIG Continue...
#define	M_CONTINUECOMPOSE	Continue...

//#ORIG Time
#define	M_TIME	Hora

//#ORIG Address(es), comma separated
#define	M_ADDRESSFORMAT	Direccin(es), separadas por comas

//#ORIG Add attachment...
#define	M_ADDATTACHMENT	Aadir adjunto...

//#ORIG Failed to rename mailbox. The name may be illegal or the mailbox may exist.
#define	M_RENAMEMBOXERROR	Fallo en el cambio de nombre de carpeta. Motivos: nombre ilegal o carpeta ya existente.

//#ORIG Current Mailbox
#define	M_CURRMAILBOX	Bandeja de entrada

//#ORIG There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent. The recipient of the mail might not exist.
#define	M_SMTPERROR	Ha habido un problema en la comunicacin con el servidor SMTP, y el mensaje no ha sido enviado. Puede ser que la direccion de correo de entrega no exista.

//#ORIG Forward
#define	M_FORWARD	Reenviar

//#ORIG Change to
#define	M_SPELLCHANGETO	Cambiar a

//#ORIG Index filter
#define	M_INDEXNAMEFILTER	Index filter

//#ORIG Signature
#define	M_PSIGNATURE	Firma

//#ORIG Search name containing:
#define	M_NAMECONT	Buscar nombre que contiene:

//#ORIG Showing mail with\s
#define	M_SEARCHSHOWINGMAIL	Mostrar mensajes con\s

//#ORIG Mail
#define	M_MAIL	Mensaje

//#ORIG Bcc
#define	M_BCC	Ccc

//#ORIG [No mail]
#define	M_NOMAILS	[No hay mensajes]

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENT	Nombre de ndice (pulse para aadir como destinatario)

//#ORIG Cancel
#define	M_DIALOGCANCEL	Cancelar

//#ORIG Drafts folder
#define	M_PDRAFTSFOLDER	Borradores

//#ORIG Rename a mailbox
#define	M_RENAMEMBOX	Cambiar el nombre de una carpeta

//#ORIG Sent mail folder
#define	M_PSENTFOLDER	Carpeta de mensajes enviados

//#ORIG There was a problem talking to the mail (IMAP) server.<br>Please contact the administrator.
#define	M_IMAPERROR	Ha habido un problema en la comunicatin con el servidor IMAP.<br>Por favor, contacte con el administrador.

//#ORIG Back
#define	M_MAILMISSINGBACK	Atrs

//#ORIG \#sprintf("Mail %d-%d of %d", @arg)
#define	M_MAILSHOWN	\#sprintf("Mensaje %d-%d de %d", @arg)

//#ORIG OK
#define	M_DIALOGOK	OK

//#ORIG Report successful delivery.
#define	M_DSN_SUCCESS	Recibir acusado de recepcion correcta.

//#ORIG Wrong login or password. Try again.
#define	M_LOGINERROR	Nombre de usuario o clave incorrecta. Intnlelo de nuevo.

//#ORIG User interface
#define	M_PUSERINTERFACE	Interfaze de usuario

//#ORIG Prefix
#define	M_PQUOTEPREFIX	Prefijo

//#ORIG Edit filter
#define	M_EDITADDRESSFILTER	Edit filter

//#ORIG (Select a field)
#define	M_SELECTFIELD	(Select a field)

//#ORIG Language
#define	M_PLANGUAGE	Idioma

//#ORIG No
#define	M_NO	No

//#ORIG \#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)
#define	M_CHARSETWARNING	\#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)

//#ORIG Cc
#define	M_CC	Cc

//#ORIG Index name
#define	M_INDEXNAME	Nombre de ndice

//#ORIG Add file as an attachment
#define	M_ADDFILEASATTACHMENT	Aadir fichero como adjunto

//#ORIG <strong>Error:</strong> Failed to fetch mail. The mail might have a faulty format.<br />
#define	M_MAILMISSING	<strong>Error:</strong>Fallo al acceder a su correo. Intntelo de nuevo.<br />

//#ORIG Compose mail
#define	M_COMPOSEMAIL	Componer mensaje

//#ORIG Sent
#define	M_BOXSENTMAIL	Elementos enviados

//#ORIG Organization
#define	M_PORGANIZATION	Organization

//#ORIG Show text messages
#define	M_PSHOWTEXT	Mostrar mensajes de texto

//#ORIG \#sprintf ("The mail \"%s\" was sent to: %s", @arg)
#define	M_SMTPOK	\#sprintf ("El mensaje \"%s\" ha sido enviado a: %s", @arg)

//#ORIG Upload and import
#define	M_UPLOADANDIMPORT	Cargar e Importar

//#ORIG AND
#define	M_SEARCHAND	Y

//#ORIG New filter...
#define	M_NEWADDRESSFILTER	New filter...

//#ORIG Yes
#define	M_YES	Si

//#ORIG Sunday
#define	M_SUNDAY	Domingo

//#ORIG Move to trash
#define	M_MOVETHISTOTRASH	Poner en la papelera

//#ORIG To
#define	M_TO	A

//#ORIG in the mail body
#define	M_SEARCHBODY	dentro del mensaje

//#ORIG Empty the trash folder
#define	M_DELETEALLTRASH	Vaciar la Papelera

//#ORIG Index name (click to edit)
#define	M_INDEXNAMEEDIT	Nombre de ndice (pulse para editar)

//#ORIG \#sprintf("%sattachment of type %s",@arg)
#define	M_ATTACHMENTLINK	\#sprintf("%sadjuntos del tipo %s",@arg)

//#ORIG Check for new mail
#define	M_CHECKNEWMAIL	Comprobar nuevo correo

//#ORIG Mailboxes
#define	M_MAILBOXES	Carpetas

//#ORIG Trash
#define	M_BOXTRASH	Papelera

//#ORIG Trash folder
#define	M_PTRASHFOLDER	Papelera

//#ORIG Include mail when replying
#define	M_PINCLUDEMAIL	Incluir mensaje en respuestas

//#ORIG \#sprintf ("<b>Could not log in:</b> %s", @arg)
#define	M_NOLOGIN	\#sprintf ("<b>No se pudo acceder:</b> %s", @arg)

//#ORIG Index field
#define	M_INDEXFIELDFILTER	Index field

//#ORIG Upload
#define	M_UPLOAD	Cargar

//#ORIG Include attachments
#define	M_PSAVEATTACHMENTS	Guardar Adjuntos

//#ORIG Back to compose
#define	M_BACKTOCOMPOSE	Volver a Composicin de mensajes

//#ORIG Save and use
#define	M_SAVEADDRESS	Grabar y Utilizar

//#ORIG No attachments
#define	M_NOATTACHMENTS	Sin adjunto...

//#ORIG Path
#define	M_FOLDER_PATH	Camino

//#ORIG \#([ "forward": "forward", "backward":"backward"])[arg[0]]
#define	M_PSORTORDERS	\#([ "forward": "adelante", "backward":"atrs"])[arg[0]]

//#ORIG Read next
#define	M_READNEXT	Leer el siguiente

//#ORIG Add recipients
#define	M_ADDRECIPIENTS	Add recipients

//#ORIG Default addressbook (not extended)
#define	M_PADDRESSBOOK	Lista de contactos

//#ORIG Password:
#define	M_PASSWORD	Clave:

//#ORIG Cancel
#define	M_CANCELADDRESSFILTER	Cancel

//#ORIG Import address book...
#define	M_IMPORTADDRESSBOOK	Importar Libro de Direcciones...

//#ORIG No filter
#define	M_NOADDRESSESFILTER	No filter

//#ORIG Return Receipt (displayed) -\s
#define	M_MDNHEADER	Acusado de recepcion -\s

//#ORIG Reply to all
#define	M_REPLYTOALL	Responder a todos

//#ORIG From
#define	M_FROM	De

//#ORIG in subject
#define	M_SEARCHSUBJECT	en el asunto

//#ORIG Move marked to trash
#define	M_MOVETOTRASH	Mover mensajes marcados a la Papelera

//#ORIG Address Book
#define	M_ADDRESSBOOKTITLE	Lista de contactos

//#ORIG Saturday
#define	M_SATURDAY	Sabado

//#ORIG Select a mailbox
#define	M_SELECTMBOX	Seleccione carpeta

//#ORIG \#sprintf("Mailbox: %s",@arg)
#define	M_MAILBOX	\#sprintf("Carpeta: %s",@arg)

//#ORIG Report delayed delivery.
#define	M_DSN_DELAY	Recibir acusado de entrega retrasada.

//#ORIG Mail searchpath
#define	M_PMAILPATH	Directorio de Correo

//#ORIG Enable <em>\"Show full headers\"</em>-button
#define	M_PSHOWHIDDENHEADERS	Enable <em>\"Mostrar todas las cabezeras\"</em>-button

//#ORIG Delete filter
#define	M_DELETEADDRESSFILTER	Delete filter

//#ORIG Send
#define	M_SEND	Enviar

//#ORIG Size
#define	M_SIZE	Tamao

//#ORIG The Pine address book is often in ~/.addressbook
#define	M_PINELOCATION	El Libro de Direcciones bajo Pine suele estar en ~/.addressbook

//#ORIG Upload to attachments
#define	M_UPLOADTOATTACHMENTS	Cargar a adjuntos

//#ORIG #
#define	M_NUMBER	#

//#ORIG Add to address book
#define	M_ADDADDRESS	Aadir a la lista de contactos

//#ORIG \#sprintf("This is a Return Receipt for the mail that you sent to %s.Note: this Return Receipt only acknowledges that the message was displayed on the recipient's machine. There is no guarantee that the content has been read or understood.", @arg)
#define	M_MDNMESSAGE	\#sprintf("Esto es un acusado de recepcion del mensaje que Ud ha enviado a %s.Nota: este acusado solo asegura que el mensaje aparecio en la pantalla. No es una prueba de que el contenido ha sido leido o entendido.", @arg)

//#ORIG Do not save this mail
#define	M_DONTSAVEMAIL	No guardar este mensaje.

//#ORIG Thursday
#define	M_THURSDAY	Juves

//#ORIG Mail sort order
#define	M_PSORTORDER	Ordenacin de mensajes

//#ORIG Read previous
#define	M_READPREV	Leer el anterior

//#ORIG [Previous level]
#define	M_PREVIOUS_LEVEL	[Volver]

//#ORIG End this CAMAS session ?
#define	M_ENDSESSION	Terminar esta sesion?

//#ORIG You must specify a recipient of the mail.
#define	M_SENDNORECV	Ud tiene que escribir una direccion de correo de entrega.

//#ORIG Search...
#define	M_SEARCHMAIL	Buscar...

//#ORIG Files
#define	M_FILES	Archivos

//#ORIG Upload a Pine, exported Netscape (.ldif) or Outlook (.csv) address book
#define	M_UPLOADADDRESSBOOK	Cargar un Libro de Direcciones en formato Pine, Netscape (.ldif) o Outlook (.csv)

//#ORIG Folder
#define	M_ADDRESSFILTER	Folder

//#ORIG Monday
#define	M_MONDAY	Lunes

//#ORIG Report delivery
#define	M_MDN	Acusado de entrega

//#ORIG (Name)
#define	M_NEWMBOXNAME	(Nombre)

//#ORIG Mail is too big to be shown. Click here to download it.
#define	M_MAILTOOBIG	Es imposible leer el mensaje, por su tamao excesivo. Pulse aqui para cargar lo.

//#ORIG in the 'to' field
#define	M_SEARCHTOFIELD	en la direccion de entrega

//#ORIG Change sort order
#define	M_CHANGESORTORDER	Cambiar la ordenacin

//#ORIG Address book...
#define	M_ADDRESSBOOK	Lista de contactos...

//#ORIG Move marked to
#define	M_MOVEMARKED	Mover marcados a

//#ORIG Compose
#define	M_NEWMAIL	Nuevo correo

//#ORIG Failed to create mailbox. The name may be illegal or the mailbox may exist.
#define	M_CREATEMBOXERROR	Fallo en la creacin de carpeta. Motivos: nombre ilegal o carpeta ya existente.

//#ORIG You have no uploaded files
#define	M_NOFILES	Vd. no tiene ficheros cargados.

//#ORIG Show HTML messages
#define	M_PSHOWHTML	Mostrar mensajes HTML

//#ORIG Attachments
#define	M_ATTACHMENTSHEADER	Adjuntos

//#ORIG Search LDAP
#define	M_SEARCHLDAP	Buscar en LDAP

//#ORIG Save and use
#define	M_SAVEADDRESSFILTER	Save and use

//#ORIG OU
#define	M_OU	OU

//#ORIG Index folder
#define	M_FILTERFOLDER	Index folder

//#ORIG Today
#define	M_TODAY	Hoy

//#ORIG Add marked to attachments
#define	M_ADDMARKEDTOATTACHMENTS	Aadir los marcados a adjuntos

//#ORIG Hide full headers
#define	M_HIDEFULLHEADERS	Esconder las cabezeras

//#ORIG Edit address
#define	M_EDITADDRESS	Editar direccin

//#ORIG Spell check
#define	M_SPELLCHECK	Ortografa

//#ORIG A
#define	M_ANSWEREDFLAG	R

//#ORIG Wednesday
#define	M_WEDNESDAY	Miercoles

//#ORIG OK
#define	M_LOGIN_OK	OK

//#ORIG Messages shown in a mailbox
#define	M_PVISIBLEMESSAGES	Mensajes mostrados en carpeta

//#ORIG Question
#define	M_QUESTION	Preguntas

//#ORIG Default filterbook (not extended)
#define	M_PADDRESSBOOKFILTER	Default filterbook (not extended)

//#ORIG Search mail
#define	M_SEARCHMAILTITLE	Busqueda de mensajes

//#ORIG Add to filter book
#define	M_ADDADDRESSFILTER	Add to filter book

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOKTITLE	Importar Libro de Direcciones

//#ORIG LDAP search
#define	M_LDAP	Busqueda en LDAP

//#ORIG Create a new mailbox
#define	M_CREATEMBOX	Crear una nueva carpeta

//! Label on the login screen
//#ORIG Login:
#define	M_LOGIN	Usuario:

//#ORIG Delete
#define	M_DELETE	Borrar

//#ORIG Next
#define	M_SPELLNEXT	Siguiente

//#ORIG in the 'from' field
#define	M_SEARCHFROMFIELD	en el nombre

//#ORIG Please mark some messages first.
#define	M_DELETEMARKEDNONE	Por favor, marque algunos mensajes primero.

//#ORIG Name
#define	M_PNAME	Nombre

//#ORIG N
#define	M_NEWFLAG	N

//#ORIG Tuesday
#define	M_TUESDAY	Martes

//#ORIG Logged out
#define	M_LOGGEDOUT	Despedido (logged out)

//#ORIG \#sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0])
#define	M_SENDBROKENADDR	\#sprintf("La direccion de correo \"%s\" no es una direccion de email correcta. Por favor, corrige la y intentalo de nuevo.", arg[0])

//#ORIG User interface:
#define	M_USERINTERFACE	Interfaze de usuario:

//#ORIG Type in a name first.
#define	M_NEWMBOXNONAME	Teclee un nombre primero.

//#ORIG You must specify non-empty index folder and filter(s).
#define	M_EMPTYADDRESSFILTER	You must specify non-empty index folder and filter(s).

//#ORIG Mail was sent successfully, but save in folder failed.
#define	M_SENDSAVEFAILED	El mensaje ha sido enviado, pero no se guardo en la carpeta.

//#ORIG Mail address
#define	M_PMAILADDRESS	Direccin electrnica

//#ORIG Sort on column
#define	M_PSORTCOLUMN	Ordenar por columna

//#ORIG Mail Filter
#define	M_FILTERBOOKTITLE	Reglas de correo

//#ORIG Inbox
#define	M_INBOX	Bandeja de entrada

//#ORIG Cannot import this addressbook, since its\nformat is not recognized.
#define	M_CANNOTIMPORT	No se puede importar este Libro de Direcciones, ya que\nsu formato es desconocido.

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENTFILTER	Index name (click to add as recipient)

//#ORIG Remove marked attachments
#define	M_REMOVEMARKEDATTACHMENTS	Remove marked attachments

//#ORIG Delete marked
#define	M_DELETEMARKEDMBOX	Borrar marcados

//#ORIG Previous
#define	M_SPELLPREV	Anterior

//#ORIG New address
#define	M_NEWADDRESS	Nueva direccin...

//#ORIG \#sprintf("Are you sure you want to delete the %d marked message(s)?", @arg)
#define	M_DELETEMARKEDP	\#sprintf("Est Vd. seguro de que desea eliminar los %d mensajes marcados?", @arg)

//#ORIG Select files to send. Press 'Ctrl' to toggle-select multiple files.
#define	M_SENDMOREFILES	Seleccione los archivos a enviar. Pulse 'Ctrl' para (des)selecionar varios archivos.

//#ORIG Filename
#define	M_FILENAME	Fichero

//#ORIG Reply
#define	M_REPLY	Responder

//#ORIG Attachments
#define	M_ATTACHMENTS	Adjuntos

//#ORIG Save and use
#define	M_PSAVEANDUSE	Grabar y utilizar

//#ORIG Delete marked
#define	M_DELETEMARKED	Borrar marcados

//#ORIG Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.
#define	M_WINDOWSBUG	Atencin usuarios de Windows: Debido a un error en algunos visualizadores WEB, los nombres de fichero pueden aparecer recortados. Para evitarlo, puede sustituir el ltimo '\\' por '\\\\' antes de pulsar 'Cargar (upload)'.

//#ORIG (Lines with headers in this format: header:value)
#define	M_PHEADERDESC	(Lineas con cabezeras con este formato: cabezera: valor)

//#ORIG No files
#define	M_NOATTACHFILES	No hay ficheros

//#ORIG LDAP addresses
#define	M_LDAPTITLE	Guia de direcciones LDAP

//#ORIG Get new mail...
#define	M_GETNEWMAIL	Recibir nuevos mensajes...

//#ORIG Index field
#define	M_INDEXNAMEEDITFIELDFILTER	Index field

//#ORIG Cancel
#define	M_CANCELADDRESS	Cancelar

//#ORIG Filters
#define	M_FILTERBOOK	Reglasde correo

//#ORIG Friday
#define	M_FRIDAY	Viernes

