// Dear Emacs, please note this is a -*-text-*- file. Thank you.
//
// Caudium - An extensible World Wide Web server
// Copyright  2000-2001 The Caudium Group
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: language.fr,v 1.8.2.1 2001/07/10 17:49:34 kiwi Exp $
//

//
// The language template file format
// ---------------------------------
//
// Message definitions are formatted as follows:
//
// #define<TAB>NAME[<TAB>ID]<TAB>MESSAGE
//
// There MUST be only ONE tab character between the definition fields.
// Never enclose the message in double quotes! Below are few escape sequences
// you can use in the message text:
//
// \s - space (needed at the start and the end of message since the parser strips
//             both leading and trailing whitespace)
// \t - TAB (as above)
// \# - # sign (only needed at the start of message if you need it to start with #).
//      # used at the start of message makes this message a function invocation, and
//      not a string. It means that it won't be enclosed in the quotation marks in the
//      output.
//
// Comments starting with //! are "attached" to the message definition that follows them
// and output in the target file as an attachment of that same kind.
//
// The target file contains also another kind of entry market with the //#DIRECTIVE 
// comment. The following directives are defined:
//
//  ORIG - the line contains the original version of the string for change testing when
//         the translation and the template are combined.
//  FLAG - followed by several flags marks the state of this entry:
//           <changed>  - the entry has been changed in the original (default) file
//                        and the translation needs to be updated.
//           <new>      - new entry merged from the default file
//
//  Neither the attachment comment nor the directive comment should be edited by hand!!
//


// For the translation system internal usage. Not used by CAMAS.

//! Maintainer of this particular file
//#ORIG Xavier Beaudouin <kiwi@isdnet.net>
#define	TS_MAINTAINER	11111	Olivier Girondel <olivier.girondel@IDEALX.com>

//! This file version
//#ORIG 1.0.0-dev
#define	TS_VERSION	11112	0.1

//! Output in camas_XX.pike as default message (translate it to your language)
//#ORIG \s** MISSING MESSAGE **\s
#define	TS_NOMSGFOUND	11113	\s** MESSAGE MANQUANT **\s

//! Native language name
//#ORIG English
#define	TS_LANGNAME	11114	Franais

//! Language charset
//#ORIG iso-8859-1
#define	TS_CHARSET	11115	iso-8859-1

//! Character encodable in the above charset
//#ORIG ?
#define	TS_ENCCHAR	11116	?

//! CVS version of the file (leave set to $Id: language.fr,v 1.8.2.1 2001/07/10 17:49:34 kiwi Exp $ if you don't use CVS)
//#ORIG $Id: language.fr,v 1.8.2.1 2001/07/10 17:49:34 kiwi Exp $
#define	TS_CVSVER	11117	$Id: language.fr,v 1.8.2.1 2001/07/10 17:49:34 kiwi Exp $

//! The copyright string put in the target .pike file
//#ORIG 2000 The Caudium Group
#define	TS_COPYRIGHT	11118	2000 The Caudium Group


// CAMAS Messages

//#ORIG Done
#define	M_SPELLDONE	Correction effectue

//#ORIG anywhere
#define	M_SEARCHANYWHERE	n'importe o

//#ORIG Cancel
#define	M_CANCELSEND	Annuler

//#ORIG Drafts
#define	M_BOXDRAFTS	Brouillons

//#ORIG Mailbox (m/r/u/s)
#define	M_MBOXNAME	Dossiers (m/r/u/s)

//#ORIG Info
#define	M_INFO	Information

//#ORIG Subject
#define	M_SUBJECT	Objet

//#ORIG Save draft
#define	M_SAVEDRAFT	Enregistrer un brouillon.

//#ORIG From preferences
#define	M_SAVEDUSERINTERFACE	Depuis les prfrences

//#ORIG Mark at least one mailbox.
#define	M_MBOXMARKONE	Selectionnez au moins un dossier.

//#ORIG \#sprintf("[Next %d >>]", @arg)
#define	M_FORWARDN	Suivant

//#ORIG Show full headers
#define	M_SHOWFULLHEADERS	Montrer l'en-tte

//#ORIG Edit the filter
#define	M_EDITFILTER	Editer le filtre

//#ORIG \#sprintf("You have %d Kb available for upload.",@arg)
#define	M_AVAILSPACE	\#sprintf("Vous avez %d Kb de disponible pour charger des fichiers.",@arg)

//#ORIG Inactive logout (minutes)
#define	M_PINACTIVELOGOUT	Dconnexion automatique (minutes)

//#ORIG Delay
#define	M_DELAY	Dlais

//#ORIG Logout
#define	M_LOGOUT	Se dconnecter

//#ORIG Common addresses:
#define	M_GLOBALADDRESSES	Carnet d'adresse commun:

//#ORIG Index filter (click to edit)
#define	M_INDEXNAMEEDITFILTER	Expression

//#ORIG Upload attachment
#define	M_UPLOADATTACHMENT	Joindre un fichier

//#ORIG \#sprintf ("%s requested a receipt to be returned. Do you wish to send one ?", @arg)
#define	M_NOTIFYTO	\#sprintf ("%s a demand un accus de rception. Voulez-vous en envoyer un ?", @arg);

//#ORIG Date
#define	M_DATE	Date

//#ORIG Address
#define	M_ADDRESS	Adresse lectronique

//#ORIG Delete address
#define	M_DELETEADDRESS	Supprimer le contact

//#ORIG \#sprintf("Find mail in mailbox <strong>%s</strong> which contains",arg[0])
#define	M_SEARCHMAILBOX	\#sprintf("Chercher un message dans la bote <strong>%s</strong> qui contient",arg[0])

//#ORIG Mark all
#define	M_MARKALL	Slectionner tous les messages

//#ORIG Check inboxes
#define	M_CHECKACTIVEMAILBOXES	Vrifier les botes

//#ORIG You must select a mailbox to rename and supply a new name.
#define	M_NOMBOXERROR	Vous devez slectionner un dossier  renommer et fournir le nouveau nom.

//#ORIG Suggestions
#define	M_SPELLSUGGESTIONS	Suggestions

//#ORIG M
#define	M_MARKFLAG	S

//#ORIG No addresses
#define	M_NOADDRESSES	Pas de carte dfinie

//#ORIG Default Bcc address
#define	M_PDEFAULTBCC	Destinataire de copie cache par dfaut

//#ORIG Are you sure you want to delete the following mailboxes?
#define	M_MBOXREMOVEP	Etes vous sr de vouloir effacer le(s) dossier(s) suivant(s) ?

//#ORIG <b>You have been logged out.</b> Close this browser window to make sure no one can read your mail.<br /><br />Reload this page to login.
#define	M_LOGOUTMSG	<b><br><br>Vous tes  prsent dconnect, merci d'avoir utilis la messagerie.<br>Fermez votre navigateur pour vous assurer que personne d'autre ne lise vos messages.<br>Rechargez cette page pour vous reconnecter.<br><br></b>

//#ORIG Delete marked
#define	M_DELETEMARKEDFILES	Effacer fichier(s) slectionn(s)

//#ORIG Save a copy
#define	M_SAVEMAILCOPY	Garder une copie

//#ORIG Extra headers
#define	M_PHEADER	Champs supplmentaires

//#ORIG Mail notification...
#define	M_MAILNOTIFYWINDOW	Notification de courrier

//#ORIG Index field (click to select a field)
#define	M_INDEXNAMEFIELDFILTER	Index field

//#ORIG Preferences
#define	M_PREFS	Prfrences

//#ORIG Type
#define	M_MIMETYPE	Type

//#ORIG \#sprintf("[<< Prev %d]", @arg)
#define	M_BACKN	Prcdent

//#ORIG Continue...
#define	M_CONTINUECOMPOSE	Continuer...

//#ORIG Time
#define	M_TIME	Date

//#ORIG Address(es), comma separated
#define	M_ADDRESSFORMAT	Adresse(s) lectronique(s), virgule pour sparer

//#ORIG Add attachment...
#define	M_ADDATTACHMENT	Joindre un fichier...

//#ORIG Failed to rename mailbox. The name may be illegal or the mailbox may exist.
#define	M_RENAMEMBOXERROR	Impossible de renommer le dossier. Le nom est illgal ou le nouveau dossier peut dj exister.

//#ORIG Current Mailbox
#define	M_CURRMAILBOX	Bote en cours

//#ORIG There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent. The recipient of the mail might not exist.
#define	M_SMTPERROR	Problme avec le serveur sortant SMTP, message non envoy.

//#ORIG Forward
#define	M_FORWARD	Faire suivre

//#ORIG Change to
#define	M_SPELLCHANGETO	Remplacer par

//#ORIG Index filter
#define	M_INDEXNAMEFILTER	Index Filter

//#ORIG Signature
#define	M_PSIGNATURE	Signature

//#ORIG Search name containing:
#define	M_NAMECONT	Rechercher le nom comportant :

//#ORIG Showing mail with\s
#define	M_SEARCHSHOWINGMAIL	Affichage des messages avec\s

//#ORIG Mail
#define	M_MAIL	Mail

//#ORIG Bcc
#define	M_BCC	Copie cache 

//#ORIG [No mail]
#define	M_NOMAILS	Pas de nouveau(x) message(s)

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENT	Nom

//#ORIG Cancel
#define	M_DIALOGCANCEL	Annuler

//#ORIG Drafts folder
#define	M_PDRAFTSFOLDER	Dossier des brouillons

//#ORIG Rename a mailbox
#define	M_RENAMEMBOX	Renommer une bote

//#ORIG Sent mail folder
#define	M_PSENTFOLDER	Dossier des messages envoys

//#ORIG There was a problem talking to the mail (IMAP) server.<br>Please contact the administrator.
#define	M_IMAPERROR	Problme avec le serveur IMAP.\nContactez l'administrateur systme.

//#ORIG Back
#define	M_MAILMISSINGBACK	Retour

//#ORIG \#sprintf("Mail %d-%d of %d", @arg)
#define	M_MAILSHOWN	\#sprintf("Message %d-%d sur %d", @arg)

//#ORIG OK
#define	M_DIALOGOK	OK

//#ORIG Report successful delivery.
#define	M_DSN_SUCCESS	Accus de rception du serveur de mail.

//#ORIG Wrong login or password. Try again.
#define	M_LOGINERROR	Mauvais mot de passe ou login incorrect. Recommencez.

//#ORIG User interface
#define	M_PUSERINTERFACE	Interface utilisateur

//#ORIG Prefix
#define	M_PQUOTEPREFIX	Prfixe

//#ORIG Edit filter
#define	M_EDITADDRESSFILTER	edit filter

//#ORIG (Select a field)
#define	M_SELECTFIELD	(Slectionnez un champ)

//#ORIG Language
#define	M_PLANGUAGE	Langue

//#ORIG No
#define	M_NO	Non

//#ORIG \#sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg)
#define	M_CHARSETWARNING	\#sprintf("Attention! Impossible de dcoder le message encod en \"%s\". Le message sera prsent non dcod.",@arg)

//#ORIG Cc
#define	M_CC	Copie 

//#ORIG Index name
#define	M_INDEXNAME	Nom

//#ORIG Add file as an attachment
#define	M_ADDFILEASATTACHMENT	Joindre un fichier

//#ORIG <strong>Error:</strong> Failed to fetch mail. The mail might have a faulty format.<br />
#define	M_MAILMISSING	<strong>Erreur:</strong> Impossible de rcuprer le courrier. Essayez encore. <br />

//#ORIG Compose mail
#define	M_COMPOSEMAIL	Rdaction de message

//#ORIG Sent
#define	M_BOXSENTMAIL	Messages envoys

//#ORIG Organization
#define	M_PORGANIZATION	Socit

//#ORIG Show text messages
#define	M_PSHOWTEXT	Afficher les messages texte

//#ORIG \#sprintf ("The mail \"%s\" was sent to: %s", @arg)
#define	M_SMTPOK	\#sprintf ("Le message \"%s\" a t envoy : %s", @arg)

//#ORIG Upload and import
#define	M_UPLOADANDIMPORT	Valider

//#ORIG AND
#define	M_SEARCHAND	ET

//#ORIG New filter...
#define	M_NEWADDRESSFILTER	Nouveau filtre...

//#ORIG Yes
#define	M_YES	Oui

//#ORIG Sunday
#define	M_SUNDAY	Dimanche

//#ORIG Move to trash
#define	M_MOVETHISTOTRASH	Supprimer ce message

//#ORIG To
#define	M_TO	Destinataire

//#ORIG in the mail body
#define	M_SEARCHBODY	dans le corps du message

//#ORIG Empty the trash folder
#define	M_DELETEALLTRASH	Effacer toute la corbeille

//#ORIG Index name (click to edit)
#define	M_INDEXNAMEEDIT	Nom

//#ORIG \#sprintf("%sattachment of type %s",@arg)
#define	M_ATTACHMENTLINK	\#sprintf("%sfichier joint de type %s",@arg)

//#ORIG Check for new mail
#define	M_CHECKNEWMAIL	Retirer message(s)

//#ORIG Mailboxes
#define	M_MAILBOXES	Dossier(s)

//#ORIG Trash
#define	M_BOXTRASH	Corbeille

//#ORIG Trash folder
#define	M_PTRASHFOLDER	Corbeille

//#ORIG Include mail when replying
#define	M_PINCLUDEMAIL	Inclure le message d'origine en rpondant  l'expditeur

//#ORIG \#sprintf ("<b>Could not log in:</b> %s", @arg)
#define	M_NOLOGIN	\#sprintf ("<b>Accs impossible :</b> %s", @arg)

//#ORIG Index field
#define	M_INDEXFIELDFILTER	Index field

//#ORIG Upload
#define	M_UPLOAD	Charger fichier

//#ORIG Include attachments
#define	M_PSAVEATTACHMENTS	Inclure fichier(s) joint(s)

//#ORIG Back to compose
#define	M_BACKTOCOMPOSE	Retour au message

//#ORIG Save and use
#define	M_SAVEADDRESS	Enregistrer

//#ORIG No attachments
#define	M_NOATTACHMENTS	Pas de fichier joint

//#ORIG Path
#define	M_FOLDER_PATH	Chemin :

//#ORIG \#([ "forward": "forward", "backward":"backward"])[arg[0]]
#define	M_PSORTORDERS	\#([ "forward": "croissant", "backward":"dcroissant"])[arg[0]]

//#ORIG Read next
#define	M_READNEXT	Lire suivant

//#ORIG Add recipients
#define	M_ADDRECIPIENTS	Ajouter les destinataires

//#ORIG Default addressbook (not extended)
#define	M_PADDRESSBOOK	Carnet d'adresses...

//#ORIG Password:
#define	M_PASSWORD	Mot de passe :

//#ORIG Cancel
#define	M_CANCELADDRESSFILTER	Annuler

//#ORIG Import address book...
#define	M_IMPORTADDRESSBOOK	Importer carnet d'adresse depuis un fichier...

//#ORIG No filter
#define	M_NOADDRESSESFILTER	Pas de filtres

//#ORIG Return Receipt (displayed) -\s
#define	M_MDNHEADER	Accus de Rception (affich) -\s

//#ORIG Reply to all
#define	M_REPLYTOALL	Rpondre  tous

//#ORIG From
#define	M_FROM	Expditeur

//#ORIG in subject
#define	M_SEARCHSUBJECT	dans l'objet

//#ORIG Move marked to trash
#define	M_MOVETOTRASH	Supprimer

//#ORIG Address Book
#define	M_ADDRESSBOOKTITLE	Carnet d'adresses

//#ORIG Saturday
#define	M_SATURDAY	Samedi

//#ORIG Select a mailbox
#define	M_SELECTMBOX	Choisir un dossier...

//#ORIG \#sprintf("Mailbox: %s",@arg)
#define	M_MAILBOX	\#sprintf("Dossier : %s",@arg)

//#ORIG Report delayed delivery.
#define	M_DSN_DELAY	Rapport d'envoi de mail diffr.

//#ORIG Mail searchpath
#define	M_PMAILPATH	Chemin de la bote

//#ORIG Enable <em>\"Show full headers\"</em>-button
#define	M_PSHOWHIDDENHEADERS	Afficher le bouton Montrer l'en-t&ecirc;te lors de la lecture d'un message

//#ORIG Delete filter
#define	M_DELETEADDRESSFILTER	Supprimer

//#ORIG Send
#define	M_SEND	Envoyer

//#ORIG Size
#define	M_SIZE	Taille

//#ORIG The Pine address book is often in ~/.addressbook
#define	M_PINELOCATION	Le fichier de carnet d'adresses Pine est souvent ~/.addressbook

//#ORIG Upload to attachments
#define	M_UPLOADTOATTACHMENTS	Ajouter fichier slectionn au message

//#ORIG #
#define	M_NUMBER	#

//#ORIG Add to address book
#define	M_ADDADDRESS	Ajouter au carnet d'adresses

//#ORIG \#sprintf("This is a Return Receipt for the mail that you sent to %s.Note: this Return Receipt only acknowledges that the message was displayed on the recipient's machine. There is no guarantee that the content has been read or understood.", @arg)
#define	M_MDNMESSAGE	\#sprintf("Ceci est un accus de rception pour le message que vous avez envoy  %s. Note: cet accus de rception atteste que le message a t affich sur la machine du destinataire. Il n'y a pas de garantie que le contenu du message ait t lu ou compris.", @arg)

//#ORIG Do not save this mail
#define	M_DONTSAVEMAIL	Ne pas sauvegarder ce message.

//#ORIG Thursday
#define	M_THURSDAY	Jeudi

//#ORIG Mail sort order
#define	M_PSORTORDER	Ordre de tri des messages

//#ORIG Read previous
#define	M_READPREV	Lire prcedent

//#ORIG [Previous level]
#define	M_PREVIOUS_LEVEL	[Dossier prcedent]

//#ORIG End this CAMAS session ?
#define	M_ENDSESSION	Terminer cette session CAMAS ?

//#ORIG You must specify a recipient of the mail.
#define	M_SENDNORECV	Vous devez spcifier le destinataire du message !

//#ORIG Search...
#define	M_SEARCHMAIL	Rechercher...

//#ORIG Files
#define	M_FILES	Fichiers

//#ORIG Upload a Pine, exported Netscape (.ldif) or Outlook (.csv) address book
#define	M_UPLOADADDRESSBOOK	Importer un fichier Pine, Netscape (.ldif) ou Outlook (.csv)

//#ORIG Folder
#define	M_ADDRESSFILTER	Dossier

//#ORIG Monday
#define	M_MONDAY	Lundi

//#ORIG Report delivery
#define	M_MDN	Accus de rception utilisateur.

//#ORIG (Name)
#define	M_NEWMBOXNAME	\#""

//#ORIG Mail is too big to be shown. Click here to download it.
#define	M_MAILTOOBIG	Message trop grand pour tre affich. Cliquez ici pour le sauvegarder

//#ORIG in the 'to' field
#define	M_SEARCHTOFIELD	dans le champ 'Destinataire'

//#ORIG Change sort order
#define	M_CHANGESORTORDER	Changer l'ordre de tri

//#ORIG Address book...
#define	M_ADDRESSBOOK	Carnet d'adresses...

//#ORIG Move marked to
#define	M_MOVEMARKED	Dplacer les lments slectionns vers

//#ORIG Compose
#define	M_NEWMAIL	Ecrire un message

//#ORIG Failed to create mailbox. The name may be illegal or the mailbox may exist.
#define	M_CREATEMBOXERROR	La cration a choue. Le nom est illgal ou dj utilis.

//#ORIG You have no uploaded files
#define	M_NOFILES	Vous n'avez charg aucun fichier.

//#ORIG Show HTML messages
#define	M_PSHOWHTML	Afficher les messages HTML

//#ORIG Attachments
#define	M_ATTACHMENTSHEADER	Joindre fichier(s)

//#ORIG Search LDAP
#define	M_SEARCHLDAP	Lancer la recherche

//#ORIG Save and use
#define	M_SAVEADDRESSFILTER	Enregistrer

//#ORIG OU
#define	M_OU	Filire

//#ORIG Index folder
#define	M_FILTERFOLDER	Dossier des filtres

//#ORIG Today
#define	M_TODAY	""

//#ORIG Add marked to attachments
#define	M_ADDMARKEDTOATTACHMENTS	Joindre fichier(s) slectionn(s)

//#ORIG Hide full headers
#define	M_HIDEFULLHEADERS	Masquer l'en-tte

//#ORIG Edit address
#define	M_EDITADDRESS	Modifier le contact

//#ORIG Spell check
#define	M_SPELLCHECK	Orthographe

//#ORIG A
#define	M_ANSWEREDFLAG	R

//#ORIG Wednesday
#define	M_WEDNESDAY	Mercredi

//#ORIG OK
#define	M_LOGIN_OK	OK

//#ORIG Messages shown in a mailbox
#define	M_PVISIBLEMESSAGES	Nombre de messages  afficher dans la bote de rception

//#ORIG Question
#define	M_QUESTION	Question

//#ORIG Default filterbook (not extended)
#define	M_PADDRESSBOOKFILTER	Default filterbook

//#ORIG Search mail
#define	M_SEARCHMAILTITLE	Chercher

//#ORIG Add to filter book
#define	M_ADDADDRESSFILTER	add to filter book

//#ORIG Import address book
#define	M_IMPORTADDRESSBOOKTITLE	Importer carnet d'adresse depuis un fichier

//#ORIG LDAP search
#define	M_LDAP	Annuaire...

//#ORIG Create a new mailbox
#define	M_CREATEMBOX	Crer un nouveau dossier

//! Label on the login screen
//#ORIG Login:
#define	M_LOGIN	Utilisateur :

//#ORIG Delete
#define	M_DELETE	Effacer

//#ORIG Next
#define	M_SPELLNEXT	Suivant

//#ORIG in the 'from' field
#define	M_SEARCHFROMFIELD	Dans l'expditeur

//#ORIG Please mark some messages first.
#define	M_DELETEMARKEDNONE	Selectionnez d'abord un message.

//#ORIG Name
#define	M_PNAME	Nom

//#ORIG N
#define	M_NEWFLAG	N

//#ORIG Tuesday
#define	M_TUESDAY	Mardi

//#ORIG Logged out
#define	M_LOGGEDOUT	Se dconnecter

//#ORIG \#sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0])
#define	M_SENDBROKENADDR	\#sprintf("L'adresse \"%s\" n'est pas une adresse email correcte. Veuillez la corriger et ressayer.", arg[0])

//#ORIG User interface:
#define	M_USERINTERFACE	Interface utilisateur :

//#ORIG Type in a name first.
#define	M_NEWMBOXNONAME	Veuillez d'abord entrer un nom.

//#ORIG You must specify non-empty index folder and filter(s).
#define	M_EMPTYADDRESSFILTER	Vous devez slectionner un champ et une bote aux lettres.

//#ORIG Mail was sent successfully, but save in folder failed.
#define	M_SENDSAVEFAILED	Message envoy, mais la sauvegarde dans le dossier a chou.

//#ORIG Mail address
#define	M_PMAILADDRESS	Adresse lectronique

//#ORIG Sort on column
#define	M_PSORTCOLUMN	Trier sur la colonne

//#ORIG Mail Filter
#define	M_FILTERBOOKTITLE	Filtres

//#ORIG Inbox
#define	M_INBOX	Messages reus

//#ORIG Cannot import this addressbook, since its\nformat is not recognized.
#define	M_CANNOTIMPORT	Impossible d'importer ce fichier, format non reconnu.

//#ORIG Index name (click to add as recipient)
#define	M_INDEXNAMERECIPIENTFILTER	Index name (click to add as recipient)

//#ORIG Remove marked attachments
#define	M_REMOVEMARKEDATTACHMENTS	Annuler fichier(s) joint(s) slectionn(s)

//#ORIG Delete marked
#define	M_DELETEMARKEDMBOX	Effacer lment(s) slectionn(s)

//#ORIG Previous
#define	M_SPELLPREV	Prcdent

//#ORIG New address
#define	M_NEWADDRESS	Nouveau contact

//#ORIG \#sprintf("Are you sure you want to delete the %d marked message(s)?", @arg)
#define	M_DELETEMARKEDP	\#sprintf("Etes vous sr de vouloir effacer le(s) %d message(s) selectionn(s) ?",@arg)

//#ORIG Select files to send. Press 'Ctrl' to toggle-select multiple files.
#define	M_SENDMOREFILES	Choisir fichier  envoyer. Appuyer sur 'Ctrl' pour choix multiple.

//#ORIG Filename
#define	M_FILENAME	Nom du fichier

//#ORIG Reply
#define	M_REPLY	Rpondre

//#ORIG Attachments
#define	M_ATTACHMENTS	Fichiers joints

//#ORIG Save and use
#define	M_PSAVEANDUSE	Enregistrer les modifications

//#ORIG Delete marked
#define	M_DELETEMARKED	Supprimer les lments slectionns

//#ORIG Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.
#define	M_WINDOWSBUG	Utilisateurs de Windows: Vous pouvez rencontrer des problmes selon le navigateur utilis, les noms de fichiers peuvent tre altrs. Afin d'y remdier, remplacer le dernier \ par \\ avant d'ajouter le fichier joint au message.

//#ORIG (Lines with headers in this format: header:value)
#define	M_PHEADERDESC	(Lignes avec champs dans le format: champ:valeur)

//#ORIG No files
#define	M_NOATTACHFILES	Pas de fichier joint

//#ORIG LDAP addresses
#define	M_LDAPTITLE	Adresses LDAP

//#ORIG Get new mail...
#define	M_GETNEWMAIL	Retirer message(s)

//#ORIG Index field
#define	M_INDEXNAMEEDITFIELDFILTER	Champ

//#ORIG Cancel
#define	M_CANCELADDRESS	Annuler

//#ORIG Filters
#define	M_FILTERBOOK	Filtres

//#ORIG Friday
#define	M_FRIDAY	Vendredi

