#include <module.h>
inherit "module";
inherit "caudiumlib";
#include <camas/screens.h>	// For screennames
#include <camas/msg.h>		// MSG() Language macros
#include <camas/globals.h>	// Global definitions
#include <camas/pmods.h>        // Local or normal camas pike modules
#include <camas/addressbook.h> // Address book defines and translations

inherit camas_tags;

// ============================================================================
//  EDITADDRESSFILTER screen container handler
// ============================================================================
string screen(mapping args, string contents, object id)
{
  string out;
  CDEBUG("Editaddressfilter SCREEN");
  CSESSION->screen = "editaddressfilter";	// Admin screen name
  out = "<!-- Parsed by CAMAS tag module -->\n<!-- Beginning of screen_EDITADDRESSFILTER -->\n";
  
  mapping tags_handlers =
    ([
      "camas_filterfield"      : tag_camas_editfilters_inputs,
      "camas_filterexpression" : tag_camas_editfilters_inputs,
      "camas_filterfolder"     : tag_camas_editfilters_inputs,
      "camas_savefilter"       : tag_camas_editfilters_buttons,
      "camas_cancelfilter"     : tag_camas_editfilters_buttons,
      "camas_deletefilter"     : tag_camas_editfilters_buttons,
    ]);
  
  mapping containers_handlers = 
    ([
    ]);
  
  contents = CAMAS.Parse.parse_html(contents, tags_handlers, containers_handlers, id);

  if(!id->misc->_xml_parser && QUERY(ent_parse))
      contents = parse_scopes(contents,cb_scopes,id);


  args->method = "post";
  args->name = "camaseditaddresfilterform";

  args = CAMAS.Tools.set_target(id, args);
  
  out += CAMAS.Tools.make_container("form", args, contents);

  out += "<!-- End of screen_EDITADDRESSFILTER -->";
  return out;
}


// TODO: implement a more user-firendly method for filterfield an filterfolder
string tag_camas_editfilters_inputs(string tag_name, mapping args, object id)
{
  string out = "";

  string namefield = "",
         filterexpression = "",
	 filterfolder = "",
	 varfolder = "",
	 varfield = "";

  if (CSESSION->editaddressfiltermode == "old")
  {
    array(array) filters = CAMAS.Filters.get_filters(id);
    [ namefield, filterexpression, filterfolder ] =
      filters[CSESSION->editaddressfilter];
  }
  else
    sscanf (CSESSION->newaddressfilter, "%s:%s:%s", namefield, filterexpression, filterfolder);
  namefield = CAMAS.Filters.decode_filter(namefield);
  filterexpression = CAMAS.Filters.decode_filter(filterexpression);
  filterfolder = CAMAS.Filters.decode_filter(filterfolder);

  string contents;
  switch(tag_name)
  {
    //! tag: camas_filterfield
    //!  Input for choosing on which field to filter
    //! note: screen: editaddressfilter
    case "camas_filterfield":
      // TODO: make these fileds user-configurable
      array fieldsfilters = ({ "From", "Subject", "Date", "To", "Cc" });
      // TODO: make filters for filtering bodies of mails

      args -> value = "imhonofield";
      contents = CAMAS.Tools.make_container("option", args, MSG(M_SELECTFIELD)) + "\n";
      foreach (fieldsfilters, string field)
      {
      	args -> value = field;
        if (namefield == field)
      	  args -> selected = "";
	  
      	contents += CAMAS.Tools.make_container("option", args, field) + "\n";

        if (namefield == field)
      	  m_delete(args, "selected");
      }
      m_delete(args, "value");
      args -> name = "namefield";
      out += CAMAS.Tools.make_container("select", args, contents) + "\n";
      break;

    //! tag: camas_filterexpression
    //!  Input for the filter expression
    //! note: screen: editaddressfilter
    case "camas_filterexpression":
      args -> name = "filterexpression";
      args -> value= HTML_ENCODE_STRING (filterexpression);
      out += CAMAS.Tools.make_tag("input", args);
      break;

    //! tag: camas_filterfolder
    //!  Input for the folder destination when expression matches
    //! note: screen: edit addressfilter
    case "camas_filterfolder":

      args -> value = "imhonomailbox";
      contents = CAMAS.Tools.make_container("option", args, MSG(M_SELECT)+"...") + "\n";
      // TODO: validate it against shared and user hierarchy
      // TODO: add filtering of shared and user hierarchy as an option
      for (int i = 0; i < sizeof (CSESSION->mailboxes); i++)
      {
        if (!(CSESSION->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT))
        {
          string mbox = CAMAS.FolderTools.translate_frommboxindex (id, i);
          if (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX] != CSESSION->mailbox[MB_FOLDERNAME_IDX])
          {
            args -> value = HTML_ENCODE_STRING (CSESSION->mailboxes[i][MB_FOLDERNAME_IDX]);
            if (filterfolder == CSESSION->mailboxes[i][MB_FOLDERNAME_IDX])
      	      args -> selected = "";
	    
      	    contents += CAMAS.Tools.make_container("option", args, HTML_ENCODE_STRING (mbox)) + "\n";
	    
            if (filterfolder == CSESSION->mailboxes[i][MB_FOLDERNAME_IDX])
      	      m_delete(args, "selected");

          }
        }
      }
      m_delete(args, "value");
      args -> name = "filterfolder";
      out += CAMAS.Tools.make_container("select", args, contents) + "\n";

      break;

    default:
      out += CAMAS.Tools.make_tag(tag_name,args)+"\n";
      CDEBUG("");
  }

  return out;
}

string tag_camas_editfilters_buttons(string tag_name, mapping args, object id)
{
  string out = "";
  
  switch(tag_name)
  {
    //! tag: camas_savefilter
    //!  Saves the current filter
    //! note: screen: editaddressfilter
    case "camas_savefilter":
      out += CAMAS.Tools.formdrawbutton(id,"m_savefilter", "actioneditaddressfilterdone", MSG(M_SAVEADDRESSFILTER), args); 
      break;

    //! tag: camas_cancelfilter
    //!  Cancels current filter editing
    //! note: screen: editaddressfilter
    case "camas_cancelfilter":
      out += CAMAS.Tools.formdrawbutton(id,"m_cancelfilter", "actioncanceleditaddressfilter", MSG(M_CANCELADDRESSFILTER), args);
      break;

    //! tag: camas_deletefilter
    //!  Deletes the current filter
    //! note: screen: editaddressfilter
    case "camas_deletefilter":
      if(CSESSION->editaddressfiltermode == "old");
        out += CAMAS.Tools.formdrawbutton(id,"m_deletefilter", "actiondeleteaddressfilter", MSG(M_DELETEADDRESSFILTER), args);
      break;

    // writing tag in case it should be parsed by another function
    // WARNING: args are not put back in the unparsed tag
    default:
      out += CAMAS.Tools.make_tag(tag_name,args)+"\n";
      CDEBUG(tag_name+" not recognized by tag_camas_editfilters_buttons");
  }

  return out;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */
