/*
  imho_portuguese.pike v0.1 for IMHO v0.96.3
  
  Copyright  
  Luis Furquim <vuco@prr4.gov.br> 1999
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

*/

#include <camas/language.h>

string imho_lang() {
  return "portugues";
}

string imho_lang_short() {
  return "pt";
}

string imho_lang_charset() {
  return "iso-8859-1";
}

string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Usurio:";
  case M_PASSWORD:
    //return "Password:";
    return "Senha:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>No conseguiu logar em:</b> Senha ou usurio errado. Tente novamente. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Ocorreu um problema contactando o servidor (IMAP). Contacte o administrador do sistema.";
  case M_SMTPERROR:
    //return "There was a problem talking to the outgoing mail (SMTP) server. The recipient of the mail might not exist.";
    return "Ocorreu um problema contactando o servidor (SMTP). O destinatrio do mail pode no existir.";
  case M_SAVEDUSERINTERFACE:
    //return "From preferences";
    return "Das Preferncias";
  case M_USERINTERFACE:
    //return "User interface:";
    return "Interface de usurio:";
  case M_LOGIN_OK:
    //return "OK";
    return "OK";

  case M_NEWMAIL:
    //return "New mail";
    return "Nova Mensagem";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Caixa Postal: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Caixas Postais";
  case M_FILES:
    //return "Files";
    return "Arquivos";
  case M_PREFS:
    //return "Preferences";
    return "Preferncias";
  case M_LOGOUT:
    //return "Logout";
    return "Logout";
  case M_CURRMAILBOX:
    // return "Current Mailbox";
    return "Caixa Postal Atual";
  case M_CHECKACTIVEMAILBOXES:
    // return "Check active mailboxes";
    return "Verificar caixas postais ativas";

  case M_FROM:
    //return "From";
    return "De";
  case M_TO:
    //return "To";
    return "Para";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Assunto";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Anexos";
  case M_TIME:
    //return "Time";
    return "Hora";
  case M_DATE:
    //return "Date";
    return "Data";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "R";
    
    
  case M_SEND:
    //return "Send";
    return "Enviar";
  case M_CANCELSEND:
    //return "Cancel";
    return "Cancelar";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Selecione arquivos para enviar. Pressione 'Ctrl' para mudar a seleo de mltiplos arquivos.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Composio de Mensagem";
  case M_SPELLCHECK:
    return "Verificao de Ortografia";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "No salve esta mensagem.";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Acrescentar arquivo como anexo";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Sem anexos";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Acrescente anexos...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Remover anexos marcados";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Upload anexo";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Acrescentar anexos marcados";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Upload para anexos";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Retorna a composio de mensagem";
  case M_NOATTACHFILES:
    //return "No files";
    return "Nenhum arquivo";
  case  M_ATTACHMENTSHEADER:
    return "Cabealho do anexo";
  case M_SENDSAVEFAILED:
    //return "Mail was sent successfully, but save in folder failed.";
    return "Mensagem enviada com sucesso, mas no conseguiu salvar na pasta.";
  case M_SENDNORECV:
    //return "You must specify a recipient of the mail.";
    return "Voce tem que especificar um destinatrio para a mensagem.";

  case M_DELETEMARKED:
    //return "Delete marked";
    return "Excluir marcados";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Mover marcados para";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Selecione uma caixa postal)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Checar Novas Mensagens";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Mensagem %d-%d de %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Anterior %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Prximo %d >>]", @arg);
  case M_NUMBER:
    return "N&ordm;";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return sprintf("Voc tem certeza que quer excluir a(s) %d mensagem(ens) marcada(s)?", @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Marque alguma mensagem primeiro.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Mudar ordenao";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Mover mensagens marcadas para trash";
  case M_DELETEALLTRASH:
    //return "Delete ALL trash";
    return "Excluir TUDO em trash";
  case M_NOMAILS:
    // return "[No mails]";
    return "[Nenhuma mensagem]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Caixa Postal";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Excluir marcados";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Criar uma nova pasta";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nome)";

  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Tem certeza que voc quer excluir as seguintes caixas postais?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Marque pelo menos uma caixa postal.";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Digite um nome primeiro.";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Falha na criao de caixa postal. O nome pode ser ilegal ou a caixa postal j existe.";
  case M_INBOX:
    //return "Inbox";
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    //return "[Previuos level]";
    return "[Nvel anterior]";
  case M_FOLDER_PATH:
    //return "Path:";
    return "Caminho:";
	
  case M_FILENAME:
    //return "Filename";
    return "Nome do arquivo";
  case M_SIZE:
    //return "Size";
    return "Tamanho";
  case M_MIMETYPE:
    //return "Type";
    return "Tipo";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Excluir marcados";
  case M_UPLOAD:
    //return "Upload";
    return "Upload";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Voc tem %d Kb disponveis para upload.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Usurios Windows: Devido a um bug em alguns navegadores. nomes de arquivos podem perder caracteres.  Evite isto modificando as ocorrncias de '\\' por '\\\\' antes de clicar 'Upload'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Voc no realizou nenhum upload.";

  case M_PNAME:
    //return "Name";
    return "Nome";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "E-Mail";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Diretrio de e-mail";

  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Incluir mail quando responder";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefixo";
  case M_PSIGNATURE:
    //return "Signature";
    return "Assinatura";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Logout inativo (minutos)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Salvar e usar";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Mensagens na caixa postal";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Ordenao de mensagens";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "avanar": "avanar", "retornar":"retornar"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Pasta Trash";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Pasta Sent";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Endereo Bcc padro";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Salvar anexos";
  case M_PLANGUAGE:
    //return "Language";
    return "Lngua";
  case M_PUSERINTERFACE:
    //return "User interface";
    return "Interface de usurio";
  case M_SPELLDONE:
    //return "Done";
    return "Feito";
  case M_SPELLPREV:
    //return "Previous";
    return "Anterior";
  case M_SPELLNEXT:
    //return "Next";
    return "Prximo";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Trocar para";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Sugestes";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Voc est desconectado. Feche esta janela do navegador para ter certeza que ningum possa ler suas mensagens.<br><br>Pressione Reload para fazer nova conexo";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Desconectado";

  case M_QUESTION:
    //return "Question"; 
    return "Pergunta";
  case M_INFO:
    //return "Info"; 
    return "Informao";

  case M_REPLY:
    //return "Reply";
    return "Responder";

  case M_READPREV:
    //return "Read previous";
    return "Ler anterior";
  case M_READNEXT:
    //return "Read next";
    return "Ler prximo";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sanexo do tipo %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Erro:</b> Falha na busca da mensagem. Tente novamente.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Retorno";
  case M_DELETE:
    //return "Delete";
    return "Exclui";
  case M_FORWARD:
    //return "Forward";
    return "Encaminhar";
  case M_MAIL:
    // return "Mail";
    return "Mensagem";
  case M_SHOWFULLHEADERS:
    //return "Show full headers";
    return "Mostrar cabealhos completos";
  case M_HIDEFULLHEADERS:
    //return "Hide full headers";
    return "Esconder cabealhos completos";
  case M_MAILTOOBIG:
    // return "Mail is too big to be shown. Click here to download it.";
    return "Mensagem muito grande para ser visualizada. Clique aqui para iniciar download.";

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Livro de endereos");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Livro de endereos...");
  case M_INDEXNAMERECIPIENT:
    //return("Intex name (click to add as recipient)");
    return("Nome (Clique para acrescentar destinatrio)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Nome (Clique para editar)");
  case M_ADDRESS:
    //return("Address");
    return("Endereo");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Nenhum endereo");
  case M_NEWADDRESS:
    //return("New address...");
    return("Novo endereo...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Editar endereo");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Acrescentar ao livro de endereos");
  case M_INDEXNAME:
    //return("Index name");
    return("Nome");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Endereo(s), Lista separada por vrgulas");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Gravar e usar");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Excluir endereo");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Cancelar");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("No conseguiu importar o livro de endereos,\nformato desconhecido.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importar livro de endereos");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Upload de livro de endereos do Pine ou exportado do Netscape (.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("O livro de endereos do Pine est, freqentemente, em  ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Upload e importao");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importar livro de endereos...");

  case M_LDAPTITLE:
    //return("LDAP addresses");
    return("Endereo LDAP");
  case M_LDAP:
    //return("LDAP");
    return("LDAP");
  case M_SEARCHLDAP:
    //return("Search LDAP");
    return("Procurar LDAP");
  case M_NAMECONT:
    //return("Search name containing:");
    return("Procurar nome contendo:");

  case M_YES:
    //return "Yes";
    return "Sim";
  case M_NO:
    //return "No";
    return "No";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Cancelar";

  }
  return 0;
}





