(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the Gui standalone. *)

let _ = GMain.Main.init ()

let usage () =
  prerr_endline "usage: omom.gui <omom_file>";
  exit 2

let main () =
  let w = GWindow.window 
      ~title: Omom_messages.software 
      ~width: 800
      ~height: 400
      ()
  in

  let app = new Omom_app.app Sys.argv.(1) in
  
  let _ = w#add app#box#coerce in
  let _ = app#init_window w in
  let _ = app#box#connect#destroy w#destroy in

  let _ = w#connect#destroy GMain.Main.quit in

  let _ = w#show () in
  GMain.Main.main ();
  app#close

let _ =
  if Array.length Sys.argv <> 2 then
    usage ()
  else
    try
      main ()
  with e ->
    prerr_endline (Printexc.to_string e)
