(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Cameleon plug-in. Define a command to launch [make] on different targets. *)

open Cam_plug
open Cam_plug.Options

module C = Configwin

(** Run [make] in the selected directory, on the given targets.
   @command make
*)
let make args = 
  match selected_dir () with
    None -> ()
  | Some d ->
      let s_args = String.concat " " args in
      let com = "make "^s_args in
      let com2 = "cd "^(Filename.quote d)^" ; "^com in
      Cam_plug.background_execute_with_subst ~width: 600 com2 ()

let _ = Cam_plug.add_command "make" 
    "Run make in the selected directory, on the targets given in argument" 
    make
      
