(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module of the generator. *)

let _ = Rep_args.parse ()

let _ = match !Rep_args.file with
  None ->
    prerr_endline Rep_messages.usage ;
    exit 1
| Some file ->
    if !Rep_args.generate_code then
      (
       try
	 let data = new Rep_data.data ~gui: false file in
	 let ml_file = 
	   match !Rep_args.output_file with
	     None -> 
	       (try Filename.chop_extension file
	     with Invalid_argument _ -> file)^".ml" 
	   | Some f -> f
	 in
	 Rep_gen_code.gen_code ml_file data#report
       with
	 Failure s ->
	   prerr_endline s;
	   exit 1
      )
    else
      (* if the output_file is given, then we must 
	 save to this file. *)
      match !Rep_args.output_file with
	None -> ()
      |	Some f ->
	  try 
	    let data = new Rep_data.data ~gui: false file in
	    data#set_file f;
	    data#save 
	  with 
	    Failure s -> prerr_endline s ; exit 2
	  
      
