(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

let software = "Report"
let software_version = "1.3"

(** {2 Command line options and messages} *)

let usage = 
  let e = Filename.basename Sys.argv.(0) in
  e^" [options] <file>\n"^
  "Examples:\n"^
  e^" -ibin -o foo bar    translate the binary file bar to XML file foo\n"^
  e^" -obin -o foo bar    translate the XML file bar to binary file foo\n"^
  e^" -gen bar            generate code from file bar to bar.ml \n"^
  e^" -gen -ibin bar      generate code from binary file bar to bar.ml \n"^
  e^" -gen -o foo.ml bar  generate code from file bar to foo.ml\n"
  
let usage_gui = (Filename.basename Sys.argv.(0))^" [options] <file>\n"
let options_are = "Options are :"

let opt_gen = " generate code to (chop_extension <file>).ml"
let opt_out = " <file>  Output code to <file> or translate the given file into <file>"
let opt_bin_in = " binary input"
let opt_bin_out = " binary output"

(** {2 Messages and labels} *)

let error = "Error"
let fun_unit = "fun () -> "
let tag = "Tag : "
let ocaml_id = "OCaml id : "
let name = "Name : "
let generated_by = "File generated by "^software^" version "^software_version
let parameters = "Parameters"
let add_parameter = "Add parameter"
let code = "Code : fun () -> "
let add = "Add"
let edit = "Edit"
let remove = "Remove"
let header = "Header"
let attributes = "Attributes"

(** {2 Menu labels} *)

let mnFile = "File"
let mnSave = "Save"
let mnEdit = "Edit"
let mnNode = "Report"
let mnHelp = "?"
let mnQuit = "Quit"
let mnCopy = "Copy"
let mnPaste = "Paste"
let mnCut = "Cut"
let mnUp = "Up"
let mnInsert_leaf = "Insert leaf"
let mnInsert_tag = "Insert tag"
let mnInsert_list = "Insert list"
let mnInsert_cond = "Insert conditionnal"
let mnInsert_sub = "Insert subreport"
let mnInsert_mark = "Insert mark"
let mnEdit_selected = "Edit selected"
let mnEdit_params = "Edit parameters"
let mnEdit_header = "Edit header"
