(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Image
open OImage
open Info

let _ =
  let files = ref [] in
  Arg.parse [] (fun s -> files := s :: !files) "converter src dst";
  let src,dst = 
    match List.rev !files with
    | [src; dst] -> src, dst
    | _ -> raise (Invalid_argument "you need two arguments")
  in

  let src = OImage.load src [] in

  let saver src = src#save dst None [] in
  try
    saver src
  with
  | Wrong_image_type ->
      (* try to use other color model *)
      let src' =
	match OImage.tag src with
	| Rgb24 img -> raise (Invalid_argument "Sorry! No color reduction is implemented") 
	| Index8 img -> img#to_rgb24#coerce
	| Index16 img -> img#to_rgb24#coerce
	| _ -> raise (Invalid_argument "not supported")
      in
      saver src'
;;  
