(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Image
open OImage
open Info

let _ =
  let files = ref [] in
  Arg.parse [] (fun s -> files := s :: !files) "normalize src dst";
  let src, dst =
    match List.rev !files with
    | [src; dst] -> src, dst
    | _ -> assert false in
  
  let src = OImage.rgb24 (OImage.load src []) in

  let normalize img = 
    (* Make monochrome *)
    let hist = Colorhist.create () in
    for x = 0 to src#width - 1 do
      for y = 0 to src#height - 1 do
	Colorhist.store_sample hist (src#get x y)
      done
    done;
    prerr_endline "histgram done";
    let normalizer = Colorhist.normalize 0.9 hist in
    prerr_endline "normalizer done";
    for x = 0 to src#width - 1 do
      for y = 0 to src#height - 1 do
	let rgb = src#get x y in
	let new_rgb = normalizer rgb in
	src#set x y new_rgb;
      done
    done;
  in
  
  let saver img = img#save dst None [] in
  
  normalize src;
  saver src
;;  
