#ifndef VIDEODEVICETUNER_HPP
#define VIDEODEVICETUNER_HPP

#include <qobject.h>

class CVideoDevice;

class CVideoDeviceTuner: public QObject
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;
   int Tuner;
   
   QString Name;
   float FreqLow, FreqHigh;
   float FreqStep;
   ulong ufreq;

public:
   CVideoDeviceTuner(CVideoDevice *_video, int _tuner);
   
   const QString GetName();
   float GetLowestFrequency() const;
   float GetHighestFrequency() const;
   float GetFrequency() const;
   bool SetFrequency(float freq);
};

#endif
