/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef AUDIODISPLAY_HPP
#define AUDIODISPLAY_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qsize.h>
#include <qwidget.h>

#include "AudioDevice.h"
#include "AudioDisplayVolume.h"
#include "leftdialog.h"

class CAudioDisplayFFT;

class CAudioDisplay: public QWidget
{
   Q_OBJECT
private:
   /* left hand side */
   CAuControls *m_pLeftSide;
   CAudioDevice *m_pAudio;
   int m_LeftWidth;
   QSize m_MySize;

   QDomNode m_OrgMixerSettings;
   /* right hand side */
   CAudioDisplayVolume *m_pVolume;
//   CAudioDisplayFFT *pFFT;

   void Audio2Dlg();
   void ArrangeRight();

private slots:
   void ToggleVolumeBars(bool);
   void ToggleFFT(bool);

   void ResetMixerSettings();

public:
   CAudioDisplay(CAudioDevice *audio_device, QWidget *parent = 0, const char *name = 0);
   ~CAudioDisplay();

   virtual QSize sizeHint() const;
};


#endif
