#include <qapplication.h>
#include <qmenubar.h>

#include "VideoCollector.h"

#include "caminfowindow.h"

caminfoWindow::caminfoWindow( QWidget* parent, const char* name, WFlags f )
	: QMainWindow( parent, name, f )
{
   QListViewItem *Root, *LastDev;

   CVideoCollector *VColl = CVideoCollector::Instance();
   CVideoDevice *vd;
   int i, dev;

   setCaption("caminfo");
   menuBar()->insertItem("E&xit", qApp, SLOT(quit()));

   // Add your code
   m_pDevicesListView = new QListView(this, "devices view");
   m_pDevicesListView->addColumn(tr("Object"));
   m_pDevicesListView->addColumn(tr("Data"));   

   VColl = CVideoCollector::Instance();
   dev = VColl->NumberOfVideoDevices();
   Root = new QListViewItem(m_pDevicesListView, "Number of drivers", QString::number(dev));
   for (i = 0; i < dev; i++) {
      vd = VColl->GetVideoDevice(i);
      LastDev = new QListViewItem(Root, vd->GetNodeName(), vd->GetIntfName());

   }
   Root->setOpen(true);

   setCentralWidget(m_pDevicesListView);
}
