#include "main.h"
#include "server.h"

BattlePlayer BaPlayer[PLAYERNUM];

void Destroy( int x, int y, int BigCannon)
{
    int WhichPlayer,i,s,Hit=0,a,b;
    SDL_Rect Rect;
    
    for (WhichPlayer=0;WhichPlayer<PlayerNum;WhichPlayer++)
	for (i=0;i<BaPlayer[WhichPlayer].CannonNum;i++)
	    if (  (x>=BaPlayer[WhichPlayer].Cannon[i].x*BSIZE)&&(x<BaPlayer[WhichPlayer].Cannon[i].x*BSIZE+BSIZE*BaPlayer[WhichPlayer].Cannon[i].Size)
		&&(y>=BaPlayer[WhichPlayer].Cannon[i].y*BSIZE)&&(y<BaPlayer[WhichPlayer].Cannon[i].y*BSIZE+BSIZE*BaPlayer[WhichPlayer].Cannon[i].Size))
		if (++BaPlayer[WhichPlayer].Cannon[i].Damage >= BaPlayer[WhichPlayer].Cannon[i].Stability) {

		    if (BaPlayer[WhichPlayer].Cannon[i].Destroyed)
			return;
		
		    // force redraw
		    s=BaPlayer[WhichPlayer].Cannon[i].Size;
		    for (a=BaPlayer[WhichPlayer].Cannon[i].x;a<s+BaPlayer[WhichPlayer].Cannon[i].x;a++)
			for (b=BaPlayer[WhichPlayer].Cannon[i].y;b<s+BaPlayer[WhichPlayer].Cannon[i].y;b++)
			    BPlayer[WhichPlayer].Secured[a][b]=1-BPlayer[WhichPlayer].Secured[a][b];

		    BaPlayer[WhichPlayer].Cannon[i].Destroyed=abrand(1,5);
		    BaPlayer[WhichPlayer].Cannon[i].Active=0;
		    
		    Hit=1;
		}
		

    if (Wall[(int)(x/BSIZE)][(int)(y/BSIZE)]) {
	Rect.x=(int)(x/BSIZE)*BSIZE;    
	Rect.y=(int)(y/BSIZE)*BSIZE;    
	Rect.w=BSIZE;    
	Rect.h=BSIZE;    
	SDL_BlitSurface( BackPic, &Rect, BackBuffer, &Rect);
	SDL_BlitSurface( BackPic, &Rect, Screen, &Rect);
	AddThisRect(Rect);
        BPlayer[Landscape[x/BSIZE][y/BSIZE]].Secured[x/BSIZE][y/BSIZE]=0;
	
	Wall[(int)(x/BSIZE)][(int)(y/BSIZE)]=0;

        if (BigCannon) {
    	    BlitToBB(x/BSIZE*BSIZE, y/BSIZE*BSIZE, GarbagePic);
    	    Blit(x/BSIZE*BSIZE, y/BSIZE*BSIZE, GarbagePic);
    	    Garbage[x/BSIZE][y/BSIZE]=3;
	}

	Hit=1;
	PlaySound(DropSound);
    }

    if (House[(int)(x/BSIZE)][(int)(y/BSIZE)]) {
	Rect.x=(int)(x/BSIZE)*BSIZE;    
	Rect.y=(int)(y/BSIZE)*BSIZE;    
	Rect.w=BSIZE;    
	Rect.h=BSIZE;    
	SDL_BlitSurface( BackPic, &Rect, BackBuffer, &Rect);
	SDL_BlitSurface( BackPic, &Rect, Screen, &Rect);
	AddThisRect(Rect);
	
	House[(int)(x/BSIZE)][(int)(y/BSIZE)]=0;
    }

    for (i=0;i<TankNum;i++)
	if ( (x/BSIZE==Tank[i].x)&&(y/BSIZE==Tank[i].y) ) {
	    UndrawTank(i);
	
	    Tank[i]=Tank[TankNum-1];
	    TankNum--;
	}

    WhichPlayer=Landscape[x/BSIZE][y/BSIZE];
    if (WhichPlayer==127) {
	printf("Water was hit!\n");
	WhichPlayer=0;
    }
    if (Hit) LookForSecuredAreas(WhichPlayer);
}

void UndrawThisCannon ( int WhichPlayer, int WhichCannon, int mode )
{
    SDL_Rect rect;
    
    if ( ! BaPlayer[WhichPlayer].Cannon[WhichCannon].Active )
	return;

    rect.x = BaPlayer[WhichPlayer].Cannon[WhichCannon].x*BSIZE;
    rect.y = BaPlayer[WhichPlayer].Cannon[WhichCannon].y*BSIZE;
    rect.w = rect.h = BaPlayer[WhichPlayer].Cannon[WhichCannon].Size*BSIZE;
    
    if (mode) {
	int x,y;
	CannonType *can;
    
	SDL_BlitSurface( BackPic, &rect, BackBuffer, &rect);
	can = &BaPlayer[WhichPlayer].Cannon[WhichCannon];
	for ( x=0; x < can->Size; x++)
	    for ( y=0; y < can->Size; y++)
		BlitToBB( (can->x+x)*BSIZE, (can->y+y)*BSIZE, BPlayer[WhichPlayer].Ground );
	
    } else {
	SDL_BlitSurface( BackBuffer, &rect, Screen, &rect);
	AddThisRect( rect );
    }

}

void UndrawCannons ( int mode )
{
    int WhichPlayer,i;

    for (WhichPlayer=0;WhichPlayer<PlayerNum;WhichPlayer++) {
	for (i=0;i<BaPlayer[WhichPlayer].CannonNum;i++) {
	    UndrawThisCannon( WhichPlayer, i, mode);
	}
    }
}

void DrawCannons ( int mode )
{
    SDL_Surface *pic;
    float dx,dy,angle;
    CannonType *can;
    int WhichPlayer,i;

    for (WhichPlayer=0;WhichPlayer<PlayerNum;WhichPlayer++)
	for (i=0;i<BaPlayer[WhichPlayer].CannonNum;i++) {

	    can = &BaPlayer[WhichPlayer].Cannon[i];
	    if (can->Active) {
		dx = BaPlayer[WhichPlayer].x - (can->x + can->Size/2)*BSIZE;
		dy = BaPlayer[WhichPlayer].y - (can->y + can->Size/2)*BSIZE;
		angle = atan( dy / dx );
		angle /= 2*M_PI;
	        angle += 0.25;
		if ( dx < 0 )
		    angle += 0.5;
		// now angle is between 0 and 1
	        angle = (1-angle)*29;
		angle += 1;
		if (angle>29) angle-=29;
	
		if ( can->Type == 1) {
		    pic = BigCannonPic[(int)angle];
		} else {
		    pic = CannonPic[(int)angle];
		}

		if ( mode ) {
		    BlitToBB( can->x*BSIZE, can->y*BSIZE, pic );
		} else {
		    Blit( can->x*BSIZE, can->y*BSIZE, pic );
		}
	    }	    	    
	}
	    
}

void DrawCrosshair()
{
    int i,can,ready;
    
    for (i=0;i<PlayerNum;i++)
	if ( !BPlayer[i].Lost ) {
	    can = BaPlayer[i].NextCannon;
	    ready = 1;
	    while (( BaPlayer[i].Cannon[can].Shot )||( !BaPlayer[i].Cannon[can].Active )) {
		can++;
		if ( can >= BaPlayer[i].CannonNum) can = 0;
		if ( can == BaPlayer[i].NextCannon) {
		    ready = 0;
		    break;
		}
	    }
	    if (ready) {
		Blit( BaPlayer[i].x-CrosshairPic->w/2, BaPlayer[i].y-CrosshairPic->h/2, BaPlayer[i].Crosshair );
	    } else {
    	        Blit( BaPlayer[i].x-CrosshairPic->w/2, BaPlayer[i].y-CrosshairPic->h/2, BaPlayer[i].NotReady );
	    }
	}
}

void UndrawCrosshair()
{
    SDL_Rect Rect;
    int i;
    
    Rect.w=CrosshairPic->w;
    Rect.h=CrosshairPic->h;

    for (i=0;i<PlayerNum;i++) {
	Rect.x=BaPlayer[i].x-CrosshairPic->w/2;
	Rect.y=BaPlayer[i].y-CrosshairPic->h/2;
	SDL_BlitSurface( BackBuffer, &Rect, Screen, &Rect);
	AddThisRect( Rect );
    }
}

void DrawShots()
{
    int i,can;
    CannonType *Cannon;
    
    for (i=0;i<PlayerNum;i++)
	for (can=0;can<BaPlayer[i].CannonNum;can++) {
	    Cannon = &BaPlayer[i].Cannon[can];
	    if (Cannon->Shot)
    		Blit( Cannon->ShotX-ShotPic->w/2, Cannon->ShotY-ShotPic->h/2, ShotPic);
	}
}

void HandleShots()
{
    int i,can,headstart;
    CannonType *Cannon;

    for (i=0;i<PlayerNum;i++)
	for (can=0;can<BaPlayer[i].CannonNum;can++) {
	    Cannon = &BaPlayer[i].Cannon[can];
	    if (Cannon->Shot) {
		// Let the shots start a bit away from the middle of the cannon
		headstart = 45*Cannon->Size;
		Cannon->TimeSinceShot += Speed;
		Cannon->TimeSinceShot += headstart;
		Cannon->TimeToTarget  += headstart;
		// Calculate shot position
		Cannon->ShotX = 
		    ((float)Cannon->TimeSinceShot/Cannon->TimeToTarget)*Cannon->DestX
		    + (1-(float)Cannon->TimeSinceShot/Cannon->TimeToTarget)*(Cannon->x*BSIZE+(float)Cannon->Size/2*BSIZE);
		Cannon->ShotY = 
		    ((float)Cannon->TimeSinceShot/Cannon->TimeToTarget)*Cannon->DestY 
		    + (1-(float)Cannon->TimeSinceShot/Cannon->TimeToTarget)*(Cannon->y*BSIZE+(float)Cannon->Size/2*BSIZE);
		//printf("%d + %d + %d + %d\n",Cannon->ShotX,Cannon->ShotY,Cannon->TimeSinceShot,Cannon->TimeToTarget);
		if ( Cannon->TimeSinceShot >= Cannon->TimeToTarget ) {
		    Destroy( Cannon->DestX, Cannon->DestY, Cannon->Type );
		    Cannon->Shot=0;
		}
		// Let's keep the real values
		Cannon->TimeSinceShot -= headstart;
		Cannon->TimeToTarget  -= headstart;
	    }
	}
}

void UndrawShots()
{
    SDL_Rect Rect;
    int i,can;
    CannonType *Cannon;
    
    Rect.w=ShotPic->w;
    Rect.h=ShotPic->h;

    for (i=0;i<PlayerNum;i++)
	for (can=0;can<BaPlayer[i].CannonNum;can++) {
	    Cannon = &BaPlayer[i].Cannon[can];
	    if (Cannon->Shot) {
    	        Rect.x = Cannon->ShotX-ShotPic->w/2;
		Rect.y = Cannon->ShotY-ShotPic->h/2;
		SDL_BlitSurface( BackBuffer, &Rect, Screen, &Rect);
		AddThisRect(Rect);
	    }
	}
}

void ReallyShoot( int WhichPlayer, int i )
{
    CannonType *Cannon;

    Cannon = &BaPlayer[WhichPlayer].Cannon[i];
    Cannon->Shot=1;
    Cannon->DestX=BaPlayer[WhichPlayer].x;
    Cannon->DestY=BaPlayer[WhichPlayer].y;
    Cannon->TimeSinceShot=0;
    // printf("x:%.2f  x:%.2f\n",Cannon->DestX-(Cannon->x+(float)Cannon->Size/2)*BSIZE,Cannon->DestY-(Cannon->y+(float)Cannon->Size/2)*BSIZE);
    Cannon->TimeToTarget=hypot(Cannon->DestX-(Cannon->x+(float)Cannon->Size/2)*BSIZE,Cannon->DestY-(Cannon->y+(float)Cannon->Size/2)*BSIZE)*6;
    BaPlayer[WhichPlayer].NextCannon++;
    if (BaPlayer[WhichPlayer].NextCannon>=BaPlayer[WhichPlayer].CannonNum)
	BaPlayer[WhichPlayer].NextCannon=0;

    PlaySound(CannonSound);
}

void Shoot( int WhichPlayer )
{
    int i=BaPlayer[WhichPlayer].NextCannon;
    char data[4];
    
    while (( BaPlayer[WhichPlayer].Cannon[i].Shot )||( !BaPlayer[WhichPlayer].Cannon[i].Active )) {
	i++;
	if (i>=BaPlayer[WhichPlayer].CannonNum) i=0;
	if (i==BaPlayer[WhichPlayer].NextCannon) return;
    }
    
    data[0]=3;
    data[1]=NET_SHOOT;
    data[2]=WhichPlayer;
    data[3]=i;
    Net_Send(data);
    
    ReallyShoot( WhichPlayer, i);
}

int BattleEvents(const SDL_Event *event)
{
    int i;
    Uint8 *keys;

    switch (event->type) {
	case SDL_MOUSEBUTTONDOWN:
//	    SDL_GetMouseState(&MouseX, &MouseY);
	break;    
	case SDL_KEYDOWN:
	    keys = SDL_GetKeyState(NULL);
	    for (i=0;i<PlayerNum;i++) 
		if (( !BPlayer[i].Lost )&&( BPlayer[i].Local )) {
		    if ( event->key.keysym.sym == BPlayer[i].Button1 ) Shoot(i);
		    //if ( event->key.keysym.sym == BPlayer[i].Button2 ) Turn(i);
		}
	break;
    }
    
    return NormalEvents(event);
}

void InitBattle()
{
    int i,can;
    Coord coord;

    if (PlayerNum>2) {
        BaPlayer[0].x=(Width/4)*BSIZE;
	BaPlayer[0].y=(Height/4)*BSIZE;
        BaPlayer[1].x=(Width/4*3)*BSIZE;
        BaPlayer[1].y=(Height/4)*BSIZE;
	BaPlayer[2].x=(Width/4)*BSIZE;
        BaPlayer[2].y=(Height/4*3)*BSIZE;
	BaPlayer[3].x=(Width/4*3)*BSIZE;
        BaPlayer[3].y=(Height/4*3)*BSIZE;
    }
    for (i=0;i<PlayerNum;i++) {
	if (PlayerNum==2) {
            BaPlayer[i].x=(Width/4+Width/2*i)*BSIZE;
	    BaPlayer[i].y=(Height/2)*BSIZE;
	}
	for (can=0;can<BaPlayer[i].CannonNum;can++) {
	    BaPlayer[i].Cannon[can].Damage=0;
	    BaPlayer[i].Cannon[can].Shot=0;
	    if ((BPlayer[i].Secured[BaPlayer[i].Cannon[can].x][BaPlayer[i].Cannon[can].y])
		&&(!BaPlayer[i].Cannon[can].Destroyed))
		BaPlayer[i].Cannon[can].Active=1;
	    else
		BaPlayer[i].Cannon[can].Active=0;
	}
    }

    if (Conquer) {
	for (i=0;i<PlayerNum;i++) {
	    coord = Center(i);
	    BaPlayer[i].x = coord.x*BSIZE;
	    BaPlayer[i].y = coord.y*BSIZE;
	}
    }
	    
    Blit(0, 0, BackBuffer);
    DrawCrosshair();
    Update();
    UndrawCannons( 1 );
}

void GetSpeed()
{
    Speed=SDL_GetTicks()-Now;
    if (Server) ServerLoop();
    while (Speed<BSIZE) {
	SDL_Delay(1);
	Speed=SDL_GetTicks()-Now;
        if (Server) ServerLoop();
    }
    Now=SDL_GetTicks();
}

void BattleMove()
{
    Uint8 *keys,i;
    float Distance;
    char data[7];

    keys = SDL_GetKeyState(NULL);

    for (i=0;i<PlayerNum;i++) 
    if (BPlayer[i].Local) {
	if ( keys[BPlayer[i].Button2] == SDL_PRESSED )
	    Distance=Speed/60*BSIZE;
	else
	    Distance=Speed/120*BSIZE;
	if ( keys[BPlayer[i].Up   ] == SDL_PRESSED ) BaPlayer[i].y-=Distance;
	if ( keys[BPlayer[i].Down ] == SDL_PRESSED ) BaPlayer[i].y+=Distance;
	if ( keys[BPlayer[i].Left ] == SDL_PRESSED ) BaPlayer[i].x-=Distance;
	if ( keys[BPlayer[i].Right] == SDL_PRESSED ) BaPlayer[i].x+=Distance;
	if (BaPlayer[i].x<0)   BaPlayer[i].x=0;
	if (BaPlayer[i].x>Width*BSIZE-1) BaPlayer[i].x=Width*BSIZE-1;
	if (BaPlayer[i].y<0)   BaPlayer[i].y=0;
	if (BaPlayer[i].y>Height*BSIZE-1) BaPlayer[i].y=Height*BSIZE-1;
	
	data[0]=6;
	data[1]=NET_BATTLE_MOVE;
	data[2]=i;
	data[3]=(int)BaPlayer[i].x % 100;
	data[4]=BaPlayer[i].x / 100;
	data[5]=(int)BaPlayer[i].y % 100;
	data[6]=BaPlayer[i].y / 100;
	Net_Send( data );
    }
}


void Battle()
{
    int ShotNum,i,can;

    Phase = BATTLE_PHASE;
    SDL_EventState(SDL_KEYDOWN, SDL_IGNORE);
    SDL_SetEventFilter(&BattleEvents);
    InitBattle();
    Net_WaitForStart();
    ShowText("Shoot At Enemy Castle Walls!");
    Net_WaitForStart();
    SDL_EventState(SDL_KEYDOWN, SDL_ENABLE);
    Now=SDL_GetTicks();
    EndOfPhase=Now+10*1000;
    printf("-- Battle phase begins \n");
    // Battle
    while ((!Quit)&&(SDL_GetTicks()<EndOfPhase)) {
	GetSpeed();

	UndrawCrosshair();
	UndrawShots();
	UndrawCannons( 0 );

	Network();
	SDL_PollEvent(&event);
	BattleMove();
	HandleShots();
	HandleTanks();

	DrawCannons( 0 );
	DrawShots();
	DrawCrosshair();
	PrintTime();
	Update();
    }
    UndrawCrosshair();
    SDL_EventState(SDL_KEYDOWN, SDL_IGNORE);
    Net_WaitForStart();
    // Let the remaining shots fly...
    do {
	ShotNum=0;
	for (i=0;i<PlayerNum;i++)
	    for (can=0;can<BaPlayer[i].CannonNum;can++)
		if ( BaPlayer[i].Cannon[can].Shot)
		    ShotNum++;
    
	GetSpeed();

	UndrawShots();
	UndrawCannons( 0 );

	Network();
	SDL_PollEvent(&event);
	HandleShots();
	HandleTanks();

	DrawCannons( 0 );
	DrawShots();
	PrintTime();
	Update();
    } while ( ShotNum > 0 );
    DrawCannons( 1 );
    printf("-- Battle phase has finished\n");
}
