/*
 * cc_debug_interface.h
 *
 * Created on: Jul 28, 2011
 *     Author: George Stark <george-u@yandex.com>
 *
 * License: GNU GPL v2
 *
 */

#ifndef _CC_DEBUG_INTERFACE_H_
#define _CC_DEBUG_INTERFACE_H_

#include "common.h"

const size_t CC_BREAKPOINT_COUNT	= 4;

const uint8_t
	DEBUG_STATUS_STACK_OVERFLOW		= 0x01,
	DEBUG_STATUS_OSCILLATOR_STABLE 	= 0x02,
	DEBUG_STATUS_DEBUG_LOCKED		= 0x04,
	DEBUG_STATUS_HALT_STATUS		= 0x08,
	DEBUG_STATUS_PM_ACTIVE			= 0x10,
	DEBUG_STATUS_CPU_HALTED			= 0x20,
	DEBUG_STATUS_PCON_IDLE 			= 0x40,
	DEBUG_STATUS_CHIP_ERASE_BUSY 	= 0x80;

const uint8_t
	DEBUG_CONFIG_SEL_FLASH_INFO_PAGE = 0x01,
	DEBUG_CONFIG_TIMER_SUSPEND		= 0x02,
	DEBUG_CONFIG_DMA_PAUSE			= 0x04,
	DEBUG_CONFIG_TIMERS_OFF 		= 0x08,
	DEBUG_CONFIG_SOFT_POWER_MODE	= 0x20;

const uint8_t
	DEBUG_COMMAND_CHIP_ERASE	= 0x14,
	DEBUG_COMMAND_WR_CONFIG		= 0x1D,
	DEBUG_COMMAND_RD_CONFIG		= 0x24,
	DEBUG_COMMAND_GET_PC		= 0x28,
	DEBUG_COMMAND_READ_STATUS	= 0x34,
	DEBUG_COMMAND_SET_HW_BRKPNT	= 0x3F,
	DEBUG_COMMAND_HALT			= 0x44,
	DEBUG_COMMAND_RESUME		= 0x4C,
	DEBUG_COMMAND_DEBUG_INSTR	= 0x55,
	DEBUG_COMMAND_STEP_INSTR	= 0x5C,
	DEBUG_COMMAND_GET_BM		= 0x00,// ??
	DEBUG_COMMAND_GET_CHIP_ID	= 0x68,
	DEBUG_COMMAND_BURST_WRITE	= 0x80;

#endif // !_CC_DEBUG_INTERFACE_H_
