/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

//
// $Id: FPC.cpp,v 1.6 2001/07/19 16:57:32 lijewski Exp $
//

#include <FPC.H>
//
// FP orders.
//
const int FPC::normal_float_order[]     = { 1, 2, 3, 4 };
const int FPC::reverse_float_order[]    = { 4, 3, 2, 1 };
const int FPC::reverse_float_order_2[]  = { 2, 1, 4, 3 };
const int FPC::normal_double_order[]    = { 1, 2, 3, 4, 5, 6, 7, 8 };
const int FPC::reverse_double_order[]   = { 8, 7, 6, 5, 4, 3, 2, 1 };
const int FPC::reverse_double_order_2[] = { 2, 1, 4, 3, 6, 5, 8, 7 };
const int FPC::cray_float_order[]       = { 1, 2, 3, 4, 5, 6, 7, 8 };

//
// Floating point formats.
//
const long FPC::ieee_float[]  = { 32L,  8L, 23L, 0L, 1L,  9L, 0L,   0x7FL };
const long FPC::ieee_double[] = { 64L, 11L, 52L, 0L, 1L, 12L, 0L,  0x3FFL };
const long FPC::cray_float[]  = { 64L, 15L, 48L, 0L, 1L, 16L, 1L, 0x4000L };


//
// Every copy of the library will have exactly one
// `nativeLongDescriptor' and `nativeRealDescriptor' compiled into it.
// Each machine on which BoxLib runs MUST have them defined below.
//


const
IntDescriptor&
FPC::NativeLongDescriptor ()
{
#if defined(__alpha) || defined(__i486__) || defined(WIN32) || defined(i386) || defined(__i386__) || defined(__ia64__) || defined(__x86_64__)
    static const IntDescriptor nld(sizeof(long), IntDescriptor::ReverseOrder);
#endif

#ifdef _CRAY1
    static const IntDescriptor nld(sizeof(long), IntDescriptor::NormalOrder);
#endif

#if defined(__sgi) || \
    defined(__sun) || \
    defined(_AIX)  || \
    defined(_CRAYT3E)  || \
    defined(__hpux)
    static const IntDescriptor  nld(sizeof(long), IntDescriptor::NormalOrder);
#endif

    return nld;
}

const
RealDescriptor&
FPC::NativeRealDescriptor ()
{
#if defined(__alpha) || defined(__i486__) || defined(WIN32) || defined(i386) || defined(__i386__) || defined(__ia64__) || defined(__x86_64__)
#ifdef BL_USE_FLOAT
    static const RealDescriptor nrd(ieee_float, reverse_float_order, 4);
#else
    static const RealDescriptor nrd(ieee_double, reverse_double_order, 8);
#endif
#endif

#ifdef _CRAY1
    static const RealDescriptor nrd(cray_float, cray_float_order, 8);
#endif

#if defined(__sgi) || \
    defined(__sun) || \
    defined(_AIX)  || \
    defined(_CRAYT3E)  || \
    defined(__hpux)
#ifdef BL_USE_FLOAT
    static const RealDescriptor nrd(ieee_float, normal_float_order, 4);
#else
    static const RealDescriptor nrd(ieee_double, normal_double_order, 8);
#endif
#endif

    return nrd;
}

const
RealDescriptor&
FPC::CrayRealDescriptor ()
{
    static const RealDescriptor crd(cray_float, cray_float_order, 8);
    return crd;
}

const
RealDescriptor&
FPC::Ieee32NormalRealDescriptor ()
{
    static const RealDescriptor i32rd(ieee_float, normal_float_order, 4);
    return i32rd;
}

const
RealDescriptor&
FPC::Ieee64NormalRealDescriptor ()
{
    static const RealDescriptor i64rd(ieee_double, normal_double_order, 8);
    return i64rd;
}


//
// TODO -- add more machine descriptions.
//
#if !(defined(__alpha)    || \
      defined(_CRAY1)     || \
      defined(_CRAYT3E)   || \
      defined(__sgi)      || \
      defined(__sun)      || \
      defined(__i486__)   || \
      defined(i386)       || \
      defined(__i386__)   || \
      defined(__ia64__)   || \
      defined(__x86_64__) || \
      defined(__hpux)     || \
      defined(_MSC_VER)   || \
      defined(_AIX))
#error We do not yet support FAB I/O on this machine
#endif

