/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _ProbBld_H_
#define _ProbBld_H_

//
// $Id: ProbBld.H,v 1.7 2000/10/02 20:47:02 lijewski Exp $
//

#include <LevelBld.H>
#include <HyperCLaw.H>

//
//@Man:
//@Memo: Problem-dependent level builder.
/*@Doc: 


  This class provides a virtual constructor interface for problem-specific
  objects derived from AmrLevel.
*/

class ProbBld
    :
    public LevelBld
{
    //
    //@ManDoc: Defines static variables, physical boundary conditions, derived quantities
    //
    virtual void variableSetUp ();
    //
    //@ManDoc: Cleans up after variableSetUp().
    //
    virtual void variableCleanUp ();
    //
    //@ManDoc: Returns a problem-specific AmrLevel derived type using the default constructor.
    //
    virtual AmrLevel* operator() ();
    //
    //@ManDoc: Returns a problem-specific AmrLevel derived type using the five passed variables.
    //
    virtual AmrLevel* operator() (Amr&            papa,
                                  int             lev,
                                  const Geometry& level_geom,
                                  const BoxArray& ba,
                                  Real            time);
};

#endif /*_ProbBld_H_*/
