/***************************************************************************
                          CdCopyDialogBase.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                :  alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include "dialogParts/DialogCntPnl.h"
#include "dialogParts/DriveInfoPnl.h"
#include "dialogParts/SpeedPnl.h"
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "CdCopyDialogBase.h"
//=============================================
CdCopyDialogBase::CdCopyDialogBase( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "CdCopyDialogBase" );
    resize( 774, 550 );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 720, 550 ) );
    setMaximumSize( QSize( 820, 550 ) );
    setBaseSize( QSize( 827, 540 ) );
    setCaption( tr( "CD Copy Dialog" ) );
    QWhatsThis::add(  this, tr( "You can increase 'Maximum Speed' through the preferences menu" ) );
    CdCopyDialogBaseLayout = new QGridLayout( this );
    CdCopyDialogBaseLayout->setSpacing( 0 );
    CdCopyDialogBaseLayout->setMargin( 0 );

    detailsFrm = new QFrame( this, "detailsFrm" );
    detailsFrm->setMaximumSize( QSize( 32767, 290 ) );
    detailsFrm->setFrameShape( QFrame::StyledPanel );
    detailsFrm->setFrameShadow( QFrame::Raised );
    detailsFrmLayout = new QGridLayout( detailsFrm );
    detailsFrmLayout->setSpacing( 6 );
    detailsFrmLayout->setMargin( 11 );

    GroupBox6_2 = new QGroupBox( detailsFrm, "GroupBox6_2" );
    GroupBox6_2->setMinimumSize( QSize( 0, 0 ) );
    GroupBox6_2->setTitle( tr( "Read Details" ) );
    QToolTip::add(  GroupBox6_2, tr( "" ) );
    QWhatsThis::add(  GroupBox6_2, tr( "Source CD-Rom read details." ) );
    GroupBox6_2->setColumnLayout(0, Qt::Vertical );
    GroupBox6_2->layout()->setSpacing( 0 );
    GroupBox6_2->layout()->setMargin( 0 );
    GroupBox6_2Layout = new QGridLayout( GroupBox6_2->layout() );
    GroupBox6_2Layout->setAlignment( Qt::AlignTop );
    GroupBox6_2Layout->setSpacing( 5 );
    GroupBox6_2Layout->setMargin( 9 );

    readOnlyChk = new QCheckBox( GroupBox6_2, "readOnlyChk" );
    readOnlyChk->setText( tr( "Read Only" ) );
    readOnlyChk->setEnabled(false);
    QToolTip::add(  readOnlyChk, tr( "Read only and don't burn anything" ) );

    GroupBox6_2Layout->addWidget( readOnlyChk, 0, 0 );

    removeTempBtn = new QCheckBox( GroupBox6_2, "removeTempBtn" );
    removeTempBtn->setText( tr( "Remove Temp Files" ) );
    QToolTip::add(  removeTempBtn, tr( "When done, remove 'traks' saved during copy process " ) );

    GroupBox6_2Layout->addWidget( removeTempBtn, 1, 0 );

    optionsBtn = new QPushButton( GroupBox6_2, "optionsBtn" );
    optionsBtn->setMinimumSize( QSize( 90, 30 ) );
    optionsBtn->setMaximumSize( QSize( 90, 30 ) );
    optionsBtn->setText( tr( "Options" ) );
    QToolTip::add(  optionsBtn, tr( "Configure source CD read options" ) );

    GroupBox6_2Layout->addWidget( optionsBtn, 1, 1 );

    detailsFrmLayout->addWidget( GroupBox6_2, 0, 1 );

    GroupBox6 = new QGroupBox( detailsFrm, "GroupBox6" );
    GroupBox6->setEnabled( TRUE );
    GroupBox6->setTitle( tr( "Recording Details" ) );
    QWhatsThis::add(  GroupBox6, tr( "Recording Details." ) );
    GroupBox6->setColumnLayout(0, Qt::Vertical );
    GroupBox6->layout()->setSpacing( 0 );
    GroupBox6->layout()->setMargin( 0 );
    GroupBox6Layout = new QHBoxLayout( GroupBox6->layout() );
    GroupBox6Layout->setAlignment( Qt::AlignTop );
    GroupBox6Layout->setSpacing( 4 );
    GroupBox6Layout->setMargin( 7 );

    actionCmb = new QComboBox( FALSE, GroupBox6, "actionCmb" );
    actionCmb->insertItem( tr( "Burn" ) );
    actionCmb->insertItem( tr( "Test and burn " ) );
    actionCmb->insertItem( tr( "'Dummy' write" ) );
    actionCmb->insertItem( tr( "Copy on the fly" ) );
    actionCmb->setMinimumSize( QSize( 145, 30 ) );
    actionCmb->setMaximumSize( QSize( 145, 30 ) );
    QToolTip::add(  actionCmb, tr( "Choose the action to take" ) );
    GroupBox6Layout->addWidget( actionCmb );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    GroupBox6Layout->addItem( spacer );

    TextLabel2 = new QLabel( GroupBox6, "TextLabel2" );
    TextLabel2->setMinimumSize( QSize( 80, 35 ) );
    TextLabel2->setMaximumSize( QSize( 90, 35 ) );
    TextLabel2->setText( tr( "Number<br>of Copies" ) );
    TextLabel2->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );
    TextLabel2->setIndent( -1 );
    GroupBox6Layout->addWidget( TextLabel2 );

    numberSpn = new QSpinBox( GroupBox6, "numberSpn" );
    numberSpn->setMinimumSize( QSize( 50, 30 ) );
    numberSpn->setMaximumSize( QSize( 50, 30 ) );
    numberSpn->setButtonSymbols( QSpinBox::PlusMinus );
    numberSpn->setMinValue( 1 );
    numberSpn->setValue( 1 );
    QToolTip::add(  numberSpn, tr( "Specify number of copies to make" ) );
    GroupBox6Layout->addWidget( numberSpn );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    GroupBox6Layout->addItem( spacer_2 );

    customBurnBtn = new QPushButton( GroupBox6, "customBurnBtn" );
    customBurnBtn->setMinimumSize( QSize( 90, 30 ) );
    customBurnBtn->setMaximumSize( QSize( 90, 30 ) );
    customBurnBtn->setText( tr( "Custom" ) );
    QToolTip::add(  customBurnBtn, tr( "Configure recording options" ) );
    GroupBox6Layout->addWidget( customBurnBtn );

    detailsFrmLayout->addMultiCellWidget( GroupBox6, 1, 1, 0, 1 );

    speedPnl = new SpeedPnl( detailsFrm, "speedPnl" );
    speedPnl->setMinimumSize( QSize( 400, 60 ) );
    speedPnl->setMaximumSize( QSize( 32767, 65 ) );

    detailsFrmLayout->addMultiCellWidget( speedPnl, 2, 2, 0, 1 );

    ButtonGroup17 = new QButtonGroup( detailsFrm, "ButtonGroup17" );
    ButtonGroup17->setMaximumSize( QSize( 100, 32767 ) );
    ButtonGroup17->setTitle( tr( "Type of CD" ) );
    QWhatsThis::add(  ButtonGroup17, tr( "Type of the source CD." ) );
    ButtonGroup17->setColumnLayout(0, Qt::Vertical );
    ButtonGroup17->layout()->setSpacing( 0 );
    ButtonGroup17->layout()->setMargin( 0 );
    ButtonGroup17Layout = new QVBoxLayout( ButtonGroup17->layout() );
    ButtonGroup17Layout->setAlignment( Qt::AlignTop );
    ButtonGroup17Layout->setSpacing( 5 );
    ButtonGroup17Layout->setMargin( 6 );

    dataRBtn = new QRadioButton( ButtonGroup17, "dataRBtn" );
    dataRBtn->setText( tr( "Data" ) );
    dataRBtn->setChecked( TRUE );
    ButtonGroup17Layout->addWidget( dataRBtn );

    musicRBtn = new QRadioButton( ButtonGroup17, "musicRBtn" );
    musicRBtn->setText( tr( "Music" ) );
    ButtonGroup17Layout->addWidget( musicRBtn );

    detailsFrmLayout->addWidget( ButtonGroup17, 0, 0 );

    CdCopyDialogBaseLayout->addWidget( detailsFrm, 0, 1 );

    Frame5 = new QFrame( this, "Frame5" );
    Frame5->setFrameShape( QFrame::StyledPanel );
    Frame5->setFrameShadow( QFrame::Raised );
    Frame5->setLineWidth( 1 );
    Frame5->setMargin( 0 );
    Frame5->setMidLineWidth( 0 );
    Frame5Layout = new QVBoxLayout( Frame5 );
    Frame5Layout->setSpacing( 5 );
    Frame5Layout->setMargin( 8 );

    srcDevicePnl = new DriveInfoPnl( Frame5, "srcDevicePnl" );
    srcDevicePnl->setMinimumSize( QSize( 300, 120 ) );
    Frame5Layout->addWidget( srcDevicePnl );

    targetDevicePnl = new DriveInfoPnl( Frame5, "targetDevicePnl" );
    targetDevicePnl->setMinimumSize( QSize( 300, 120 ) );
    Frame5Layout->addWidget( targetDevicePnl );

    CdCopyDialogBaseLayout->addWidget( Frame5, 0, 0 );

    dialogCntPnl = new DialogCntPnl( this, "dialogCntPnl" );
    dialogCntPnl->setMinimumSize( QSize( 0, 280 ) );

    CdCopyDialogBaseLayout->addMultiCellWidget( dialogCntPnl, 1, 1, 0, 1 );

    // signals and slots connections
    connect( customBurnBtn, SIGNAL( clicked() ), this, SLOT( customBtnSlot() ) );
    connect( optionsBtn, SIGNAL( clicked() ), this, SLOT( readOptionsBtnSlot() ) );
}

//==========================================
CdCopyDialogBase::~CdCopyDialogBase(){
}
//==========================================
void CdCopyDialogBase::customBtnSlot()
{
    qWarning( "CdCopyDialogBase::customBtnSlot(): Not implemented yet!" );
}
//==========================================
void CdCopyDialogBase::readOptionsBtnSlot()
{
    qWarning( "CdCopyDialogBase::readOptionsBtnSlot(): Not implemented yet!" );
}

#include "CdCopyDialogBase.moc"
