/***************************************************************************
                          DetectTbsPnl.h  -  description
                             -------------------
    begin                : Fri Jun 1 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DETECTTBSPNL_H
#define DETECTTBSPNL_H

#include <qwidget.h>
#include <qstringlist.h>

#include <kconfig.h>
#include <kprocess.h>

#include "DetectPnlBase.h"

class QListViewItem;
class CommandOutputDialog;

class DetectTbsPnl : public DetectPnlBase
{
	Q_OBJECT
public:
    DetectTbsPnl(QWidget* parent = 0, const char* name = 0);
    ~DetectTbsPnl();

	void saveOptions();
	void readOptions();
	void applyDefaults();

protected slots:
    virtual void rescanSlot();
    virtual void retryScsiSlot();
    virtual void addCustomSlot();
    virtual void removeCustomSlot();
    virtual void browseCustomSlot();
    virtual void customScsiSlot();
    virtual void customLstSlot(QListViewItem *);
    virtual void modifyCustomSlot();
    virtual void scsiDetailesSlot();
    virtual void autoScsiDetailesSlot();
    virtual void autoSelectionChangedSlot(QListViewItem*);
    void scanbusProcessDoneSlot(KProcess *proc);
    void scsiDetailesDoneSlot(KProcess *proc);
    void receivedScanbusMessageSlot(KProcess *proc, char *buffer, int buflen);
    void receivedScsiDetailesMessageSlot(KProcess *proc, char *buffer, int buflen);

private:
	void scanIdes();
	void scanScsi();
	void enableCustScsi(bool yes);
	void getScsiDetailes(QString &);
	
	//DialogActions *actions;
	KConfig *config;
	KProcess *cdboProc;
	
	QStringList sourceList;
	QStringList sourceNameMappings;
	
	QStringList targetsList;
	QStringList targetsMappings;
	QStringList targetsNameMappings;
	
	QStringList scsiList;
	
	QStringList customList;
	QStringList customMappings;
	
	CommandOutputDialog* cod;
	
	int unknown;
};
#endif