/***************************************************************************
                          IsoOptPnl.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef ISOOPTPNL_H
#define ISOOPTPNL_H

#include <qvariant.h>
#include <qwidget.h>

#include "IsoOptPnlBase.h"

class KConfig;

class IsoOptPnl : public IsoOptPnlBase
{ 
    Q_OBJECT

public:
    	IsoOptPnl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    	~IsoOptPnl();
	void saveOptions();	
	void readOptions();
	void applyDefaults();
	
	static const int LinuxISO = 0;
    	static const int LinWinISO = 1;
    	static const int AudioISO = 2;
     static const int CustomISO = 3;

	
protected slots:
    // virtual void audioTypeSlot();
     virtual void linuxTypeSlot();
     virtual void customTypeSlot();
     virtual void linWinTypeSlot();
     virtual void hybridSlot();
     virtual void multivolSlot();
     virtual void browseBootSlot();
     virtual void bootCatalogBrowseSlot();
     virtual void bootableSlot();
     virtual void relaxedFilenamesSlot();
	virtual void filenameChangeSlot(int);
	void sessionChangedSlot();
	
private:
	KConfig *config;
	
	void setClickable(bool);
	
};

#endif // ISOOPTPNL_H
