/***************************************************************************
                          IsoOptPnlBase.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef ISOOPTPNLBASE_H
#define ISOOPTPNLBASE_H

#include <qvariant.h>
#include <qwidget.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QCheckBox;
class QFrame;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSpinBox;
class QTabWidget;

class IsoOptPnlBase : public QWidget
{ 
    Q_OBJECT

public:
    IsoOptPnlBase( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~IsoOptPnlBase();

    QTabWidget* isoOptTbs;
    QWidget* imageTab;
    QButtonGroup* imagePnl;
    QLabel* TextLabel1;
    QLabel* isoOptLbl;
    QLineEdit* extraOptTxt;
    QCheckBox* noDeepChk;
    QCheckBox* followSymChk;
    QCheckBox* rockRidgeChk;
    QCheckBox* jolietChk;
    QCheckBox* relaxedNamesChk;
    QCheckBox* generateTablsChk;
    QLineEdit* imageNameTxt;
    QCheckBox* appleChk;
    QCheckBox* hfsChk;
    QButtonGroup* cdda2wavPnl;
    QRadioButton* linuxRBtn;
    QRadioButton* linwinRBtn;
    QRadioButton* customRBtn;
    QFrame* Line3;
    QCheckBox* hybridChk;
    QButtonGroup* sessionPropertiesPnl;
    QRadioButton* singleSesRBtn;
    QRadioButton* multiSesRBtn;
    QCheckBox* forceRRChk;
    QCheckBox* checkOldNamesChk;
    QCheckBox* chkOldSesChk;
    QFrame* Line7;
    QWidget* extrasTab;
    QGroupBox* GroupBox6_2;
    QCheckBox* probeChk;
    QCheckBox* multivoluemedChk;
    QLabel* volumeSetSizeLbl;
    QSpinBox* volumeSetSizeSpn;
    QSpinBox* volumeSetSequenceSpn;
    QLabel* volumeSetSequenceLbl;
    QCheckBox* omitVersionChk;
    QCheckBox* hideRRChk;
    QButtonGroup* filenamePnl;
    QCheckBox* beginPeriodChk;
    QCheckBox* untransFNmamesChk;
    QCheckBox* longFNamesChk;
    QCheckBox* omitTrailChk;
    QCheckBox* multiDotChk;
    QCheckBox* lowercaseChk;
    QGroupBox* bootPnl;
    QLabel* biLbl;
    QLabel* bcLbl;
    QLabel* bootCatalogLbl;
    QLabel* bootLbl;
    QPushButton* bootBrowseBtn;
    QPushButton* bootCatalogBrowseBtn;
    QCheckBox* bootableChk;
    QWidget* lablesTab;
    QGroupBox* GroupBox2_2;
    QLabel* TextLabel1_2_2;
    QLabel* TextLabel1_4;
    QLabel* TextLabel1_3_2_2_2;
    QLabel* TextLabel1_3_2_2;
    QFrame* Line1;
    QLabel* TextLabel1_3_2;
    QLineEdit* preparerIdTxt;
    QLineEdit* publisherIdTxt;
    QLineEdit* copyrightTxt;
    QLineEdit* volumeSetTxt;
    QLabel* TextLabel1_3_2_3;
    QLineEdit* applicationIdTxt;
    QLineEdit* volumeIdTxt;

protected slots:
    virtual void bootCatalogBrowseSlot();
    virtual void bootableSlot();
    virtual void browseBootSlot();
    virtual void customTypeSlot();
    virtual void filenameChangeSlot(int);
    virtual void hybridSlot();
    virtual void linWinTypeSlot();
    virtual void linuxTypeSlot();
    virtual void multivolSlot();
    virtual void relaxedFilenamesSlot();

protected:
    QGridLayout* imageTabLayout;
    QVBoxLayout* cdda2wavPnlLayout;
    QGridLayout* sessionPropertiesPnlLayout;
    QVBoxLayout* extrasTabLayout;
    QGridLayout* filenamePnlLayout;
    QVBoxLayout* lablesTabLayout;
};

#endif // ISOOPTPNLBASE_H
