/***************************************************************************
                          EstimatePnl.cpp  -  description
                             -------------------
    begin                : Fri Jul 27 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <klocale.h>
#include <kapp.h>
#include <kconfig.h>


#include "EstimatePnl.h"

/* 
 *  Constructs a EstimatePnl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
EstimatePnl::EstimatePnl( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl ){
    	
    	if ( !name )
		setName( "EstimatePnl" );
	
     resize( 209, 273 );
     setMinimumSize( QSize( 209, 272 ) );
     setMaximumSize( QSize( 209, 32767 ) );
     setCaption( i18n( "Form1" ) );
     EstimatePnlLayout = new QGridLayout( this );
     EstimatePnlLayout->setSpacing( 2 );
     EstimatePnlLayout->setMargin( 2 );

     estFrm = new QGroupBox( this, "estFrm" );
     estFrm->setMinimumSize( QSize( 205, 269 ) );
     estFrm->setTitle( i18n( "Estimate:" ) );
     estFrm->setColumnLayout(0, Qt::Vertical );
     estFrm->layout()->setSpacing( 0 );
     estFrm->layout()->setMargin( 0 );
     estFrmLayout = new QVBoxLayout( estFrm->layout() );
     estFrmLayout->setAlignment( Qt::AlignTop );
     estFrmLayout->setSpacing( 5 );
     estFrmLayout->setMargin( 9 );

     GroupBox5 = new QGroupBox( estFrm, "GroupBox5" );
     GroupBox5->setTitle( i18n( "Size:" ) );
     GroupBox5->setColumnLayout(0, Qt::Vertical );
     GroupBox5->layout()->setSpacing( 0 );
     GroupBox5->layout()->setMargin( 0 );
     GroupBox5Layout = new QHBoxLayout( GroupBox5->layout() );
     GroupBox5Layout->setAlignment( Qt::AlignTop );
     GroupBox5Layout->setSpacing( 6 );
     GroupBox5Layout->setMargin( 11 );

     capacityCmb = new QComboBox( FALSE, GroupBox5, "capacityCmb" );
     capacityCmb->insertItem( i18n( "74 min" ) );
     capacityCmb->insertItem( i18n( "80 min" ) );
     capacityCmb->insertItem( i18n( "100 min" ) );
     capacityCmb->setMinimumSize( QSize( 85, 25 ) );
     capacityCmb->setMaximumSize( QSize( 100, 25 ) );
     QToolTip::add(  capacityCmb, i18n( "Chose CD-R(W) capacity" ) );
     GroupBox5Layout->addWidget( capacityCmb );

     capacityLbl = new QLabel( GroupBox5, "capacityLbl" );
     capacityLbl->setMinimumSize( QSize( 70, 20 ) );
     capacityLbl->setMaximumSize( QSize( 70, 25 ) );
     QFont capacityLbl_font(  capacityLbl->font() );
     capacityLbl_font.setBold( TRUE );
     capacityLbl->setFont( capacityLbl_font );
     capacityLbl->setFrameShape( QLabel::Box );
     capacityLbl->setFrameShadow( QLabel::Raised );
     QToolTip::add(  capacityLbl, i18n( "CD-R(W) Capacity" ) );
     GroupBox5Layout->addWidget( capacityLbl );
     estFrmLayout->addWidget( GroupBox5 );

     GroupBox2_2_2 = new QGroupBox( estFrm, "GroupBox2_2_2" );
     GroupBox2_2_2->setTitle( i18n( "Used:" ) );
     GroupBox2_2_2->setColumnLayout(0, Qt::Vertical );
     GroupBox2_2_2->layout()->setSpacing( 0 );
     GroupBox2_2_2->layout()->setMargin( 0 );
     GroupBox2_2_2Layout = new QHBoxLayout( GroupBox2_2_2->layout() );
     GroupBox2_2_2Layout->setAlignment( Qt::AlignTop );
     GroupBox2_2_2Layout->setSpacing( 6 );
     GroupBox2_2_2Layout->setMargin( 11 );

     usedLCD = new QLCDNumber( GroupBox2_2_2, "usedLCD" );
     usedLCD->setMinimumSize( QSize( 105, 35 ) );
     usedLCD->setMaximumSize( QSize( 105, 35 ) );
     usedLCD->setMargin( 0 );
   // usedLCD->setSmallDecimalPoint( true );
     usedLCD->setNumDigits( 6 );
     usedLCD->setMode( QLCDNumber::DEC );
     usedLCD->setSegmentStyle( QLCDNumber::Filled );
     usedLCD->setProperty( "intValue", 0 );
     QToolTip::add(  usedLCD, i18n( "Total used space" ) );
     GroupBox2_2_2Layout->addWidget( usedLCD );

     usedTypeCmb = new QComboBox( FALSE, GroupBox2_2_2, "usedTypeCmb" );
     usedTypeCmb->insertItem( i18n( "Mb" ) );
     usedTypeCmb->insertItem( i18n( "Kb" ) );
     usedTypeCmb->setMinimumSize( QSize( 50, 30 ) );
     usedTypeCmb->setMaximumSize( QSize( 50, 30 ) );
     GroupBox2_2_2Layout->addWidget( usedTypeCmb );
     estFrmLayout->addWidget( GroupBox2_2_2 );

     GroupBox2_2 = new QGroupBox( estFrm, "GroupBox2_2" );
     GroupBox2_2->setTitle( i18n( "Wasted:" ) );
     GroupBox2_2->setColumnLayout(0, Qt::Vertical );
     GroupBox2_2->layout()->setSpacing( 0 );
     GroupBox2_2->layout()->setMargin( 0 );
     GroupBox2_2Layout = new QHBoxLayout( GroupBox2_2->layout() );
     GroupBox2_2Layout->setAlignment( Qt::AlignTop );
     GroupBox2_2Layout->setSpacing( 6 );
     GroupBox2_2Layout->setMargin( 11 );

     wastedLCD = new QLCDNumber( GroupBox2_2, "wastedLCD" );
     wastedLCD->setMinimumSize( QSize( 105, 35 ) );
     wastedLCD->setMaximumSize( QSize( 105, 35 ) );
     wastedLCD->setMargin( 0 );
    //wastedLCD->setSmallDecimalPoint( true );
     wastedLCD->setNumDigits( 6 );
     wastedLCD->setMode( QLCDNumber::DEC );
     wastedLCD->setSegmentStyle( QLCDNumber::Filled );
     wastedLCD->setProperty( "intValue", 0 );
     QToolTip::add(  wastedLCD, i18n( "Total wasted space" ) );
     GroupBox2_2Layout->addWidget( wastedLCD );

     wastedTypeCmb = new QComboBox( FALSE, GroupBox2_2, "wastedTypeCmb" );
     wastedTypeCmb->insertItem( i18n( "Mb" ) );
     wastedTypeCmb->insertItem( i18n( "Kb" ) );
     wastedTypeCmb->setMinimumSize( QSize( 50, 30 ) );
     wastedTypeCmb->setMaximumSize( QSize( 50, 30 ) );
     GroupBox2_2Layout->addWidget( wastedTypeCmb );
     estFrmLayout->addWidget( GroupBox2_2 );
     QSpacerItem* spacer = new QSpacerItem( 10, 10, QSizePolicy::Minimum, QSizePolicy::Expanding );
     estFrmLayout->addItem( spacer );

     recalcEstBtn = new QPushButton( estFrm, "recalcEstBtn" );
     recalcEstBtn->setMinimumSize( QSize( 120, 25 ) );
     recalcEstBtn->setMaximumSize( QSize( 120, 25 ) );
     QFont recalcEstBtn_font(  recalcEstBtn->font() );
     recalcEstBtn_font.setBold( TRUE );
     recalcEstBtn->setFont( recalcEstBtn_font );
     recalcEstBtn->setText( i18n( "Recalculate" ) );
     QToolTip::add(  recalcEstBtn, i18n( "Recalculate estimate." ) );
     estFrmLayout->addWidget( recalcEstBtn );

     EstimatePnlLayout->addWidget( estFrm, 0, 0 );

	////////////////////////////////////////
	config = kapp->config();
    	
	readOptions();
	reset();
	///////////////////////////////////////

     // signals and slots connections
     //connect( recalcEstBtn, SIGNAL( clicked() ), this, SLOT( recalculate() ) );
     connect( wastedTypeCmb, SIGNAL( activated(int) ), this, SLOT( wastedTypeChangedSlot(int) ) );
     connect( usedTypeCmb, SIGNAL( activated(int) ), this, SLOT( usedTypeChangedSlot(int) ) );
     connect( capacityCmb, SIGNAL( activated(int) ), this, SLOT( capacityChangedSlot(int) ) );
}

EstimatePnl::~EstimatePnl(){
	saveOptions();
}
//---------------------------------------------------------------------------------------------
void EstimatePnl::readOptions(){	
    	config->setGroup("Estimate");		
	int  iBuff = config->readNumEntry("Capacity Type", 0);
     capacityCmb->setCurrentItem(iBuff);
	capacityChangedSlot(iBuff);
	
     iBuff = config->readNumEntry("Used Type", 0);
     usedTypeCmb->setCurrentItem(iBuff);
     usedTypeChangedSlot(iBuff);

     iBuff = config->readNumEntry("Wasted Type", 0);
     wastedTypeCmb->setCurrentItem(iBuff);
     wastedTypeChangedSlot(iBuff);

	
}
//-----------------------------------------------------------------------------------------------
void EstimatePnl::saveOptions(){
	config->setGroup("Estimate");		
	config->writeEntry("Capacity Type", capacityCmb->currentItem());
	config->writeEntry("Used Type", usedTypeCmb->currentItem());
	config->writeEntry("Wasted Type", wastedTypeCmb->currentItem());
	
	//config->sync();
}
/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool EstimatePnl::event( QEvent* ev ){
    bool ret = QWidget::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont capacityLbl_font(  capacityLbl->font() );
	capacityLbl_font.setBold( TRUE );
	capacityLbl->setFont( capacityLbl_font ); 
	QFont recalcEstBtn_font(  recalcEstBtn->font() );
	recalcEstBtn_font.setBold( TRUE );
	recalcEstBtn->setFont( recalcEstBtn_font ); 
    }
    return ret;
}
//===================================
void EstimatePnl::capacityChangedSlot(int index){
	int buff = max;
	switch(index){
    		case 0: capacityLbl->setText( i18n( "650 Mb" ) ); max = 665600; break;
    		case 1: capacityLbl->setText( i18n( "700 Mb" ) ); max = 716800; break;
    		case 2: capacityLbl->setText( i18n( "875 Mb" ) ); max = 896000; break;
	}
	if(max != buff)
		emit recalculate();
}
//=======================================
bool EstimatePnl::add(int buff){
	if( (buff + total)  > max)
		return false;
	
	total += buff;
	wasted -= buff;	
	synchUp();
	return true;
}
//===============================
void EstimatePnl::subtract(int buff){
	if(buff == 0) return;
	total -= buff;
	wasted += buff;	
	synchUp();
}
//===============================
void EstimatePnl::synchUp(){
	QString num;
	if(wastedMB){	
		num.setNum( ((double)wasted) / 1024, 'f', 1);
		wastedLCD->display(num);
	}
	else
		wastedLCD->display(wasted);
		
	//if(total == 0) return;

	if(usedMB){	
		num.setNum( ((double)total) / 1024, 'f', 1);
		usedLCD->display(num);
	}
	else
		usedLCD->display(total);
		
}
//===============================
void EstimatePnl::reset(){
	total = 0;
 	wasted = max;
 	synchUp();
}
//===============================
void EstimatePnl::usedTypeChangedSlot(int index){
    switch(index){
    		case 0: usedMB = true; break;
    		case 1: usedMB = false; break;
   	 }
    synchUp();
}
//=======================================
void EstimatePnl::wastedTypeChangedSlot(int index){
	switch(index){
    		case 0: wastedMB = true; break;
    		case 1: wastedMB = false; break;
	 }
	synchUp();
}

#include "EstimatePnl.moc"
