/***************************************************************************
                          AdvancedCompilationTreeView.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 #include <iostream.h>

/* QT includes */

#include <qsplitter.h>
#include <qfileinfo.h>

/* KDE includes */
#include <kprogress.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kapp.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>

/* cdbakeoven includes */
#include "../../cdbakeoven.h"
#include "AdvancedCompilationTreeView.h"

#include "FakeFilesListView.h"
#include "FakeFoldersListView.h"
#include "FakeFolderItem.h"


#include "../../dialogs/SettingsDialog.h"
#include "../../dialogs/NewCdDialog.h"



//========================================
AdvancedCompilationTreeView::AdvancedCompilationTreeView(CDBakeOvenApp * cdboApp,
													QWidget *parent, const char *name) :
			QSplitter(parent, name){
	this->cdboApp = cdboApp;
	initView();
	listFileName = "";
	saved = true;
	config = kapp->config();

}
//========================================
AdvancedCompilationTreeView::~AdvancedCompilationTreeView(){
}
//========================================
void AdvancedCompilationTreeView::initView(){
  	
  	foldersView = new FakeFoldersListView(this,"foldersView");
	foldersView ->setFocusPolicy(QWidget::ClickFocus);
	
	filesView = new FakeFilesListView(this,"filesView");
	filesView ->setFocusPolicy(QWidget::ClickFocus);
	foldersView ->setFakeListView(filesView);
	
	
	
	connect( foldersView, SIGNAL(folderClicked(FakeFolderItem *)),
						filesView, SLOT(loadFiles( FakeFolderItem *)) );
	connect(  filesView, SIGNAL(dropped (QDropEvent *, QListViewItem *)),
						foldersView, SLOT(dropOcurred(QDropEvent *, QListViewItem *)));
	/*connect(  filesView, SIGNAL(selectFileForDrop (QListViewItem *)),
						foldersView, SLOT(slotSelectFileForDrop (QListViewItem *)));
	*/
	connect(  foldersView, SIGNAL(popUpSettings(int)),
						this, SLOT(popUpSettings(int)));
	connect(  foldersView, SIGNAL(modified()),
						this, SLOT(contentsModified()));
	connect(  filesView, SIGNAL(modified()),
						this, SLOT(contentsModified()));
						
}
//==============================
void AdvancedCompilationTreeView::saveOptions(){
	/*compilView->saveOptions();
	audioCompilView->saveOptions();
	srcTree->saveTopList();*/
}
//---------------------------------------------------------------------------------------------
void AdvancedCompilationTreeView::popUpSettings(int type){
	cdboApp->popUpSettings(type);
}
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//============================================
/*void AdvancedCompilationTreeView::compilSettingsSlot(){
	popUpSettings(SettingsDialog::Image);
}*/
//========================
void AdvancedCompilationTreeView::createISO(){
	
	QString *mappingsString = foldersView->generateMappingsString();
	if(!mappingsString || mappingsString->length() == 0){
		KMessageBox::sorry(this,
			"Compilation list is empty!");
		return;
	}
	
	//cerr << "mappingsString->length() ========= " << mappingsString->length() << endl;
	
	
	config->setGroup("Default Settings");	
	
	if(config->readBoolEntry("Check Tmp Size", true)){
	
		int size = config->readNumEntry("tmp Size", -1);
	
		if(size == -1){
			int result = KMessageBox::warningContinueCancel(this,
					"Unable to determine temporary directory size! Would you \n"\
					"like to run 'Setting Dialog' to choose tmp directory now?",
        				"Run Settings Dialog now?",
        				QString("&Yes"));
    			switch(result) {
    				case KMessageBox::Continue:{
					popUpSettings(SettingsDialog::Defaults);
					return;
				}
    			}
		}
		else{
			//cerr << "size = " << size << endl;
			//cerr << "foldersView->getTotalSize() / 1024 = " << foldersView->getTotalSize() / 1024 << endl;
			if(size < (int)(foldersView->getTotalSize() / 1024 / 1024)){
				KMessageBox::error(this,
					"Temprorary directory does not have enough space available\n" \
					"for storing disk image. Please remove some files from the list\n"\
					"or choose another location through 'Settings Dialog'.");
				return;
			}
		}
	}
	QString fn = config->readEntry("Tmp Dir", "/tmp/");
	
	config->setGroup("ISO Settings");	
	fn = fn + config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	
	QFileInfo d(fn);
	if(d.exists()){
		int result = KMessageBox::warningContinueCancel(this,
			"File with the same name already exists!\n"\
			"Click 'Cancel' to run 'Setting Dialog' and\n"\
			"change ISO name Or overwrite existing one.",
        		"Overwrite existing?",
        		QString("&Overwrite"));
    		switch(result) {
    			case KMessageBox::Continue:
    				break;
    			default:{
				popUpSettings(SettingsDialog::Image);
				//return;
			}
		}
    	}
	NewCdDialog *ncd = new NewCdDialog(mappingsString, cdboApp, "ncd", true ) ;
	ncd->exec();
	delete ncd;
	foldersView->updateSettings();
}
//========================
void AdvancedCompilationTreeView::createCD(){
	
	QString *mappingsString = foldersView->generateMappingsString();
	if(!mappingsString || mappingsString->length() == 0){
		KMessageBox::sorry(this,
			"Compilation list is empty!");
		return;
	}
	
	//cerr << "mappingsString->length() ========= " << mappingsString->length() << endl;
	
	config->setGroup("Default Settings");
	
	if(config->readBoolEntry("Check Tmp Size", true)){
	
		int size = config->readNumEntry("tmp Size", -1);
	
		if(size == -1){
			int result = KMessageBox::warningContinueCancel(this,
					"Unable to determine temporary directory size! Would you \n"\
					"like to run 'Setting Dialog' to choose tmp directory now?",
        				"Run Settings Dialog now?",
        				QString("&Yes"));
    			switch(result) {
    				case KMessageBox::Continue:{
					popUpSettings(SettingsDialog::Defaults);
					return;
				}
    			}
		}
		else{
			//cerr << "size = " << size << endl;
			//cerr << "foldersView->getTotalSize() / 1024 = " << foldersView->getTotalSize() / 1024 << endl;
			if(size < (int)(foldersView->getTotalSize() / 1024 / 1024)){
				KMessageBox::error(this,
					"Temprorary directory does not have enough space available\n" \
					"for storing disk image. Please remove some files from the list\n"\
					"or choose another location through 'Settings Dialog'.");
				return;
			}
		}
	}
	
	QString fn = config->readEntry("Tmp Dir", "/tmp/");
	
	config->setGroup("ISO Settings");	
	fn = fn + config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	
	QFileInfo d(fn);
	if(d.exists()){
		int result = KMessageBox::warningContinueCancel(this,
			"File with the same name already exists!\n"\
			"Click 'Cancel' to run 'Setting Dialog' and\n"\
			"change ISO name Or overwrite existing one.",
        		"Overwrite existing?",
        		QString("&Overwrite"));
    		switch(result) {
    			case KMessageBox::Continue:
    				break;
    			default:{
				popUpSettings(SettingsDialog::Image);
				//return;
			}
		}
    	}
    	
    	NewCdDialog *ncd = new NewCdDialog(mappingsString, cdboApp, "ncd") ;
	ncd->exec();
	delete ncd;
	foldersView->updateSettings();

}

//====================================
//====================================
//=====  FILE PROCESS ====================
//====================================
//====================================
//============================================
void AdvancedCompilationTreeView::saveRemoveAndLoad(QString fileToOpen){
	if(!saveAndRemove())
		return;
	//foldersView->updateSettings();
	KConfig *file = new KConfig(fileToOpen);
	foldersView->loadFile(file);

     listFileName = fileToOpen;
     saved = true;
     emitGotCaption();
}

//===========================================================
bool AdvancedCompilationTreeView::saveAndRemove(){//////OK
	if(!foldersView->firstChild())
		return true;
	
	 if(saved){
	 	removeAll();
		return true;
	 }
	config->setGroup("Notification Messages");	
	if(!config->readBoolEntry("Do Show Save List Warning", true)){
		removeAll();
		listFileName = "";
		return true;
	}
	int result = KMessageBox::warningYesNoCancel(this,
					"Compilation file list has been modified, would you like to save it?",
        				"Save File List?",
        				QString("&Yes"),
        				QString("&No"));
    	switch(result) {
    		case KMessageBox::No:{
			removeAll();
			listFileName = "";
			return true;
		}
		case KMessageBox::Cancel:{
			return false;
		}
		case KMessageBox::Yes:{
			if(!save())
				return false;
			removeAll();
			listFileName = "";
			return true;
		}	
    	}
    	return true;
}
//=====================================================
bool AdvancedCompilationTreeView::save(){//////OK
	if(!foldersView->firstChild() || saved )
	//if(isEmpty())
		return true;
    	
    	if(!listFileName.isNull() && listFileName != ""){
    		doSave(listFileName);
    		return true;
    	}
    	else
    		return saveAs();
}
//=====================================================
bool AdvancedCompilationTreeView::saveAs(){///////OK
	//if(fList.count() == 0)
	if(isEmpty())
		return true;
		
	QString fileToOpen = listFileName;
	if(!fileToOpen.isNull() && fileToOpen != "")
		fileToOpen = fileToOpen.left(fileToOpen.findRev("/", -2));
	else
		fileToOpen = QDir::homeDirPath(); //QString::null;
		
		
	fileToOpen = KFileDialog::getSaveFileName(fileToOpen,
				"*.cdbo|CD List Files (*.cdbo)\n*|All files",
				this,
				"Save CD List File As...");
	if(!fileToOpen || fileToOpen == "")
		return false;
	if(fileToOpen.find(".cdbo", -5, false) == -1)
		fileToOpen = fileToOpen.stripWhiteSpace() + ".cdbo";
	
	doSave(fileToOpen);
	return true;
}

//=================================
void AdvancedCompilationTreeView::doSave(QString fileToOpen){//////

	KIO::NetAccess::del(KURL(fileToOpen));
	
	KConfig *file = new KConfig(fileToOpen);
	file->setGroup("CD Bake Oven - CD File List");
	file->writeEntry("Type of CD", "Advanced Layout Data CD");
	/////////////////////////////////////////////////////////////////
	config->setGroup("ISO Settings");	
	QString name = config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	file->writeEntry("Total Size", foldersView->getTotalSize());
	file->writeEntry("Name of CD", name);
     	
	foldersView->persist(file);
	file->sync();
	delete file;
	
	
	saved = true;
	listFileName = fileToOpen;
	emitGotCaption();
}
//===========================================================
void AdvancedCompilationTreeView::removeAll(){//////OK
	foldersView->removeAll();
	listFileName = "";

	saved = true;
     	emitGotCaption();
}
//========================
bool AdvancedCompilationTreeView::isEmpty(){//////OK
	if(foldersView->getTotalSize() == 0){
		KMessageBox::sorry(this,
			"Compilation list is empty!");
		return true;
	}
	return false;
}
//========================
bool AdvancedCompilationTreeView::loadSession(){
	if(!saveAndRemove())
		return false;
	foldersView->loadSession();
	return true;
}
//==============================
void AdvancedCompilationTreeView::emitGotCaption(){//////OK
	if(foldersView->getTotalSize() == 0)
		emit gotCaption(listFileName, false);
	else
		emit gotCaption(listFileName, !saved);
}
//==============================
void AdvancedCompilationTreeView::contentsModified(){//////OK
	saved = false;
     	emitGotCaption();
}