/***************************************************************************
                          CdboFileItem.h  -  description
                             -------------------
    begin                : Mon Nov 19 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CDBOFILEITEM_H
#define CDBOFILEITEM_H

#include <qlistview.h>

class CdboFileItem : public QListViewItem  {

public:
	
	CdboFileItem(QListView * parent, QString path);
	CdboFileItem(CdboFileItem * parent, QString path);
	~CdboFileItem();
	
	
	
	inline QString getFileName() { return name;}
	inline QString getFilePath() { return path;}
	inline int getFileSize() { return size;}
	void setFileSize(int size);
	
	virtual QString key ( int column, bool ascending ) const;
	
	inline QString getPathToTop() { return pathToTop;}
	inline void setPathToTop(QString pathToTop) { this->pathToTop = pathToTop;}
	
protected:
	int size;
	QString name;
	QString path;
	QString pathToTop;
	
	int sizeField;
	int nameField;
	int locationField;
	int modifiedField;
	int ownerField;
	
	void init();

};
#endif