/***************************************************************************
                          DataCompilationTreeView.cpp  -  description
                             -------------------
    begin                : Mon Nov 19 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <iostream.h>
// QT includes
#include <qdir.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qclipboard.h>
#include <qapp.h>
#include <qfileinfo.h>
#include <qdragobject.h>
#include <qevent.h>

// KDE includes
#include <kurl.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kio/job.h>
#include <kpropsdlg.h>
#include <kopenwith.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include <kfileviewitem.h>
#include <kmessagebox.h>
#include <klistview.h>
#include <kmimemagic.h>
#include <kdirsize.h>
#include <kfiledialog.h>

// CDBO includes
#include "DataCompilationTreeView.h"
#include "CompilationTreeView.h"
#include "FileItem.h"
#include "FolderItem.h"
#include "../EstimatePnl.h"
#include "../../dialogs/SettingsDialog.h"
#include "../../dialogs/NewCdDialog.h"
#include "../../dialogs/dialogWidgets/IsoOptPnl.h"

DataCompilationTreeView::DataCompilationTreeView( QWidget *parent, const char *name) :
	CompilationTreeView(parent, name){

	config = kapp->config();
	
	config->setGroup("Default Settings");	
	showHidden = config->readBoolEntry("Show Hidden Items in Compilation", true);
	
	setAcceptDrops(true);
	setDropVisualizer(true);
	
	//setItemsMovable(true);
	//setDragEnabled (true);
	//setRenameable(true);
	
	
	addColumn(  "Name"  );
    	addColumn(  "Size" );
    	addColumn(  "Modified" );
    	addColumn(  "Owner" );
    	addColumn(  "Source Location" );

    	
    	setColumnAlignment(1, AlignRight);
    	setColumnAlignment(2, AlignHCenter);
    	
    	setColumnWidth(0,210);
    	setColumnWidth(1,45);
    	setColumnWidth(2,100);
    	setColumnWidth(3,70);
    	setColumnWidth(4,220);
	
    	
	updateSettings();
	/////////////////////////////////////////////////////////////////////////
	folderMenu = new QPopupMenu();
	folderMenu -> setCheckable(true);
	
	folderMenu -> insertItem( i18n("Folder Properties"),   this ,SLOT(slotProperties()));
	
	folderMenu -> insertSeparator();
	folderMenu -> insertItem(UserIcon("cross"), i18n("&Remove this Branch"), this ,SLOT(remove()));
	folderMenu -> insertItem( BarIcon("reload"), i18n("Reload Directory"),   this ,SLOT(slotReload()));
	hiddenIndex = folderMenu -> insertItem( i18n("Show Hidden Items"),   this ,SLOT(slotShowHidden()));
	folderMenu->setItemChecked(hiddenIndex, showHidden);
	
	folderMenu -> insertSeparator();	
	folderMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify ISO Image Properties"), this ,SLOT(compilSettingsSlot()));
	folderMenu ->insertItem(UserIcon("burn"), i18n("Create CD"), this ,SLOT(createCD()));
	createIsoIndexInFolderMenu = folderMenu ->insertItem(UserIcon("cdImageSm"),
		i18n("Create ISO Image"), this ,SLOT(createISO()));
	
	////////////////////////////////////////////////////////////////////////////
	fileMenu = new QPopupMenu();
	fileMenu -> setCheckable(true);
	
	fileMenu -> insertItem( i18n("File Properties"),   this ,SLOT(slotProperties()));
	fileMenu -> insertItem( i18n("Preview File With..."),
		this ,SLOT(openWithSlot()));	
	
	fileMenu -> insertSeparator();
	fileMenu->insertItem(UserIcon("cross"), i18n("&Remove this Branch"), this ,SLOT(remove()));
	fileMenu -> insertItem( BarIcon("reload"), i18n("Reload Directory"),   this ,SLOT(slotReload()));
	hiddenFIndex = fileMenu -> insertItem( i18n("Show Hidden Items"),   this ,SLOT(slotShowHidden()));
	fileMenu->setItemChecked(hiddenFIndex, showHidden);
	
	fileMenu -> insertSeparator();
	fileMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify ISO Image Properties"), this ,SLOT(compilSettingsSlot()));
	fileMenu ->insertItem(UserIcon("burn"), i18n("Create CD"), this ,SLOT(createCD()));
	createIsoIndexInFileMenu = fileMenu ->insertItem(UserIcon("cdImageSm"),
		i18n("Create ISO Image"), this ,SLOT(createISO()));
		
	////////////////////////////////////////////////////////////////////////////
	isoMenu = new QPopupMenu();
	//isoMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify ISO Image Properties"), this ,SLOT(slotProperties()));
	isoMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify ISO Image Properties"), this ,SLOT(compilSettingsSlot()));
	isoMenu ->insertItem(UserIcon("burn"), i18n("Create CD"), this ,SLOT(createCD()));
	createIsoIndex = isoMenu ->insertItem(UserIcon("cdImageSm"), i18n("Create ISO Image"), this ,SLOT(createISO()));
	isoMenu -> insertSeparator();
	haveItemsIndex = isoMenu -> insertItem(UserIcon("cross"), i18n("Remove &All Branches"),   this ,SLOT(removeAll()));
	//////////////////////////////////////////////////////////////////////
	connect(	this, SIGNAL(returnPressed(QListViewItem *)),
						this, SLOT(slotSelectItem(QListViewItem *)));					
	connect( this, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
					 this, SLOT(popupMenuSlot(QListViewItem*, const QPoint&, int)));
     connect(  this, SIGNAL(doubleClicked(QListViewItem *)),
						this, SLOT(slotSelectItem(QListViewItem *)));
						
	//setBackgroundPixmap();
	//cerr << "backgroundPixmap()->width() " << backgroundPixmap()->width() << endl;
	//update();
	//setBackgroundMode(PaletteBackground);
	//QPixmap *pix = new QPixmap("/usr/share/apps/konqueror/tiles/punika_attack.png");
    	//setBackgroundPixmap( *pix );
		//QPixmap pix("/usr/share/apps/konqueror/tiles/kenwimer.png");
		//QPixmap pix("/usr/share/nautilus/patterns/countertop.png");
/*
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 223, 223, 223) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 245, 245, 245) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setBrush( QColorGroup::Base, QBrush( white, pix ) );
    cg.setColor( QColorGroup::Background, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 50, 40, 158) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 245, 245, 245) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setBrush( QColorGroup::Base, QBrush( white, pix ) );
    cg.setColor( QColorGroup::Background, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 50, 40, 158) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Dark, QColor( 96, 96, 96) );
    cg.setColor( QColorGroup::Mid, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 245, 245, 245) );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setBrush( QColorGroup::Base, QBrush( white, pix ) );
    cg.setColor( QColorGroup::Background, QColor( 192, 192, 192) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 50, 40, 158) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
    setPalette( pal );
    setBackgroundOrigin( QListView::ParentOrigin );
    	
   */ 	
}
//================================================
DataCompilationTreeView::~DataCompilationTreeView(){
}
//====================================
void DataCompilationTreeView::setEstimate(EstimatePnl *e) {
	if(!e) return;
	
	estimate = e;
	connect(estimate->getRecalculateBtn(), SIGNAL(clicked ()),
						this, SLOT(recalculate()));
	connect(estimate, SIGNAL(recalculate ()),
						this, SLOT(recalculate()));
	
}
//==============================================================
void DataCompilationTreeView::updateSettings(){
	config->setGroup("ISO Settings");	
	QString fn = config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	config->setGroup("Default Settings");	
	reloadTop();
	top->setPixmap(0,BarIcon("cdrom_unmount", KIcon::SizeSmall ));
	top->setText(0,config->readEntry("Tmp Dir", "/tmp/") + fn);
}
//==============================================================
void DataCompilationTreeView::popupMenuSlot(QListViewItem *item, const QPoint &point, int){
	if(!item || item == top){
		setSelected(top, true);
		//setCurrentItem(top);
		if(top->childCount() == 0)
			isoMenu->setItemEnabled(haveItemsIndex, false);
		else
			isoMenu->setItemEnabled(haveItemsIndex, true);
		
		isoMenu->setItemEnabled(createIsoIndex, true);
		fileMenu->setItemEnabled(createIsoIndexInFileMenu, true);
		folderMenu->setItemEnabled(createIsoIndexInFolderMenu, true);	
		
		
		isoMenu->popup(point);
	}
	else{
		setSelected(item, true);
		if( dynamic_cast<FolderItem *>( item) ){
	  		folderMenu->setItemEnabled(createIsoIndexInFolderMenu, true);	
			
			folderMenu->popup( point);		
	  	}
		else{
			fileMenu->setItemEnabled(createIsoIndexInFileMenu, true);
			fileMenu->popup( point);
		}
	}
}


//===========================================================
void DataCompilationTreeView::collapse(){
	QListViewItem *item;
	for(item = top->firstChild(); item; item = item->nextSibling())
		item->setOpen(false);
}
//===========================================================
void DataCompilationTreeView::slotShowHidden(){
	showHidden = !folderMenu->isItemChecked(hiddenIndex);
	
	folderMenu->setItemChecked(hiddenIndex, showHidden);
	fileMenu->setItemChecked(hiddenFIndex, showHidden);
	
	QListViewItem *item;
	for(item = top->firstChild(); item; item = item->nextSibling()){
		FolderItem * i = dynamic_cast<FolderItem *>(item);
		if(i){
	  		i->setShowHidden(showHidden);
	  		i->reloadList();
			i->setOpen(false);
		}
	}
	config->setGroup("Default Settings");	
	config->writeEntry("Show Hidden Items in Compilation", showHidden);
}	
//===========================================================
void DataCompilationTreeView::slotReload(){
	QListViewItem *item = currentItem();
	if ( !item )
		return;
	if(item->parent() == top){
		FolderItem *d = dynamic_cast<FolderItem *>(item);
  		if (d)
			d->reloadList();
	}
	else{
		FolderItem *d = dynamic_cast<FolderItem *>(item->parent() );
  		if (d)
			d->reloadList();
	}
}
//---------------------------------------------------------------------------------------------
void DataCompilationTreeView::compilSettingsSlot(){
	popUpSettings(SettingsDialog::Image);	
}

//====================================
void DataCompilationTreeView::slotSelectItem(QListViewItem * item){
	if ( !item ) return;
	
	if(item == top) {
		top->setOpen(true);
		return;
	}
	FolderItem *ftf = dynamic_cast<FolderItem *>(item);
	if (!ftf) return;
	
	emit haveStatus("Parsing directory contense. Please wait...");
	emit processStarted();

	ftf->setOpen(!ftf->isOpen());
	
	emit processDone();
	emit haveStatus("Ready.");

}

//=========================================
bool DataCompilationTreeView::addItem(QString path){
	if(!canAccept(path))
		return false;
	
	top->setOpen(true);
	return true;
}
//================================
bool DataCompilationTreeView::canAccept(QString path) {
	
	int size = 0;
	if(fList.contains(path) > 0){
		KMessageBox::sorry(this,
				"Can not accept: " +  path + "\n"\
				"Item with same path is already on the list!");
		return false;
	}
	
	QFileInfo d( path );
	if(!d.exists() || !d.isReadable()){
		KMessageBox::sorry(this,
				"Can not accept: " +  path + "\n"\
				"Not a valid path! or possibly you do not\n" \
				"have enough privileges to add this item.");
		return false;
	}
	
	if(nameList.contains(d.fileName()) > 0){
		KMessageBox::sorry(this,
				"Can not accept: '" +  d.fileName() + "'\n"\
				"Object with the same name is already on the list!");
		return false;
	}
	if(d.isDir()){
		FolderItem *fItem = new FolderItem( top, path, false, showHidden);
		fItem->setFileSize(0);
		nameList.append(fItem->getFileName());
		fList.append(path);
		ensureItemVisible(fItem);
		setSelected(fItem, true);
		
		//////////////////////////////////////////////
		KDirSize *job = KDirSize::dirSizeJob(KURL(path));
		job->setName(fItem->getFileName());
		
		emit longProcessStarted(job);
		map.insert(job->name(), fItem);
		connect(job, SIGNAL(result(KIO::Job *)),
			this, SLOT(gotSize(KIO::Job *)));
				
		emit haveStatus("Calculating directory size. Please wait...");
		emit processStarted();
		
	}
	else{
		size = (int)d.size();
		if(!estimate->add(size / 1024)){
       		KMessageBox::sorry(this,
       				"Can not accept: " +  path + "\n"\
       				"It's too big to fit on this CD!");
       		return false;
       	}
		
		addFileItem( path, size);
		
	}

	return true;	
}


//==============================================================
void DataCompilationTreeView::addFileItem(QString path, int size){
	FileItem *fItem = new FileItem( top, path);
	//FileItem *fItem = new FileItem(parentForDrop, path);
	fItem->setFileSize(size);
	
	
	//namePositionMap.insert(position, path);
	
	nameList.append(fItem->getFileName());
	
	
	//fItem->setPathToTop(currentItem()->getPathToTop() + "/" + fItem->getFileName());
	
	fList.append(path);
	ensureItemVisible(fItem);
	setSelected(fItem, true);
	saved = false;
	emitGotCaption();
}
//====================================
void DataCompilationTreeView::resetTotal(){
	estimate->reset();
}
//==============================
void DataCompilationTreeView::subtractFromTotal(int size){
	estimate->subtract(size);
}
//==============================================================
void DataCompilationTreeView::recalculate(){
	estimate->reset();
	emit haveStatus("Recalculating image size. Please wait...");
     		
	QListViewItem *item;
	FileItem *fileItem;
	FolderItem *folderItem;
	
	for(item = top->firstChild(); item; item = item->nextSibling()){
		
		fileItem = dynamic_cast<FileItem *>(item);
		if(fileItem){
			QFileInfo d( fileItem->getFilePath() );
			
			if(!d.exists() || !d.isReadable()){
              		KMessageBox::sorry(this,
              				"Can not accept: " +  fileItem->getFilePath() + "\n"\
              				"This path is no longer valid! or possibly you do not\n"\
              				"have enough privileges to use this item.");
              		setCurrentItem(fileItem);
				remove();
				continue;
              	}
              	int size = (int)d.size();
              	
              	if(!estimate->add(size / 1024)){
       			KMessageBox::sorry(this,
       				"Can not accept: " +  fileItem->getFilePath() + "\n"\
       				"It's too big to fit on this CD!");
       			setCurrentItem(fileItem);
				remove();
				continue;
       		}
			
			fileItem->setFileSize(size);
		
		}
		else if((folderItem = dynamic_cast<FolderItem *>(item)) != NULL){
			
			QFileInfo d( folderItem->getFilePath() );
			
			if(!d.exists() || !d.isReadable()){
              		KMessageBox::sorry(this,
              				"Can not accept: " + folderItem->getFilePath() + "\n"\
              				"This path is no longer valid! or possibly you do not\n"\
              				"have enough privileges to use this item.");
              		setCurrentItem(folderItem);
				remove();
				continue;
              	}
      		
      		KDirSize *job = KDirSize::dirSizeJob(KURL(folderItem->getFilePath()));
      		job->setName(folderItem->getFileName());
      		emit processStarted();
      		emit longProcessStarted(job);
      		
      		map.insert(job->name(), folderItem);
      		connect(job, SIGNAL(result(KIO::Job *)),
      			this, SLOT(gotSize(KIO::Job *)));
      				
		}
		else
			continue;
	}
	if(map.isEmpty()){		
		emit processDone();
		emit haveStatus("Ready.");
	}
}

//========================================================================
void DataCompilationTreeView::gotSize(KIO::Job *j){
	
	if ( j->error() )
    		return;
	emit longProcessDone(j);
	
	KDirSize *job = dynamic_cast<KDirSize *>(j);
	int size = (int)(job->totalSize() / 1024);
	
	QString id = j->name();
	FolderItem *folderItem = map[id];
	
	if(!estimate->add(size)){
		KMessageBox::sorry(this,
			"Can not accept: " + folderItem->getFilePath() + "\n"\
			"It's too big to fit on this CD!");
			
		setCurrentItem(folderItem);
		remove();
		
	}
	else{
		folderItem->setFileSize(size*1024);
		saved = false;
		emitGotCaption();
	}
	map.remove(id);
	
	if(map.isEmpty()){		
		emit processDone();
		emit haveStatus("Ready.");
	}
}
//========================
void DataCompilationTreeView::longProcessCanceled(QString id){

	FolderItem *cur = map[id];
			
	setCurrentItem(cur);
	remove();
	
	map.remove(id);
	if(map.isEmpty()){		
		emit processDone();
		emit haveStatus("Ready.");
	}
}
//========================
void DataCompilationTreeView::createISO(){
	if(isEmpty())
		return;
		
	config->setGroup("Default Settings");	
	
	if(config->readBoolEntry("Check Tmp Size", true)){
	
		int size = config->readNumEntry("tmp Size", -1);
	
		if(size == -1){
			int result = KMessageBox::warningContinueCancel(this,
					"Unable to determine temporary directory size! Would you \n"\
					"like to run 'Setting Dialog' to choose tmp directory now?",
        				"Run Settings Dialog now?",
        				QString("&Yes"));
    			switch(result) {
    				case KMessageBox::Continue:{
					popUpSettings(SettingsDialog::Defaults);
					return;
				}
    			}
		}
		else{
			//cerr << "size = " << size << endl;
			//cerr << "estimate->getTotal() / 1024 = " << estimate->getTotal() / 1024 << endl;
			if(size < (estimate->getTotal() / 1024)){
				KMessageBox::sorry(this,
					"Temprorary directory does not have enough space available\n" \
					"for storing disk image. Please remove some files from the list\n"\
					"or choose another location through 'Settings Dialog'.");
				return;
			}
		}
	}
	
	QFileInfo d(top->text(0));		
	if(d.exists()){
		int result = KMessageBox::warningContinueCancel(this,
			"File with the same name already exists!\n"\
			"Click 'Cancel' to run 'Setting Dialog' and\n"\
			"change ISO name Or overwrite existing one.",
        		"Overwrite existing?",
        		QString("&Overwrite"));
    		switch(result) {
    			case KMessageBox::Continue:
    				break;
    			default:{
				popUpSettings(SettingsDialog::Image);
				//return;
			}
		}
    	}
	NewCdDialog *ncd = new NewCdDialog(&fList, cdboApp, "ncd", true ) ;
	ncd->exec();
	delete ncd;
	updateSettings();
}
//========================
void DataCompilationTreeView::createCD(){
	if(isEmpty())
		return;

	config->setGroup("Default Settings");	
	
	if(config->readBoolEntry("Check Tmp Size", true)){
	
		int size = config->readNumEntry("tmp Size", -1);
	
		if(size == -1){
			int result = KMessageBox::warningContinueCancel(this,
					"Unable to determine temporary directory size!\n"\
					"Do you want to run 'Setting Dialog' to choose tmp directory?",
        				"Run Settings Dialog now?",
        				QString("Yes"));
    			switch(result) {
    				case KMessageBox::Continue:{
					popUpSettings(SettingsDialog::Defaults);
					return;
				}
    			}
		}
		else{
			if(size < (estimate->getTotal() / 1024)){
				KMessageBox::sorry(this,
					"Temprorary directory does not have enough space available\n" \
					"for storing disk image. Please remove some files from the list\n"\
					"or choose another location through 'Settings Dialog'.");
				return;
			}
		}
	}
	
	//config->setGroup("ISO Settings");	
	//config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	QFileInfo d(top->text(0));		
	if(d.exists()){
		int result = KMessageBox::warningContinueCancel(this,
			"File with the same name already exists!\n"\
			"Click 'Cancel' to run 'Setting Dialog' and\n"\
			"change ISO name Or overwrite existing one.",
        		"Overwrite existing?",
        		QString("&Overwrite"));
    		switch(result) {
    			case KMessageBox::Continue:
    				break;
    			default:{
				popUpSettings(SettingsDialog::Image);
				//return;
			}
    		}
    	}
	NewCdDialog *ncd = new NewCdDialog(&fList, cdboApp, "ncd" ) ;
       ncd->exec();
       delete ncd;
       updateSettings();
	
}
/*/=============================================
QDragObject *DataCompilationTreeView::dragObject() const{
	
	QListViewItem *item = currentItem();
	if ( !item ){
		return 0;
		cerr << "returning item = null\n\n";
	}
	CdboFileItem *cur = dynamic_cast<CdboFileItem *> (item);
	if ( !cur ){
		return 0;
		cerr << "returning cur = null\n\n";
	}
	QDragObject *d = new QTextDrag(cur->getFilePath(), (QWidget *)this);
	const QPixmap *p = cur->pixmap(0);
	d->setPixmap(*p);
	return d;
}*/
