(*:Name: PointShape3D *)

(* :Title: PointShape3D *)

(* :Author: Tom Wickham-Jones*)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.2 *)

(*:Summary:
	This package provides functions to replace 3D points
	by solid objects.
*)


(* :History:
	Created spring 1994 by Tom Wickham-Jones.

	This package is described in the book
	Mathematica Graphics: Techniques and Applications.
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.

*)


BeginPackage[ "ExtendGraphics`PointSubstitute3D`", "Graphics`Polyhedra`"]


PointSubstitute::usage = 
	"PointSubstitute[ gobj, shape] replaces Point primitives in the
	Graphics3D object gobj with shape. PointSubstitute[ gobj, shape, size] 
	replaces Point primitives with shapes of particular size."
	

LineSubstitute::usage =
	"LineSubstitute[ gobj, shape] inserts shape at each point of Line 
	primitives in the Graphics3D object gobj.
	LineSubstitute[ gobj, shape, size] replaces Line primitives with 
	shapes of particular size."


Begin[ "`Private`"]


PointSubstitute[ obj_Graphics3D, 
		shape_ /; VectorQ[ shape, (Head[#] === Polygon)&], 
		size_:Automatic] :=
    Block[{rng, nsize},
	nsize =
	    If[ !NumberQ[ size],
		rng = FullOptions[ obj, PlotRange] ;
		rng = Min[ Map[ (Last[#] - First[#])&, rng]] ;
		rng/40.,
		size] ;
	obj /. Point[ pt_] :>
	    Map[
		Polygon[ Map[ Function[ {p1}, pt + nsize p1], First[#]]]&,
                shape]
	]

LineSubstitute[ obj_Graphics3D, 
		shape_ /; VectorQ[ shape, (Head[#] === Polygon)&], 
		size_:Automatic] :=
    Block[{rng, nsize},
	nsize =
	    If[ !NumberQ[ size],
		rng = FullOptions[ obj, PlotRange] ;
		rng = Min[ Map[ (Last[#] - First[#])&, rng]] ;
		rng/40.,
		size] ;
	obj /. Line[ pt_] :>
	    {
	    Line[ pt], 
	    Map[ Function[{lpt},  
	    Map[
		Polygon[ Map[ Function[ {p1}, lpt + nsize p1], First[#]]]&,
			shape]], pt]
	    }
    ]

End[]

EndPackage[]


(*

d1 = Table[N[{t, 0, Sin[t]}], {t,0,4Pi,Pi/10}];

p = ScatterPlot3D[ d1]

PointSubstitute[ p, Octahedron[], 0.3]

Show[%]

*)
