let loc = (Lexing.dummy_pos, Lexing.dummy_pos)

let usage =
"Usage: mlcduce_wrapper [-I path ...] <primitive file>
" 

let err s = prerr_endline s; prerr_endline usage; exit 1


let rec args = function
  | "-I"::path::rest ->
      Librarian.obj_path := path::!Librarian.obj_path;
      args rest
  | [p] -> p
  | _ -> err "Invalid command line"


let () =
  let fn = args (List.tl (Array.to_list Sys.argv)) in
  let ic = 
    try open_in fn
    with Sys_error s -> err s in
  let v = ref [] in
  (try while true do 
     let s = input_line ic in
     if s != "" then
       match s.[0] with
	 | 'A'..'Z' -> v := s :: !v 
	 | '#' -> ()
	 | _ -> err "Names must start with a capitalized letter"
   done 
   with End_of_file -> ());
  let s = Mlstub.gen_wrapper !v in
  !Pcaml.print_implem [ s,loc ];
  print_endline "let () = Librarian.obj_path := [";
  List.iter (fun s -> Printf.printf "  %S;\n" s) !Librarian.obj_path;
  print_endline " ];;";
  print_endline "let () = Run.main ();;"

