/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 - 2001 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <time.h>
#include <stdio.h>
#include <zlib.h>
#include <png.h>

#include "absimg.h"

absimg_rgb_t *absimg_rgb_new(w, h)
int w;
int h;
{
	absimg_rgb_t *rv;

	rv = g_malloc(sizeof(absimg_rgb_t));

	rv->rgb = g_malloc(3 * w * h);
	memset(rv->rgb, '\0', 3 * w * h);

	rv->alpha = NULL;

	rv->width = w;
	rv->height = h;

	return rv;
}

absimg_rgb_t *absimg_to_rgb(img)
absimg_image_t *img;
{
	absimg_rgb_t *rv;
	int w,h;

	w = img->rgb_width;
	h = img->rgb_height;

	rv = absimg_rgb_new(w, h);

	absimg_render_to_rgb(rv, img, w, h, 0.0, 0.0);

	return rv;
}

void absimg_rgb_fill(rgb, r, g, b)
absimg_rgb_t *rgb;
guchar r;
guchar g;
guchar b;
{
	int l = 3 * rgb->width * rgb->height;
	int i;

	for (i = 0; i < l; i += 3)
	{
	       rgb->rgb[i] = r;
	       rgb->rgb[i+1] = g;
	       rgb->rgb[i+2] = b;
	}

	if (rgb->alpha)
		memset(rgb->alpha, '\377', rgb->width * rgb->height);
}

int absimg_rgb_savePNG(rgb, name)
absimg_rgb_t *rgb;
char *name;
{
	FILE *f;
	png_structp pngw;
	png_infop pngi;
	png_time pngt;
	time_t t;
	struct tm *gtm;
	int j;
	png_bytepp bufp;
	
	f = fopen(name, "wb");

	if (!f)
	{
		perror(name);
		return -1;
	}
	
	pngw = png_create_write_struct(PNG_LIBPNG_VER_STRING, 
		(png_voidp) NULL,
		(png_error_ptr) NULL,
		(png_error_ptr) NULL);
	
	pngi = png_create_info_struct(pngw);
	
	if (setjmp(pngw->jmpbuf))
	{
		png_destroy_write_struct(&pngw, &pngi);
		fclose(f);
		return -1;
	}
	
	png_init_io(pngw, f);
	png_set_IHDR(pngw, pngi, rgb->width, rgb->height, 8, PNG_COLOR_TYPE_RGB,
		PNG_INTERLACE_NONE , PNG_COMPRESSION_TYPE_DEFAULT ,
		PNG_FILTER_TYPE_DEFAULT);
	
	t = time(NULL);
	gtm = gmtime(&t);
	png_convert_from_struct_tm(&pngt, gtm);
	png_set_tIME(pngw, pngi, &pngt);
	
	png_write_info(pngw, pngi);
	
	bufp = g_malloc(sizeof(png_bytepp) * rgb->height);

	for (j = 0 ; j < rgb->height; j++)
	{
		bufp[j] = rgb->rgb + j*rgb->width*3;
	}
	png_write_image(pngw, bufp);
	g_free(bufp);
	
	png_write_end(pngw, pngi);
	png_destroy_write_struct(&pngw, &pngi);
	
	fclose(f);
	
	return 0;
}

void absimg_rgb_tile(rgb, img, w, h)
absimg_rgb_t *rgb;
absimg_image_t *img;
int w;
int h;
{
	absimg_image_t *timg = NULL,*cimg;
	absimg_rgb_t *irgb;
	int x,y;

	if (img->rgb_width != w || img->rgb_height != h)
	{
		timg = absimg_scale(img, w, h);
		cimg = timg;
	}
	else
	{
		cimg = img;
	}

	irgb = absimg_to_rgb(cimg);

	if (timg)
		absimg_destroy(timg);

	for (y = 0; y < rgb->height; y++)
	{
		int lstart = y * rgb->width * 3;
		int ilstart = (y % irgb->height) * irgb->width *3;

		for (x = 0; x < rgb->width; x += irgb->width)
		{
			memcpy(rgb->rgb + lstart + x * 3, irgb->rgb + ilstart,
				3 * (((rgb->width - x) < 0) ?
				     (x - rgb->width) : irgb->width));
		}
	}

	absimg_rgb_free(irgb);
}

void absimg_rgb_grayfy(rgb)
absimg_rgb_t *rgb;
{
	int i,v;

	for (i = 0; i < rgb->height * rgb->width * 3; i+=3)
	{
		v = ((int)rgb->rgb[i] + (int)rgb->rgb[i+1] + (int)rgb->rgb[i+2])/3;

		rgb->rgb[i] = (unsigned char) v;
		rgb->rgb[i+1] = (unsigned char) v;
		rgb->rgb[i+2] = (unsigned char) v;
	}
}

absimg_rgb_t *absimg_rgb_dup(rgb)
absimg_rgb_t *rgb;
{
	absimg_rgb_t *rv;

	rv = absimg_rgb_new(rgb->width, rgb->height);
	memcpy(rv->rgb, rgb->rgb, rgb->width * rgb->height * 3);

	if (rgb->alpha)
		rv->alpha = g_memdup(rgb->alpha, rgb->width * rgb->height);

	return rv;
}

