/***************************************************************************
                          interface.h  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_H
#define INTERFACE_H

#include <gtk--/window.h>
#include <gtk--/box.h>
#include <gtk--/pixmap.h>
#include <gtk--/label.h>
#include <gtk--/notebook.h>
#include <gtk--/main.h>
#include <gdk/gdkkeysyms.h>
#include <gtk--/accelgroup.h>
#include <gtk--/list.h>
#include <gtk--/clist.h>
#include <gtk--/viewport.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/entry.h>
#include <gtk--/button.h>
#include <gtk--/separator.h>
#include <gtk--/togglebutton.h>
#include <gtk--/radiobutton.h>
#include <gtk--/statusbar.h>
#include <gtk--/combo.h>
#include <gtk--/text.h>
#include <gtk--/spinbutton.h>
#include <gtk--/adjustment.h>
#include <gtk--/table.h>
#include <gtk--/frame.h>
#include <gtk--/main.h>
#include <gtk--/paned.h>

/* own custom widgets */
#include "interface_widget_sample_view.h"
#include "interface_widget_pattern_editor.h"
#include "interface_widget_orderlist.h"
#include "interface_widget_envelope.h"
#include "interface_widget_equivtable.h"
#include "interface_widget_sample_import.h"
#include "interface_widget_posvar.h"
#include "interface_widget_visual1.h"
#include "interface_widget_visual2.h"


/* Popup windows */
#include "interface_popups.h"

/* everything else */
#include "file_format_manager.h"
#include "song.h"
#include "player_rt_keyboard.h"
#include "player_data.h"
#include "mixer_software.h"
#include "sound_driver_manager.h"

#include "properties.h"

using SigC::bind;

/**
  *@author Juan Linietsky
  */


/******************************
 interface.h
 ----------

this class just scares me
********************************/

//There is this neat option to show messages when doing actions.. this is
//the time that a message remains viewable
#define DEFAULT_MSG_TIME 40

class Interface : public Gtk::Window {

        /* Widget declarations */
        enum Key_Names {
		
  		KEY_NOTEOFF,
		KEY_NOTECUT,
	 	KEY_PLAY_NOTE,
	  	KEY_PLAY_ROW,
	   	KEY_NEXT_INSTRUMENT,
	   	KEY_PREV_INSTRUMENT,
	        KEY_ERASE_FIELD,
	        KEY_TOGGLE_MASK,
	        KEY_REPEAT_LAST_FIELD,
	        KEY_NOTE_O1_C,
	        KEY_NOTE_O1_Cs,
	        KEY_NOTE_O1_D,
	        KEY_NOTE_O1_Ds,
	        KEY_NOTE_O1_E,
	        KEY_NOTE_O1_F,
	        KEY_NOTE_O1_Fs,
	        KEY_NOTE_O1_G,
	        KEY_NOTE_O1_Gs,
	        KEY_NOTE_O1_A,
	        KEY_NOTE_O1_As,
		KEY_NOTE_O1_B,
	        KEY_NOTE_O2_C,
	        KEY_NOTE_O2_Cs,
	        KEY_NOTE_O2_D,
	        KEY_NOTE_O2_Ds,
	        KEY_NOTE_O2_E,
	        KEY_NOTE_O2_F,
	        KEY_NOTE_O2_Fs,
	        KEY_NOTE_O2_G,
	        KEY_NOTE_O2_Gs,
	        KEY_NOTE_O2_A,
	        KEY_NOTE_O2_As,
	        KEY_NOTE_O2_B,
	        KEY_NOTE_O3_C,
	        KEY_NOTE_O3_Cs,
	        KEY_NOTE_O3_D,
	        KEY_NOTE_O3_Ds,
	        KEY_NOTE_O3_E,
	        KEY_NOTE_O3_F,
	        KEY_NOTE_O3_Fs,
	        KEY_NOTE_O3_G,

	        KEY_MAX_KEYS
	};

 	static const char * key_names[KEY_MAX_KEYS];

 	Uint8 key_assign[KEY_MAX_KEYS];

	enum notebook_pages {

        	PATTERN_EDITOR_PAGE,
		SAMPLE_LIST_PAGE,
		INSTRUMENT_LIST_PAGE,
		INFO_PAGE,
		ORDERPAN_PAGE,
		VARIABLES_PAGE,
		SETUP_PAGE
	};
	//All the widget declarations go in a separate file to avoid headaches
	#include "interface_widget_declarations.gtkmm"

	/* Bindings */
	Song *song;
        File_Format_Manager *file_manager;
	Player_Data *player;
	Player_Realtime_Keyboard realtime_keyboard;
        Gtk::Main *kit;
        Mutex_Lock *variables_lock;
	Mixer_Software *software_mixer;
	Sound_Driver_Manager *driver_manager;
       	Editor editor;
        Info_View_Data view_data;
        Info_View_Pattern view_pattern;
	struct Reverb {

   		char room;
     		char damp;
     		char wet;
       		char dry;
         	char width;

   	} reverb;
        string song_path;
        string data_path;
        string fontname;
	Gdk_Font font;
	/* Variables */

        bool previous_shift;
	int selected_sample;
	int selected_instrument;
	bool selected_sample_updating_in_progress;
	bool selected_instrument_updating_in_progress;
	bool variables_page_updating_in_progress;
	bool orderpan_page_updating_in_progress;
	bool config_page_updating_in_progress;
	bool main_entries_updating_in_progress;
	bool song_follow_mode;
        Sample sample_clipboard;
        int clipboard_sample_index;
        Instrument instrument_clipboard;
        int clipboard_instrument_index;
        int current_page;
        int volume_scale_memory;
        int update_freq_counter;
        int widgets_update_freq;
        bool quit_request;
        int selected_key;

	/* Status Text in Statusbar */
	void set_message(string p_msg,int p_time);
	void update_message();
	Uint64 update_counter;
        Uint64 message_time_left_counter;
	string message_bar;

	/* Popups! */
        Window_File_Popup *file_menu_popup;
        File_Access_Widget *file_select_popup;
        Dialog_Accept *accept_dialog;
        Popup_Sample_Utils sample_utils_popup;
        Popup_Instrument_Utils instrument_utils_popup;
        Dialog_Enter_Value *input_value_popup;
        Dialog_OkCancel *okcancel_dialog;
        PopUp_Pattern_Properties *pattern_properties_popup;
	Popup_Undo_Window *pattern_undo_popup;
	Sample_Import *sample_import;

	gint delete_event_impl(GdkEventAny* p_event);

	void initialize_widgets();
	void destroy_widgets();
	
	void save_sample();

        void set_fonts();

 	bool is_key(Key_Names p_key,int p_key);
  	bool is_note(int p_key);
   	bool has_key(int p_key);
	int get_key_pos(int p_key);
        void save_instrument();
        void set_some_default_path(string p_path,string p_which);

        void generate_config_file(FILE *f);
	Properties* check_for_config_file();

public:
	void load_icons();	
        void load_config();
        void save_config();

        void run_song_load_menu();
        void run_song_save_menu();

	static bool xlib_key_is_pressed(int key);

        void update_info_widgets();
	void update_redrawable_widgets();
        void update_sound_driver_widgets();
	void update_all_widgets();
	void link_to_song(Song *p_song);
	void link_to_software_mixer(Mixer_Software *p_softmixer);
	void link_to_player(Player_Data *p_player);
	void link_to_main(Gtk::Main *p_kit) { kit=p_kit; };
        void link_to_file_manager(File_Format_Manager *p_file_manager) { file_manager=p_file_manager; };
	void link_to_variables_lock(Mutex_Lock *p_variables_lock) { variables_lock=p_variables_lock; };
	void link_to_sound_driver_manager(Sound_Driver_Manager *p_driver_manager);

	bool is_quit_requested() { return quit_request; };

	Interface();
	~Interface();
};

#endif
