/***************************************************************************
                          interface_callbacks_config.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

void Interface::set_some_default_path(string p_path,string p_which) {

	if (p_which=="data") {

		entry_main_data_path->set_text(p_path);   		

  	} else if (p_which=="song") {

		entry_main_song_path->set_text(p_path);   		

     	}
}

void Interface::on_entry_main_song_path_changed() {

	if (config_page_updating_in_progress) return;

 	song_path=entry_main_song_path->get_text();
  	if ((song_path.size()==0) || (song_path[song_path.size()-1]!='/'))
                song_path+="/";
   		


}
void Interface::on_entry_main_data_path_changed() {

	if (config_page_updating_in_progress) return;

 	data_path=entry_main_data_path->get_text();
  	if ((data_path.size()==0) || (data_path[data_path.size()-1]!='/'))
                data_path+="/";



}

void Interface::on_entry_main_font_name_changed() {

	if (config_page_updating_in_progress) return;
	fontname=entry_main_font_name.get_text();

}

void Interface::on_button_main_ok_font_changed() {

        set_fonts();
}
void Interface::on_button_main_font_list_changed() {

	 Window_FontSelect_PopUp font_select;
  	 font_select.set_font_name(fontname);
    	 font_select.poll_until_action(*kit);
	 if (font_select.action==Window_FontSelect_PopUp::PRESSED_OK) {

    		fontname=font_select.get_font_name();
		entry_main_font_name.set_text(fontname);   		
      	 }
}

void Interface::on_button_config_enable_filters_clicked() {

          player->set_filters_enabled(checkbutton_config_enable_filters.get_active());

}


void Interface::on_clist_config_sound_driver_name_select_row(gint row, gint column, GdkEvent *event) {

	driver_manager->set_active_driver(row);
}

void Interface::on_checkbutton_config_16bits_clicked() {

	if (config_page_updating_in_progress) return;

	driver_manager->request_mix_16bits(checkbutton_config_16bits.get_active());
	update_sound_driver_widgets();
}

void Interface::on_checkbutton_config_stereo_clicked() {

	if (config_page_updating_in_progress) return;
	driver_manager->request_mix_stereo(checkbutton_config_stereo.get_active());
	update_sound_driver_widgets();
}

void Interface::on_button_config_sound_restart_clicked() {

	if (config_page_updating_in_progress) return;
	driver_manager->reset_active_driver();
	update_sound_driver_widgets();
}

void Interface::on_button_config_sound_config_clicked() {


}

void Interface::on_clist_config_mixer_proc_select_row(gint row, gint column, GdkEvent *event) {

	software_mixer->set_mixer_procedure_in_use(row);
}

void Interface::on_button_config_save_clicked() {


}

void Interface::on_button_config_adjust_colors_clicked() {


 	if (selected_key==-1) return;

	Window_Get_Key get_key_popup(key_names[selected_key]);

	get_key_popup.poll_until_action(*kit);
	get_key_popup.hide(); 	

 	if (get_key_popup.action==Window_Get_Key::PRESSED_KEY) {

		if (has_key(get_key_popup.key_pressed)) {

	                Dialog_Accept accept_your_bad_luck((string)"Key `" +(char)get_key_popup.key_pressed+ (string)"` already assigned to " + (string)key_names[get_key_pos(get_key_popup.key_pressed)],*kit);
                 	accept_your_bad_luck.hide();
    		} else {

                        char keyz[4]={'\'','.','\'',0};        	
                        key_assign[selected_key]=get_key_popup.key_pressed;
			keyz[1]=(char)key_assign[selected_key];
        		clist_config_keyboard_type.set_text(selected_key,0,keyz);

        	}
    	}

     	
}


void Interface::on_clist_config_keyboard_type_select_row(gint row, gint column, GdkEvent *event) {

	selected_key=row;
}

void Interface::on_combo_config_buffersize_changed() {

	if (config_page_updating_in_progress) return;

	string tmp_string;
	int real_buffsize;
	
	tmp_string=combo_config_buffersize.get_entry()->get_text();
	real_buffsize=atoi(tmp_string.c_str());

	driver_manager->request_buffer_size(real_buffsize);

	update_sound_driver_widgets();

}

void Interface::on_combo_config_frequency_changed() {

	if (config_page_updating_in_progress) return;

	string tmp_string;
	int real_freq;
	
	tmp_string=combo_config_frequency.get_entry()->get_text();
	real_freq=atoi(tmp_string.c_str());

	driver_manager->request_mix_frequency(real_freq);

	update_sound_driver_widgets();
}

void Interface::on_spinbutton_config_virtual_channels_changed() {

        if (config_page_updating_in_progress) return;

	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();
      	player->play_stop();

	player->set_virtual_channels(spinbutton_config_virtual_channels->get_value_as_int());
	
}

void Interface::on_vscrollbar_config_reverb_changed() {

        if (config_page_updating_in_progress) return;

   	reverb.room=(char)config_reverb_parms[0]->get_adjustment()->get_value();
     	reverb.damp=(char)config_reverb_parms[1]->get_adjustment()->get_value();
     	reverb.wet=(char)config_reverb_parms[2]->get_adjustment()->get_value();
       	reverb.dry=(char)config_reverb_parms[3]->get_adjustment()->get_value();
 	reverb.width=(char)config_reverb_parms[4]->get_adjustment()->get_value();

	software_mixer->set_reverb_params(
		config_reverb_parms[0]->get_adjustment()->get_value(),
		config_reverb_parms[1]->get_adjustment()->get_value(),
		config_reverb_parms[2]->get_adjustment()->get_value(),
		config_reverb_parms[3]->get_adjustment()->get_value(),
		config_reverb_parms[4]->get_adjustment()->get_value()
	);

}

void Interface::on_button_config_reverb_enabled_clicked() {

	software_mixer->set_reverb_enabled(checkbutton_config_reverb_enabled.get_active());
}