/***************************************************************************
                          interface_config.cpp  -  description
                             -------------------
    begin                : Wed Apr 10 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"


#define CREATE_CONFIG_FILE_NAME  { \
			           \
			string file; \
			file=file+getenv("HOME"); \
			file=file+"/.cheesetracker/cheesetracker.conf"; \
			config_file=file; \
		    }

#define CREATEDIR  { \
			system("mkdir ~/.cheesetracker"); \
		    }




void Interface::generate_config_file(FILE *f) {

       	fprintf(f,"[CheeseTracker Config File]\n");		
       	fprintf(f,"; This is a generated configuration file\n");		
       	fprintf(f,"; for CheeseTracker.\n");	
       	fprintf(f,"; feel free to edit it\n");		
       	fprintf(f,"; any text after semicolons will be ignored\n\n");					
       	fprintf(f,"[device]\n\n");
       	fprintf(f,";\n");
       	fprintf(f,"sample_rate=%i\n",driver_manager->get_mix_frequency());
       	fprintf(f,"mix_16bits=%i\n",driver_manager->get_mix_16bits());
       	fprintf(f,"mix_stereo=%i\n",driver_manager->get_mix_stereo());
       	fprintf(f,"buffer_size=%i ; in bytes\n\n",driver_manager->get_mix_buffer_size());
       	fprintf(f,";\n");
       	fprintf(f,"; Audio drivers found:\n");
       	fprintf(f,";\n");
	
  	for (int i=0;i<driver_manager->get_amount_of_drivers();i++) {

       		fprintf(f,"; %i- %s:\n",i,driver_manager->get_driver_name(i).c_str());
	}
       	fprintf(f,";\n");
	
    	fprintf(f,"driver_index=%i ; default\n",driver_manager->get_active_driver());
       	fprintf(f,";\n");
		
       	fprintf(f,"[mixer]\n\n\n");

       	fprintf(f,"max_polyphony=%i ; max virtual channels\n",software_mixer->get_number_of_channels());
       	fprintf(f,"enable_filters=%i ; enable IT filters\n",player->are_filters_enabled());
       	fprintf(f,"enable_reverb=%i ; enable reverb\n",software_mixer->is_reverb_enabled());
       	fprintf(f,"; Reverb parameters\n");
       	fprintf(f,"reverb_room=%i\n",reverb.room);
       	fprintf(f,"reverb_damp=%i\n",reverb.damp);
       	fprintf(f,"reverb_wet=%i\n",reverb.wet);
       	fprintf(f,"reverb_dry=%i\n",reverb.dry);
       	fprintf(f,"reverb_width=%i\n",reverb.width);
       	fprintf(f,";\n");
       	fprintf(f,"; Mixer Procedures:\n");
       	fprintf(f,";\n");

	for (int i=0;i<software_mixer->get_amount_of_mixer_procedures();i++) {

       		fprintf(f,"; %i- %s:\n",i,software_mixer->get_mixer_procedure_name(i).c_str());
       	}

       	fprintf(f,";\n");

       	fprintf(f,"mixer_procedure=%i",software_mixer->get_mixer_procedure_in_use());
       	fprintf(f,"\n");
       	fprintf(f,"\n");
                		
       	
        fprintf(f,"[interface]\n\n");
       	fprintf(f,"\n");
       	fprintf(f,"editor_font=%s\n",fontname.c_str());
       	fprintf(f,"widget_repaint_frequency=%i\n",widgets_update_freq);	
        fprintf(f,"\n");
       	fprintf(f,"\n");

        fprintf(f,"[paths]\n\n");
       	fprintf(f,"\n");
       	fprintf(f,"song_path=%s ; path to songs directory\n",song_path.c_str());
       	fprintf(f,"data_path=%s ; path to samples & instruments directory\n",data_path.c_str());
       	fprintf(f,"\n");
       	fprintf(f,"\n");
       	
        fprintf(f,"[keys]\n\n");
       	fprintf(f,"\n");
       	fprintf(f,"\n");

       	fprintf(f,"; for ';' use \\;\n");

	for (int i=0;i<KEY_MAX_KEYS;i++) {

		char keystr[3]={'.',0,0};
  		
    		if (key_assign[i]==';') {
	  		keystr[0]='\\';
	  		keystr[1]=';';
     		} else
	  		keystr[0]=key_assign[i];

     		

       		fprintf(f,"key_%s= %s\n",key_names[i],keystr); 	

       	}
       	fprintf(f,"\n");
}

Properties* Interface::check_for_config_file() {

	FILE *f=NULL;
	string config_file;	
	Properties *config_props= new Properties;
	CREATE_CONFIG_FILE_NAME;
	printf("using config file at.. %s\n",config_file.c_str());
	
	f=fopen(config_file.c_str(),"rb");
	if (f==NULL) {
			
		int err;
		
		printf("error: config file not found!! - creating new config file. Feel free to edit it!.\n");
		
		CREATEDIR;
		
		f=fopen(config_file.c_str(),"wb");
		
		if (f==NULL) {
			
			printf("Failed creating the config file. Exiting..\n");
			return NULL;
		}
		
  		generate_config_file(f);


	}
						
	fclose(f);
	config_props->load_from_text(config_file);	

	return config_props;

		

}


void Interface::load_config() {

	Properties *config_props = check_for_config_file();

	/* DEVICE SECTION */ 	

        combo_config_frequency.get_entry()->set_text(config_props->get_str_property("device","sample_rate"));
        checkbutton_config_16bits.set_active(config_props->get_int_property("device","mix_16bits"));
	checkbutton_config_stereo.set_active(config_props->get_int_property("device","mix_stereo"));
 	on_checkbutton_config_16bits_clicked();
  	on_checkbutton_config_stereo_clicked();
//        combo_config_buffersize.get_entry()->set_text(config_props->get_str_property("device","buffer_size"));
        on_clist_config_sound_driver_name_select_row(config_props->get_int_property("device","driver_index"),0,NULL);

        /* MIXER SECTION */

        spinbutton_config_virtual_channels->set_value(config_props->get_int_property("mixer","max_polyphony"));
        checkbutton_config_enable_filters.set_active(config_props->get_int_property("mixer","enable_filters"));
	checkbutton_config_reverb_enabled.set_active(config_props->get_int_property("mixer","enable_reverb"));
        on_button_config_reverb_enabled_clicked();
        on_button_config_enable_filters_clicked();
       	config_reverb_parms[0]->get_adjustment()->set_value(config_props->get_int_property("mixer","reverb_room"));
       	config_reverb_parms[1]->get_adjustment()->set_value(config_props->get_int_property("mixer","reverb_damp"));
       	config_reverb_parms[2]->get_adjustment()->set_value(config_props->get_int_property("mixer","reverb_wet"));
       	config_reverb_parms[3]->get_adjustment()->set_value(config_props->get_int_property("mixer","reverb_dry"));
       	config_reverb_parms[4]->get_adjustment()->set_value(config_props->get_int_property("mixer","reverb_width"));
        on_clist_config_mixer_proc_select_row(config_props->get_int_property("mixer","mixer_procedure"),0,NULL);              		
	
        /* INTERFACE SECTION */

        entry_main_font_name.set_text(config_props->get_str_property("interface","editor_font"));       	
        spinbutton__config_interface_repaint->set_value(config_props->get_int_property("interface","widget_repaint_frequency"));
        set_fonts();
        /* PATHS SECTION */

        entry_main_song_path->set_text(config_props->get_str_property("paths","song_path"));
        entry_main_data_path->set_text(config_props->get_str_property("paths","data_path"));
                       	
        /* KEYS SECTION */

	for (int i=0;i<KEY_MAX_KEYS;i++) {

		char keystr[3]={'.',0,0};
  		char var[500];

  		
    		if (key_assign[i]==';') {
	  		keystr[0]='\\';
	  		keystr[1]=';';
     		} else
	  		keystr[0]=key_assign[i];

     		
       		sprintf(var,"key_%s",key_names[i]);		
		key_assign[i]=config_props->get_str_property("keys",var)[0];
       	}

 	delete config_props;
        update_config_widgets();
}

void Interface::save_config() {

	FILE *f=NULL;
	string config_file;	
	CREATE_CONFIG_FILE_NAME;
	printf("saving config file at.. %s\n",config_file.c_str());
	
	f=fopen(config_file.c_str(),"wb");
	if (f==NULL) {
			
	
		printf("Failed creating the config file. Exiting..\n");
		return ;

	}
						
	generate_config_file(f);

 	fclose(f);
}
