/***************************************************************************
                          interface_widget_pattern_editor.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_pattern_editor.h"

#define SEP_OFFSET (-5)
#define VOLUME_OVERDRIVE_LIMIT 270
int Tracker::color_values[] = {
    10, 20, 30,
    100, 200, 100,
    250, 250, 250,
    50, 60, 70,
    70, 80, 90,
    10, 50, 10,
    15, 80, 15,
    250, 250, 250,
    150, 150, 150,
    210, 210, 210,
    250, 100, 100,
    70, 110, 70,

};

void Tracker::allocate_colormap () {

	int i;

	for (i=0;i<Max_Colors*3;i+=3) {

		colors[i/3].red = color_values[i] * 0xFFFF / 0xFF;
		colors[i/3].green = color_values[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = color_values[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}

gint Tracker::do_expose_event(GdkEventExpose* p0) {

	if (editor==NULL) {

		return 0;
	}


	editor->set_flag_redraw_all();

	queue_draw();

	return 0;

}

void Tracker::realize_impl() {

	int i;

	Gdk_WindowAttr attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Tracker::do_expose_event));

	allocate_colormap();

       	for (i=0;i<Max_Colors;i++) {

		GC[i].create(get_window());
		GC[i].set_foreground(colors[i]);
	}

	GC[Col_BackGround].set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);
	old_row_to_draw=-1;
}

void Tracker::adjust_editor() {

	editor->set_window_width(width());
	editor->set_window_height(height());
	editor->adjust_view_to_cursor();
}

void Tracker::print_osciloscopes() {

	int i;

        if (player==NULL) return;

	window.draw_rectangle(GC[Col_BackGround],TRUE ,0,editor->get_row_height(),editor->left_numbers_width()+SEP_OFFSET,editor->get_row_height());

	for (i=0;i<editor->get_visible_columns();i++) {

		int tmpvoice,pos,j,tmppan,tmpvol,panpos,tmpvolval,tmpvolcol;
		window.draw_rectangle(GC[Col_BackGround],TRUE ,editor->left_numbers_width()+i*editor->get_column_width()+SEP_OFFSET,editor->get_row_height(),editor->get_window_width(),editor->get_row_height());
		tmpvoice=player->get_channel_voice(editor->get_column_offset()+i);

		window.draw_rectangle(GC[Col_SepChannels],TRUE,editor->left_numbers_width()+i*editor->get_column_width()+SEP_OFFSET,editor->get_row_height(),1,editor->get_row_height());
		window.draw_rectangle(GC[Col_SepChannels],TRUE,editor->left_numbers_width()+i*editor->get_column_width()+SEP_OFFSET+5,editor->get_row_height(),1,editor->get_row_height());

                if ((tmpvoice==-1) || (player->get_mixer_ptr()->is_voice_stopped(tmpvoice))) continue;

		pos=player->get_mixer_ptr()->get_voice_sample_pos_index(tmpvoice);
		tmppan=player->get_mixer_ptr()->get_voice_panning_pos(tmpvoice);
		tmpvol=player->get_mixer_ptr()->get_voice_volume(tmpvoice);



		if (tmppan==PAN_SURROUND) {
			
			panpos=editor->get_font_width();
			window.draw_string(*font,GC[Col_ForeGround_Selected],editor->left_numbers_width()+i*editor->get_column_width()+5,editor->get_row_height()+editor->get_font_height(),"s");	
		} else {
               		panpos=5+(tmppan*(editor->get_column_width()-5)/PAN_RIGHT);
			window.draw_rectangle(GC[Col_ForeGround_Selected],TRUE,editor->left_numbers_width()+i*editor->get_column_width()+panpos+SEP_OFFSET,editor->get_row_height(),1,editor->get_row_height());
		}

		if (panpos>(editor->get_column_width()-5)) panpos=editor->get_column_width()-5;

		tmpvolval=(tmpvol*(editor->get_row_height()-1)/VOLUME_OVERDRIVE_LIMIT);

		switch ((tmpvolval*3)/(editor->get_row_height()-1)) {

			case 0: {

				tmpvolcol=Col_SepChannels;
			} break;
			case 1: {

				tmpvolcol=Col_ForeGround;
			} break;
			case 2: {

				tmpvolcol=Col_ForeGround_Selected;
			} break;
        		default: {

				tmpvolcol=Col_Mask;
			} break;
		}	

		

		if (tmpvolval>(editor->get_row_height()-1)) tmpvolval=(editor->get_row_height()-1);

		window.draw_rectangle(GC[tmpvolcol],TRUE,editor->left_numbers_width()+i*editor->get_column_width()+SEP_OFFSET,(editor->get_top_height()-tmpvolval),5,editor->get_top_height()-(editor->get_top_height()-tmpvolval));

		for(j=5;j<editor->get_column_width();j++) {

                 	Sint8* sample_8bits;
                 	Sint16* sample_16bits;
			int size,val;
			
			if (player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)==NULL) break;

			sample_8bits=(Sint8*)player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->data_ptr;
			sample_16bits=player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->data_ptr;
			size=player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->size;

			if ((size==0) || (sample_8bits==NULL)) break;
			
			if (player->get_mixer_ptr()->get_voice_sample_data_ptr(tmpvoice)->is_16bits) {

                                val=(32768+sample_16bits[(pos+j)%size])*(editor->get_row_height()-1)/65535;
				
			} else {

                                val=(128+sample_8bits[(pos+j)%size])*(editor->get_row_height()-1)/255;
			}

			window.draw_rectangle(GC[(editor->is_channel_muted(editor->get_column_offset()+i))?Col_SepChannels:Col_ForeGround],TRUE,editor->left_numbers_width()+i*editor->get_column_width()+j+SEP_OFFSET,editor->get_row_height()+val,1,1);		
		}


	}

}


void Tracker::print_top() {

	char mask_string[5]={'I','V','C','P',0};
	int i;

/*  Print TOP info */

        /*  Clear top */	
	window.draw_rectangle(GC[Col_BackGround],TRUE ,0,0,editor->get_window_width(),editor->get_row_height());

        /* Edit Mask */	
	if (!editor->get_instrument_mask()) mask_string[0]=' ';
	if (!editor->get_volume_mask()) mask_string[1]=' ';
	if (!editor->get_command_mask()) mask_string[2]=' ';
	if (!editor->get_volume_pan_mode()) mask_string[3]=' ';

	window.draw_string(*font,GC[Col_Mask],0,editor->get_row_height(),mask_string);	

/* Track Numbers */

	for (i=0;i<editor->get_visible_columns();i++) {

		char track_string[15]={'C','h','a','n','n','e','l',' ','0','0','(','M',')',0};

		int col_offset = editor->get_column_offset()+i;

                track_string[8]='0'+(col_offset+1) / 10;
                track_string[9]='0'+(col_offset+1) % 10;

		if (!editor->is_channel_muted(col_offset)) {

                 	track_string[10]=' ';
                 	track_string[11]=' ';
                 	track_string[12]=' ';
			window.draw_string(*font,GC[Col_SepNewChannels],editor->left_numbers_width()+i*editor->get_column_width(),editor->get_row_height(),track_string);
		} else {


			window.draw_string(*font,GC[Col_SepChannels],editor->left_numbers_width()+i*editor->get_column_width(),editor->get_row_height(),track_string);
		}

	


	}
}

void Tracker::print_number(int rowofs,bool hilite_number,bool mark_number) {

	char number_string[5];
	number_string[4]=0;

	if ((rowofs<0) || (rowofs>editor->get_visible_rows())) return;
	number_string[0]='0'+(rowofs+editor->get_row_offset()) / 100;
	number_string[1]='0'+((rowofs+editor->get_row_offset())/10) % 10;
	number_string[2]='0'+(rowofs+editor->get_row_offset()) % 10;
	number_string[3]=mark_number?'<':' ';

/* Left Numbers */
	if (hilite_number) {

		window.draw_string(*font,GC[Col_ForeGround_Selected],0,editor->get_top_height()+rowofs*editor->get_row_height()+editor->get_font_height(),number_string);
	} else {

		window.draw_string(*font,GC[Col_ForeGround],0,editor->get_top_height()+rowofs*editor->get_row_height()+editor->get_font_height(),number_string);
        }
}

void Tracker::print_single_row(int rowofs) {
	
	int i;
        char note_string[19];
	int current_row,y_offset;

	note_string[18]=0;

	if ((rowofs<0) || (rowofs>=editor->get_visible_rows()) ) return;

	current_row=rowofs+editor->get_row_offset();
//	physical_row=rowofs;

	/* ROW Background - may depend on row hilite */

	y_offset=editor->get_top_height()+rowofs*editor->get_row_height();

 	if ((current_row % editor->get_hl_major())==0) {

		window.draw_rectangle(GC[Col_Row_Hilite_Major],TRUE,0,y_offset,editor->get_window_width(),editor->get_row_height());

	} else if ((current_row % editor->get_hl_minor())==0) {

		window.draw_rectangle(GC[Col_Row_Hilite_Minor],TRUE,0,y_offset,editor->get_window_width(),editor->get_row_height());

	} else {

		window.draw_rectangle(GC[Col_BackGround],TRUE,0,y_offset,editor->get_window_width(),editor->get_row_height());
	}


	/* Draw notes and separator lines. */

	for (i=0;i<editor->get_visible_columns();i++) {

		editor->get_note_string(editor->get_column_offset()+i,current_row,(char*)&note_string);
		
		if ( (editor->is_selection_active())
                     && (editor->get_column_offset()+i>=editor->get_selection_begin_x())
                     && (editor->get_column_offset()+i<=editor->get_selection_end_x())
                     && (editor->get_row_offset()+rowofs>=editor->get_selection_begin_y())
                     && (editor->get_row_offset()+rowofs<=editor->get_selection_end_y())
		    ) {	


			if ((current_row % editor->get_hl_major())==0) {

				window.draw_rectangle(GC[Col_Row_Hilite_Selected],TRUE ,editor->left_numbers_width()+i*editor->get_column_width(),y_offset,editor->get_column_width()-editor->get_font_width(),editor->get_row_height());
                        } else {

				window.draw_rectangle(GC[Col_BackGround_Selected],TRUE ,editor->left_numbers_width()+i*editor->get_column_width(),y_offset,editor->get_column_width()-editor->get_font_width(),editor->get_row_height());
			}

	                window.draw_string(*font,GC[Col_ForeGround_Selected],editor->left_numbers_width()+i*editor->get_column_width(),y_offset+editor->get_font_height(),note_string);
			
		} else 	{

	                window.draw_string(*font,GC[Col_ForeGround],editor->left_numbers_width()+i*editor->get_column_width(),y_offset+editor->get_font_height(),note_string);

		}


                window.draw_rectangle(GC[Col_SepChannels], TRUE,editor->left_numbers_width()+i*editor->get_column_width()-5,y_offset, 1 ,editor->get_row_height());
	}


	/* Draw Numbers */

//	if (editor->is_player_active() && current_row==editor->.get_playing_row()) {

//		print_number(rowofs,true);

//	} else {

	print_number(rowofs,false,editor->is_mark_active() && (current_row==editor->get_marked_row()) && (editor->get_current_pattern()==editor->get_marked_pattern()));
//	}

}



void Tracker::print_rows() {

	int i;

	for (i=0;i<editor->get_visible_rows();i++) print_single_row(i);
		

}

void Tracker::print_cursor() {

	int xinit,yinit;
	
	const char cursor_spacing[] = {

		0 , //note
		2 , //octave
		4 , //instrument 1
		5 , //instrument 2
		7 , //volume 1
		8 , //volume 2
		10, //command
		11, //parameter 1
		12, //parameter 2
	};

	xinit=editor->left_numbers_width()+(editor->get_cursor_x()-editor->get_column_offset())*editor->get_column_width()+cursor_spacing[editor->get_cursor_field()]*editor->get_font_width();
 	yinit=editor->get_top_height()+(editor->get_cursor_y()-editor->get_row_offset())*editor->get_row_height();

	window.draw_rectangle(GC[Col_Cursor],FALSE, xinit-2, yinit,editor->get_font_width()+4,editor->get_font_height()+3);
}



void Tracker::draw_impl(GdkRectangle* p0){

	int cursor_y_ofs_to_clear;

      	if (editor==NULL) return;

	adjust_editor();

	window.draw_rectangle(GC[Col_BackGround],TRUE,0,editor->get_visible_rows()*editor->get_row_height()+editor->get_top_height(),width(),height()-(editor->get_visible_rows()*editor->get_row_height()+editor->get_row_height()));

	if (editor->flag_redraw_all()) {

		print_top();
		print_rows();
		print_cursor();

	} else {
		
		if (editor->flag_redraw_row()) {

			cursor_y_ofs_to_clear=editor->get_previous_cursor_y()-editor->get_row_offset();

	                print_single_row(cursor_y_ofs_to_clear-1);
	                print_single_row(cursor_y_ofs_to_clear);
	                print_single_row(cursor_y_ofs_to_clear+1);

	                print_single_row(editor->get_cursor_y()-editor->get_row_offset());			
			print_cursor();
		}

		if (editor->flag_redraw_top()) {

                        print_top();
		}

		if (editor->flag_redraw_playing_row()) {

			print_single_row(editor->get_playing_row()-editor->get_row_offset());
			print_single_row(editor->get_old_playing_row()-editor->get_row_offset());

			print_cursor();
		}


	}

	editor->set_previous_cursor_y(editor->get_cursor_y());
	editor->set_previous_cursor_x(editor->get_cursor_x());
	editor->clear_redraw_flags();
	
}

void Tracker::link_to_editor(Editor *p_editor) {

	editor=p_editor;
	if (font!=NULL) {
		
		editor->set_font_width(font->string_width("X"));
		editor->set_font_height(font->ascent()+font->descent());
		
	}

}
void Tracker::update_info_areas(int p_row_being_played,int p_pattern_being_played) {

	if (!is_drawable()) return;

	bool current_row_marked =editor->is_mark_active() && (p_row_being_played==editor->get_marked_row()) && (editor->get_current_pattern()==editor->get_marked_pattern());
	bool old_row_marked =editor->is_mark_active() && (old_row_to_draw==editor->get_marked_row()) && (editor->get_current_pattern()==editor->get_marked_pattern());

	if (p_pattern_being_played==editor->get_current_pattern()) {
	
		if (old_row_to_draw!=p_row_being_played) {

			print_number(old_row_to_draw-editor->get_row_offset(),false,old_row_marked);
			print_number(p_row_being_played-editor->get_row_offset(),true,current_row_marked);
		}

		old_row_to_draw=p_row_being_played;

	} else {

		print_number(old_row_to_draw-editor->get_row_offset(),false,old_row_marked);
		old_row_to_draw=-1;
	}

	print_osciloscopes();
}

void Tracker::link_to_player(Player_Data *p_player) {
	
        player=p_player;
}

Tracker::Tracker(){

	player=NULL;
	editor=NULL;
	font=NULL;
	
}
Tracker::~Tracker(){
}
