/***************************************************************************
                          interface_widget_sample_import.h  -  description
                             -------------------
    begin                : Sun Apr 15 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_SAMPLE_IMPORT_H
#define INTERFACE_WIDGET_SAMPLE_IMPORT_H


/**
  *@author Juan Linietsky
  */
#include <gtk--/window.h>
#include <gtk--/clist.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/frame.h>
#include <gtk--/pixmap.h>
#include <gtk--/checkbutton.h>
#include <gtk--/button.h>
#include <gtk--/separator.h>
#include <gtk--/box.h>
#include <gtk--/main.h>
#include <unistd.h>


#include "loader.h"
#include "player_rt_keyboard.h"
#include "mixer.h"
#include <gdk/gdkkeysyms.h>

using SigC::bind;

/******************************
 interface_widget_sample_menu.h
 ----------

this popup picks samples from a loaded
but not imported file
********************************/


class Sample_Import : public Gtk::Window {


        Gtk::ScrolledWindow scrolledwindow1;
        Gtk::Frame frame1;
     //   Sample_View sample_view;
        Gtk::Frame sample_viewer;
        Gtk::CheckButton checkbutton_sample_import_create_instruments;
        Gtk::Frame frame2;
        Gtk::Button button_sample_import_ok;
        Gtk::HSeparator hseparator1;
        Gtk::Button button_sample_import_cancel;
        Gtk::HBox hbox1;
        Gtk::VBox vbox1;

	Loader *loader;
        Player_Realtime_Keyboard *keyboard;

       	gint delete_event_impl(GdkEventAny* p_event) {

		action=CANCEL;
		return 1;
	}

        void button_cancel_pressed();
	void button_ok_pressed();

	enum {

		WAITING,
		OK,
		CANCEL
	};

	gint key_press_event_callback(GdkEventKey* event) {

		if (event->keyval==GDK_F8) keyboard->sample_stop_all();

		return 1;
	}

	void on_clist_sample_import_select_row(gint row, gint column, GdkEvent *event);

        int selected_row;
	int action;
	int source_sample_pos;
public:

        Gtk::CList clist_sample_import;

        Sample_Import(Loader *p_loader,Player_Realtime_Keyboard *p_keyboard,int p_source_sample_pos);
        bool do_main_loop(Gtk::Main &p_kit);

        ~Sample_Import();
};

#endif
