/***************************************************************************
                          interface_widget_sample_view.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_SAMPLE_VIEW_H
#define INTERFACE_WIDGET_SAMPLE_VIEW_H

#include <gtk--/widget.h>
#include <gtk--/window.h>

#include "sample_data.h"
#include "mixer.h"
#include "player_data.h"

/**
  *@author Juan Linietsky
  */

/******************************
 interface_widget_sample_view.h
 --------

This widget shows you a sample..
the loop points, places where it's
being played, etc.
********************************/

class Sample_View : public Gtk::Widget {

	enum _Colormap {

                Col_BackGround,
                Col_ForeGround,
                Col_Loop_ForeGround,
                Col_Loop_BackGround,
                Max_Colors
        };


	static int color_values[];

        Gdk_Color colors[Max_Colors];
        Gdk_GC GC[Max_Colors];

	void allocate_colormap ();

	Sample_Data *sample;

	void draw_sample();

        Uint16 get_height_at_pos(int s_position,int p_height_max);
	void recalculate();
        void draw_position(int pos);
	bool need_recalculation;
	bool redraw_all;


	Uint16 *table_max;
	Uint16 *table_min;
	Uint8 *frames_played;
	int table_length;

	int old_width;
	int old_height;
	Mixer *mixer;

public:

       	Gdk_Window window;
        void realize_impl();
        void set_redraw_all() { redraw_all=true;};
	gint do_expose_event(GdkEventExpose* p0);

	void draw_impl(GdkRectangle* p0){

		redraw_all=true;
		draw_sample();
	
	}

	void redraw_update() {

		if (!is_drawable()) return;
		redraw_all=false;
		draw_sample();
	}

	void set_sample(Sample_Data *p_sample) {

		redraw_all=true;
		sample=p_sample;
		need_recalculation=true;
		queue_draw();
	}
	void set_mixer(Mixer *p_mixer) {

		mixer=p_mixer;
		need_recalculation=true;
		queue_draw();
	}

	Sample_View();
	~Sample_View();
};

#endif
