/***************************************************************************
                          mixer_procedure.h  -  description
                             -------------------
    begin                : Tue Apr 17 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIXER_PROCEDURE_H
#define MIXER_PROCEDURE_H

#include  "sample_data.h"
#include <hash_map>

/**Mixer Procedure

  *@author Juan Linietsky
  */
#define FRACBITS 11 // for fixed point precision
#define FRACMASK ((1L<<FRACBITS)-1L)

#define FILTER_BITS 12

/******************************
 mixer_procedure.h
 ----------

A mixer procedure.. usually
the critical section of the tracker.
this gets sample data and pastes it.

It needs functions to proovide click removal

I need to proovide some better
methods for registering samples,
since that is unimplemented yet!
********************************/
#define MIXER_STEP_1_INIT Sint16 data;						\
										\
        	Depth *data_ptr=(Depth*)sample->data_ptr;                       \
        	Precision aux_index,incr;                                       \
        	register Sint32 final_data;                                     \
        	Sint32 vol_l=l_volume,vol_r=r_volume;                         \
        	Sint32 send_l,send_r,rev_send_l,rev_send_r;			\
        	aux_index=sample_index;                                         \
        	incr=increment;                                                 \
        	                                                                \
		hist1=*real_history1;\
		hist2=*real_history2; \
        	Uint16 shift = (sizeof(Depth)==2) ? 0 : 8; \
		rev_send_l=(reverb_send_amount*vol_l) >> 8; \
		rev_send_r=(reverb_send_amount*vol_r) >> 8; \
		send_l=vol_l-rev_send_l;            \
		send_r=vol_r-rev_send_r;            \
        	
        	

#define MIXER_STEP_2_LOOP_BEGIN while(samples_to_mix--) {        	

#define MIXER_STEP_3_CONVERT_TO_16BITS final_data<<=shift;
//smp_in = (smp_in * vi->flt_B0 + fx1 * vi->flt_B1 + fx2 * vi->flt_B2) / FILTER_PRECISION; \
//    fx2 = fx1; fx1 = smp_in;
#define MIXER_STEP_3_BIS_PASS_FILTER if (filter_enabled) { \
								\
		final_data = (final_data * coef1 + hist1 * coef2 + hist2 * coef3) / (1<<FILTER_BITS); 	\
		hist2=hist1;                                                             \
		hist1=final_data; 							\
	}
        	
#define MIXER_STEP_4_MIX_TO_BUFFER_AND_EXIT \
                                                    \
	                                             \
	if (stereo) { \
		*dest++ += send_l * final_data; 				\
		*dest++ += send_r * final_data;                              \
		*reverb_send_buff++ += rev_send_l * final_data; 				\
		*reverb_send_buff++ += rev_send_r * final_data;                              \
	} else if (surround) {                                                  \
		if (vol_l>=vol_r) {                                     \
			*dest++ += send_l*final_data;                          \
			*dest++ -= send_l*final_data;                          \
			*reverb_send_buff++ += rev_send_l*final_data;                          \
			*reverb_send_buff++ -= rev_send_l*final_data;                          \
		} else {                                                        \
			*dest++ -= send_r*final_data;                          \
			*dest++ += send_r*final_data;                          \
			*reverb_send_buff++ -= rev_send_r*final_data;                          \
			*reverb_send_buff++ += rev_send_r*final_data;                          \
		}		                                                \
	} else {                                                                \
		*dest++ += vol_l * final_data;                                \
	}									\
		aux_index+=incr;                                \
    	}							\
sample_index=aux_index;						\
*real_history1=hist1; \
*real_history2=hist2;


	
class Mixer_Procedure {

protected:
	/* Pool of registered samples / versions */


        typedef hash_map <Sample_Data*, int, hash<Sample_Data*> > Registered_Samples;

	Registered_Samples samples;
	
	Sample_Data *sample;
	Sint32* dest;
	Sint64 sample_index;
	Sint64 increment;
	Sint32 samples_to_mix;
	
	Sint32 l_volume;
	Sint32 r_volume;
	Sint32 l_volume_prev;
	Sint32 r_volume_prev;

	Sint32 *reverb_send_buff;
	Sint32 reverb_send_amount; /* 0 - 255 */
	
	
	bool mono;
	bool stereo;
	bool surround;

	bool filter_enabled;
	
	Sint32 coef1,coef2,coef3,hist1,hist2,hist3,*real_history1,*real_history2;
		

	inline Sint16 get_sample();
	
	
public:
	
	virtual string get_name() =0;

	virtual void register_sample(Sample_Data *p_sample) =0;
	virtual void unregister_sample(Sample_Data *p_sample) =0;


	virtual Sint64 mix_mono() =0;
	virtual Sint64 mix_stereo() =0;
	virtual Sint64 mix_surround() =0;

	void set_sample_data (Sample_Data *p_sample);
	void set_dest_buffer (Sint32* p_dest);
	void set_sample_index (Sint64 p_sample_index);
	void set_increment(Sint64 p_increment);
	void set_samples_to_mix(Sint32 p_samples_to_mix);
	void set_l_volume(Sint32 p_l_volume);
	void set_r_volume(Sint32 p_r_volume);
	void set_previous_l_volume(Sint32 p_l_volume_prev);
	void set_previous_t_volume(Sint32 p_r_volume_prev);
	void set_filter(bool p_enabled,Sint32 p_coef1,Sint32 p_coef2,Sint32 p_coef3,Sint32 *p_story1,Sint32 *p_story2,Sint16 p_story3);	
	void set_reverb_send_buffer(Sint32 *p_buffer);
	void set_reverb_send(int p_send);		

	
	Mixer_Procedure();
	virtual ~Mixer_Procedure();

};

#endif
