/***************************************************************************
                          mixer_software.h  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIXER_SOFTWARE_H
#define MIXER_SOFTWARE_H


#include <vector>

#include "player_data.h"
#include "sample_data.h"
#include "mixer.h"
#include "mixer_procedure.h"

#define BITSHIFT 9


#include "revmodel.h" //freeverberer!


#define TICKLSIZE 8192 // internal mixing buffer size
#define TICKWSIZE (TICKLSIZE<<1)
#define TICKBSIZE (TICKWSIZE<<1)

#define CLICK_SHIFT  6
#define CLICK_BUFFER (1L<<CLICK_SHIFT)

#ifndef MIN
#define MIN(a,b) (((a)<(b)) ? (a) : (b))
#endif

#define DEFAULT_VIRTUAL_CHANNELS 256

#define NATIVE Sint32

/**
  *@author Juan Linietsky
  */

/******************************
 mixer_software.h
 ----------

Software version of the mixer..
and the only one aviable for now! :D
********************************/

class Mixer_Software : public Mixer {

	Player_Data * player_data;

	struct VC_Info {

		//bool kick;              /* =1 -> sample has to be restarted */
		bool needs_restart;
		bool active;            /* =1 -> sample is playing */
		//UWORD     flags;             /* 16/8 bits looping/one-shot */

                Sample_Data *sample_data_ptr;
		
		bool playing_backwards;

		Uint32 start_index;             /* start index */
		Uint32 current_frequency;  //frq;               /* current frequency */

		int volume;               /* current volume */
		int panning;               /* current panning position */
	
		int rampvol;
		int lvolsel,rvolsel;   /* Volume factor in range 0-255 */
		int oldlvol,oldrvol;

		Sint64 current_index;           /* current index in the sample */
		Sint64 increment_index;         /* increment value */
		
		Uint16 reverb_send;

		//filter
		Sint32 filter_coef1,filter_coef2,filter_coef3;
		Sint32 filter_history1,filter_history2,filter_history3;
		
		bool filter_enabled;
		
		void clear() {

			needs_restart=active=playing_backwards=false;
			start_index=current_frequency=0;
			reverb_send=volume=panning=rampvol=lvolsel=rvolsel=oldlvol=oldrvol=0;
			current_index=increment_index=0;
                        sample_data_ptr=NULL;
                        filter_enabled=false;

		}

		void restart() {

			playing_backwards=false;
			current_index=((Sint64)start_index)<<FRACBITS;
			needs_restart=false;
			active=true;
		}
	
		VC_Info() {

			clear();
                        filter_history1=0; filter_history2=0;
		}
	};


	/* Mixing Properties */

	int mix_frequency;
	bool mix_interpolated;
	bool mix_surround;
 	bool mix_stereo;
	bool mix_16bits;
	int mix_channels;
	
	/* Mixing Memory */
        revmodel reverb; //freeberb object
        bool do_reverb;

	Uint32 current_tick_size; // gets set to the size tick's block size in samples
	Sint32 *internal_mixing_buffer; // buffer for internal 32bits precission mixing
	Sint32 *reverb_send_buffer; // buffer for internal 32bits precission mixing

	
	float *reverb_in_l;
	float *reverb_in_r;
	float *reverb_out_l;
	float *reverb_out_r;
	

	void do_freeverb(Sint32 *p_buff,Sint32 *p_reverb_in, int p_length);
	
	long real_mixing_buffer_size; // mixing buffer size in bytes
        long mixing_buffer_size;

	Sint64 idxsize,idxlpos,idxlend; // index size/begin/end for fast loop/pos check

	void Mix32To16(Sint16* dste,Sint32* srce,NATIVE count);
	void Mix32To8(Sint8* dste,Sint32* srce,NATIVE count);
	void add_channel_to_mix_buffer(VC_Info *vchannel,NATIVE todo);

	Uint32 samples2bytes(Uint32 samples);
	Uint32 bytes2samples(Uint32 bytes);
	void write_samples(Sint8* p_dest_buf,Uint32 p_todo);

	VC_Info **channel;

	typedef vector<Mixer_Procedure*> MixerProcs_List;

	MixerProcs_List mixerprocs_list;

	Mixer_Procedure* curent_mixer_procedure;

public:
 	void request_player_data() {
	
		player_data->link_to_mixer(this);	
	}

	/* Mixer Procedures */
	void register_mixer_procedure(Mixer_Procedure* p_mixer_proc);
	int get_amount_of_mixer_procedures();
	string get_mixer_procedure_name(int p_mixer_proc_index);
	void set_mixer_procedure_in_use(int p_mixer_proc_index);
	int get_mixer_procedure_in_use();


	Uint32 write_bytes(Sint8* buf,Uint32 todo);

        void link_player_data(Player_Data *p_player_data);

	/* External Control (player/program)*/
	void setup_voice(int p_voice_index,Sample_Data *p_sample_data,Sint32 p_start_index);
	void stop_voice(int p_voice_index);
	void set_voice_frequency(int p_voice_index,Uint32 p_freq);
	void set_voice_panning(int p_voice_index,int p_pan);
	void set_voice_volume(int p_voice_index,int p_vol);
	void set_number_of_channels(int p_numb_channels);
	void set_voice_filter(int p_voice_index,Sint32 p_coef1, Sint32 p_coef2,Sint32 p_coef3,bool p_enabled);
        void set_voice_vibrato(int p_voice_index,int p_speed,int p_depth) {};
        void set_voice_reverb_send(int p_voice_index,int p_reverb); /* 0 - 255 */
	/* External Control (sound driver)*/
	void set_mix_frequency(int p_mix_frequency) {mix_frequency=p_mix_frequency; };
        void set_mix_stereo(bool p_mix_stereo);
        void set_mix_16bits(bool p_mix_16bits);
	
	/* Info retrieving */

	int get_voice_panning_pos(int p_voice_index);
	int get_voice_volume(int p_voice_index);
	Sint32 get_voice_sample_pos_index(int p_voice_index);
	Sample_Data *get_voice_sample_data_ptr(int p_voice_index);
	bool is_voice_stopped(int p_voice_index);
	int get_number_of_channels();
       	int get_mix_frequency() { return mix_frequency; }
	// returns the index of the empty channel -1 if didnt find any

        void set_reverb_enabled(bool p_enabled);
        bool is_reverb_enabled();
        void set_reverb_params(char p_room_size, char p_damp, char p_wet, char p_dry, char p_width);

	bool is_song_playing();
	bool has_song_finished();
	
	Mixer_Software();
	~Mixer_Software();
};


#endif
