/***************************************************************************
                          sample.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sample.h"

Sample::Sample(){

	reset(false);
}
Sample::~Sample(){
}

void Sample::reset(bool try_to_free_data=true) {

	name="";
	filename="";

	def_volume=64;
	glb_volume=64;

	def_panning_on=false;
	def_panning=32;

	vibrato_type=0;
	vibrato_speed=0;
	vibrato_depth=0;
	vibrato_rate=0;

	data.loop_on=false;

	data.pingpong_loop=false;
	data.sustain_loop_on=false;

	data.loop_begin=0;
	data.loop_end=5;

	data.sustain_loop_begin=0;
	data.sustain_loop_end=5;

	data.is_16bits=false;

       	data.finetune=0;
	data.note_offset=0;

	data.size=0; // in samples, not bytes.
	if (in_use && try_to_free_data) free(data.data_ptr);
	data.data_ptr=NULL; //this is superimportant, so the player wont crash	
	
	in_use=false;


}

void Sample::operator=(Sample r_sample) {

	name=r_sample.name;
	filename=r_sample.filename;

	def_volume=r_sample.def_volume;
	glb_volume=r_sample.glb_volume;

	def_panning_on=r_sample.def_panning_on;
	def_panning=r_sample.def_panning;

	vibrato_type=r_sample.vibrato_type;
	vibrato_speed=r_sample.vibrato_speed;
	vibrato_depth=r_sample.vibrato_depth;
	vibrato_rate=r_sample.vibrato_rate;
	
	if ((in_use) && (data.data_ptr!=NULL)) {

		free(data.data_ptr);
	}

	data=r_sample.data;
	in_use=r_sample.in_use;


	if ((in_use) && (data.data_ptr!=NULL)) {

		int size=data.is_16bits?data.size*2:data.size;
		(void*)data.data_ptr=malloc(size);
		memcpy(data.data_ptr,r_sample.data.data_ptr,size);
	}
}
	

