// Sound_Driver_Win32.cpp: implementation of the Sound_Driver_Win32 class.
//
////////////////////////////ll//////////////////////////////////////////
#include "sound_driver_win32.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


#ifdef __WIN32__
LPDIRECTSOUND g_lpDS;

Sound_Driver_Win32::Sound_Driver_Win32()
{

	//  DESCRIPTION 겱

	// This initializes Direct Sound if it isn't already initialized.  If
	// this routine fails it returns TRUE, or FALSE if succeeded.

	//  LOCAL VARIABLES 겱

	HRESULT DSReturnValue;
	HWND hWnd;
	g_lpDS=NULL;;		// DirectSound object
	//  CODE 겱

	

	DSReturnValue = DirectSoundCreate (
		NULL,
		&g_lpDS,
		NULL
		);

	if ( DSReturnValue != DS_OK ) {

	    g_lpDS = NULL;
	    return;
	}

	hWnd = GetForegroundWindow();

	if ( hWnd == NULL ) {

	    hWnd = GetDesktopWindow();
	}

	DSReturnValue = g_lpDS->SetCooperativeLevel (
		hWnd,
		DSSCL_PRIORITY
		);

	if ( DSReturnValue != DS_OK ) {

	    g_lpDS->Release ();
	    
	}




	g_PrimaryBuffer=NULL;
	g_SecondaryBuffer=NULL;
	g_SoundNotify=NULL;
        g_SoundThread=FALSE;
	driver_ready = false;
	
	
}

Sound_Driver_Win32::~Sound_Driver_Win32()
{

}

int Sound_Driver_Win32::init() {

// DESCRIPTION


	// LOCAL VARIABLES

/* typedef struct waveformat_extended_tag {

    WORD  wFormatTag;
    WORD  nChannels;
    DWORD nSamplesPerSec;
    DWORD nAvgBytesPerSec;
    WORD  nBlockAlign;
    WORD  wBitsPerSample;
    WORD  cbSize;
} WAVEFORMATEX;
*/
	HRESULT DSReturnValue;
	
	static WAVEFORMATEX DesiredWaveFormat = {
		WAVE_FORMAT_PCM,
		(mix_stereo?2:1),
		mix_frequency,
		mix_frequency * (mix_stereo?4:2),
		(mix_stereo?4:2),
		(mix_16bits?16:8),
		0
	};
	
	static WAVEFORMATEX WaveFormat;
	DSBUFFERDESC BufferDesc;


	Uint8 * Buffer1;	// First part of circular buffer when locking
	Uint32 Buffer1Size;
	Uint8 * Buffer2;	// Second part of circular buffer when locking
	Uint32 Buffer2Size;

	DSBPOSITIONNOTIFY NotifyPositions[2];

	//  CODE 겱


	//  Create primary sound buffer and set its desired format. 

	memset(&BufferDesc,0, sizeof ( BufferDesc ));
	
	BufferDesc.dwSize = sizeof ( BufferDesc );
	BufferDesc.dwFlags = DSBCAPS_PRIMARYBUFFER;

	DSReturnValue = g_lpDS->CreateSoundBuffer (
		
		&BufferDesc,
		&g_PrimaryBuffer,
		NULL
		);

	if ( DSReturnValue != DS_OK ) {

	    ERROR( "Cannot create primary sound buffer.");
	    finish();
	    goto Failure;
	}

	g_PrimaryBuffer->SetFormat (
		
		&DesiredWaveFormat
		);

	//  Get the actual format of the primary buffer. 

	g_PrimaryBuffer->GetFormat (
		
		&WaveFormat,
		sizeof ( WaveFormat ),
		NULL
		);

	mix_frequency = WaveFormat.nSamplesPerSec;
	mix_16bits = (WaveFormat.wBitsPerSample==16);
	mix_stereo = (WaveFormat.nChannels==2);


	//  Determine size of secondary buffer and create it. 

	// Get amount of samples in SOUNDBLOCKSIZE milliseconds

	g_SecondaryBufferSize = mix_frequency;
	g_SecondaryBufferSize *= SOUNDBLOCKSIZE;
	g_SecondaryBufferSize /= 1000;

	// Round the samples up to be divisible by 2

	g_SecondaryBufferSize += ( g_SecondaryBufferSize & 1 );

	// Convert samples to bytes

	g_SecondaryBufferSize *= WaveFormat.nChannels;
	g_SecondaryBufferSize *= mix_16bits?2:1;

	// Create secondary buffer


	memset(&BufferDesc,0, sizeof ( BufferDesc ));
		
	BufferDesc.dwSize = sizeof ( BufferDesc );
	BufferDesc.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_CTRLPOSITIONNOTIFY;
	BufferDesc.dwBufferBytes = g_SecondaryBufferSize;
	BufferDesc.lpwfxFormat = &WaveFormat;

	DSReturnValue = g_lpDS->CreateSoundBuffer (

		&BufferDesc,
		&g_SecondaryBuffer,
		NULL
		);

	if ( DSReturnValue != DS_OK ) {

	    ERROR( "Cannot create secondary sound buffer.");
	    finish();
	    goto Failure;
	}


	//  Determine minimum size to mix. 

	// Get amount of samples in MINMIXSIZE milliseconds

	g_MinimumMixBytes = mix_frequency;
	g_MinimumMixBytes *= MINMIXSIZE;
	g_MinimumMixBytes /= 1000;

	// Convert samples to bytes

	g_MinimumMixBytes *= WaveFormat.nChannels;
	g_MinimumMixBytes *= (mix_16bits?2:1);


	//  Create sound thread and notification event. 

	

	//  Fill the secondary buffer with zeros and play it. 

	DSReturnValue = g_SecondaryBuffer->Lock (
		
		0,
		g_SecondaryBufferSize,
		(void**)&Buffer1,
		(DWORD*)&Buffer1Size,
		(void**)&Buffer2,
		(DWORD*)&Buffer2Size,
		DSBLOCK_ENTIREBUFFER
		);

	if ( DSReturnValue == DSERR_BUFFERLOST ) {

	    DSReturnValue = g_SecondaryBuffer->Restore (
		    
		    );

	    if ( DSReturnValue != DS_OK ) {

		finish();
		ERROR ( "Can't lock secondary buffer.");
		goto Failure;
	    }

	    DSReturnValue = g_SecondaryBuffer->Lock (
		    
		    0,
		    g_SecondaryBufferSize,
		    (void**)&Buffer1,
		   (DWORD*) &Buffer1Size,
		    (void**)&Buffer2,
		   (DWORD*) &Buffer2Size,
		    DSBLOCK_ENTIREBUFFER
		    );

	}

	if ( DSReturnValue != DS_OK ) {

	    finish();
	    ERROR("Can't lock secondary buffer.");
	    goto Failure;
	}

	if ( Buffer1 ) {

	    memset (
		    Buffer1,
		    0,
		    Buffer1Size
		    );
	}

	if ( Buffer2 ) {

	    memset (
		    Buffer1,
		    0,
		    Buffer1Size
		    );
	}

	g_SecondaryBuffer->Unlock (
		
		Buffer1,
		Buffer1Size,
		Buffer2,
		Buffer2Size
		);

	g_WritePosition = 0;

	DSReturnValue = g_SecondaryBuffer->Play (
		
		0,
		0,
		DSBPLAY_LOOPING
		);

	if ( DSReturnValue == DSERR_BUFFERLOST ) {

	    DSReturnValue = g_SecondaryBuffer->Restore (
		    
		    );

	    if ( DSReturnValue != DS_OK ) {

		finish();
		ERROR( "Can't play secondary buffer.");
		goto Failure;
	    }

	    DSReturnValue = g_SecondaryBuffer->Play (
		 
		    0,
		    0,
		    DSBPLAY_LOOPING
		    );
	}

	if ( DSReturnValue != DS_OK ) {

	    finish();
	    ERROR( "Can't play secondary buffer.");
	    goto Failure;
	}

	driver_ready=true;

	return FALSE;

	Failure:




	return FALSE;
}



bool Sound_Driver_Win32::is_active() {

	return driver_ready;
}

bool Sound_Driver_Win32::finish() {

	driver_ready=false;

	if ( g_SecondaryBuffer ) {

	    g_SecondaryBuffer->Stop (
		    
		    );
	}

	if ( g_SecondaryBufferNotify ) {

	    g_SecondaryBufferNotify->Release (
		    
		    );
	    g_SecondaryBufferNotify = NULL;
	}

	if ( g_SecondaryBuffer ) {

	    g_SecondaryBuffer->Release (

		    );
	    g_SecondaryBuffer = NULL;
	}

	if ( g_PrimaryBuffer ) {

	    g_PrimaryBuffer->Release ( );
	    g_PrimaryBuffer = NULL;
	}

	if ( g_SoundThread ) {

	    g_SoundThreadExit = TRUE;
	    SetEvent ( g_SoundNotify );

	} else {

	    if ( g_SoundNotify ) {

		CloseHandle ( g_SoundNotify );
		g_SoundNotify = NULL;
	    }
	}



}

bool Sound_Driver_Win32::update() {

	HRESULT DSReturnValue;
	Uint32 PlayCursor;
	Uint32 WriteBytes;
	Uint32 Count;

	Uint8 * Buffer1;	// First part of circular buffer when locking
	Uint32 Buffer1Size;
	Uint8 * Buffer2;	// Second part of circular buffer when locking
	Uint32 Buffer2Size;

	static Uint8 Reentrant;       // Nonzero if in progress

	//  CODE 겱

	Reentrant++;

	if ( Reentrant > 1 ) { Reentrant--; return false; }

	// Find out how many more bytes to mix

	if ( g_SecondaryBuffer == NULL ) {

	    Reentrant--;
	    return false;
	}

	DSReturnValue = g_SecondaryBuffer->GetCurrentPosition (

		(DWORD*)&PlayCursor,
		NULL
		);

	if ( DSReturnValue == DSERR_BUFFERLOST ) {

	    DSReturnValue = g_SecondaryBuffer->Restore (

		    );

	    if ( DSReturnValue != DS_OK ) {

		ERROR ( "Can't get position of secondary buffer in UpdateSoundBuffer.");
		Reentrant--;
		return false;
	    }

	    DSReturnValue = g_SecondaryBuffer->GetCurrentPosition (

		    (DWORD*)&PlayCursor,
		    NULL
		    );

	}

	if ( DSReturnValue != DS_OK ) {

	    ERROR ( "Can't get position of secondary buffer in UpdateSoundBuffer.");
	    Reentrant--;
	    return false;
	}


	if ( PlayCursor < g_WritePosition ) {

	    PlayCursor += g_SecondaryBufferSize;
	}

	WriteBytes = PlayCursor - g_WritePosition;

	for ( Count = 2 ; Count ; Count-- ) {

	    if ( WriteBytes < g_MinimumMixBytes ) {

		Reentrant--;
		return false;
	    }

	    DSReturnValue = g_SecondaryBuffer->Lock (

		    g_WritePosition,
		    WriteBytes,
		    (void**)&Buffer1,
		    (DWORD*)&Buffer1Size,
		    (void**)&Buffer2,
		    (DWORD*)&Buffer2Size,
		    0
		    );

	    if ( DSReturnValue == DSERR_BUFFERLOST ) {

		DSReturnValue = g_SecondaryBuffer->Restore (
			
			);

		if ( DSReturnValue != DS_OK ) {

		    ERROR ( "Can't lock secondary buffer in UpdateSoundBuffer.");
		    Reentrant--;
		    return false;
		}

		DSReturnValue = g_SecondaryBuffer->Lock (

			g_WritePosition,
			WriteBytes,
			(void**)&Buffer1,
			(DWORD*)&Buffer1Size,
			(void**)&Buffer2,
			(DWORD*)&Buffer2Size,
			0
			);
	    }

	    if ( DSReturnValue != DS_OK ) {

		WriteBytes *= 181;	// Try again with the buffer .5^.5
		WriteBytes >>= 8;	// times the size.
		WriteBytes &= ~3;	// Make sure it is aligned on sample
					// boundary
		ERROR ( "Can't lock, trying again");
		continue;
	    }

	    if ( Buffer1 ) {

	
	    	mixer->write_bytes((void*)Buffer1,Buffer1Size); 	

	    }

	    if ( Buffer2 ) {

	    	mixer->write_bytes((void*)Buffer2,Buffer2Size); 	
	

	    }

	    g_WritePosition += WriteBytes;
	    g_WritePosition %= g_SecondaryBufferSize;

	    g_SecondaryBuffer->Unlock (

		    Buffer1,
		    Buffer1Size,
		    Buffer2,
		    Buffer2Size
		    );

	    Reentrant--;
	    return true;

	}

	ERROR ("Couldn't lock.");

	Reentrant--;

}

void Sound_Driver_Win32::request_mix_frequency(int p_mix_frequency)

{
	mix_frequency=p_mix_frequency;
}


void Sound_Driver_Win32::request_mix_stereo(bool p_mix_stereo)
{
	mix_stereo=p_mix_stereo;
}


void Sound_Driver_Win32::request_mix_16bits(bool p_mix_16bits)
{
	mix_16bits=p_mix_16bits;
}

void Sound_Driver_Win32::request_buffer_size(int p_buffsize)
{
	mix_buffersize=p_buffsize;
}

int Sound_Driver_Win32::get_mix_frequency()
{
	return mix_frequency;
}

bool Sound_Driver_Win32::get_mix_stereo()
{
	return mix_stereo;
}

bool Sound_Driver_Win32::get_mix_16bits()
{
	return mix_16bits;
}

int Sound_Driver_Win32::get_mix_buffer_size()
{
	return mix_buffersize;
}


#endif