/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_envelope.h  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_ENVELOPE_H
#define INTERFACE_WIDGET_ENVELOPE_H

#include <gtkmm/drawingarea.h>
#include "components/audio/envelope.h"
#include <pangomm/font.h>
//#include "player_data.h"

/**
  *@author Juan Linietsky
  */

/******************************
 interface_widget_envelope.h
 ----------

This is a widget for editing envelopes!
********************************/


class Envelope_Editor : public Gtk::DrawingArea {

	enum _Colormap {

                Col_BackGround,
                Col_ForeGround,
                Col_Loop_ForeGround,
                Col_Loop_BackGround,
                Col_SusLoop_ForeGround,
                Col_SusLoop_BackGround,
                Col_Metric,
                Col_MetricHi,
                Col_Soft,
                Max_Colors
        };

       	void init_colors();
	static int color_values[];

        Gdk::Color colors[Max_Colors];
        Glib::RefPtr<Gdk::GC> GC[Max_Colors];
        

	void allocate_colormap ();

	Envelope *envelope;
//	Player_Data *player;

	void draw_envelope();

        Sint16 get_height_at_pos(int e_position,int p_height_max);
	void recalculate();
        void draw_position(int pos);
	void draw_points();
	bool need_recalculation;
	bool redraw_all;


        int get_point_x(int p_node);
	int get_point_y(int p_node);
	int get_envelope_pos_x(int p_posx);
	int get_envelope_pos_y(int p_posy);

	Uint8 *frames_played;
	int table_length;

        int zoom_amount;

	int old_width;
	int old_height;

	bool grabbing_point;
	bool zooming;
	int zoom_original;
	int grab_point_number;
	int grab_x,grab_y;

	int bottom_height;
    //    Glib::RefPtr<Pango::Font> font;
	int font_height;
public:

        void attempt_node_grab(int p_node_x,int p_node_y);

	bool do_expose_event(GdkEventExpose* p0);

	void draw_impl(GdkRectangle* p0){

		redraw_all=true;
		draw_envelope();
	
	}

	SigC::Signal0<void> changed;
	
	void redraw_update() {

		if (!is_drawable()) return;
		redraw_all=false;
		draw_envelope();
	}


	void set_envelope(Envelope *p_envelope) {

		if (p_envelope!=envelope) grab_point_number=-1;
		redraw_all=true;
		envelope=p_envelope;
		need_recalculation=true;
		queue_draw();
	}

/*	
	void set_player(Player_Data *p_player) {

		redraw_all=true;
		player=p_player;
	}
*/
	void set_redraw_all() { redraw_all=true; }

	void start_zoom(int x, int y);
	void delete_selected_node();

//	gint button_press_event_impl(GdkEventButton* event);
	gint button_release_event_impl(GdkEventButton* event);
	gint enter_notify_event_impl(GdkEventCrossing* event);
	gint leave_notify_event_impl(GdkEventCrossing* event);
	gint motion_notify_event_impl(GdkEventMotion* event);

	Envelope_Editor();
	~Envelope_Editor();
};
#endif
