/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _COLUMNED_LIST_H_
#define _COLUMNED_LIST_H_

#include <gtkmm/box.h>
#include <gtkmm/treeview.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/liststore.h>
#include <gtkmm/treeview.h>
#include <gtkmm/frame.h>
#include <gtkmm/box.h>
#include <gtkmm/entry.h>
/**
 * 
 * Juan Linietsky
 **/
class Columned_List : public Gtk::Frame {

	
	Columned_List();
	
	void tree_selection_changed_callback();
		
public:
	class Base_Model_Column : public Gtk::TreeModel::ColumnRecord {
	
		public:

		Base_Model_Column()
		{ add(column_internal_index); }

		Gtk::TreeModelColumn<unsigned int> column_internal_index; //hidden column
	};

	SigC::Signal1<void,int> row_selected;

	Gtk::Label label;
	Gtk::VBox vbox;
	Gtk::HBox hbox;
	Gtk::Entry entry;

	Base_Model_Column * base_tree_model;
	
	Gtk::TreeView tree_view;
	Gtk::ScrolledWindow tree_scroll;
	Glib::RefPtr<Gtk::ListStore> tree_model_ref;
	Glib::RefPtr<Gtk::TreeSelection> tree_selection;
		


	Columned_List(Base_Model_Column *p_columnrecord);
	~Columned_List();
};

#endif
