/* GNU Chess 5.0 - book.c - book code
   Copyright (c) 1999 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

#include <stdio.h>
#include <stdlib.h>
#ifdef NEVER
#ifdef UNIX
#include <sys/types.h>
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif
#include "common.h"
#include "book.h"
#ifdef UNIX
#include <unistd.h>
#endif

#define vcol(c) (c>='a' && c<='h')
#define vpiece(p) (p=='N'||p=='B'||p=='R'||p=='Q'||p=='K')

#define MAXMOVES 200
#define MAXLINE 512
#define MAXVAR 10
#define MAXBOOK 5000
#define MAXMATCH 100
#define MAXPEEK 10
			   
static int bookcnt, bigbookcnt = 0, variations = 0, bigvariations = 0;
static int lastbookcnt;
static  char linebuf[MAXVAR][MAXLINE];  
static  char smallbuf[MAXLINE/2];
HashType posshash[MAXMOVES];
struct hashtype {
  int score;
  HashType key;
} bookpos[MAXBOOK];

int compare(leaf *, leaf *);
int compare(a, b)
leaf *a;
leaf *b;
{
    if (b->score > a->score) return(1);
    else if (b->score < a->score) return(-1);
    else return(0);
}

int bookmove()
{
  int i,j,k,icnt = 0, mcnt, found;
  int matches[MAXMATCH], best = 0;
  short bestsofar;
  leaf m[MAXMOVES];
  leaf pref[MAXMOVES];
  FILE *rfp;
  leaf *p;
  short side,xside,temp;

  bestsofar = 0;
  mcnt = -1;
  side = board.side;
  xside = 1^side;
  rfp = fopen(BOOKBIN,"r+b");
  if (rfp == NULL) {
    if (!(flags & XBOARD))
      fprintf(ofp," no book (%s).\n",BOOKBIN);
    return(0);
  }
  if (flags & XBOARD)
    if (!(flags & XBOARD))
      if (rfp != NULL)
        fprintf(ofp,", found book (%s).\n",BOOKBIN);
  /* GenCnt = 0; */
  TreePtr[2] = TreePtr[1];
  GenMoves(1);
  FilterIllegalMoves (1);
  for (p = TreePtr[1]; p < TreePtr[2]; p++) {
    MakeMove(side, &p->move);
    m[icnt].move = p->move;
    posshash[icnt] = HashKey;
    icnt++;
    UnmakeMove(xside,&p->move);
  }
  bigbookcnt = 0;
  if (!(flags & XBOARD))
    fprintf(ofp,"Read opening book (%s)... ",BOOKBIN);
  fseek(rfp,0L,SEEK_SET);
  for(;;) {
    bookcnt = fread(&bookpos,sizeof(struct hashtype),MAXBOOK,rfp);
    if (bookcnt == 0) {
      if (feof(rfp)) {
	break;
      }
      break;
    }
    bigbookcnt += bookcnt;
    for (j = 0; j < bookcnt; j++) {
      for (i = 0; i < icnt; i++) {
	if (bookpos[j].key == posshash[i]) {
	  found = 0;
	  for (k = 0; k < mcnt; k++) 
	      if (matches[k] == i) {
	        found = 1;
	        break;
	      }
	  if (!found) {
	      matches[++mcnt] = i;
	      pref[mcnt].move = m[matches[mcnt]].move;
	      pref[mcnt].score = m[i].score = -bookpos[j].score;
	  }
	  if (mcnt >= MAXMATCH) {
	      fprintf(ofp,"Too many matches in book.\n");
	      goto fini;
	  }
	}
      }
    }
  }
fini:  
  fclose(rfp); 
  if (!(flags & XBOARD))
  {
    fprintf(ofp,"Opening database: %d book positions.\n",bigbookcnt);
    fprintf(ofp,"In this position, %d move%c %s book moves%c\n\n",
	mcnt+1,mcnt+1!=1?'s':(char)NULL,mcnt+1!=1?"are":"is",mcnt+1>0?':':'.');
  }
  if (mcnt == -1) {return(0); }
  k = 0;
  if (bookmode == BOOKPREFER) best = -INFINITY;
  if (mcnt+1 == 1) {
    if (!(flags & XBOARD)) {
      SANMove(m[matches[0]].move,1);
      fprintf(ofp,"%s(%d)\n",SANmv,m[matches[0]].score);
    }
    RootPV = m[matches[0]].move;
  }
  if (mcnt+1 != 1) {
    if (bookmode != BOOKPREFER && !(flags & XBOARD)) {
      for (i = 0; i <= mcnt; i++) {
	if (!(flags & XBOARD)) {
	  SANMove(m[matches[i]].move,1);
	  fprintf(ofp,"%s(%d) ",SANmv,m[matches[i]].score);
          if ((i+1) % 8 == 0) fputc('\n',ofp);
	}
      }
      if (!(flags & XBOARD))
        if ((i+1) % 8 != 0) fprintf(ofp,"\n\n");
    }
    if (bookmode == BOOKRAND) {
      k = rand() % mcnt;
      RootPV = m[matches[k]].move;
/*
      if (!(flags & XBOARD))
        printf("\n(Random picked move #%d %s%s from above list)\n",k,
	  square_n[FROMSQ(RootPV)],square_n[TOSQ(RootPV)]);
*/
    } else if (bookmode == BOOKBEST) {
      temp = (bookfirstlast > mcnt ? mcnt : bookfirstlast);
      k = rand() % temp;
      RootPV = m[matches[k]].move;
    } else if (bookmode == BOOKWORST) {
      temp = (bookfirstlast > mcnt ? mcnt : bookfirstlast);
      k = rand() % temp;
      RootPV = m[matches[k]].move;
    } else if (bookmode == BOOKPREFER) {
      qsort(&pref,mcnt+1,sizeof(leaf),compare);
      for (i = 0; i <= mcnt; i++) {
	if (!(flags & XBOARD)) {
	  SANMove(pref[i].move,1);
          printf("%s(%d) ",SANmv,pref[i].score);
	}
	m[i].move = pref[i].move;
	if (!(flags & XBOARD)) 
          if ((i+1) % 8 == 0) fputc('\n',ofp);
      }
      if (!(flags & XBOARD))
	if (i % 8 != 0) fprintf(ofp,"\n\n");
#ifdef NEVER
      if (GameCnt == -1)
	temp = 2;
      else if (GameCnt == 0)
	temp = 1;
      else
#endif
        temp = (bookfirstlast > mcnt ? mcnt : bookfirstlast);
      k = rand() % temp;
      RootPV = m[k].move;
    }
  }
  return(1);
}

int genbook(void);
int genbook()
{
  int i,j;
  short found, epsilon;
  int curvar = 0;
  char *pp, *qq;
  leaf *ptr;
  FILE *wfp,*rfp;

  printf("Trying to generate book %s from %s...\n",BOOKBIN,BOOKSRC);
  if ((wfp = fopen(BOOKBIN,"w+b"))==NULL) {
      printf("Couldn't open the bin book (%s) for write.\n",BOOKBIN);
      return(0);
  }
  if ((rfp = fopen(BOOKSRC,"r"))==NULL) {
	  printf("Couldn't open the pgn book (%s) for read.\n",BOOKSRC);
	  fclose(wfp);
	  return(0);
  }
  InitVars();
  NewPosition();
  CalcHashKey();
  /*  read_settings(SET_RUN); */
  bookcnt = 0;
  while (fgets(linebuf[curvar],MAXLINE,rfp) != NULL) {
    if (linebuf[curvar][0] == '#') continue;
    if (linebuf[curvar][0] == '[') {  
      for (i = 0; i < curvar; i++) {     
	pp = linebuf[i]; qq = smallbuf;
	while (*pp != '\0') {
	  for (;;) {
	    if (*pp == '\n' || *pp == '\r' || *pp == ' ' || *pp == '\t') {
	      pp++;
	      if (qq != smallbuf) break;
	    } else if (*pp == '.' || *pp == ';') {
	      *qq++ = *pp++;
	      if (qq != smallbuf) break;
	    } else if (*pp == '\0')
	      break;
	    else *qq++ = *pp++;
	  }
	  *qq = '\0';
	  if (strlen(smallbuf)>0 && strlen(smallbuf)<8&&
	      (vpiece(smallbuf[0])||smallbuf[0]=='o'||smallbuf[0]=='O'||
	       vcol(smallbuf[0]))) {
	    /* GenCnt = 0; */
	    TreePtr[2] = TreePtr[1];
	    GenMoves(1);
  	    FilterIllegalMoves (1);
	    ptr = ValidateMove(smallbuf);
	    epsilon = 0;
	    if (smallbuf[strlen(smallbuf)-1] == '?') {
		epsilon = -50;
	    } else if (smallbuf[strlen(smallbuf)-1] == '!') {
		epsilon = 50;
	    }
	    if (ptr != NULL) {
	      MakeMove(board.side,&ptr->move);
	      if (bookcnt >= MAXBOOK) {
		fwrite(&bookpos,sizeof(struct hashtype),bookcnt,wfp);
		bigbookcnt += bookcnt;
		bigvariations += variations;
		printf("Wrote %d moves, %d variations - total: %d / %d\n",
		       bookcnt,variations,bigbookcnt,bigvariations);
		variations = 0;
		bookcnt = 0;   
		curvar = 0;     
		found = 0;
		/* Did we already score? If so, then skip it */
	  	for (j = 0; j < bookcnt; j++)
		  if (bookpos[j].key == HashKey) {
		    found = 1;
		    break;
		  }
		if (!found) { 
		  bookpos[bookcnt].key = HashKey;
	          bookpos[bookcnt].score = BookSearch() + epsilon;
		  bookcnt++;
		}
		break;
	      } else if (bookcnt % MAXPEEK == 0 && bookcnt != lastbookcnt) {
		printf("Buffer/OnDisk: %d->%d positions, %d->%d variations\r",
			bookcnt,bigbookcnt,variations,bigvariations);
		lastbookcnt = bookcnt;
		fflush(stdout);
	      }
	      /* Did we already score? If so, then skip it */
	      found = 0;
	      for (j = 0; j < bookcnt; j++)
		if (bookpos[j].key == HashKey) {
		  found = 1;
		  break;
		}
	      if (!found) { 
		bookpos[bookcnt].key = HashKey;
		bookpos[bookcnt].score = BookSearch() + epsilon;
		bookcnt++;
	      }
	    } else {                                            
	      printf("Error in variation %d (%s)                            \n",
		     bigvariations, smallbuf);
	      break;
	    }
	  }
	  qq = smallbuf;
	}
      } 
      variations++;
      InitVars();
      NewPosition();
      CalcHashKey();
      curvar = 0;
    } else curvar++;
  }
  printf("bookcnt = %d\n",bookcnt);
  if (bookcnt < MAXBOOK) {
    fwrite(&bookpos,sizeof(struct hashtype),bookcnt,wfp);
    bigbookcnt += bookcnt;
    bigvariations += variations;
  }
  fclose(rfp); fclose(wfp);  
  printf("total of %d variations\n",bigvariations); 
  printf("total of %d positions\n",bigbookcnt-1);
  printf("\007\007\007\007\007\007\007\007\007");
  return(1);
}

int BookSearch(void);
int BookSearch()
{
  return(Quiesce(1,-INFINITY,INFINITY));
}

