;;;; std-highlevel-macros.scm


;;; macro-defs.ss
;;; Robert Hieb & Kent Dybvig
;;; 92/06/18

(define-syntax with-syntax
   (lambda (x)
      (syntax-case x ()
         ((_ () e1 e2 ...)
          (syntax (begin e1 e2 ...)))
         ((_ ((out in)) e1 e2 ...)
          (syntax (syntax-case in () (out (begin e1 e2 ...)))))
         ((_ ((out in) ...) e1 e2 ...)
          (syntax (syntax-case (list in ...) ()
                     ((out ...) (begin e1 e2 ...))))))))

(define-syntax syntax-rules
   (lambda (x)
      (syntax-case x ()
         ((_ (k ...) ((keyword . pattern) template) ...)
          (with-syntax (((dummy ...)
                         (generate-temporaries (syntax (keyword ...)))))
             (syntax (lambda (x)
                        (syntax-case x (k ...)
                           ((dummy . pattern) (syntax template))
                           ...))))))))

(define-syntax or
   (lambda (x)
      (syntax-case x ()
         ((_) (syntax #f))
         ((_ e) (syntax e))
         ((_ e1 e2 e3 ...)
          (syntax (let ((t e1)) (if t t (or e2 e3 ...))))))))

(define-syntax and
   (lambda (x)
      (syntax-case x ()
         ((_ e1 e2 e3 ...) (syntax (if e1 (and e2 e3 ...) #f)))
         ((_ e) (syntax e))
         ((_) (syntax #t)))))

(define-syntax cond
   (lambda (x)
      (syntax-case x (else =>)
         ((_ (else e1 e2 ...))
          (syntax (begin e1 e2 ...)))
         ((_ (e0))
          (syntax (let ((t e0)) (if t t))))
         ((_ (e0) c1 c2 ...)
          (syntax (let ((t e0)) (if t t (cond c1 c2 ...)))))
         ((_ (e0 => e1)) (syntax (let ((t e0)) (if t (e1 t)))))
         ((_ (e0 => e1) c1 c2 ...)
          (syntax (let ((t e0)) (if t (e1 t) (cond c1 c2 ...)))))
         ((_ (e0 e1 e2 ...)) (syntax (if e0 (begin e1 e2 ...))))
         ((_ (e0 e1 e2 ...) c1 c2 ...)
          (syntax (if e0 (begin e1 e2 ...) (cond c1 c2 ...)))))))

(define-syntax let*
   (lambda (x)
      (syntax-case x ()
         ((let* () e1 e2 ...)
          (syntax (let () e1 e2 ...)))
         ((let* ((x1 v1) (x2 v2) ...) e1 e2 ...)
          (##syncase#andmap identifier? (syntax (x1 x2 ...)))
          (syntax (let ((x1 v1)) (let* ((x2 v2) ...) e1 e2 ...)))))))

(define-syntax case
   (lambda (x)
      (syntax-case x (else)
	 ((_ v (else e1 e2 ...))
          (syntax (begin e1 e2 ...)))
         ((_ v ((k1 ...) e1 e2 ...))
	  (syntax (let ((x v))
		    (if (or (eqv? x 'k1) ...) (begin e1 e2 ...)) ) ) )
         ((_ v ((k1 ...) e1 e2 ...) c1 c2 ...)
	  (syntax (let ((x v))
		    (if (or (eqv? x 'k1) ...)
			(begin e1 e2 ...)
			(case x c1 c2 ...))))))) )

(define-syntax do
   (lambda (orig-x)
      (syntax-case orig-x ()
         ((_ ((var init . step) ...) (e0 e1 ...) c ...)
          (with-syntax (((step ...)
                         (map (lambda (v s)
                                 (syntax-case s ()
                                    (() v)
                                    ((e) (syntax e))
                                    (_ (syntax-error orig-x))))
                              (syntax (var ...))
                              (syntax (step ...)))))
             (syntax-case (syntax (e1 ...)) ()
                (() (syntax (let doloop ((var init) ...)
                               (if (not e0)
                                   (begin c ... (doloop step ...))))))
                ((e1 e2 ...)
                 (syntax (let doloop ((var init) ...)
                            (if e0
                                (begin e1 e2 ...)
                                (begin c ... (doloop step ...))))))))))))

(define-syntax quasiquote
   (letrec
      ((gen-cons
        (lambda (x y)
           (syntax-case x (quote)
              ((quote x)
               (syntax-case y (quote ##sys#list)
                  ((quote y) (syntax (quote (x . y))))
                  ((##sys#list y ...) (syntax (##sys#list (quote x) y ...)))
                  (y (syntax (##sys#cons (quote x) y)))))
              (x (syntax-case y (quote ##sys#list)
                   ((quote ()) (syntax (##sys#list x)))
                   ((##sys#list y ...) (syntax (##sys#list x y ...)))
                   (y (syntax (##sys#cons x y))))))))

       (gen-append
        (lambda (x y)
           (syntax-case x (quote ##sys#list ##sys#cons)
              ((quote (x1 x2 ...))
               (syntax-case y (quote)
                  ((quote y) (syntax (quote (x1 x2 ... . y))))
                  (y (syntax (##sys#append (quote (x1 x2 ...) y))))))
              ((quote ()) y)
              ((##sys#list x1 x2 ...)
               (gen-cons (syntax x1) (gen-append (syntax (##sys#list x2 ...)) y)))
              (x (syntax-case y (quote ##sys#list)
                   ((quote ()) (syntax x))
                   (y (syntax (##sys#append x y))))))))

       (gen-vector
        (lambda (x)
           (syntax-case x (quote ##sys#list)
              ((quote (x ...)) (syntax (quote #(x ...))))
              ((##sys#list x ...) (syntax (##sys#vector x ...)))
              (x (syntax (##sys#list->vector x))))))

       (gen
        (lambda (p lev)
           (syntax-case p (unquote unquote-splicing quasiquote)
              ((unquote p)
               (if (= lev 0)
                   (syntax p)
                   (gen-cons (syntax (quote unquote))
                             (gen (syntax (p)) (- lev 1)))))
              (((unquote-splicing p) . q)
               (if (= lev 0)
                   (gen-append (syntax p) (gen (syntax q) lev))
                   (gen-cons (gen-cons (syntax (quote unquote-splicing))
                                       (gen (syntax p) (- lev 1)))
                             (gen (syntax q) lev))))
              ((quasiquote p)
               (gen-cons (syntax (quote quasiquote))
                         (gen (syntax (p)) (+ lev 1))))
              ((p . q)
               (gen-cons (gen (syntax p) lev) (gen (syntax q) lev)))
              (#(x ...) (gen-vector (gen (syntax (x ...)) lev)))
              (p (syntax (quote p)))))))

    (lambda (x)
       (syntax-case x ()
          ((- e) (gen (syntax e) 0))))))

(define-syntax delay
   (lambda (x)
      (syntax-case x ()
         ((delay exp)
          (syntax (##sys#make-promise (lambda () exp)))))))
