;;; srfi-37.scm - Argument option processor
;
; Copyright (c) 2002 Anthony Carrico
;
; All rights reserved.
;
; - ported to Chicken by felix


(declare
  (unit srfi-37)
  (usual-integrations)
  (fixnum)
  (disable-interrupts) )

(cond-expand
 [paranoia]
 [else (declare (no-bound-checks))] )

(cond-expand
 [unsafe
  (eval-when (compile)
    (define-macro (##sys#check-structure . _) '(##core#undefined))
    (define-macro (##sys#check-range . _) '(##core#undefined))
    (define-macro (##sys#check-pair . _) '(##core#undefined))
    (define-macro (##sys#check-list . _) '(##core#undefined))
    (define-macro (##sys#check-symbol . _) '(##core#undefined))
    (define-macro (##sys#check-string . _) '(##core#undefined))
    (define-macro (##sys#check-char . _) '(##core#undefined))
    (define-macro (##sys#check-exact . _) '(##core#undefined))
    (define-macro (##sys#check-port . _) '(##core#undefined))
    (define-macro (##sys#check-number . _) '(##core#undefined))
    (define-macro (##sys#check-byte-vector . _) '(##core#undefined)) ) ]
 [else] )

(register-feature! 'srfi-37)

(define (option names req opt pro)
  (##sys#make-structure 'option names req opt pro) )

(define (option-names opt)
  (##sys#check-structure opt 'option 'option-names)
  (##sys#slot opt 1) )

(define (option-required-arg? opt)
  (##sys#check-structure opt 'option 'option-required-arg?)
  (##sys#slot opt 2) )

(define (option-optional-arg? opt)
  (##sys#check-structure opt 'option 'option-optional-arg?)
  (##sys#slot opt 3) )

(define (option-processor opt)
  (##sys#check-structure opt 'option 'option-processor)
  (##sys#slot opt 4) )

(define (option? x) (##sys#structure? x 'option))

(define args-fold
  (lambda (args				; list of args
           options			; list of options
           unrecognized-option-proc
           ;; (lambda (non-option . seeds) <body>) -> next-seed ...
           non-option-proc
           . seeds)
    (letrec
        ((find
          (lambda (l ?)
            (cond ((null? l) #f)
                  ((? (car l)) (car l))
                  (else (find (cdr l) ?)))))
         (find-option
          ;; ISSUE: This is a brute force search. Could use a table.
          (lambda (name)
            (find
             options
             (lambda (option)
               (find
                (option-names option)
                (lambda (test-name)
                  (equal? name test-name)))))))
         (scan-short-options
          (lambda (index shorts args seeds)
            (if (= index (string-length shorts))
                (scan-args args seeds)
                (let* ((name (string-ref shorts index))
                       (option (or (find-option name)
                                   (option (list name)
                                           #f
                                           #f
                                           unrecognized-option-proc))))
                  (cond ((and (< (+ index 1) (string-length shorts))
                              (or (option-required-arg? option)
                                  (option-optional-arg? option)))
                         (receive seeds
			     (apply (option-processor option)
				    option
				    name
				    (substring
				     shorts
				     (+ index 1)
				     (string-length shorts))
				    seeds)
			   (scan-args args seeds)))
                        ((and (option-required-arg? option)
                              (pair? args))
                         (receive seeds
			     (apply (option-processor option)
				    option
				    name
				    (car args)
				    seeds)
                           (scan-args (cdr args) seeds)))
                        (else
                         (receive seeds
			     (apply (option-processor option)
				    option
				    name
				    #f
				    seeds)
			   (scan-short-options
			    (+ index 1)
                            shorts
                            args
                            seeds))))))))
	 (scan-non-options
	  (lambda (non-options seeds)
	    (if (null? non-options)
		(apply values seeds)
		(receive seeds (apply non-option-proc (car non-options) seeds)
		  (scan-non-options (cdr non-options) seeds)))))
	 (parse-long-option
	  ;; "--([^=]+)=(.*)"
	  (lambda (str len)
	    (let loop ([i 2])
	      (cond [(>= i len) #f]
		    [(char=? #\= (string-ref str i))
		     (cons (substring str 2 i) (substring str (add1 i) len)) ]
		    [else (loop (add1 i))] ) ) ) )
         (scan-args
          (lambda (args seeds)
            (if (null? args)
                (apply values seeds)
                (let* ([arg (car args)]
		       [args (cdr args)]
		       [len (string-length arg)] )
		  (if (and (> len 1) (char=? #\- (string-ref arg 0)))
		      (if (char=? #\- (string-ref arg 1))
			  (cond [(eq? 2 len)
				 (scan-non-options args seeds) ]
				[(parse-long-option arg len)
				 => (lambda (name+arg)
				      ;; Found long option with arg:
				      (let* ([name (car name+arg)]
					     [arg (cdr name+arg)]
					     [option (or (find-option name)
							 (option (list name)
								 #t
								 #f
								 unrecognized-option-proc)) ] )
					(receive seeds
					    (apply (option-processor option)
						   option
						   name
						   arg
						   seeds)
					  (scan-args args seeds) ) ) ) ]
				[else 
				 ;; Found long option:
				 (let* ([name (substring arg 2 len)]
					[option (or (find-option name)
						    (option
						     (list name)
						     #f
						     #f
						     unrecognized-option-proc)) ] )
				   (if (and (option-required-arg? option)
					    (pair? args))
				       (receive seeds
					   (apply (option-processor option)
						  option
						  name
						  (car args)
						  seeds)
					 (scan-args (cdr args) seeds))
				       (receive seeds
					   (apply (option-processor option)
						  option
						  name
						  #f
						  seeds)
					 (scan-args args seeds)))) ] )
			  ;; Found short options
			  (scan-short-options 0 (substring arg 1 len) args seeds) )
		      (receive seeds (apply non-option-proc arg seeds)
			(scan-args args seeds) ) ) ) ) ) ) )
      (scan-args args seeds))))
