/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2008-06-03 04:48
   Version 3.2.0 - linux-unix-gnu-x86	[ manyargs dload ptables applyhook hostpcre ]
   SVN rev. 10674	compiled 2008-04-30 on debian (Linux)
   command line: posixwin.scm -quiet -no-trace -optimize-level 2 -include-path . -explicit-use -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

/*
MinGW should have winsock2.h and ws2tcpip.h as well.
The CMake build will set HAVE_WINSOCK2_H and HAVE_WS2TCPIP_H.
However, the _MSC_VER test is still needed for vcbuild.bat.
./configure doesn't test for these.  It should, for MinGW.
*/
#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>

#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)	    (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid	    getpid
#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))
#define C_dup(x)	    C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)	    C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)	    C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)	    C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

#define C_ftell(p)	    C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[399];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,38),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,32,108,111,99,56,32,109,115,103,57,32,46,32,97,114,103,115,49,48,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,49,51,32,102,108,97,103,115,49,52,32,46,32,109,111,100,101,49,53,41,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,99,108,111,115,101,32,102,100,50,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,114,101,97,100,32,102,100,50,55,32,115,105,122,101,50,56,32,46,32,98,117,102,102,101,114,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,119,114,105,116,101,32,102,100,51,55,32,98,117,102,102,101,114,51,56,32,46,32,115,105,122,101,51,57,41,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,52,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,53,53,41,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,115,116,97,116,32,102,53,57,32,46,32,103,53,56,54,48,41,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,15),40,102,105,108,101,45,115,105,122,101,32,102,54,54,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,109,111,100,105,102,105,99,97,116,105,111,110,45,116,105,109,101,32,102,54,56,41,0,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,55,48,41,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,55,50,41,0,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,111,119,110,101,114,32,102,55,52,41};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,55,54,41,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,110,97,109,101,55,56,41,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,56,49,41};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,16),40,102,95,49,53,53,49,32,102,110,97,109,101,56,53,41};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,18),40,115,116,97,116,45,116,121,112,101,32,110,97,109,101,56,52,41,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,112,111,115,105,116,105,111,110,32,112,111,114,116,57,51,41,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,44),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,57,55,32,112,111,115,57,56,32,46,32,119,104,101,110,99,101,57,57,41,0,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,15),40,97,49,55,48,57,32,120,49,49,56,49,51,55,41,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,36),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,49,50,57,32,46,32,103,49,50,56,49,51,48,41,0,0,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,49,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,26),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,49,53,48,41,0,0,0,0,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,35),40,98,111,100,121,49,54,48,32,115,112,101,99,49,54,54,32,115,104,111,119,45,100,111,116,102,105,108,101,115,63,49,54,55,41,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,35),40,100,101,102,45,115,104,111,119,45,100,111,116,102,105,108,101,115,63,49,54,51,32,37,115,112,101,99,49,53,56,49,56,55,41,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,115,112,101,99,49,54,50,41,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,32,46,32,103,49,53,54,49,53,55,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,21),40,100,105,114,101,99,116,111,114,121,63,32,102,110,97,109,101,49,57,51,41,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,103,49,57,55,49,57,56,41,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,105,115,112,101,114,115,101,32,103,50,49,56,50,49,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,6),40,115,101,112,63,41,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,7),40,97,50,49,50,55,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,15),40,97,50,49,50,49,32,103,50,50,52,50,50,57,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,7),40,97,50,49,52,53,41,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,7),40,97,50,49,53,55,41,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,17),40,97,50,49,53,49,32,46,32,103,50,50,55,50,51,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,7),40,97,50,49,51,57,41,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,15),40,97,50,49,49,53,32,103,50,50,54,50,50,56,41,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,5),40,99,119,100,41,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,108,50,51,54,32,114,50,51,55,41};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,24),40,99,97,110,111,110,105,99,97,108,45,112,97,116,104,32,112,97,116,104,50,51,51,41};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,6),40,109,111,100,101,41,0,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,14),40,98,97,100,109,111,100,101,32,109,50,52,52,41,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,50,52,53,32,105,110,112,50,52,54,32,114,50,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,50,53,49,32,46,32,109,50,53,50,41,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,50,53,55,32,46,32,109,50,53,56,41};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,50,54,51,41,0,0,0,0,0,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,50,54,53,53,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,20),40,97,50,54,54,49,32,46,32,114,101,115,117,108,116,115,50,56,49,41,0,0,0,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,50,55,55,32,112,114,111,99,50,55,56,32,46,32,109,111,100,101,50,55,57,41,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,50,54,55,57,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,20),40,97,50,54,56,53,32,46,32,114,101,115,117,108,116,115,50,56,55,41,0,0,0,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,50,56,51,32,112,114,111,99,50,56,52,32,46,32,109,111,100,101,50,56,53,41};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,20),40,97,50,55,48,52,32,46,32,114,101,115,117,108,116,115,50,57,52,41,0,0,0,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,50,56,57,32,116,104,117,110,107,50,57,48,32,46,32,109,111,100,101,50,57,49,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,20),40,97,50,55,50,52,32,46,32,114,101,115,117,108,116,115,51,48,51,41,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,50,57,56,32,116,104,117,110,107,50,57,57,32,46,32,109,111,100,101,51,48,48,41,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,23),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,103,51,49,48,51,49,49,41,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,115,105,103,51,49,57,41,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,51,50,49,32,112,114,111,99,51,50,50,41,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,51,50,53,32,115,116,97,116,101,51,50,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,51,51,49,32,109,51,51,50,41};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,51,51,55,32,97,99,99,51,51,56,32,108,111,99,51,51,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,51,52,51,41,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,51,52,52,41};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,34),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,51,52,53,41,0,0,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,18),40,109,111,100,101,32,105,110,112,51,53,49,32,109,51,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,25),40,99,104,101,99,107,32,102,100,51,53,54,32,105,110,112,51,53,55,32,114,51,53,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,51,54,50,32,46,32,109,51,54,51,41,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,51,54,53,32,46,32,109,51,54,54,41};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,51,55,49,41,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,51,55,54,32,46,32,110,101,119,51,55,55,41,0,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,51,56,52,32,118,97,108,51,56,53,41,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,51,56,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,52,48,51,41,0,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,52,48,48,41,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,21),40,99,117,114,114,101,110,116,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,115,101,99,115,52,48,54,41,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,27),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,115,101,99,115,52,48,56,41,0,0,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,25),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,115,101,99,115,52,49,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,30),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,52,51,51,32,46,32,103,52,51,50,52,51,52,41,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,52,52,52,41,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,17),40,95,101,120,105,116,32,46,32,99,111,100,101,52,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,52,53,54,32,109,111,100,101,52,53,55,32,46,32,115,105,122,101,52,53,56,41,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,7),40,97,51,52,57,48,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,52,57,49,41,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,37),40,97,51,52,57,54,32,100,105,114,52,55,54,52,55,57,32,102,105,108,52,55,55,52,56,48,32,101,120,116,52,55,56,52,56,49,41,0,0,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,52,55,52,41,0,0,0,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,52,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,53,48,57,41,0,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,21),40,110,101,101,100,115,45,113,117,111,116,105,110,103,63,32,115,53,48,54,41,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,22),40,108,111,111,112,32,105,108,115,116,53,49,50,32,111,108,115,116,53,49,51,41,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,35),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,53,48,51,32,101,120,97,99,116,102,53,48,52,41,0,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,32),40,115,101,116,97,114,103,32,97,53,50,50,53,50,54,32,97,53,50,49,53,50,55,32,97,53,50,48,53,50,56,41};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,32),40,115,101,116,101,110,118,32,97,53,51,50,53,51,54,32,97,53,51,49,53,51,55,32,97,53,51,48,53,51,56,41};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,17),40,100,111,53,52,52,32,108,53,52,54,32,105,53,52,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,57),40,98,117,105,108,100,45,101,120,101,99,45,97,114,103,118,101,99,32,108,111,99,53,52,48,32,108,115,116,53,52,49,32,97,114,103,118,101,99,45,115,101,116,116,101,114,53,52,50,32,105,100,120,53,52,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,62),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,53,53,51,32,102,105,108,101,110,97,109,101,53,53,52,32,97,114,103,108,115,116,53,53,53,32,101,110,118,108,115,116,53,53,54,32,101,120,97,99,116,102,53,53,55,41,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,49),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,53,54,52,32,109,115,103,53,54,53,32,102,105,108,101,110,97,109,101,53,54,54,32,114,101,115,53,54,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,39),40,98,111,100,121,53,55,55,32,97,114,103,108,115,116,53,56,52,32,101,110,118,108,115,116,53,56,53,32,101,120,97,99,116,102,53,56,54,41,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,53,56,49,32,37,97,114,103,108,115,116,53,55,52,53,56,57,32,37,101,110,118,108,115,116,53,55,53,53,57,48,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,29),40,100,101,102,45,101,110,118,108,115,116,53,56,48,32,37,97,114,103,108,115,116,53,55,52,53,57,50,41,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,114,103,108,115,116,53,55,57,41,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,39),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,53,55,50,32,46,32,103,53,55,49,53,55,51,41,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,39),40,98,111,100,121,54,48,55,32,97,114,103,108,115,116,54,49,52,32,101,110,118,108,115,116,54,49,53,32,101,120,97,99,116,102,54,49,54,41,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,43),40,100,101,102,45,101,120,97,99,116,102,54,49,49,32,37,97,114,103,108,115,116,54,48,52,54,49,57,32,37,101,110,118,108,115,116,54,48,53,54,50,48,41,0,0,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,29),40,100,101,102,45,101,110,118,108,115,116,54,49,48,32,37,97,114,103,108,115,116,54,48,52,54,50,50,41,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,114,103,108,115,116,54,48,57,41,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,45),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,54,48,49,32,102,105,108,101,110,97,109,101,54,48,50,32,46,32,103,54,48,48,54,48,51,41,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,54,51,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,114,117,110,32,102,54,51,56,32,46,32,97,114,103,115,54,51,57,41,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,22),40,99,108,111,115,101,45,104,97,110,100,108,101,32,97,54,52,49,54,52,52,41,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,86),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,54,55,57,32,99,109,100,54,56,48,32,97,114,103,115,54,56,49,32,101,110,118,54,56,50,32,115,116,100,111,117,116,102,54,56,51,32,115,116,100,105,110,102,54,56,52,32,115,116,100,101,114,114,102,54,56,53,32,46,32,103,54,55,56,54,56,54,41,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,15),40,97,52,50,50,52,32,103,55,50,54,55,50,55,41,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,18),40,99,104,107,115,116,114,108,115,116,32,108,115,116,55,50,53,41,0,0,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,7),40,97,52,50,52,50,41,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,34),40,97,52,50,52,56,32,105,110,55,51,49,32,111,117,116,55,51,50,32,112,105,100,55,51,51,32,101,114,114,55,51,52,41,0,0,0,0,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,57),40,37,112,114,111,99,101,115,115,32,108,111,99,55,49,56,32,101,114,114,63,55,49,57,32,99,109,100,55,50,48,32,97,114,103,115,55,50,49,32,101,110,118,55,50,50,32,101,120,97,99,116,102,55,50,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,34),40,98,111,100,121,55,52,52,32,97,114,103,115,55,53,49,32,101,110,118,55,53,50,32,101,120,97,99,116,102,55,53,51,41,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,38),40,100,101,102,45,101,120,97,99,116,102,55,52,56,32,37,97,114,103,115,55,52,49,55,53,53,32,37,101,110,118,55,52,50,55,53,54,41,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,101,110,118,55,52,55,32,37,97,114,103,115,55,52,49,55,53,56,41};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,97,114,103,115,55,52,54,41,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,32,99,109,100,55,51,57,32,46,32,103,55,51,56,55,52,48,41,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,34),40,98,111,100,121,55,55,50,32,97,114,103,115,55,55,57,32,101,110,118,55,56,48,32,101,120,97,99,116,102,55,56,49,41,0,0,0,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,38),40,100,101,102,45,101,120,97,99,116,102,55,55,54,32,37,97,114,103,115,55,54,57,55,56,51,32,37,101,110,118,55,55,48,55,56,52,41,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,101,110,118,55,55,53,32,37,97,114,103,115,55,54,57,55,56,54,41};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,13),40,100,101,102,45,97,114,103,115,55,55,52,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,27),40,112,114,111,99,101,115,115,42,32,99,109,100,55,54,55,32,46,32,103,55,54,54,55,54,56,41,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,55,57,53,32,110,111,104,97,110,103,55,57,54,41,0,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,7),40,97,52,52,54,56,41,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,33),40,97,52,52,55,52,32,101,112,105,100,56,48,52,32,101,110,111,114,109,56,48,53,32,101,99,111,100,101,56,48,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,55,57,55,32,46,32,97,114,103,115,55,57,56,41,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,12),40,115,108,101,101,112,32,116,56,48,57,41,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,13),40,102,95,52,54,57,53,32,120,56,51,56,41,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,7),40,97,52,54,51,53,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,7),40,97,52,54,52,51,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,7),40,97,52,54,53,55,41,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,56,52,48,32,114,56,52,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,15),40,102,95,52,55,49,49,32,46,32,95,56,51,54,41,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,15),40,102,95,52,55,48,51,32,46,32,95,56,51,53,41,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,34),40,98,111,100,121,56,50,51,32,97,99,116,105,111,110,56,51,48,32,105,100,56,51,49,32,108,105,109,105,116,56,51,50,41,0,0,0,0,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,38),40,100,101,102,45,108,105,109,105,116,56,50,55,32,37,97,99,116,105,111,110,56,50,48,56,53,53,32,37,105,100,56,50,49,56,53,54,41,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,25),40,100,101,102,45,105,100,56,50,54,32,37,97,99,116,105,111,110,56,50,48,56,53,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,17),40,97,52,55,51,49,32,120,56,54,48,32,121,56,54,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,15),40,100,101,102,45,97,99,116,105,111,110,56,50,53,41,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,48),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,56,49,55,32,112,114,101,100,56,49,56,32,46,32,97,99,116,105,111,110,45,105,100,45,108,105,109,105,116,56,49,57,41};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,56,54,56,41,0,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,20),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,56,55,48,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,23),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,56,55,49,41,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,29),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,56,55,50,41,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,35),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,56,55,51,41,0,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,34),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,56,55,52,41,0,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,36),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,56,55,53,41,0,0,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,25),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,56,55,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,24),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,56,55,55,41};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,27),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,46,32,95,56,55,56,41,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,108,105,110,107,32,46,32,95,56,55,57,41,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,108,111,99,107,32,46,32,95,56,56,48,41,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,56,56,49,41,0,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,20),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,56,56,50,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,56,56,51,41,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,56,56,52,41,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,20),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,56,56,53,41,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,19),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,56,56,54,41,0,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,26),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,56,56,55,41,0,0,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,26),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,56,56,56,41,0,0,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,35),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,46,32,95,56,56,57,41,0,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,26),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,56,57,48,41,0,0,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,21),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,56,57,49,41,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,25),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,56,57,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,23),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,56,57,51,41,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,27),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,56,57,52,41,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,19),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,56,57,53,41,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,56,57,54,41,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,20),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,56,57,55,41,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,56,57,56,41,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,28),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,56,57,57,41,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,57,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,21),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,57,48,49,41,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,20),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,57,48,50,41,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,21),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,57,48,51,41,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,57,48,52,41,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,23),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,57,48,53,41,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,22),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,57,48,54,41,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,23),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,46,32,95,57,48,55,41,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,22),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,46,32,95,57,48,56,41,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,31),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,46,32,95,57,48,57,41,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,25),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,57,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,57,49,49,41,0,0,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,21),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,57,49,50,41,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,12),40,102,105,102,111,63,32,95,57,49,51,41,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,26),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,95,57,49,52,41,0,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k4063 */
static C_word C_fcall stub654(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub654(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from close-handle in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall stub642(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub642(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_truep(C_a0);
C_r=C_fix((C_word)close_handle(t0));
return C_r;}

/* from current-process-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall stub630(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub630(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from k3692 */
static C_word C_fcall stub533(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub533(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k3675 */
static C_word C_fcall stub523(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub523(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k3392 */
static C_word C_fcall stub452(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub452(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub447(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub447(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (daylight ? _tzname[1] : _tzname[0]);return(z);
C_ret:
#undef return

return C_r;}

/* from strftime */
static C_word C_fcall stub427(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub427(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub421(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub421(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3239 */
static C_word C_fcall stub412(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub412(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3146 */
static C_word C_fcall stub395(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub395(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k1183 */
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1162)
static void C_ccall f_1162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1165)
static void C_ccall f_1165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1168)
static void C_ccall f_1168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1171)
static void C_ccall f_1171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1174)
static void C_ccall f_1174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1560)
static void C_ccall f_1560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1564)
static void C_ccall f_1564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1568)
static void C_ccall f_1568(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1572)
static void C_ccall f_1572(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1576)
static void C_ccall f_1576(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1580)
static void C_ccall f_1580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2809)
static void C_ccall f_2809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5063)
static void C_ccall f_5063(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5060)
static void C_ccall f_5060(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5047)
static void C_ccall f_5047(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5041)
static void C_ccall f_5041(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5035)
static void C_ccall f_5035(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5029)
static void C_ccall f_5029(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5023)
static void C_ccall f_5023(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5017)
static void C_ccall f_5017(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5011)
static void C_ccall f_5011(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5005)
static void C_ccall f_5005(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4999)
static void C_ccall f_4999(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4993)
static void C_ccall f_4993(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4987)
static void C_ccall f_4987(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4981)
static void C_ccall f_4981(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4975)
static void C_ccall f_4975(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4969)
static void C_ccall f_4969(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4963)
static void C_ccall f_4963(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4957)
static void C_ccall f_4957(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4951)
static void C_ccall f_4951(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4945)
static void C_ccall f_4945(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4939)
static void C_ccall f_4939(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4933)
static void C_ccall f_4933(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4927)
static void C_ccall f_4927(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4921)
static void C_ccall f_4921(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4915)
static void C_ccall f_4915(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4909)
static void C_ccall f_4909(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4903)
static void C_ccall f_4903(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4897)
static void C_ccall f_4897(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4891)
static void C_ccall f_4891(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4885)
static void C_ccall f_4885(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4879)
static void C_ccall f_4879(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4867)
static void C_ccall f_4867(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4861)
static void C_ccall f_4861(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4855)
static void C_ccall f_4855(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4849)
static void C_ccall f_4849(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4843)
static void C_ccall f_4843(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4837)
static void C_ccall f_4837(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4831)
static void C_ccall f_4831(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4825)
static void C_ccall f_4825(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4819)
static void C_ccall f_4819(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4813)
static void C_ccall f_4813(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4807)
static void C_ccall f_4807(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4801)
static void C_ccall f_4801(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4795)
static void C_ccall f_4795(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4569)
static void C_ccall f_4569(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4569)
static void C_ccall f_4569r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4726)
static void C_fcall f_4726(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4732)
static void C_ccall f_4732(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4721)
static void C_fcall f_4721(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4716)
static void C_fcall f_4716(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4571)
static void C_fcall f_4571(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4703)
static void C_ccall f_4703(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4578)
static void C_fcall f_4578(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4691)
static void C_ccall f_4691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4588)
static void C_ccall f_4588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4590)
static void C_fcall f_4590(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4609)
static void C_ccall f_4609(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4677)
static void C_ccall f_4677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4684)
static void C_ccall f_4684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4671)
static void C_ccall f_4671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4624)
static void C_ccall f_4624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4658)
static void C_ccall f_4658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4644)
static void C_ccall f_4644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4656)
static void C_ccall f_4656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4652)
static void C_ccall f_4652(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4636)
static void C_ccall f_4636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4634)
static void C_ccall f_4634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4695)
static void C_ccall f_4695(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4554)
static void C_ccall f_4554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4564)
static void C_ccall f_4564(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4523)
static void C_ccall f_4523(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4549)
static void C_ccall f_4549(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4534)
static void C_ccall f_4534(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4538)
static void C_ccall f_4538(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4542)
static void C_ccall f_4542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4546)
static void C_ccall f_4546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4511)
static void C_ccall f_4511(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4508)
static void C_ccall f_4508(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4448)
static void C_ccall f_4448(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4448)
static void C_ccall f_4448r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4475)
static void C_ccall f_4475(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4485)
static void C_ccall f_4485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4469)
static void C_ccall f_4469(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4436)
static void C_ccall f_4436(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4356)
static void C_ccall f_4356(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4356)
static void C_ccall f_4356r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4373)
static void C_fcall f_4373(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4368)
static void C_fcall f_4368(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4363)
static void C_fcall f_4363(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4358)
static void C_fcall f_4358(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4276)
static void C_ccall f_4276(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4276)
static void C_ccall f_4276r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4293)
static void C_fcall f_4293(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4288)
static void C_fcall f_4288(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4283)
static void C_fcall f_4283(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4278)
static void C_fcall f_4278(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4214)
static void C_fcall f_4214(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4270)
static void C_ccall f_4270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4274)
static void C_ccall f_4274(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4235)
static void C_ccall f_4235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4238)
static void C_ccall f_4238(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4249)
static void C_ccall f_4249(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4243)
static void C_ccall f_4243(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4216)
static void C_fcall f_4216(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4225)
static void C_ccall f_4225(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4095)
static void C_ccall f_4095(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_4095)
static void C_ccall f_4095r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_4099)
static void C_ccall f_4099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4190)
static void C_ccall f_4190(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4102)
static void C_ccall f_4102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4162)
static void C_ccall f_4162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4166)
static void C_ccall f_4166(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4170)
static void C_ccall f_4170(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4174)
static void C_ccall f_4174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4037)
static void C_ccall f_4037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4041)
static void C_ccall f_4041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4151)
static void C_ccall f_4151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4131)
static void C_ccall f_4131(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4135)
static void C_ccall f_4135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4139)
static void C_ccall f_4139(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4029)
static void C_ccall f_4029(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4000)
static void C_ccall f_4000(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4000)
static void C_ccall f_4000r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4017)
static void C_ccall f_4017(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4021)
static void C_ccall f_4021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3994)
static void C_ccall f_3994(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3973)
static void C_ccall f_3973(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3977)
static void C_ccall f_3977(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3989)
static void C_ccall f_3989(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3970)
static void C_ccall f_3970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3883)
static void C_ccall f_3883(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3883)
static void C_ccall f_3883r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3907)
static void C_fcall f_3907(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3902)
static void C_fcall f_3902(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3897)
static void C_fcall f_3897(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3885)
static void C_fcall f_3885(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3889)
static void C_ccall f_3889(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3820)
static void C_fcall f_3820(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3815)
static void C_fcall f_3815(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3810)
static void C_fcall f_3810(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3798)
static void C_fcall f_3798(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3802)
static void C_ccall f_3802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3781)
static void C_fcall f_3781(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3785)
static void C_ccall f_3785(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3748)
static void C_fcall f_3748(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3758)
static void C_ccall f_3758(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3775)
static void C_ccall f_3775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3761)
static void C_ccall f_3761(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3764)
static void C_ccall f_3764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3771)
static void C_ccall f_3771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3698)
static void C_fcall f_3698(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3710)
static void C_fcall f_3710(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3729)
static void C_ccall f_3729(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3681)
static void C_ccall f_3681(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3664)
static void C_ccall f_3664(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3585)
static void C_fcall f_3585(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3628)
static void C_fcall f_3628(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3659)
static void C_ccall f_3659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3656)
static void C_ccall f_3656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3590)
static void C_fcall f_3590(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3594)
static void C_ccall f_3594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3599)
static void C_fcall f_3599(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3623)
static void C_ccall f_3623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3612)
static void C_ccall f_3612(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3470)
static void C_ccall f_3470(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3470)
static void C_ccall f_3470r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3476)
static void C_fcall f_3476(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3497)
static void C_ccall f_3497(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3574)
static void C_ccall f_3574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3501)
static void C_ccall f_3501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3504)
static void C_ccall f_3504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3507)
static void C_ccall f_3507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3514)
static void C_ccall f_3514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3516)
static void C_fcall f_3516(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3533)
static void C_ccall f_3533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3543)
static void C_ccall f_3543(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3547)
static void C_ccall f_3547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3491)
static void C_ccall f_3491(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3411)
static void C_ccall f_3411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3411)
static void C_ccall f_3411r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3415)
static void C_ccall f_3415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3421)
static void C_ccall f_3421(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3395)
static void C_ccall f_3395(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3395)
static void C_ccall f_3395r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3383)
static void C_ccall f_3383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3355)
static void C_ccall f_3355(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3362)
static void C_ccall f_3362(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3275)
static void C_ccall f_3275(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3275)
static void C_ccall f_3275r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3279)
static void C_ccall f_3279(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3285)
static void C_ccall f_3285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3307)
static void C_ccall f_3307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3304)
static void C_ccall f_3304(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3294)
static void C_ccall f_3294(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3242)
static void C_ccall f_3242(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3246)
static void C_ccall f_3246(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3214)
static void C_ccall f_3214(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3149)
static void C_ccall f_3149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3155)
static void C_fcall f_3155(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3159)
static void C_ccall f_3159(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3167)
static void C_fcall f_3167(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3197)
static void C_ccall f_3197(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3185)
static void C_ccall f_3185(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3129)
static void C_ccall f_3129(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3137)
static void C_ccall f_3137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3112)
static void C_ccall f_3112(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3123)
static void C_ccall f_3123(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3127)
static void C_ccall f_3127(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3082)
static void C_ccall f_3082(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3082)
static void C_ccall f_3082r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3089)
static void C_fcall f_3089(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3098)
static void C_ccall f_3098(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3092)
static void C_ccall f_3092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3047)
static void C_ccall f_3047(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3051)
static void C_ccall f_3051(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3080)
static void C_ccall f_3080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3066)
static void C_ccall f_3066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3060)
static void C_ccall f_3060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3033)
static void C_ccall f_3033(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3033)
static void C_ccall f_3033r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3045)
static void C_ccall f_3045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3019)
static void C_ccall f_3019(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3019)
static void C_ccall f_3019r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3031)
static void C_ccall f_3031(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3001)
static void C_fcall f_3001(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3005)
static void C_ccall f_3005(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3017)
static void C_ccall f_3017(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2964)
static void C_fcall f_2964(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2972)
static void C_ccall f_2972(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2955)
static void C_ccall f_2955(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2949)
static void C_ccall f_2949(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2919)
static void C_fcall f_2919(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2941)
static void C_ccall f_2941(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2937)
static void C_ccall f_2937(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2929)
static void C_ccall f_2929(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2889)
static void C_ccall f_2889(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2917)
static void C_ccall f_2917(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2913)
static void C_ccall f_2913(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2905)
static void C_ccall f_2905(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2833)
static void C_ccall f_2833(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2843)
static void C_ccall f_2843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2820)
static void C_ccall f_2820(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2811)
static void C_ccall f_2811(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2735)
static void C_ccall f_2735(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2735)
static void C_ccall f_2735r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2739)
static void C_ccall f_2739(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2751)
static void C_ccall f_2751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2742)
static void C_ccall f_2742(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2715)
static void C_ccall f_2715(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2715)
static void C_ccall f_2715r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2719)
static void C_ccall f_2719(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2729)
static void C_ccall f_2729(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2695)
static void C_ccall f_2695(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2695)
static void C_ccall f_2695r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2699)
static void C_ccall f_2699(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2705)
static void C_ccall f_2705(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2705)
static void C_ccall f_2705r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2709)
static void C_ccall f_2709(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2671)
static void C_ccall f_2671(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2671)
static void C_ccall f_2671r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2675)
static void C_ccall f_2675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2690)
static void C_ccall f_2690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2680)
static void C_ccall f_2680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2651)
static void C_ccall f_2651(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2662)
static void C_ccall f_2662(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2662)
static void C_ccall f_2662r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2628)
static void C_ccall f_2628(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2632)
static void C_ccall f_2632(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2635)
static void C_ccall f_2635(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2592)
static void C_ccall f_2592(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2592)
static void C_ccall f_2592r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2623)
static void C_ccall f_2623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2613)
static void C_ccall f_2613(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2606)
static void C_ccall f_2606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2556)
static void C_ccall f_2556(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2556)
static void C_ccall f_2556r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2587)
static void C_ccall f_2587(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2577)
static void C_ccall f_2577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2570)
static void C_ccall f_2570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2538)
static void C_fcall f_2538(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2542)
static void C_ccall f_2542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2554)
static void C_ccall f_2554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2532)
static void C_fcall f_2532(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2520)
static C_word C_fcall f_2520(C_word t0);
C_noret_decl(f_2163)
static void C_ccall f_2163(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2510)
static void C_ccall f_2510(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2309)
static void C_fcall f_2309(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2496)
static void C_ccall f_2496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2485)
static void C_ccall f_2485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2492)
static void C_ccall f_2492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2339)
static void C_fcall f_2339(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2478)
static void C_ccall f_2478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2457)
static void C_ccall f_2457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2474)
static void C_ccall f_2474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2463)
static void C_ccall f_2463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2470)
static void C_ccall f_2470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2381)
static void C_fcall f_2381(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2454)
static void C_ccall f_2454(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2433)
static void C_ccall f_2433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2450)
static void C_ccall f_2450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2439)
static void C_ccall f_2439(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2446)
static void C_ccall f_2446(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2387)
static void C_ccall f_2387(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2430)
static void C_ccall f_2430(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2426)
static void C_ccall f_2426(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2419)
static void C_ccall f_2419(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2415)
static void C_ccall f_2415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2394)
static void C_ccall f_2394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2398)
static void C_ccall f_2398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2375)
static void C_ccall f_2375(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2362)
static void C_ccall f_2362(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2346)
static void C_ccall f_2346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2350)
static void C_ccall f_2350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2354)
static void C_ccall f_2354(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2333)
static void C_ccall f_2333(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2320)
static void C_ccall f_2320(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2316)
static void C_ccall f_2316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2303)
static void C_ccall f_2303(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2170)
static void C_ccall f_2170(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2289)
static void C_ccall f_2289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2177)
static void C_ccall f_2177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2179)
static void C_fcall f_2179(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2186)
static void C_ccall f_2186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2261)
static void C_ccall f_2261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2270)
static void C_ccall f_2270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2258)
static void C_fcall f_2258(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2192)
static void C_ccall f_2192(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2239)
static void C_ccall f_2239(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2227)
static void C_ccall f_2227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2235)
static void C_ccall f_2235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2231)
static void C_ccall f_2231(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2208)
static void C_ccall f_2208(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2216)
static void C_ccall f_2216(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2212)
static void C_ccall f_2212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2107)
static void C_fcall f_2107(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2116)
static void C_ccall f_2116(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2140)
static void C_ccall f_2140(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2152)
static void C_ccall f_2152(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2152)
static void C_ccall f_2152r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2158)
static void C_ccall f_2158(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2146)
static void C_ccall f_2146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2122)
static void C_ccall f_2122(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2128)
static void C_ccall f_2128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2114)
static void C_ccall f_2114(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2096)
static C_word C_fcall f_2096(C_word t0);
C_noret_decl(f_2091)
static void C_fcall f_2091(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2040)
static void C_ccall f_2040(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2040)
static void C_ccall f_2040r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2044)
static void C_ccall f_2044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2053)
static void C_ccall f_2053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2056)
static void C_ccall f_2056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2013)
static void C_ccall f_2013(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2038)
static void C_ccall f_2038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2034)
static void C_ccall f_2034(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2020)
static void C_ccall f_2020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1853)
static void C_ccall f_1853(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_1853)
static void C_ccall f_1853r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_1961)
static void C_fcall f_1961(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1969)
static void C_ccall f_1969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1956)
static void C_fcall f_1956(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1855)
static void C_fcall f_1855(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1862)
static void C_ccall f_1862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1865)
static void C_ccall f_1865(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1868)
static void C_ccall f_1868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1955)
static void C_ccall f_1955(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1872)
static void C_ccall f_1872(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1889)
static void C_fcall f_1889(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1899)
static void C_ccall f_1899(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1911)
static void C_fcall f_1911(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1921)
static void C_ccall f_1921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1881)
static void C_ccall f_1881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1826)
static void C_ccall f_1826(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1851)
static void C_ccall f_1851(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1847)
static void C_ccall f_1847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1839)
static void C_ccall f_1839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1799)
static void C_ccall f_1799(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1824)
static void C_ccall f_1824(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1820)
static void C_ccall f_1820(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1812)
static void C_ccall f_1812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1686)
static void C_ccall f_1686(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1686)
static void C_ccall f_1686r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1690)
static void C_ccall f_1690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1761)
static void C_ccall f_1761(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1778)
static void C_ccall f_1778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1770)
static void C_ccall f_1770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1699)
static void C_ccall f_1699(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1702)
static void C_ccall f_1702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1710)
static void C_ccall f_1710(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1715)
static void C_ccall f_1715(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1741)
static void C_ccall f_1741(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1744)
static void C_ccall f_1744(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1721)
static void C_fcall f_1721(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1738)
static void C_ccall f_1738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1730)
static void C_ccall f_1730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1622)
static void C_ccall f_1622(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1622)
static void C_ccall f_1622r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1635)
static void C_ccall f_1635(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1650)
static void C_ccall f_1650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1641)
static void C_ccall f_1641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1644)
static void C_ccall f_1644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1582)
static void C_ccall f_1582(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1601)
static void C_ccall f_1601(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1586)
static void C_ccall f_1586(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1595)
static void C_ccall f_1595(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1589)
static void C_ccall f_1589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1549)
static void C_fcall f_1549(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1551)
static void C_ccall f_1551(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1544)
static void C_ccall f_1544(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1521)
static void C_ccall f_1521(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1542)
static void C_ccall f_1542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1528)
static void C_ccall f_1528(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1515)
static void C_ccall f_1515(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1519)
static void C_ccall f_1519(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1509)
static void C_ccall f_1509(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1513)
static void C_ccall f_1513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1503)
static void C_ccall f_1503(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1507)
static void C_ccall f_1507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1497)
static void C_ccall f_1497(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1501)
static void C_ccall f_1501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1491)
static void C_ccall f_1491(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1495)
static void C_ccall f_1495(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1485)
static void C_ccall f_1485(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1489)
static void C_ccall f_1489(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1454)
static void C_ccall f_1454(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1454)
static void C_ccall f_1454r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1458)
static void C_ccall f_1458(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1461)
static void C_ccall f_1461(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1416)
static void C_fcall f_1416(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1449)
static void C_ccall f_1449(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1445)
static void C_ccall f_1445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1420)
static void C_ccall f_1420(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1429)
static void C_ccall f_1429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1378)
static void C_ccall f_1378(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1385)
static void C_ccall f_1385(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1388)
static void C_ccall f_1388(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1408)
static void C_ccall f_1408(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1391)
static void C_ccall f_1391(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1398)
static void C_ccall f_1398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1336)
static void C_ccall f_1336(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1336)
static void C_ccall f_1336r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1343)
static void C_ccall f_1343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1358)
static void C_ccall f_1358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1352)
static void C_ccall f_1352(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1291)
static void C_ccall f_1291(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1291)
static void C_ccall f_1291r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1301)
static void C_ccall f_1301(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1304)
static void C_ccall f_1304(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1316)
static void C_ccall f_1316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1307)
static void C_ccall f_1307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1273)
static void C_ccall f_1273(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1286)
static void C_ccall f_1286(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1232)
static void C_ccall f_1232(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1232)
static void C_ccall f_1232r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1265)
static void C_ccall f_1265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1249)
static void C_ccall f_1249(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1258)
static void C_ccall f_1258(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1252)
static void C_ccall f_1252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1186)
static void C_ccall f_1186(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1186)
static void C_ccall f_1186r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1190)
static void C_ccall f_1190(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1201)
static void C_ccall f_1201(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1197)
static void C_ccall f_1197(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_4726)
static void C_fcall trf_4726(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4726(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4726(t0,t1);}

C_noret_decl(trf_4721)
static void C_fcall trf_4721(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4721(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4721(t0,t1,t2);}

C_noret_decl(trf_4716)
static void C_fcall trf_4716(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4716(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4716(t0,t1,t2,t3);}

C_noret_decl(trf_4571)
static void C_fcall trf_4571(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4571(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4571(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4578)
static void C_fcall trf_4578(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4578(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4578(t0,t1);}

C_noret_decl(trf_4590)
static void C_fcall trf_4590(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4590(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4590(t0,t1,t2,t3);}

C_noret_decl(trf_4373)
static void C_fcall trf_4373(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4373(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4373(t0,t1);}

C_noret_decl(trf_4368)
static void C_fcall trf_4368(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4368(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4368(t0,t1,t2);}

C_noret_decl(trf_4363)
static void C_fcall trf_4363(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4363(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4363(t0,t1,t2,t3);}

C_noret_decl(trf_4358)
static void C_fcall trf_4358(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4358(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4358(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4293)
static void C_fcall trf_4293(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4293(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4293(t0,t1);}

C_noret_decl(trf_4288)
static void C_fcall trf_4288(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4288(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4288(t0,t1,t2);}

C_noret_decl(trf_4283)
static void C_fcall trf_4283(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4283(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4283(t0,t1,t2,t3);}

C_noret_decl(trf_4278)
static void C_fcall trf_4278(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4278(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4278(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4214)
static void C_fcall trf_4214(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4214(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_4214(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4216)
static void C_fcall trf_4216(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4216(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4216(t0,t1,t2);}

C_noret_decl(trf_3907)
static void C_fcall trf_3907(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3907(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3907(t0,t1);}

C_noret_decl(trf_3902)
static void C_fcall trf_3902(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3902(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3902(t0,t1,t2);}

C_noret_decl(trf_3897)
static void C_fcall trf_3897(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3897(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3897(t0,t1,t2,t3);}

C_noret_decl(trf_3885)
static void C_fcall trf_3885(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3885(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3885(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3820)
static void C_fcall trf_3820(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3820(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3820(t0,t1);}

C_noret_decl(trf_3815)
static void C_fcall trf_3815(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3815(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3815(t0,t1,t2);}

C_noret_decl(trf_3810)
static void C_fcall trf_3810(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3810(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3810(t0,t1,t2,t3);}

C_noret_decl(trf_3798)
static void C_fcall trf_3798(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3798(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3798(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3781)
static void C_fcall trf_3781(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3781(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3781(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3748)
static void C_fcall trf_3748(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3748(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_3748(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_3698)
static void C_fcall trf_3698(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3698(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3698(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3710)
static void C_fcall trf_3710(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3710(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3710(t0,t1,t2,t3);}

C_noret_decl(trf_3585)
static void C_fcall trf_3585(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3585(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3585(t0,t1,t2,t3);}

C_noret_decl(trf_3628)
static void C_fcall trf_3628(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3628(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3628(t0,t1,t2,t3);}

C_noret_decl(trf_3590)
static void C_fcall trf_3590(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3590(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3590(t0,t1,t2);}

C_noret_decl(trf_3599)
static void C_fcall trf_3599(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3599(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3599(t0,t1,t2);}

C_noret_decl(trf_3476)
static void C_fcall trf_3476(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3476(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3476(t0,t1,t2);}

C_noret_decl(trf_3516)
static void C_fcall trf_3516(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3516(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3516(t0,t1,t2);}

C_noret_decl(trf_3155)
static void C_fcall trf_3155(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3155(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3155(t0,t1,t2);}

C_noret_decl(trf_3167)
static void C_fcall trf_3167(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3167(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3167(t0,t1,t2);}

C_noret_decl(trf_3089)
static void C_fcall trf_3089(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3089(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3089(t0,t1);}

C_noret_decl(trf_3001)
static void C_fcall trf_3001(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3001(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3001(t0,t1,t2,t3);}

C_noret_decl(trf_2964)
static void C_fcall trf_2964(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2964(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2964(t0,t1,t2);}

C_noret_decl(trf_2919)
static void C_fcall trf_2919(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2919(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2919(t0,t1,t2,t3);}

C_noret_decl(trf_2538)
static void C_fcall trf_2538(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2538(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2538(t0,t1,t2,t3);}

C_noret_decl(trf_2532)
static void C_fcall trf_2532(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2532(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2532(t0,t1);}

C_noret_decl(trf_2309)
static void C_fcall trf_2309(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2309(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2309(t0,t1);}

C_noret_decl(trf_2339)
static void C_fcall trf_2339(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2339(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2339(t0,t1);}

C_noret_decl(trf_2381)
static void C_fcall trf_2381(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2381(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2381(t0,t1);}

C_noret_decl(trf_2179)
static void C_fcall trf_2179(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2179(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2179(t0,t1,t2,t3);}

C_noret_decl(trf_2258)
static void C_fcall trf_2258(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2258(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2258(t0,t1);}

C_noret_decl(trf_2107)
static void C_fcall trf_2107(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2107(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2107(t0,t1);}

C_noret_decl(trf_2091)
static void C_fcall trf_2091(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2091(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2091(t0,t1);}

C_noret_decl(trf_1961)
static void C_fcall trf_1961(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1961(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1961(t0,t1);}

C_noret_decl(trf_1956)
static void C_fcall trf_1956(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1956(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_1956(t0,t1,t2);}

C_noret_decl(trf_1855)
static void C_fcall trf_1855(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1855(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1855(t0,t1,t2,t3);}

C_noret_decl(trf_1889)
static void C_fcall trf_1889(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1889(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1889(t0,t1);}

C_noret_decl(trf_1911)
static void C_fcall trf_1911(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1911(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1911(t0,t1);}

C_noret_decl(trf_1721)
static void C_fcall trf_1721(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1721(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1721(t0,t1);}

C_noret_decl(trf_1549)
static void C_fcall trf_1549(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1549(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1549(t0,t1);}

C_noret_decl(trf_1416)
static void C_fcall trf_1416(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1416(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1416(t0,t1);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr9r)
static void C_fcall tr9r(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9r(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n*3);
t9=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3120)){
C_save(t1);
C_rereclaim2(3120*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,399);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[6]=C_h_intern(&lf[6],15,"\003syssignal-hook");
lf[7]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[8]=C_h_intern(&lf[8],17,"\003syspeek-c-string");
lf[9]=C_h_intern(&lf[9],16,"\003sysupdate-errno");
lf[10]=C_h_intern(&lf[10],15,"\003sysposix-error");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"open/rdonly");
lf[13]=C_h_intern(&lf[13],11,"open/wronly");
lf[14]=C_h_intern(&lf[14],9,"open/rdwr");
lf[15]=C_h_intern(&lf[15],9,"open/read");
lf[16]=C_h_intern(&lf[16],10,"open/write");
lf[17]=C_h_intern(&lf[17],10,"open/creat");
lf[18]=C_h_intern(&lf[18],11,"open/append");
lf[19]=C_h_intern(&lf[19],9,"open/excl");
lf[20]=C_h_intern(&lf[20],10,"open/trunc");
lf[21]=C_h_intern(&lf[21],11,"open/binary");
lf[22]=C_h_intern(&lf[22],9,"open/text");
lf[23]=C_h_intern(&lf[23],14,"open/noinherit");
lf[24]=C_h_intern(&lf[24],10,"perm/irusr");
lf[25]=C_h_intern(&lf[25],10,"perm/iwusr");
lf[26]=C_h_intern(&lf[26],10,"perm/ixusr");
lf[27]=C_h_intern(&lf[27],10,"perm/irgrp");
lf[28]=C_h_intern(&lf[28],10,"perm/iwgrp");
lf[29]=C_h_intern(&lf[29],10,"perm/ixgrp");
lf[30]=C_h_intern(&lf[30],10,"perm/iroth");
lf[31]=C_h_intern(&lf[31],10,"perm/iwoth");
lf[32]=C_h_intern(&lf[32],10,"perm/ixoth");
lf[33]=C_h_intern(&lf[33],10,"perm/irwxu");
lf[34]=C_h_intern(&lf[34],10,"perm/irwxg");
lf[35]=C_h_intern(&lf[35],10,"perm/irwxo");
lf[36]=C_h_intern(&lf[36],9,"file-open");
lf[37]=C_h_intern(&lf[37],11,"\000file-error");
lf[38]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[39]=C_h_intern(&lf[39],17,"\003sysmake-c-string");
lf[40]=C_h_intern(&lf[40],20,"\003sysexpand-home-path");
lf[41]=C_h_intern(&lf[41],10,"file-close");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[43]=C_h_intern(&lf[43],11,"make-string");
lf[44]=C_h_intern(&lf[44],9,"file-read");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[46]=C_h_intern(&lf[46],11,"\000type-error");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[48]=C_h_intern(&lf[48],10,"file-write");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[51]=C_h_intern(&lf[51],13,"string-length");
lf[52]=C_h_intern(&lf[52],12,"file-mkstemp");
lf[53]=C_h_intern(&lf[53],13,"\003syssubstring");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[55]=C_h_intern(&lf[55],8,"seek/set");
lf[56]=C_h_intern(&lf[56],8,"seek/end");
lf[57]=C_h_intern(&lf[57],8,"seek/cur");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[61]=C_h_intern(&lf[61],9,"file-stat");
lf[62]=C_h_intern(&lf[62],9,"\003syserror");
lf[63]=C_h_intern(&lf[63],9,"file-size");
lf[64]=C_h_intern(&lf[64],22,"file-modification-time");
lf[65]=C_h_intern(&lf[65],16,"file-access-time");
lf[66]=C_h_intern(&lf[66],16,"file-change-time");
lf[67]=C_h_intern(&lf[67],10,"file-owner");
lf[68]=C_h_intern(&lf[68],16,"file-permissions");
lf[69]=C_h_intern(&lf[69],13,"regular-file\077");
lf[70]=C_h_intern(&lf[70],13,"\003sysfile-info");
lf[71]=C_h_intern(&lf[71],14,"symbolic-link\077");
lf[72]=C_h_intern(&lf[72],13,"stat-regular\077");
lf[73]=C_h_intern(&lf[73],15,"stat-directory\077");
lf[74]=C_h_intern(&lf[74],17,"stat-char-device\077");
lf[75]=C_h_intern(&lf[75],18,"stat-block-device\077");
lf[76]=C_h_intern(&lf[76],10,"stat-fifo\077");
lf[77]=C_h_intern(&lf[77],13,"stat-symlink\077");
lf[78]=C_h_intern(&lf[78],12,"stat-socket\077");
lf[79]=C_h_intern(&lf[79],13,"file-position");
lf[80]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[81]=C_h_intern(&lf[81],6,"stream");
lf[82]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[83]=C_h_intern(&lf[83],5,"port\077");
lf[84]=C_h_intern(&lf[84],18,"set-file-position!");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[86]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[87]=C_h_intern(&lf[87],13,"\000bounds-error");
lf[88]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[89]=C_h_intern(&lf[89],20,"g107-1212508111.0351");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[91]=C_h_intern(&lf[91],20,"g126-1212508111.0442");
lf[92]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[93]=C_h_intern(&lf[93],20,"g125-1212508111.0264");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[95]=C_h_intern(&lf[95],16,"create-directory");
lf[96]=C_h_intern(&lf[96],12,"file-exists\077");
lf[97]=C_h_intern(&lf[97],12,"\003sysfor-each");
lf[98]=C_h_intern(&lf[98],12,"string-split");
lf[99]=C_h_intern(&lf[99],14,"canonical-path");
lf[100]=C_h_intern(&lf[100],16,"change-directory");
lf[101]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[102]=C_h_intern(&lf[102],16,"delete-directory");
lf[103]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[104]=C_h_intern(&lf[104],6,"string");
lf[105]=C_h_intern(&lf[105],9,"directory");
lf[106]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[107]=C_h_intern(&lf[107],16,"\003sysmake-pointer");
lf[108]=C_h_intern(&lf[108],17,"current-directory");
lf[109]=C_h_intern(&lf[109],10,"directory\077");
lf[110]=C_h_intern(&lf[110],27,"\003sysplatform-fixup-pathname");
lf[111]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[112]=C_h_intern(&lf[112],5,"null\077");
lf[113]=C_h_intern(&lf[113],6,"char=\077");
lf[114]=C_h_intern(&lf[114],8,"string=\077");
lf[115]=C_h_intern(&lf[115],16,"char-alphabetic\077");
lf[116]=C_h_intern(&lf[116],10,"string-ref");
lf[117]=C_h_intern(&lf[117],18,"string-intersperse");
lf[118]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[119]=C_h_intern(&lf[119],17,"current-user-name");
lf[120]=C_h_intern(&lf[120],9,"condition");
lf[121]=C_decode_literal(C_heaptop,"\376B\000\000\003c:\134");
lf[122]=C_h_intern(&lf[122],22,"with-exception-handler");
lf[123]=C_h_intern(&lf[123],30,"call-with-current-continuation");
lf[124]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[125]=C_h_intern(&lf[125],7,"reverse");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[127]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[130]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[131]=C_decode_literal(C_heaptop,"\376B\000\000\027Documents and Settings\134");
lf[132]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[133]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[134]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[135]=C_h_intern(&lf[135],5,"\000text");
lf[136]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[137]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[138]=C_h_intern(&lf[138],13,"\003sysmake-port");
lf[139]=C_h_intern(&lf[139],21,"\003sysstream-port-class");
lf[140]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[141]=C_h_intern(&lf[141],15,"open-input-pipe");
lf[142]=C_h_intern(&lf[142],7,"\000binary");
lf[143]=C_h_intern(&lf[143],16,"open-output-pipe");
lf[144]=C_h_intern(&lf[144],16,"close-input-pipe");
lf[145]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[146]=C_h_intern(&lf[146],14,"\003syscheck-port");
lf[147]=C_h_intern(&lf[147],17,"close-output-pipe");
lf[148]=C_h_intern(&lf[148],20,"call-with-input-pipe");
lf[149]=C_h_intern(&lf[149],21,"call-with-output-pipe");
lf[150]=C_h_intern(&lf[150],20,"with-input-from-pipe");
lf[151]=C_h_intern(&lf[151],18,"\003sysstandard-input");
lf[152]=C_h_intern(&lf[152],19,"with-output-to-pipe");
lf[153]=C_h_intern(&lf[153],19,"\003sysstandard-output");
lf[154]=C_h_intern(&lf[154],11,"create-pipe");
lf[155]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[156]=C_h_intern(&lf[156],11,"signal/term");
lf[157]=C_h_intern(&lf[157],10,"signal/int");
lf[158]=C_h_intern(&lf[158],10,"signal/fpe");
lf[159]=C_h_intern(&lf[159],10,"signal/ill");
lf[160]=C_h_intern(&lf[160],11,"signal/segv");
lf[161]=C_h_intern(&lf[161],11,"signal/abrt");
lf[162]=C_h_intern(&lf[162],12,"signal/break");
lf[163]=C_h_intern(&lf[163],11,"signal/alrm");
lf[164]=C_h_intern(&lf[164],11,"signal/chld");
lf[165]=C_h_intern(&lf[165],11,"signal/cont");
lf[166]=C_h_intern(&lf[166],10,"signal/hup");
lf[167]=C_h_intern(&lf[167],9,"signal/io");
lf[168]=C_h_intern(&lf[168],11,"signal/kill");
lf[169]=C_h_intern(&lf[169],11,"signal/pipe");
lf[170]=C_h_intern(&lf[170],11,"signal/prof");
lf[171]=C_h_intern(&lf[171],11,"signal/quit");
lf[172]=C_h_intern(&lf[172],11,"signal/stop");
lf[173]=C_h_intern(&lf[173],11,"signal/trap");
lf[174]=C_h_intern(&lf[174],11,"signal/tstp");
lf[175]=C_h_intern(&lf[175],10,"signal/urg");
lf[176]=C_h_intern(&lf[176],11,"signal/usr1");
lf[177]=C_h_intern(&lf[177],11,"signal/usr2");
lf[178]=C_h_intern(&lf[178],13,"signal/vtalrm");
lf[179]=C_h_intern(&lf[179],12,"signal/winch");
lf[180]=C_h_intern(&lf[180],11,"signal/xcpu");
lf[181]=C_h_intern(&lf[181],11,"signal/xfsz");
lf[182]=C_h_intern(&lf[182],12,"signals-list");
lf[183]=C_h_intern(&lf[183],18,"\003sysinterrupt-hook");
lf[184]=C_h_intern(&lf[184],14,"signal-handler");
lf[185]=C_h_intern(&lf[185],19,"set-signal-handler!");
lf[186]=C_h_intern(&lf[186],10,"errno/perm");
lf[187]=C_h_intern(&lf[187],11,"errno/noent");
lf[188]=C_h_intern(&lf[188],10,"errno/srch");
lf[189]=C_h_intern(&lf[189],10,"errno/intr");
lf[190]=C_h_intern(&lf[190],8,"errno/io");
lf[191]=C_h_intern(&lf[191],12,"errno/noexec");
lf[192]=C_h_intern(&lf[192],10,"errno/badf");
lf[193]=C_h_intern(&lf[193],11,"errno/child");
lf[194]=C_h_intern(&lf[194],11,"errno/nomem");
lf[195]=C_h_intern(&lf[195],11,"errno/acces");
lf[196]=C_h_intern(&lf[196],11,"errno/fault");
lf[197]=C_h_intern(&lf[197],10,"errno/busy");
lf[198]=C_h_intern(&lf[198],11,"errno/exist");
lf[199]=C_h_intern(&lf[199],12,"errno/notdir");
lf[200]=C_h_intern(&lf[200],11,"errno/isdir");
lf[201]=C_h_intern(&lf[201],11,"errno/inval");
lf[202]=C_h_intern(&lf[202],11,"errno/mfile");
lf[203]=C_h_intern(&lf[203],11,"errno/nospc");
lf[204]=C_h_intern(&lf[204],11,"errno/spipe");
lf[205]=C_h_intern(&lf[205],10,"errno/pipe");
lf[206]=C_h_intern(&lf[206],11,"errno/again");
lf[207]=C_h_intern(&lf[207],10,"errno/rofs");
lf[208]=C_h_intern(&lf[208],10,"errno/nxio");
lf[209]=C_h_intern(&lf[209],10,"errno/2big");
lf[210]=C_h_intern(&lf[210],10,"errno/xdev");
lf[211]=C_h_intern(&lf[211],11,"errno/nodev");
lf[212]=C_h_intern(&lf[212],11,"errno/nfile");
lf[213]=C_h_intern(&lf[213],11,"errno/notty");
lf[214]=C_h_intern(&lf[214],10,"errno/fbig");
lf[215]=C_h_intern(&lf[215],11,"errno/mlink");
lf[216]=C_h_intern(&lf[216],9,"errno/dom");
lf[217]=C_h_intern(&lf[217],11,"errno/range");
lf[218]=C_h_intern(&lf[218],12,"errno/deadlk");
lf[219]=C_h_intern(&lf[219],17,"errno/nametoolong");
lf[220]=C_h_intern(&lf[220],11,"errno/nolck");
lf[221]=C_h_intern(&lf[221],11,"errno/nosys");
lf[222]=C_h_intern(&lf[222],14,"errno/notempty");
lf[223]=C_h_intern(&lf[223],11,"errno/ilseq");
lf[224]=C_h_intern(&lf[224],16,"change-file-mode");
lf[225]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[226]=C_h_intern(&lf[226],17,"file-read-access\077");
lf[227]=C_h_intern(&lf[227],18,"file-write-access\077");
lf[228]=C_h_intern(&lf[228],20,"file-execute-access\077");
lf[229]=C_h_intern(&lf[229],12,"fileno/stdin");
lf[230]=C_h_intern(&lf[230],13,"fileno/stdout");
lf[231]=C_h_intern(&lf[231],13,"fileno/stderr");
lf[232]=C_h_intern(&lf[232],7,"\000append");
lf[233]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[237]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[239]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[240]=C_h_intern(&lf[240],16,"open-input-file*");
lf[241]=C_h_intern(&lf[241],17,"open-output-file*");
lf[242]=C_h_intern(&lf[242],12,"port->fileno");
lf[243]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[244]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[245]=C_h_intern(&lf[245],25,"\003syspeek-unsigned-integer");
lf[246]=C_h_intern(&lf[246],16,"duplicate-fileno");
lf[247]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[248]=C_h_intern(&lf[248],6,"setenv");
lf[249]=C_h_intern(&lf[249],8,"unsetenv");
lf[250]=C_h_intern(&lf[250],9,"substring");
lf[251]=C_h_intern(&lf[251],19,"current-environment");
lf[252]=C_h_intern(&lf[252],19,"seconds->local-time");
lf[253]=C_h_intern(&lf[253],18,"\003sysdecode-seconds");
lf[254]=C_h_intern(&lf[254],17,"seconds->utc-time");
lf[255]=C_h_intern(&lf[255],15,"seconds->string");
lf[256]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[257]=C_h_intern(&lf[257],12,"time->string");
lf[258]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[259]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[260]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[261]=C_h_intern(&lf[261],19,"local-time->seconds");
lf[262]=C_h_intern(&lf[262],15,"\003syscons-flonum");
lf[263]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[264]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[265]=C_h_intern(&lf[265],27,"local-timezone-abbreviation");
lf[266]=C_h_intern(&lf[266],5,"_exit");
lf[267]=C_h_intern(&lf[267],19,"set-buffering-mode!");
lf[268]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[269]=C_h_intern(&lf[269],5,"\000full");
lf[270]=C_h_intern(&lf[270],5,"\000line");
lf[271]=C_h_intern(&lf[271],5,"\000none");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[273]=C_h_intern(&lf[273],6,"regexp");
lf[274]=C_h_intern(&lf[274],21,"make-anchored-pattern");
lf[275]=C_h_intern(&lf[275],12,"string-match");
lf[276]=C_h_intern(&lf[276],12,"glob->regexp");
lf[277]=C_h_intern(&lf[277],13,"make-pathname");
lf[278]=C_h_intern(&lf[278],18,"decompose-pathname");
lf[279]=C_h_intern(&lf[279],4,"glob");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[281]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[282]=C_h_intern(&lf[282],13,"spawn/overlay");
lf[283]=C_h_intern(&lf[283],10,"spawn/wait");
lf[284]=C_h_intern(&lf[284],12,"spawn/nowait");
lf[285]=C_h_intern(&lf[285],13,"spawn/nowaito");
lf[286]=C_h_intern(&lf[286],12,"spawn/detach");
lf[287]=C_h_intern(&lf[287],16,"char-whitespace\077");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[290]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[291]=C_h_intern(&lf[291],24,"pathname-strip-directory");
lf[294]=C_h_intern(&lf[294],15,"process-execute");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[296]=C_h_intern(&lf[296],13,"process-spawn");
lf[297]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[298]=C_h_intern(&lf[298],18,"current-process-id");
lf[299]=C_h_intern(&lf[299],17,"\003sysshell-command");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[301]=C_h_intern(&lf[301],6,"getenv");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[303]=C_h_intern(&lf[303],27,"\003sysshell-command-arguments");
lf[304]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[305]=C_h_intern(&lf[305],11,"process-run");
lf[307]=C_h_intern(&lf[307],11,"\003sysprocess");
lf[308]=C_h_intern(&lf[308],14,"\000process-error");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[310]=C_h_intern(&lf[310],17,"\003sysmake-locative");
lf[311]=C_h_intern(&lf[311],8,"location");
lf[312]=C_h_intern(&lf[312],7,"process");
lf[313]=C_h_intern(&lf[313],8,"process*");
lf[314]=C_h_intern(&lf[314],16,"\003sysprocess-wait");
lf[315]=C_h_intern(&lf[315],12,"process-wait");
lf[316]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[317]=C_h_intern(&lf[317],5,"sleep");
lf[318]=C_h_intern(&lf[318],13,"get-host-name");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[320]=C_h_intern(&lf[320],18,"system-information");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[324]=C_h_intern(&lf[324],10,"find-files");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[327]=C_h_intern(&lf[327],19,"\003sysundefined-value");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[329]=C_h_intern(&lf[329],16,"\003sysdynamic-wind");
lf[330]=C_h_intern(&lf[330],13,"pathname-file");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[332]=C_h_intern(&lf[332],17,"change-file-owner");
lf[333]=C_h_intern(&lf[333],5,"error");
lf[334]=C_h_intern(&lf[334],11,"create-fifo");
lf[335]=C_h_intern(&lf[335],14,"create-session");
lf[336]=C_h_intern(&lf[336],20,"create-symbolic-link");
lf[337]=C_h_intern(&lf[337],26,"current-effective-group-id");
lf[338]=C_h_intern(&lf[338],25,"current-effective-user-id");
lf[339]=C_h_intern(&lf[339],27,"current-effective-user-name");
lf[340]=C_h_intern(&lf[340],16,"current-group-id");
lf[341]=C_h_intern(&lf[341],15,"current-user-id");
lf[342]=C_h_intern(&lf[342],18,"map-file-to-memory");
lf[343]=C_h_intern(&lf[343],9,"file-link");
lf[344]=C_h_intern(&lf[344],9,"file-lock");
lf[345]=C_h_intern(&lf[345],18,"file-lock/blocking");
lf[346]=C_h_intern(&lf[346],11,"file-select");
lf[347]=C_h_intern(&lf[347],14,"file-test-lock");
lf[348]=C_h_intern(&lf[348],13,"file-truncate");
lf[349]=C_h_intern(&lf[349],11,"file-unlock");
lf[350]=C_h_intern(&lf[350],10,"get-groups");
lf[351]=C_h_intern(&lf[351],17,"group-information");
lf[352]=C_h_intern(&lf[352],17,"initialize-groups");
lf[353]=C_h_intern(&lf[353],26,"memory-mapped-file-pointer");
lf[354]=C_h_intern(&lf[354],17,"parent-process-id");
lf[355]=C_h_intern(&lf[355],12,"process-fork");
lf[356]=C_h_intern(&lf[356],16,"process-group-id");
lf[357]=C_h_intern(&lf[357],14,"process-signal");
lf[358]=C_h_intern(&lf[358],18,"read-symbolic-link");
lf[359]=C_h_intern(&lf[359],10,"set-alarm!");
lf[360]=C_h_intern(&lf[360],13,"set-group-id!");
lf[361]=C_h_intern(&lf[361],11,"set-groups!");
lf[362]=C_h_intern(&lf[362],21,"set-process-group-id!");
lf[363]=C_h_intern(&lf[363],19,"set-root-directory!");
lf[364]=C_h_intern(&lf[364],16,"set-signal-mask!");
lf[365]=C_h_intern(&lf[365],12,"set-user-id!");
lf[366]=C_h_intern(&lf[366],11,"signal-mask");
lf[367]=C_h_intern(&lf[367],12,"signal-mask!");
lf[368]=C_h_intern(&lf[368],14,"signal-masked\077");
lf[369]=C_h_intern(&lf[369],14,"signal-unmask!");
lf[370]=C_h_intern(&lf[370],13,"terminal-name");
lf[371]=C_h_intern(&lf[371],14,"terminal-port\077");
lf[372]=C_h_intern(&lf[372],13,"terminal-size");
lf[373]=C_h_intern(&lf[373],22,"unmap-file-from-memory");
lf[374]=C_h_intern(&lf[374],16,"user-information");
lf[375]=C_h_intern(&lf[375],17,"utc-time->seconds");
lf[376]=C_h_intern(&lf[376],12,"string->time");
lf[377]=C_h_intern(&lf[377],16,"errno/wouldblock");
lf[378]=C_h_intern(&lf[378],5,"fifo\077");
lf[379]=C_h_intern(&lf[379],19,"memory-mapped-file\077");
lf[380]=C_h_intern(&lf[380],13,"map/anonymous");
lf[381]=C_h_intern(&lf[381],8,"map/file");
lf[382]=C_h_intern(&lf[382],9,"map/fixed");
lf[383]=C_h_intern(&lf[383],11,"map/private");
lf[384]=C_h_intern(&lf[384],10,"map/shared");
lf[385]=C_h_intern(&lf[385],10,"open/fsync");
lf[386]=C_h_intern(&lf[386],11,"open/noctty");
lf[387]=C_h_intern(&lf[387],13,"open/nonblock");
lf[388]=C_h_intern(&lf[388],9,"open/sync");
lf[389]=C_h_intern(&lf[389],10,"perm/isgid");
lf[390]=C_h_intern(&lf[390],10,"perm/isuid");
lf[391]=C_h_intern(&lf[391],10,"perm/isvtx");
lf[392]=C_h_intern(&lf[392],9,"prot/exec");
lf[393]=C_h_intern(&lf[393],9,"prot/none");
lf[394]=C_h_intern(&lf[394],9,"prot/read");
lf[395]=C_h_intern(&lf[395],10,"prot/write");
lf[396]=C_h_intern(&lf[396],11,"make-vector");
lf[397]=C_h_intern(&lf[397],17,"register-feature!");
lf[398]=C_h_intern(&lf[398],5,"posix");
C_register_lf2(lf,399,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=C_mutate(&lf[2],lf[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1162,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t4);}

/* k1160 */
static void C_ccall f_1162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1162,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1165,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1163 in k1160 */
static void C_ccall f_1165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1165,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1168,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1166 in k1163 in k1160 */
static void C_ccall f_1168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1168,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1171,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1171,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1174,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 944  register-feature! */
t3=*((C_word*)lf[397]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[398]);}

/* k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word ab[63],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1174,2,t0,t1);}
t2=*((C_word*)lf[4]+1);
t3=C_mutate(&lf[5],(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1186,a[2]=t2,a[3]=((C_word)li0),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[10]+1,lf[5]);
t5=C_mutate((C_word*)lf[11]+1,C_fix((C_word)PIPE_BUF));
t6=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_RDONLY));
t7=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_WRONLY));
t11=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_APPEND));
t13=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_EXCL));
t14=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_TRUNC));
t15=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_BINARY));
t16=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_TEXT));
t17=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_NOINHERIT));
t18=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[30]+1,C_fix((C_word)S_IREAD));
t25=C_mutate((C_word*)lf[31]+1,C_fix((C_word)S_IWRITE));
t26=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IEXEC));
t27=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=(C_word)C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=C_mutate((C_word*)lf[36]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1232,a[2]=t31,a[3]=((C_word)li1),tmp=(C_word)a,a+=4,tmp));
t33=C_mutate((C_word*)lf[41]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1273,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t34=*((C_word*)lf[43]+1);
t35=C_mutate((C_word*)lf[44]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1291,a[2]=t34,a[3]=((C_word)li3),tmp=(C_word)a,a+=4,tmp));
t36=C_mutate((C_word*)lf[48]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1336,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t37=*((C_word*)lf[51]+1);
t38=C_mutate((C_word*)lf[52]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1378,a[2]=t37,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp));
t39=C_mutate((C_word*)lf[55]+1,C_fix((C_word)SEEK_SET));
t40=C_mutate((C_word*)lf[56]+1,C_fix((C_word)SEEK_END));
t41=C_mutate((C_word*)lf[57]+1,C_fix((C_word)SEEK_CUR));
t42=C_mutate(&lf[58],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1416,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[61]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1454,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[63]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1485,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[64]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1491,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[65]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1497,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[66]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1503,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[67]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1509,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1515,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[69]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1521,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[71]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1544,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1549,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[72]+1,*((C_word*)lf[69]+1));
t54=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1560,a[2]=t52,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1129 stat-type */
f_1549(t54,lf[73]);}

/* k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1560,2,t0,t1);}
t2=C_mutate((C_word*)lf[73]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1564,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1130 stat-type */
f_1549(t3,lf[74]);}

/* k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1564,2,t0,t1);}
t2=C_mutate((C_word*)lf[74]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1568,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1131 stat-type */
f_1549(t3,lf[75]);}

/* k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1568(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1568,2,t0,t1);}
t2=C_mutate((C_word*)lf[75]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1572,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1132 stat-type */
f_1549(t3,lf[76]);}

/* k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1572(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1572,2,t0,t1);}
t2=C_mutate((C_word*)lf[76]+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1576,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1133 stat-type */
f_1549(t3,lf[77]);}

/* k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1576,2,t0,t1);}
t2=C_mutate((C_word*)lf[77]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1580,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1134 stat-type */
f_1549(t3,lf[78]);}

/* k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word ab[121],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1580,2,t0,t1);}
t2=C_mutate((C_word*)lf[78]+1,t1);
t3=C_mutate((C_word*)lf[79]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1582,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1622,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[89]+1,lf[90]);
t6=C_mutate((C_word*)lf[91]+1,lf[92]);
t7=C_mutate((C_word*)lf[93]+1,lf[94]);
t8=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1686,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[100]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1799,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[102]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1826,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t11=*((C_word*)lf[4]+1);
t12=*((C_word*)lf[43]+1);
t13=*((C_word*)lf[104]+1);
t14=C_mutate((C_word*)lf[105]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1853,a[2]=t12,a[3]=((C_word)li28),tmp=(C_word)a,a+=4,tmp));
t15=C_mutate((C_word*)lf[109]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2013,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t16=*((C_word*)lf[43]+1);
t17=C_mutate((C_word*)lf[108]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2040,a[2]=t16,a[3]=((C_word)li30),tmp=(C_word)a,a+=4,tmp));
t18=*((C_word*)lf[112]+1);
t19=*((C_word*)lf[113]+1);
t20=*((C_word*)lf[114]+1);
t21=*((C_word*)lf[115]+1);
t22=*((C_word*)lf[116]+1);
t23=*((C_word*)lf[4]+1);
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2091,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp);
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2096,a[2]=((C_word)li32),tmp=(C_word)a,a+=3,tmp);
t26=*((C_word*)lf[119]+1);
t27=*((C_word*)lf[108]+1);
t28=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2107,a[2]=t27,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp);
t29=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2163,a[2]=t21,a[3]=t19,a[4]=t26,a[5]=t28,a[6]=t20,a[7]=t18,a[8]=t22,a[9]=t24,a[10]=t23,a[11]=t25,a[12]=((C_word)li42),tmp=(C_word)a,a+=13,tmp));
t30=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2520,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
t31=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2532,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp);
t32=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2538,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
t33=C_mutate((C_word*)lf[141]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2556,a[2]=t31,a[3]=t32,a[4]=t30,a[5]=((C_word)li46),tmp=(C_word)a,a+=6,tmp));
t34=C_mutate((C_word*)lf[143]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2592,a[2]=t31,a[3]=t32,a[4]=t30,a[5]=((C_word)li47),tmp=(C_word)a,a+=6,tmp));
t35=C_mutate((C_word*)lf[144]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2628,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[147]+1,*((C_word*)lf[144]+1));
t37=*((C_word*)lf[141]+1);
t38=*((C_word*)lf[143]+1);
t39=*((C_word*)lf[144]+1);
t40=*((C_word*)lf[147]+1);
t41=C_mutate((C_word*)lf[148]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2647,a[2]=t37,a[3]=t39,a[4]=((C_word)li51),tmp=(C_word)a,a+=5,tmp));
t42=C_mutate((C_word*)lf[149]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2671,a[2]=t38,a[3]=t40,a[4]=((C_word)li54),tmp=(C_word)a,a+=5,tmp));
t43=C_mutate((C_word*)lf[150]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2695,a[2]=t37,a[3]=t39,a[4]=((C_word)li56),tmp=(C_word)a,a+=5,tmp));
t44=C_mutate((C_word*)lf[152]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2715,a[2]=t38,a[3]=t40,a[4]=((C_word)li58),tmp=(C_word)a,a+=5,tmp));
t45=C_mutate((C_word*)lf[154]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2735,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[156]+1,C_fix((C_word)SIGTERM));
t47=C_mutate((C_word*)lf[157]+1,C_fix((C_word)SIGINT));
t48=C_mutate((C_word*)lf[158]+1,C_fix((C_word)SIGFPE));
t49=C_mutate((C_word*)lf[159]+1,C_fix((C_word)SIGILL));
t50=C_mutate((C_word*)lf[160]+1,C_fix((C_word)SIGSEGV));
t51=C_mutate((C_word*)lf[161]+1,C_fix((C_word)SIGABRT));
t52=C_mutate((C_word*)lf[162]+1,C_fix((C_word)SIGBREAK));
t53=C_set_block_item(lf[163],0,C_fix(0));
t54=C_set_block_item(lf[164],0,C_fix(0));
t55=C_set_block_item(lf[165],0,C_fix(0));
t56=C_set_block_item(lf[166],0,C_fix(0));
t57=C_set_block_item(lf[167],0,C_fix(0));
t58=C_set_block_item(lf[168],0,C_fix(0));
t59=C_set_block_item(lf[169],0,C_fix(0));
t60=C_set_block_item(lf[170],0,C_fix(0));
t61=C_set_block_item(lf[171],0,C_fix(0));
t62=C_set_block_item(lf[172],0,C_fix(0));
t63=C_set_block_item(lf[173],0,C_fix(0));
t64=C_set_block_item(lf[174],0,C_fix(0));
t65=C_set_block_item(lf[175],0,C_fix(0));
t66=C_set_block_item(lf[176],0,C_fix(0));
t67=C_set_block_item(lf[177],0,C_fix(0));
t68=C_set_block_item(lf[178],0,C_fix(0));
t69=C_set_block_item(lf[179],0,C_fix(0));
t70=C_set_block_item(lf[180],0,C_fix(0));
t71=C_set_block_item(lf[181],0,C_fix(0));
t72=(C_word)C_a_i_list(&a,7,*((C_word*)lf[156]+1),*((C_word*)lf[157]+1),*((C_word*)lf[158]+1),*((C_word*)lf[159]+1),*((C_word*)lf[160]+1),*((C_word*)lf[161]+1),*((C_word*)lf[162]+1));
t73=C_mutate((C_word*)lf[182]+1,t72);
t74=*((C_word*)lf[183]+1);
t75=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2809,a[2]=((C_word*)t0)[2],a[3]=t74,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1482 make-vector */
t76=*((C_word*)lf[396]+1);
((C_proc4)(void*)(*((C_word*)t76+1)))(4,t76,t75,C_fix(256),C_SCHEME_FALSE);}

/* k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word ab[322],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2809,2,t0,t1);}
t2=C_mutate((C_word*)lf[184]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2811,a[2]=t1,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[185]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2820,a[2]=t1,a[3]=((C_word)li61),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[183]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2833,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li62),tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[186]+1,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[187]+1,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[188]+1,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[189]+1,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[190]+1,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[191]+1,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[193]+1,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[194]+1,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[195]+1,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[196]+1,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[197]+1,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[198]+1,C_fix((C_word)EEXIST));
t18=C_mutate((C_word*)lf[199]+1,C_fix((C_word)ENOTDIR));
t19=C_mutate((C_word*)lf[200]+1,C_fix((C_word)EISDIR));
t20=C_mutate((C_word*)lf[201]+1,C_fix((C_word)EINVAL));
t21=C_mutate((C_word*)lf[202]+1,C_fix((C_word)EMFILE));
t22=C_mutate((C_word*)lf[203]+1,C_fix((C_word)ENOSPC));
t23=C_mutate((C_word*)lf[204]+1,C_fix((C_word)ESPIPE));
t24=C_mutate((C_word*)lf[205]+1,C_fix((C_word)EPIPE));
t25=C_mutate((C_word*)lf[206]+1,C_fix((C_word)EAGAIN));
t26=C_mutate((C_word*)lf[207]+1,C_fix((C_word)EROFS));
t27=C_mutate((C_word*)lf[208]+1,C_fix((C_word)ENXIO));
t28=C_mutate((C_word*)lf[209]+1,C_fix((C_word)E2BIG));
t29=C_mutate((C_word*)lf[210]+1,C_fix((C_word)EXDEV));
t30=C_mutate((C_word*)lf[211]+1,C_fix((C_word)ENODEV));
t31=C_mutate((C_word*)lf[212]+1,C_fix((C_word)ENFILE));
t32=C_mutate((C_word*)lf[213]+1,C_fix((C_word)ENOTTY));
t33=C_mutate((C_word*)lf[214]+1,C_fix((C_word)EFBIG));
t34=C_mutate((C_word*)lf[215]+1,C_fix((C_word)EMLINK));
t35=C_mutate((C_word*)lf[216]+1,C_fix((C_word)EDOM));
t36=C_mutate((C_word*)lf[217]+1,C_fix((C_word)ERANGE));
t37=C_mutate((C_word*)lf[218]+1,C_fix((C_word)EDEADLK));
t38=C_mutate((C_word*)lf[219]+1,C_fix((C_word)ENAMETOOLONG));
t39=C_mutate((C_word*)lf[220]+1,C_fix((C_word)ENOLCK));
t40=C_mutate((C_word*)lf[221]+1,C_fix((C_word)ENOSYS));
t41=C_mutate((C_word*)lf[222]+1,C_fix((C_word)ENOTEMPTY));
t42=C_mutate((C_word*)lf[223]+1,C_fix((C_word)EILSEQ));
t43=C_mutate((C_word*)lf[224]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2889,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2919,a[2]=((C_word)li64),tmp=(C_word)a,a+=3,tmp);
t45=C_mutate((C_word*)lf[226]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2943,a[2]=t44,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp));
t46=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2949,a[2]=t44,a[3]=((C_word)li66),tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[228]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2955,a[2]=t44,a[3]=((C_word)li67),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate((C_word*)lf[229]+1,C_fix((C_word)0));
t49=C_mutate((C_word*)lf[230]+1,C_fix((C_word)1));
t50=C_mutate((C_word*)lf[231]+1,C_fix((C_word)2));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2964,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp);
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3001,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp);
t53=C_mutate((C_word*)lf[240]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3019,a[2]=t51,a[3]=t52,a[4]=((C_word)li70),tmp=(C_word)a,a+=5,tmp));
t54=C_mutate((C_word*)lf[241]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3033,a[2]=t51,a[3]=t52,a[4]=((C_word)li71),tmp=(C_word)a,a+=5,tmp));
t55=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3047,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[246]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3082,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[248]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3112,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[249]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3129,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp));
t59=*((C_word*)lf[250]+1);
t60=C_mutate((C_word*)lf[251]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3149,a[2]=t59,a[3]=((C_word)li78),tmp=(C_word)a,a+=4,tmp));
t61=C_mutate((C_word*)lf[252]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3214,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[254]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3223,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[255]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3242,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[257]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3275,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[261]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3355,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[265]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3383,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[266]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3395,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[267]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3411,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t69=*((C_word*)lf[273]+1);
t70=*((C_word*)lf[274]+1);
t71=*((C_word*)lf[275]+1);
t72=*((C_word*)lf[276]+1);
t73=*((C_word*)lf[105]+1);
t74=*((C_word*)lf[277]+1);
t75=*((C_word*)lf[278]+1);
t76=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3470,a[2]=t72,a[3]=t70,a[4]=t69,a[5]=t73,a[6]=t71,a[7]=t74,a[8]=t75,a[9]=((C_word)li91),tmp=(C_word)a,a+=10,tmp));
t77=C_mutate((C_word*)lf[282]+1,C_fix((C_word)P_OVERLAY));
t78=C_mutate((C_word*)lf[283]+1,C_fix((C_word)P_WAIT));
t79=C_mutate((C_word*)lf[284]+1,C_fix((C_word)P_NOWAIT));
t80=C_mutate((C_word*)lf[285]+1,C_fix((C_word)P_NOWAITO));
t81=C_mutate((C_word*)lf[286]+1,C_fix((C_word)P_DETACH));
t82=*((C_word*)lf[287]+1);
t83=*((C_word*)lf[51]+1);
t84=*((C_word*)lf[116]+1);
t85=*((C_word*)lf[4]+1);
t86=C_mutate(&lf[288],(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3585,a[2]=t85,a[3]=t83,a[4]=t84,a[5]=t82,a[6]=((C_word)li95),tmp=(C_word)a,a+=7,tmp));
t87=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3664,a[2]=((C_word)li96),tmp=(C_word)a,a+=3,tmp);
t88=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3681,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp);
t89=*((C_word*)lf[291]+1);
t90=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3698,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp);
t91=C_mutate(&lf[292],(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3748,a[2]=t89,a[3]=t87,a[4]=t88,a[5]=t90,a[6]=((C_word)li100),tmp=(C_word)a,a+=7,tmp));
t92=C_mutate(&lf[293],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3781,a[2]=((C_word)li101),tmp=(C_word)a,a+=3,tmp));
t93=C_mutate((C_word*)lf[294]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3796,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t94=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3883,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[298]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3970,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3973,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[303]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3994,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t98=*((C_word*)lf[296]+1);
t99=*((C_word*)lf[301]+1);
t100=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4000,a[2]=t98,a[3]=((C_word)li115),tmp=(C_word)a,a+=4,tmp));
t101=C_mutate(&lf[306],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4029,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[307]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4095,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t103=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4214,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp);
t104=C_mutate((C_word*)lf[312]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4276,a[2]=t103,a[3]=((C_word)li127),tmp=(C_word)a,a+=4,tmp));
t105=C_mutate((C_word*)lf[313]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4356,a[2]=t103,a[3]=((C_word)li132),tmp=(C_word)a,a+=4,tmp));
t106=C_mutate((C_word*)lf[314]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4436,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[315]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4448,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[317]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4508,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[318]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4511,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[320]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4523,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4554,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t112=*((C_word*)lf[279]+1);
t113=*((C_word*)lf[275]+1);
t114=*((C_word*)lf[277]+1);
t115=*((C_word*)lf[109]+1);
t116=C_mutate((C_word*)lf[324]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4569,a[2]=t115,a[3]=t114,a[4]=t112,a[5]=t113,a[6]=((C_word)li153),tmp=(C_word)a,a+=7,tmp));
t117=C_mutate((C_word*)lf[332]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4795,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t118=C_mutate((C_word*)lf[334]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4801,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[335]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4807,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[336]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4813,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[337]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4819,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[338]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4825,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4831,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[340]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4837,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[341]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4843,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[342]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4849,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[343]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4855,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[344]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4861,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[345]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4867,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[346]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4873,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[347]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4879,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[348]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4885,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[349]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4891,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[350]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4897,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[351]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4903,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4909,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[353]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4915,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[354]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4921,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[355]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4927,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4933,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[357]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4939,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[358]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4945,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[359]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4951,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[360]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4957,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[361]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4963,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[362]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4969,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[363]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4975,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[364]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4981,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[365]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4987,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[366]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4993,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[367]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4999,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[368]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5005,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[369]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5011,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[370]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5017,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[371]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5023,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[372]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5029,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[373]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5035,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[374]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5041,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[375]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5047,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate((C_word*)lf[376]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5053,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t161=C_set_block_item(lf[377],0,C_fix(0));
t162=C_mutate((C_word*)lf[378]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5060,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[379]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5063,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t164=C_set_block_item(lf[380],0,C_fix(0));
t165=C_set_block_item(lf[381],0,C_fix(0));
t166=C_set_block_item(lf[382],0,C_fix(0));
t167=C_set_block_item(lf[383],0,C_fix(0));
t168=C_set_block_item(lf[384],0,C_fix(0));
t169=C_set_block_item(lf[385],0,C_fix(0));
t170=C_set_block_item(lf[386],0,C_fix(0));
t171=C_set_block_item(lf[387],0,C_fix(0));
t172=C_set_block_item(lf[388],0,C_fix(0));
t173=C_set_block_item(lf[389],0,C_fix(0));
t174=C_set_block_item(lf[390],0,C_fix(0));
t175=C_set_block_item(lf[391],0,C_fix(0));
t176=C_set_block_item(lf[392],0,C_fix(0));
t177=C_set_block_item(lf[393],0,C_fix(0));
t178=C_set_block_item(lf[394],0,C_fix(0));
t179=C_set_block_item(lf[395],0,C_fix(0));
t180=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t180+1)))(2,t180,C_SCHEME_UNDEFINED);}

/* memory-mapped-file? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5063(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5063,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* fifo? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5060(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5060,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* string->time in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5053(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5053,2,t0,t1);}
/* posixwin.scm: 2124 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[376],lf[0]);}

/* utc-time->seconds in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5047(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5047,2,t0,t1);}
/* posixwin.scm: 2123 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[375],lf[0]);}

/* user-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5041(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5041,2,t0,t1);}
/* posixwin.scm: 2122 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[374],lf[0]);}

/* unmap-file-from-memory in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5035(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5035,2,t0,t1);}
/* posixwin.scm: 2121 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[373],lf[0]);}

/* terminal-size in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5029(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5029,2,t0,t1);}
/* posixwin.scm: 2120 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[372],lf[0]);}

/* terminal-port? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5023(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5023,2,t0,t1);}
/* posixwin.scm: 2119 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* terminal-name in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5017(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5017,2,t0,t1);}
/* posixwin.scm: 2118 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* signal-unmask! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5011(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5011,2,t0,t1);}
/* posixwin.scm: 2117 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* signal-masked? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_5005(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5005,2,t0,t1);}
/* posixwin.scm: 2116 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* signal-mask! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4999(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4999,2,t0,t1);}
/* posixwin.scm: 2115 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* signal-mask in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4993(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4993,2,t0,t1);}
/* posixwin.scm: 2114 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* set-user-id! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4987(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4987,2,t0,t1);}
/* posixwin.scm: 2113 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* set-signal-mask! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4981(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4981,2,t0,t1);}
/* posixwin.scm: 2112 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* set-root-directory! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4975(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4975,2,t0,t1);}
/* posixwin.scm: 2111 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* set-process-group-id! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4969(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4969,2,t0,t1);}
/* posixwin.scm: 2110 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* set-groups! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4963(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4963,2,t0,t1);}
/* posixwin.scm: 2109 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* set-group-id! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4957(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4957,2,t0,t1);}
/* posixwin.scm: 2108 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* set-alarm! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4951(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4951,2,t0,t1);}
/* posixwin.scm: 2107 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* read-symbolic-link in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4945(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4945,2,t0,t1);}
/* posixwin.scm: 2106 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* process-signal in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4939(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4939,2,t0,t1);}
/* posixwin.scm: 2105 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* process-group-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4933(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4933,2,t0,t1);}
/* posixwin.scm: 2104 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* process-fork in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4927(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4927,2,t0,t1);}
/* posixwin.scm: 2103 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* parent-process-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4921(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4921,2,t0,t1);}
/* posixwin.scm: 2102 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* memory-mapped-file-pointer in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4915(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4915,2,t0,t1);}
/* posixwin.scm: 2101 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* initialize-groups in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4909(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4909,2,t0,t1);}
/* posixwin.scm: 2100 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* group-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4903(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4903,2,t0,t1);}
/* posixwin.scm: 2099 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* get-groups in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4897(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4897,2,t0,t1);}
/* posixwin.scm: 2098 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* file-unlock in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4891(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4891,2,t0,t1);}
/* posixwin.scm: 2097 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[349],lf[0]);}

/* file-truncate in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4885(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4885,2,t0,t1);}
/* posixwin.scm: 2096 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* file-test-lock in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4879(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4879,2,t0,t1);}
/* posixwin.scm: 2095 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[347],lf[0]);}

/* file-select in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4873(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4873,2,t0,t1);}
/* posixwin.scm: 2094 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[346],lf[0]);}

/* file-lock/blocking in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4867(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4867,2,t0,t1);}
/* posixwin.scm: 2093 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[345],lf[0]);}

/* file-lock in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4861(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4861,2,t0,t1);}
/* posixwin.scm: 2092 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[344],lf[0]);}

/* file-link in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4855(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4855,2,t0,t1);}
/* posixwin.scm: 2091 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[343],lf[0]);}

/* map-file-to-memory in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4849(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4849,2,t0,t1);}
/* posixwin.scm: 2090 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[342],lf[0]);}

/* current-user-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4843(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4843,2,t0,t1);}
/* posixwin.scm: 2089 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[341],lf[0]);}

/* current-group-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4837(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4837,2,t0,t1);}
/* posixwin.scm: 2088 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[340],lf[0]);}

/* current-effective-user-name in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4831(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4831,2,t0,t1);}
/* posixwin.scm: 2087 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[339],lf[0]);}

/* current-effective-user-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4825(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4825,2,t0,t1);}
/* posixwin.scm: 2086 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[338],lf[0]);}

/* current-effective-group-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4819(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4819,2,t0,t1);}
/* posixwin.scm: 2085 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[337],lf[0]);}

/* create-symbolic-link in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4813(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4813,2,t0,t1);}
/* posixwin.scm: 2084 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[336],lf[0]);}

/* create-session in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4807(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4807,2,t0,t1);}
/* posixwin.scm: 2083 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[335],lf[0]);}

/* create-fifo in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4801(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4801,2,t0,t1);}
/* posixwin.scm: 2082 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[334],lf[0]);}

/* change-file-owner in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4795(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4795,2,t0,t1);}
/* posixwin.scm: 2081 error */
t2=*((C_word*)lf[333]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[332],lf[0]);}

/* find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4569(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_4569r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4569r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4569r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4571,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=((C_word)li148),tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4716,a[2]=t5,a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4721,a[2]=t6,a[3]=((C_word)li150),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4726,a[2]=t7,a[3]=((C_word)li152),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action825859 */
t9=t8;
f_4726(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id826857 */
t11=t7;
f_4721(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit827854 */
t13=t6;
f_4716(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body823829 */
t15=t5;
f_4571(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-action825 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4726(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4726,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4732,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp);
/* def-id826857 */
t3=((C_word*)t0)[2];
f_4721(t3,t1,t2);}

/* a4731 in def-action825 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4732(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4732,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id826 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4721(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4721,NULL,3,t0,t1,t2);}
/* def-limit827854 */
t3=((C_word*)t0)[2];
f_4716(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit827 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4716(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4716,NULL,4,t0,t1,t2,t3);}
/* body823829 */
t4=((C_word*)t0)[2];
f_4571(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4571(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4571,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[324]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4578,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_4578(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4711,a[2]=t4,a[3]=t7,a[4]=((C_word)li146),tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_4578(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4703,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));}}

/* f_4703 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4703(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4703,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_4711 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4578(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4578,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4695,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],a[4]=((C_word)li141),tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4588,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4691,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2059 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[331]);}

/* k4689 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2059 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4588,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4590,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=((C_word)li145),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4590(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4590(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4590,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4609,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 2065 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4609(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4609,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4671,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 2066 pathname-file */
t3=*((C_word*)lf[330]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4677,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 2072 pproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k4675 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4677,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4684,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 2072 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 2073 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_4590(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k4682 in k4675 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2072 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4590(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4671,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[325]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[326]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 2066 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_4590(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4624,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 2067 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4624,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4634,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4636,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=((C_word)li142),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4644,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word)li143),tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4658,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=((C_word)li144),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 2069 ##sys#dynamic-wind */
t11=*((C_word*)lf[329]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixwin.scm: 2071 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_4590(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a4657 in k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4658,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[327]+1));}

/* a4643 in k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4644,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4652,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4656,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2070 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[328]);}

/* k4654 in a4643 in k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2070 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4650 in a4643 in k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4652(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2070 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4590(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a4635 in k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4636,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[327]+1));}

/* k4632 in k4622 in k4669 in k4607 in loop in k4586 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2068 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4590(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_4695 in k4576 in body823 in find-files in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4695(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4695,3,t0,t1,t2);}
/* posixwin.scm: 2057 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* current-user-name in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4554,2,t0,t1);}
if(C_truep((C_word)C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4564,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2033 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4562 in current-user-name in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2034 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[119],lf[323]);}

/* system-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4523(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4523,2,t0,t1);}
if(C_truep((C_word)C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4534,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4549,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2024 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4547 in system-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2025 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[320],lf[322]);}

/* k4532 in system-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4534(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4534,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4538,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k4536 in k4532 in system-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4538(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4538,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4542,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k4540 in k4536 in k4532 in system-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4542,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4546,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k4544 in k4540 in k4536 in k4532 in system-information in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4546,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,lf[321],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4511,2,t0,t1);}
if(C_truep((C_word)C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 2014 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[318],lf[319]);}}

/* sleep in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4508(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4508,3,t0,t1,t2);}
t3=(C_word)C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4448(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr3r,(void*)f_4448r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4448r(t0,t1,t2,t3);}}

static void C_ccall f_4448r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(9);
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
if(C_truep((C_word)C_i_nullp(t7))){
t8=(C_word)C_i_check_exact_2(t2,lf[315]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4469,a[2]=t5,a[3]=t2,a[4]=((C_word)li134),tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4475,a[2]=t2,a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1993 ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}
else{
/* ##sys#error */
t8=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t1,lf[2],t7);}}

/* a4474 in process-wait in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4475(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4475,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4485,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1996 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
/* posixwin.scm: 1998 values */
C_values(5,0,t1,t2,t3,t4);}}

/* k4483 in a4474 in process-wait in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1997 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[308],lf[315],lf[316],((C_word*)t0)[2]);}

/* a4468 in process-wait in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4469(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4469,2,t0,t1);}
/* posixwin.scm: 1993 ##sys#process-wait */
t2=*((C_word*)lf[314]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4436(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4436,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_process_wait(t2,t3))){
/* posixwin.scm: 1986 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm: 1987 values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4356(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_4356r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4356r(t0,t1,t2,t3);}}

static void C_ccall f_4356r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4358,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li128),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4363,a[2]=t4,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4368,a[2]=t5,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4373,a[2]=t6,a[3]=((C_word)li131),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args774787 */
t8=t7;
f_4373(t8,t1);}
else{
t8=(C_word)C_i_car(t3);
t9=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env775785 */
t10=t6;
f_4368(t10,t1,t8);}
else{
t10=(C_word)C_i_car(t9);
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf776782 */
t12=t5;
f_4363(t12,t1,t8,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* body772778 */
t14=t4;
f_4358(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args774 in process* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4373(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4373,NULL,2,t0,t1);}
/* def-env775785 */
t2=((C_word*)t0)[2];
f_4368(t2,t1,C_SCHEME_FALSE);}

/* def-env775 in process* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4368(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4368,NULL,3,t0,t1,t2);}
/* def-exactf776782 */
t3=((C_word*)t0)[2];
f_4363(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf776 in process* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4363(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4363,NULL,4,t0,t1,t2,t3);}
/* body772778 */
t4=((C_word*)t0)[2];
f_4358(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body772 in process* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4358(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4358,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1980 %process */
f_4214(t1,lf[313],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3,t4);}

/* process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4276(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr3r,(void*)f_4276r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4276r(t0,t1,t2,t3);}}

static void C_ccall f_4276r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(17);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4278,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li123),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4283,a[2]=t4,a[3]=((C_word)li124),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4288,a[2]=t5,a[3]=((C_word)li125),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4293,a[2]=t6,a[3]=((C_word)li126),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args746759 */
t8=t7;
f_4293(t8,t1);}
else{
t8=(C_word)C_i_car(t3);
t9=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env747757 */
t10=t6;
f_4288(t10,t1,t8);}
else{
t10=(C_word)C_i_car(t9);
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf748754 */
t12=t5;
f_4283(t12,t1,t8,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* body744750 */
t14=t4;
f_4278(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-args746 in process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4293(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4293,NULL,2,t0,t1);}
/* def-env747757 */
t2=((C_word*)t0)[2];
f_4288(t2,t1,C_SCHEME_FALSE);}

/* def-env747 in process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4288(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4288,NULL,3,t0,t1,t2);}
/* def-exactf748754 */
t3=((C_word*)t0)[2];
f_4283(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf748 in process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4283(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4283,NULL,4,t0,t1,t2,t3);}
/* body744750 */
t4=((C_word*)t0)[2];
f_4278(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body744 in process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4278(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4278,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1977 %process */
f_4214(t1,lf[312],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3,t4);}

/* %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4214(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4214,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4216,a[2]=t2,a[3]=((C_word)li119),tmp=(C_word)a,a+=4,tmp);
t12=(C_word)C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4235,a[2]=t11,a[3]=t1,a[4]=t10,a[5]=t3,a[6]=t6,a[7]=t9,a[8]=t8,a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm: 1965 chkstrlst */
t14=t11;
f_4216(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4270,a[2]=t13,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1968 ##sys#shell-command-arguments */
t16=*((C_word*)lf[303]+1);
((C_proc3)C_retrieve_proc(t16))(3,t16,t15,((C_word*)t8)[1]);}}

/* k4268 in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4270,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4274,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1969 ##sys#shell-command */
t4=*((C_word*)lf[299]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k4272 in k4268 in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4274(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_4235(2,t3,t2);}

/* k4233 in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4235,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4238,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm: 1970 chkstrlst */
t3=((C_word*)t0)[2];
f_4216(t3,t2,((C_word*)t0)[6]);}
else{
t3=t2;
f_4238(2,t3,C_SCHEME_UNDEFINED);}}

/* k4236 in k4233 in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4238(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4238,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4243,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li120),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4249,a[2]=((C_word*)t0)[4],a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1971 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4248 in k4236 in k4233 in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4249(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4249,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm: 1973 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm: 1974 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a4242 in k4236 in k4233 in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4243(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4243,2,t0,t1);}
/* posixwin.scm: 1971 ##sys#process */
t2=*((C_word*)lf[307]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[7],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[4],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* chkstrlst in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_4216(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4216,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4225,a[2]=((C_word*)t0)[2],a[3]=((C_word)li118),tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a4224 in chkstrlst in %process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4225(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4225,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4095(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr9r,(void*)f_4095r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest(a,C_rest_count(0));
f_4095r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_4095r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4099,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=t7,a[6]=t8,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep((C_word)C_i_nullp(t9))){
t11=t10;
f_4099(2,t11,C_SCHEME_FALSE);}
else{
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
t12=t10;
f_4099(2,t12,(C_word)C_i_car(t9));}
else{
/* ##sys#error */
t12=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,lf[2],t9);}}}

/* k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4099,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4102,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4190,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[8],((C_word*)t0)[2]);
/* posixwin.scm: 1937 $quote-args-list */
t5=lf[288];
f_3585(t5,t3,t4,t1);}

/* k4188 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1937 string-intersperse */
t2=*((C_word*)lf[117]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4102,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t4=((*(int *)C_data_pointer(t2))=C_unfix(t3),C_SCHEME_UNDEFINED);
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t6=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t7=((*(int *)C_data_pointer(t5))=C_unfix(t6),C_SCHEME_UNDEFINED);
t8=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t9=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t10=((*(int *)C_data_pointer(t8))=C_unfix(t9),C_SCHEME_UNDEFINED);
t11=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t12=(C_word)C_i_foreign_fixnum_argumentp(C_fix(-1));
t13=((*(int *)C_data_pointer(t11))=C_unfix(t12),C_SCHEME_UNDEFINED);
t14=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4158,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=((C_word*)t0)[3],a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=t11,a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=((C_word*)t0)[6],a[11]=t1,a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
/* ##sys#make-locative */
t15=*((C_word*)lf[310]+1);
((C_proc6)C_retrieve_proc(t15))(6,t15,t14,t2,C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4158(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4158,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4162,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[310]+1);
((C_proc6)C_retrieve_proc(t3))(6,t3,t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4162,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4166,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[310]+1);
((C_proc6)C_retrieve_proc(t3))(6,t3,t2,((C_word*)t0)[3],C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4166,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|15,a[1]=(C_word)f_4170,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],tmp=(C_word)a,a+=16,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[310]+1);
((C_proc6)C_retrieve_proc(t3))(6,t3,t2,((C_word*)t0)[7],C_fix(0),C_SCHEME_FALSE,lf[311]);}

/* k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4170(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4170,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|16,a[1]=(C_word)f_4174,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],a[16]=((C_word*)t0)[15],tmp=(C_word)a,a+=17,tmp);
t3=(C_truep(((C_word*)t0)[6])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[4])?C_fix(0):C_fix(2));
t5=(C_truep(((C_word*)t0)[8])?C_fix(0):C_fix(4));
/* posixwin.scm: 1944 + */
C_plus(5,0,t2,t3,t4,t5);}

/* k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4174,2,t0,t1);}
t2=((C_word*)t0)[16];
t3=((C_word*)t0)[15];
t4=((C_word*)t0)[14];
t5=((C_word*)t0)[13];
t6=((C_word*)t0)[12];
t7=((C_word*)t0)[11];
t8=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_4037,a[2]=t3,a[3]=((C_word*)t0)[15],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=t1,a[14]=t7,a[15]=t6,a[16]=t5,a[17]=t4,tmp=(C_word)a,a+=18,tmp);
if(C_truep(t2)){
t9=(C_word)C_i_foreign_string_argumentp(t2);
/* ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_4037(2,t9,C_SCHEME_FALSE);}}

/* k4035 in k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4037,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_4041,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t1,a[13]=((C_word*)t0)[13],a[14]=((C_word*)t0)[14],a[15]=((C_word*)t0)[15],a[16]=((C_word*)t0)[16],a[17]=((C_word*)t0)[17],tmp=(C_word)a,a+=18,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_4041(2,t3,C_SCHEME_FALSE);}}

/* k4039 in k4035 in k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4041,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[17])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[17]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[16])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[16]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[15])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[15]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[14])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[14]):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[13]);
if(C_truep((C_word)stub654(C_SCHEME_UNDEFINED,((C_word*)t0)[12],t1,C_SCHEME_FALSE,t2,t3,t4,t5,t6))){
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4131,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm: 1947 open-input-file* */
t8=*((C_word*)lf[240]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
t8=t7;
f_4131(2,t8,C_SCHEME_FALSE);}}
else{
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4151,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1952 ##sys#update-errno */
t8=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* k4149 in k4039 in k4035 in k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1953 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[308],((C_word*)t0)[3],lf[309],((C_word*)t0)[2]);}

/* k4129 in k4039 in k4035 in k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4131(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4131,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4135,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1948 open-output-file* */
t3=*((C_word*)lf[241]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_4135(2,t3,C_SCHEME_FALSE);}}

/* k4133 in k4129 in k4039 in k4035 in k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4135,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4139,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1950 open-input-file* */
t3=*((C_word*)lf[240]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_4139(2,t3,C_SCHEME_FALSE);}}

/* k4137 in k4133 in k4129 in k4039 in k4035 in k4172 in k4168 in k4164 in k4160 in k4156 in k4100 in k4097 in ##sys#process in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1946 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))),t1);}

/* close-handle in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4029(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4029,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub642(C_SCHEME_UNDEFINED,t2));}

/* process-run in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4000(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4000r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4000r(t0,t1,t2,t3);}}

static void C_ccall f_4000r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1905 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,*((C_word*)lf[284]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4017,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command */
t7=*((C_word*)lf[299]+1);
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}}

/* k4015 in process-run in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4017(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4017,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4021,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command-arguments */
t3=*((C_word*)lf[303]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4019 in k4015 in process-run in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_4021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1906 process-spawn */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],*((C_word*)lf[284]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3994(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3994,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[304],t2));}

/* ##sys#shell-command in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3973,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3977,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1889 getenv */
t3=*((C_word*)lf[301]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[302]);}

/* k3975 in ##sys#shell-command in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3977(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3977,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
if(C_truep((C_word)C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3989,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1893 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}}

/* k3987 in k3975 in ##sys#shell-command in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1894 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[299],lf[300]);}

/* current-process-id in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3970,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub630(C_SCHEME_UNDEFINED));}

/* process-spawn in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3883(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_3883r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3883r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3883r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3885,a[2]=t3,a[3]=t2,a[4]=((C_word)li107),tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3897,a[2]=t5,a[3]=((C_word)li108),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3902,a[2]=t6,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3907,a[2]=t7,a[3]=((C_word)li110),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-arglst609623 */
t9=t8;
f_3907(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-envlst610621 */
t11=t7;
f_3902(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-exactf611618 */
t13=t6;
f_3897(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body607613 */
t15=t5;
f_3885(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[2],t14);}}}}}

/* def-arglst609 in process-spawn in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3907(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3907,NULL,2,t0,t1);}
/* def-envlst610621 */
t2=((C_word*)t0)[2];
f_3902(t2,t1,C_SCHEME_FALSE);}

/* def-envlst610 in process-spawn in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3902(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3902,NULL,3,t0,t1,t2);}
/* def-exactf611618 */
t3=((C_word*)t0)[2];
f_3897(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf611 in process-spawn in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3897(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3897,NULL,4,t0,t1,t2,t3);}
/* body607613 */
t4=((C_word*)t0)[2];
f_3885(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body607 in process-spawn in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3885(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3885,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3889,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1880 $exec-setup */
t6=lf[292];
f_3748(t6,t5,lf[296],((C_word*)t0)[2],t2,t3,t4);}

/* k3887 in body607 in process-spawn in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3889(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?(C_word)C_spawnvpe(((C_word*)t0)[4],t1):(C_word)C_spawnvp(((C_word*)t0)[4],t1));
/* posixwin.scm: 1881 $exec-teardown */
f_3781(((C_word*)t0)[3],lf[296],lf[297],((C_word*)t0)[2],t2);}

/* process-execute in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3796(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr3r,(void*)f_3796r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3796r(t0,t1,t2,t3);}}

static void C_ccall f_3796r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(16);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3798,a[2]=t2,a[3]=((C_word)li102),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3810,a[2]=t4,a[3]=((C_word)li103),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3815,a[2]=t5,a[3]=((C_word)li104),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3820,a[2]=t6,a[3]=((C_word)li105),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglst579593 */
t8=t7;
f_3820(t8,t1);}
else{
t8=(C_word)C_i_car(t3);
t9=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t9))){
/* def-envlst580591 */
t10=t6;
f_3815(t10,t1,t8);}
else{
t10=(C_word)C_i_car(t9);
t11=(C_word)C_i_cdr(t9);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf581588 */
t12=t5;
f_3810(t12,t1,t8,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* body577583 */
t14=t4;
f_3798(t14,t1,t8,t10,t12);}
else{
/* ##sys#error */
t14=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[2],t13);}}}}}

/* def-arglst579 in process-execute in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3820(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3820,NULL,2,t0,t1);}
/* def-envlst580591 */
t2=((C_word*)t0)[2];
f_3815(t2,t1,C_SCHEME_FALSE);}

/* def-envlst580 in process-execute in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3815(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3815,NULL,3,t0,t1,t2);}
/* def-exactf581588 */
t3=((C_word*)t0)[2];
f_3810(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf581 in process-execute in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3810(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3810,NULL,4,t0,t1,t2,t3);}
/* body577583 */
t4=((C_word*)t0)[2];
f_3798(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body577 in process-execute in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3798(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3798,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3802,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1875 $exec-setup */
t6=lf[292];
f_3748(t6,t5,lf[294],((C_word*)t0)[2],t2,t3,t4);}

/* k3800 in body577 in process-execute in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
/* posixwin.scm: 1876 $exec-teardown */
f_3781(((C_word*)t0)[3],lf[294],lf[295],((C_word*)t0)[2],t2);}

/* $exec-teardown in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3781(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3781,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3785,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1867 ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k3783 in $exec-teardown in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3785(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_free_exec_args();
t3=(C_word)C_free_exec_env();
t4=(C_word)C_eqp(((C_word*)t0)[6],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm: 1871 ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[6]);}}

/* $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3748(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3748,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(C_word)C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3755,a[2]=t6,a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t5,a[7]=t2,a[8]=((C_word*)t0)[5],a[9]=t3,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1859 pathname-strip-directory */
t9=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t9))(3,t9,t8,t3);}

/* k3753 in $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3755,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3758,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=(C_word)C_block_size(t1);
/* posixwin.scm: 1860 setarg */
t4=((C_word*)t0)[4];
f_3664(5,t4,t2,C_fix(0),t1,t3);}

/* k3756 in k3753 in $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3758,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3761,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3775,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1861 $quote-args-list */
t4=lf[288];
f_3585(t4,t3,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3773 in k3756 in k3753 in $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1861 build-exec-argvec */
f_3698(((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2],C_fix(1));}

/* k3759 in k3756 in k3753 in $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3761,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3764,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1862 build-exec-argvec */
f_3698(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k3762 in k3759 in k3756 in k3753 in $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3764,2,t0,t1);}
t2=(C_word)C_flushall();
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3771,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1864 ##sys#expand-home-path */
t4=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k3769 in k3762 in k3759 in k3756 in k3753 in $exec-setup in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1864 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* build-exec-argvec in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3698(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3698,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=(C_word)C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3710,a[2]=t8,a[3]=t2,a[4]=t4,a[5]=((C_word)li98),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_3710(t10,t1,t3,t5);}
else{
/* posixwin.scm: 1856 argvec-setter */
t6=t4;
((C_proc5)C_retrieve_proc(t6))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* do544 in build-exec-argvec in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3710(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3710,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1852 argvec-setter */
t4=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t4))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3729,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=(C_word)C_block_size(t4);
/* posixwin.scm: 1855 argvec-setter */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,t3,t4,t7);}}

/* k3727 in do544 in build-exec-argvec in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_3710(t4,((C_word*)t0)[2],t2,t3);}

/* setenv in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3681(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3681,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?(C_word)C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=(C_word)C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(C_word)stub533(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* setarg in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3664(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3664,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(t3)?(C_word)C_i_foreign_block_argumentp(t3):C_SCHEME_FALSE);
t7=(C_word)C_i_foreign_fixnum_argumentp(t4);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(C_word)stub523(C_SCHEME_UNDEFINED,t5,t6,t7));}

/* $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3585(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3585,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3590,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li93),tmp=(C_word)a,a+=6,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3628,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li94),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_3628(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* loop in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3628(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3628,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1833 reverse */
t4=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3656,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3659,a[2]=t4,a[3]=t6,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1838 needs-quoting? */
t8=((C_word*)t0)[2];
f_3590(t8,t7,t4);}}

/* k3657 in loop in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1838 string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],lf[289],((C_word*)t0)[2],lf[290]);}
else{
t2=((C_word*)t0)[3];
f_3656(2,t2,((C_word*)t0)[2]);}}

/* k3654 in loop in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3656,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,t1,((C_word*)t0)[5]);
/* posixwin.scm: 1835 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3628(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* needs-quoting? in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3590(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3590,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3594,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1825 string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t2);}

/* k3592 in needs-quoting? in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3594,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3599,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=t1,a[7]=((C_word)li92),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3599(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k3592 in needs-quoting? in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3599(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3599,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(t2,((C_word*)t0)[6]);
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3612,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3623,a[2]=t4,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1829 string-ref */
t6=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],t2);}}

/* k3621 in loop in k3592 in needs-quoting? in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1829 char-whitespace? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3610 in loop in k3592 in needs-quoting? in $quote-args-list in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}
else{
t2=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1830 loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3599(t3,((C_word*)t0)[4],t2);}}

/* glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3470(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr2r,(void*)f_3470r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3470r(t0,t1,t2);}}

static void C_ccall f_3470r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(13);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3476,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[8],a[10]=((C_word)li90),tmp=(C_word)a,a+=11,tmp));
t6=((C_word*)t4)[1];
f_3476(t6,t1,t2);}

/* conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3476(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3476,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3491,a[2]=t3,a[3]=((C_word*)t0)[9],a[4]=((C_word)li87),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3497,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word)li89),tmp=(C_word)a,a+=11,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3497(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3497,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3501,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3574,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[281]);
/* posixwin.scm: 1786 make-pathname */
t8=((C_word*)t0)[7];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3572 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1786 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3501,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3504,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 1787 make-anchored-pattern */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3504,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3507,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1788 regexp */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,t1);}

/* k3505 in k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3507,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3514,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[280]);
/* posixwin.scm: 1789 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k3512 in k3505 in k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3514,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3516,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li88),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3516(t5,((C_word*)t0)[2],t1);}

/* loop in k3512 in k3505 in k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3516(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3516,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[8]);
/* posixwin.scm: 1790 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_3476(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3533,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixwin.scm: 1791 string-match */
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3531 in loop in k3512 in k3505 in k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3533,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3543,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixwin.scm: 1792 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixwin.scm: 1793 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3516(t3,((C_word*)t0)[6],t2);}}

/* k3541 in k3531 in loop in k3512 in k3505 in k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3543(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3543,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3547,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixwin.scm: 1792 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3516(t4,t2,t3);}

/* k3545 in k3541 in k3531 in loop in k3512 in k3505 in k3502 in k3499 in a3496 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3547,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3490 in conc-loop in glob in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3491(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3491,2,t0,t1);}
/* posixwin.scm: 1785 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3411(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3411r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3411r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3411r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3415,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1756 ##sys#check-port */
t6=*((C_word*)lf[146]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[267]);}

/* k3413 in set-buffering-mode! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3415,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3421,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[269]);
if(C_truep(t6)){
t7=t5;
f_3421(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[270]);
if(C_truep(t7)){
t8=t5;
f_3421(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[271]);
if(C_truep(t8)){
t9=t5;
f_3421(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1762 ##sys#error */
t9=*((C_word*)lf[62]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[267],lf[272],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k3419 in k3413 in set-buffering-mode! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3421(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[267]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[81],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixwin.scm: 1768 ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[267],lf[268],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* _exit in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3395(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3395r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3395r(t0,t1,t2);}}

static void C_ccall f_3395r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(t2,C_fix(0)):C_fix(0));
t5=(C_word)C_i_foreign_fixnum_argumentp(t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub452(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3383,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub447(t2),C_fix(0));}

/* local-time->seconds in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3355(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3355,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[261]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3362,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1732 ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[261],lf[264],t2);}
else{
t6=t4;
f_3362(2,t6,C_SCHEME_UNDEFINED);}}

/* k3360 in local-time->seconds in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3362(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixwin.scm: 1734 ##sys#cons-flonum */
t2=*((C_word*)lf[262]+1);
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1735 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[261],lf[263],((C_word*)t0)[3]);}}

/* time->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3275(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3275r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3275r(t0,t1,t2,t3);}}

static void C_ccall f_3275r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3279,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_3279(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_3279(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k3277 in time->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3279(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3279,2,t0,t1);}
t2=(C_word)C_i_check_vector_2(((C_word*)t0)[3],lf[257]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3285,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_block_size(((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(10)))){
/* posixwin.scm: 1719 ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t3,lf[257],lf[260],((C_word*)t0)[3]);}
else{
t5=t3;
f_3285(2,t5,C_SCHEME_UNDEFINED);}}

/* k3283 in k3277 in time->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3285,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[257]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3294,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3304,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1723 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3307,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub421(t4,t3),C_fix(0));}}

/* k3305 in k3283 in k3277 in time->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1727 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1728 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[259],((C_word*)t0)[2]);}}

/* k3302 in k3283 in k3277 in time->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3304,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub427(t3,t2,t1),C_fix(0));}

/* k3292 in k3283 in k3277 in time->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3294(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixwin.scm: 1724 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[258],((C_word*)t0)[2]);}}

/* seconds->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3242(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3242,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3246,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub412(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3244 in seconds->string in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1711 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1712 ##sys#error */
t2=*((C_word*)lf[62]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[255],lf[256],((C_word*)t0)[2]);}}

/* seconds->utc-time in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3223(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3223,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[254]);
/* posixwin.scm: 1704 ##sys#decode-seconds */
t4=*((C_word*)lf[253]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3214(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3214,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[252]);
/* posixwin.scm: 1700 ##sys#decode-seconds */
t4=*((C_word*)lf[253]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3149,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3155,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li77),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_3155(t5,t1,C_fix(0));}

/* loop in current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3155(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3155,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3159,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub395(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3157 in loop in current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3159(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3159,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3167,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word)li76),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3167(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3157 in loop in current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3167(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3167,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3193,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1692 substring */
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1693 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3191 in scan in k3157 in loop in current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3193,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3197,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1692 substring */
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k3195 in k3191 in scan in k3157 in loop in current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3197(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3197,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3185,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1692 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_3155(t5,t3,t4);}

/* k3183 in k3195 in k3191 in scan in k3157 in loop in current-environment in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3185(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3185,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3129(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3129,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[249]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3137,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1680 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3135 in unsetenv in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3112(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3112,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[248]);
t5=(C_word)C_i_check_string_2(t3,lf[248]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3123,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1675 ##sys#make-c-string */
t7=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3121 in setenv in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3123,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3127,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1675 ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3125 in k3121 in setenv in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3127(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3082(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3082r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3082r(t0,t1,t2,t3);}}

static void C_ccall f_3082r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[246]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3089,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_3089(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[246]);
t8=t5;
f_3089(t8,(C_word)C_dup2(t2,t6));}}

/* k3087 in duplicate-fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3089(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3089,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3092,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3098,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1665 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_3092(2,t3,C_SCHEME_UNDEFINED);}}

/* k3096 in k3087 in duplicate-fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1666 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[246],lf[247],((C_word*)t0)[2]);}

/* k3090 in k3087 in duplicate-fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3047(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3047,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3051,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1647 ##sys#check-port */
t4=*((C_word*)lf[146]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[242]);}

/* k3049 in port->fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3051,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3080,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1648 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[245]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k3078 in k3049 in port->fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3080,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixwin.scm: 1654 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[46],lf[242],lf[243],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3060,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3066,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1651 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_3060(2,t4,C_SCHEME_UNDEFINED);}}}

/* k3064 in k3078 in k3049 in port->fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1652 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[242],lf[244],((C_word*)t0)[2]);}

/* k3058 in k3078 in k3049 in port->fileno in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3033(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3033r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3033r(t0,t1,t2,t3);}}

static void C_ccall f_3033r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[241]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3045,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1643 mode */
f_2964(t5,C_SCHEME_FALSE,t3);}

/* k3043 in open-output-file* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3045,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1643 check */
f_3001(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3019(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3019r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3019r(t0,t1,t2,t3);}}

static void C_ccall f_3019r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[240]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3031,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1639 mode */
f_2964(t5,C_SCHEME_TRUE,t3);}

/* k3029 in open-input-file* in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3031,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1639 check */
f_3001(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_3001(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3001,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3005,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1630 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k3003 in check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3005(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3005,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1632 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[238],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3017,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1633 ##sys#make-port */
t3=*((C_word*)lf[138]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[139]+1),lf[239],lf[81]);}}

/* k3015 in k3003 in check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_3017(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2964(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2964,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2972,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[232]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1625 ##sys#error */
t8=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[233],t5);}
else{
t8=t4;
f_2972(2,t8,lf[234]);}}
else{
/* posixwin.scm: 1626 ##sys#error */
t7=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[235],t5);}}
else{
t5=t4;
f_2972(2,t5,(C_truep(t2)?lf[236]:lf[237]));}}

/* k2970 in mode in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2972(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1621 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2955(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2955,3,t0,t1,t2);}
/* posixwin.scm: 1605 check */
f_2919(t1,t2,C_fix((C_word)2),lf[228]);}

/* file-write-access? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2949(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2949,3,t0,t1,t2);}
/* posixwin.scm: 1604 check */
f_2919(t1,t2,C_fix((C_word)4),lf[227]);}

/* file-read-access? in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2943(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2943,3,t0,t1,t2);}
/* posixwin.scm: 1603 check */
f_2919(t1,t2,C_fix((C_word)2),lf[226]);}

/* check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2919(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2919,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2937,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2941,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1600 ##sys#expand-home-path */
t8=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2939 in check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1600 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2935 in check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2937,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2929,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2929(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1601 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2927 in k2935 in check in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2889(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2889,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[224]);
t5=(C_word)C_i_check_exact_2(t3,lf[224]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2913,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2917,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1589 ##sys#expand-home-path */
t8=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2915 in change-file-mode in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1589 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2911 in change-file-mode in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2913,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2905,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1590 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2903 in k2911 in change-file-mode in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2905(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1591 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[224],lf[225],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#interrupt-hook in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2833(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2833,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2843,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1497 h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1499 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k2841 in ##sys#interrupt-hook in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1498 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2820(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2820,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[185]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k2807 in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2811(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2811,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[184]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2735(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_2735r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2735r(t0,t1,t2);}}

static void C_ccall f_2735r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2739,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_2739(2,t4,(C_word)C_fixnum_or(*((C_word*)lf[21]+1),*((C_word*)lf[23]+1)));}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_2739(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k2737 in create-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2739(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2739,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2742,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE,t1),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2751,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1434 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2742(2,t3,C_SCHEME_UNDEFINED);}}

/* k2749 in k2737 in create-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1435 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[37],lf[154],lf[155]);}

/* k2740 in k2737 in create-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1436 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2715(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2715r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2715r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2715r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[153]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2719,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2717 in with-output-to-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2719(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2719,2,t0,t1);}
t2=C_mutate((C_word*)lf[153]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2725,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li57),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1419 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2724 in k2717 in with-output-to-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2725(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2725r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2725r(t0,t1,t2);}}

static void C_ccall f_2725r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2729,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1421 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2727 in a2724 in k2717 in with-output-to-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[153]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2695(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2695r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2695r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2695r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[151]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2699,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2697 in with-input-from-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2699,2,t0,t1);}
t2=C_mutate((C_word*)lf[151]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2705,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word)li55),tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1409 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2704 in k2697 in with-input-from-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2705(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2705r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2705r(t0,t1,t2);}}

static void C_ccall f_2705r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2709,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1411 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2707 in a2704 in k2697 in with-input-from-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[151]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2671(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2671r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2671r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2671r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2675,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2673 in call-with-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2675,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2680,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li52),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2686,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li53),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1399 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2685 in k2673 in call-with-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2686(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2686r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2686r(t0,t1,t2);}}

static void C_ccall f_2686r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2690,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1402 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2688 in a2685 in k2673 in call-with-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2679 in k2673 in call-with-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2680,2,t0,t1);}
/* posixwin.scm: 1400 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2647(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2647r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2647r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2647r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2651,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2649 in call-with-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2651(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2651,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2656,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word)li49),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2662,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word)li50),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1391 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2661 in k2649 in call-with-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2662(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2662r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2662r(t0,t1,t2);}}

static void C_ccall f_2662r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2666,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1394 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2664 in a2661 in k2649 in call-with-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2666(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2655 in k2649 in call-with-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2656,2,t0,t1);}
/* posixwin.scm: 1392 proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2628(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2628,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2632,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1378 ##sys#check-port */
t4=*((C_word*)lf[146]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[144]);}

/* k2630 in close-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2632(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2632,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2635,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1380 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2633 in k2630 in close-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 1381 ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[37],lf[144],lf[145],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2592(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2592r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2592r(t0,t1,t2,t3);}}

static void C_ccall f_2592r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[143]);
t5=f_2520(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2606,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[135]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2613,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1373 ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[142]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2623,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1374 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1375 badmode */
f_2532(t6,t5);}}}

/* k2621 in open-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2623,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2606(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2611 in open-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2613(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2613,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2606(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2604 in open-output-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1370 check */
f_2538(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2556(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2556r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2556r(t0,t1,t2,t3);}}

static void C_ccall f_2556r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[141]);
t5=f_2520(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2570,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[135]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2577,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1363 ##sys#make-c-string */
t9=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[142]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2587,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1364 ##sys#make-c-string */
t10=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1365 badmode */
f_2532(t6,t5);}}}

/* k2585 in open-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2587(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2587,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2570(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2575 in open-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2577,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2570(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2568 in open-input-pipe in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1360 check */
f_2538(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2538(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2538,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2542,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1350 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k2540 in check in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2542,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1352 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[37],lf[137],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2554,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1353 ##sys#make-port */
t3=*((C_word*)lf[138]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[139]+1),lf[140],lf[81]);}}

/* k2552 in k2540 in check in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2532(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2532,NULL,2,t1,t2);}
/* posixwin.scm: 1348 ##sys#error */
t3=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[136],t2);}

/* mode in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall f_2520(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[135]));}

/* canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2163(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[28],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2163,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[99]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2170,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2303,a[2]=t4,a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1287 cwd */
t8=((C_word*)t0)[5];
f_2107(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2309,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,a[9]=t4,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2510,a[2]=((C_word*)t0)[11],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1289 sref */
t10=((C_word*)t0)[8];
((C_proc4)C_retrieve_proc(t10))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_2309(t9,C_SCHEME_FALSE);}}}

/* k2508 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2510(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1289 sep? */
t2=((C_word*)t0)[3];
f_2309(t2,f_2096(t1));}

/* k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2309(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[34],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2309,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2316,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2320,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1291 cwd */
t4=((C_word*)t0)[7];
f_2107(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2333,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1294 cwd */
t5=((C_word*)t0)[7];
f_2107(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2339,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2485,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2496,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1295 sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k2494 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1295 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k2483 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2485,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2492,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1296 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_2339(t2,C_SCHEME_FALSE);}}

/* k2490 in k2483 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1296 sep? */
t2=((C_word*)t0)[3];
f_2339(t2,f_2096(t1));}

/* k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2339(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[35],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2339,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2346,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2362,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1298 cwd */
t4=((C_word*)t0)[6];
f_2107(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2375,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1304 cwd */
t5=((C_word*)t0)[6];
f_2107(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2381,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2457,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2478,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1305 sref */
t7=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k2476 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1305 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k2455 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2457,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2463,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2474,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1306 sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_2381(t2,C_SCHEME_FALSE);}}

/* k2472 in k2455 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1306 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k2461 in k2455 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2463,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2470,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1307 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_2381(t2,C_SCHEME_FALSE);}}

/* k2468 in k2461 in k2455 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1307 sep? */
t2=((C_word*)t0)[3];
f_2381(t2,f_2096(t1));}

/* k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2381(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2381,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[9];
f_2170(2,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2387,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2433,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2454,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1309 sref */
t5=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[8],C_fix(0));}}

/* k2452 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1309 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k2431 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2433,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2439,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2450,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1310 sref */
t4=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_2387(2,t2,C_SCHEME_FALSE);}}

/* k2448 in k2431 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1310 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k2437 in k2431 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2439,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2446,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1311 sref */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_2387(2,t2,C_SCHEME_FALSE);}}

/* k2444 in k2437 in k2431 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2446(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1311 char=? */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2387(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2387,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2394,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1313 ##sys#substring */
t3=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t3))(5,t3,t2,((C_word*)t0)[5],C_fix(1),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2430,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1317 sref */
t3=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[5],C_fix(0));}}

/* k2428 in k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2430,2,t0,t1);}
t2=f_2096(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2415,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2419,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1319 cwd */
t5=((C_word*)t0)[2];
f_2107(t5,t4);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2426,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1322 cwd */
t4=((C_word*)t0)[2];
f_2107(t4,t3);}}

/* k2424 in k2428 in k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1322 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[134],((C_word*)t0)[2]);}

/* k2417 in k2428 in k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2419(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1319 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k2413 in k2428 in k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1318 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k2392 in k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2394,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2398,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1315 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t2,((C_word*)t0)[2],C_fix(3),t3);}

/* k2396 in k2392 in k2385 in k2379 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1312 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[133],t1);}

/* k2373 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2375(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1304 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[132],((C_word*)t0)[2]);}

/* k2360 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2362(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1298 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(3));}

/* k2344 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2346,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2350,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1300 user */
t3=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k2348 in k2344 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2350,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2354,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1301 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k2352 in k2348 in k2344 in k2337 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2354(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1297 sappend */
t2=((C_word*)t0)[5];
((C_proc6)C_retrieve_proc(t2))(6,t2,((C_word*)t0)[4],((C_word*)t0)[3],lf[131],((C_word*)t0)[2],t1);}

/* k2331 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2333(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1294 sappend */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],t1,lf[130],((C_word*)t0)[2]);}

/* k2318 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1291 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k2314 in k2307 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1290 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k2301 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2303(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1287 sappend */
t2=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],t1,lf[129]);}

/* k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2170(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2170,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2177,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t1,tmp=(C_word)a,a+=10,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2289,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(C_word)C_block_size(t1);
/* posixwin.scm: 1323 ##sys#substring */
t5=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t3,t1,C_fix(3),t4);}

/* k2287 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* string-split */
t2=*((C_word*)lf[98]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[2],t1,lf[128]);}

/* k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2177,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_2179,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word)li41),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_2179(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2179(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2179,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2186,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 1325 null? */
t5=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2186,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2192,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1326 null? */
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[7]);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2258,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2261,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_i_car(((C_word*)t0)[4]);
/* posixwin.scm: 1337 string=? */
t6=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,lf[127],t5);}}

/* k2259 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2261,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_2258(t2,(C_word)C_i_cdr(((C_word*)t0)[4]));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2270,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(((C_word*)t0)[3]);
/* posixwin.scm: 1339 string=? */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,lf[126],t3);}}

/* k2268 in k2259 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2270,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_2258(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_2258(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k2256 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2258(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1335 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2179(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2192,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1327 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[8],((C_word*)t0)[7],C_fix(0),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2239,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[7]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixwin.scm: 1328 sref */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,((C_word*)t0)[7],t4);}}

/* k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2239,2,t0,t1);}
t2=f_2096(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2208,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1330 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2227,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1333 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}}

/* k2225 in k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2227,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2231,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2235,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1334 reverse */
t4=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2233 in k2225 in k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1334 isperse */
f_2091(((C_word*)t0)[2],t1);}

/* k2229 in k2225 in k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1332 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2206 in k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2208(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2208,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2212,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2216,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_a_i_cons(&a,2,lf[124],((C_word*)t0)[2]);
/* posixwin.scm: 1331 reverse */
t5=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* k2214 in k2206 in k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2216(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1331 isperse */
f_2091(((C_word*)t0)[2],t1);}

/* k2210 in k2206 in k2237 in k2190 in k2184 in loop in k2175 in k2168 in canonical-path in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1329 sappend */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2107(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2107,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2114,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2116,a[2]=((C_word*)t0)[2],a[3]=((C_word)li39),tmp=(C_word)a,a+=4,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[123]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2116(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2116,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2122,a[2]=t2,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2140,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li38),tmp=(C_word)a,a+=5,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[122]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t3,t4);}

/* a2139 in a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2140,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2146,a[2]=((C_word*)t0)[3],a[3]=((C_word)li35),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2152,a[2]=((C_word*)t0)[2],a[3]=((C_word)li37),tmp=(C_word)a,a+=4,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t2,t3);}

/* a2151 in a2139 in a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2152(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2152r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2152r(t0,t1,t2);}}

static void C_ccall f_2152r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2158,a[2]=t2,a[3]=((C_word)li36),tmp=(C_word)a,a+=4,tmp);
/* g226228 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a2157 in a2151 in a2139 in a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2158(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2158,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a2145 in a2139 in a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2146,2,t0,t1);}
/* posixwin.scm: 1282 cw */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a2121 in a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2122(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2122,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2128,a[2]=t2,a[3]=((C_word)li33),tmp=(C_word)a,a+=4,tmp);
/* g226228 */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t1,t3);}

/* a2127 in a2121 in a2115 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2128,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[120]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[121]);}

/* k2112 in cwd in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2114(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* sep? in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static C_word C_fcall f_2096(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_2091(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2091,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[117]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,t2,lf[118]);}

/* current-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2040(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2040r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2040r(t0,t1,t2);}}

static void C_ccall f_2040r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2044,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_2044(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_2044(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[2],t2);}}}

/* k2042 in current-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2044,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1260 change-directory */
t2=*((C_word*)lf[100]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2053,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1261 make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k2051 in k2042 in current-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2053,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2056,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1263 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2054 in k2051 in k2042 in current-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 1265 ##sys#substring */
t2=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 1266 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[108],lf[111]);}}

/* directory? in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2013(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2013,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[109]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2020,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2034,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2038,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1253 ##sys#expand-home-path */
t7=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t2);}

/* k2036 in directory? in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1253 ##sys#platform-fixup-pathname */
t2=*((C_word*)lf[110]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k2032 in directory? in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2034(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1252 ##sys#file-info */
t2=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2018 in directory? in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_2020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1853(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_1853r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1853r(t0,t1,t2);}}

static void C_ccall f_1853r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1855,a[2]=((C_word*)t0)[2],a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1956,a[2]=t3,a[3]=((C_word)li26),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1961,a[2]=t4,a[3]=((C_word)li27),tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec162188 */
t6=t5;
f_1961(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?163186 */
t8=t4;
f_1956(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body160165 */
t10=t3;
f_1855(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[2],t9);}}}}

/* def-spec162 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1961(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1961,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1969,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1223 current-directory */
t3=*((C_word*)lf[108]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1967 in def-spec162 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?163186 */
t2=((C_word*)t0)[3];
f_1956(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?163 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1956(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1956,NULL,3,t0,t1,t2);}
/* body160165 */
t3=((C_word*)t0)[2];
f_1855(t3,t1,t2,C_SCHEME_FALSE);}

/* body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1855(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1855,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[105]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1862,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1225 make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1862,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1865,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1226 ##sys#make-pointer */
t3=*((C_word*)lf[107]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1865(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1865,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1868,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1227 ##sys#make-pointer */
t3=*((C_word*)lf[107]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1868,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1872,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1955,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1228 ##sys#expand-home-path */
t4=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1953 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1228 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1870 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1872(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1872,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1881,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1231 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1889,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word)li24),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_1889(t6,((C_word*)t0)[6]);}}

/* loop in k1870 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1889(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1889,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1899,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1240 ##sys#substring */
t5=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1897 in loop in k1870 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1899(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1899,2,t0,t1);}
t2=(C_word)C_i_string_ref(t1,C_fix(0));
t3=(C_word)C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1911,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_1911(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_1911(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_1911(t7,C_SCHEME_FALSE);}}

/* k1909 in k1897 in loop in k1870 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1911(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1911,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1247 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_1889(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1921,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1248 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_1889(t3,t2);}}

/* k1919 in k1909 in k1897 in loop in k1870 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1921,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k1879 in k1870 in k1866 in k1863 in k1860 in body160 in directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1232 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[105],lf[106],((C_word*)t0)[2]);}

/* delete-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1826(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1826,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[102]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1847,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1851,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1215 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1849 in delete-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1215 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1845 in delete-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1847,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1839,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1216 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1837 in k1845 in delete-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1217 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[102],lf[103],((C_word*)t0)[2]);}

/* change-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1799(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1799,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[100]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1820,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1824,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1208 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1822 in change-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1208 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1818 in change-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1820,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1812,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1209 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1810 in k1818 in change-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1210 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[100],lf[101],((C_word*)t0)[2]);}

/* create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1686(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_1686r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1686r(t0,t1,t2,t3);}}

static void C_ccall f_1686r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1690,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_1690(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_1690(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1690,2,t0,t1);}
t2=(C_word)C_i_check_string_2(((C_word*)t0)[3],lf[95]);
if(C_truep(t1)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1699,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1196 canonical-path */
t4=*((C_word*)lf[99]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[3]);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1761,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1197 canonical-path */
t4=*((C_word*)lf[99]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[3]);}}

/* k1759 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1761,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1778,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k1776 in k1759 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1778,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1770,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1768 in k1776 in k1759 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[95],*((C_word*)lf[89]+1),((C_word*)t0)[2]);}

/* k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1699,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1702,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* string-split */
t3=*((C_word*)lf[98]+1);
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,t1,*((C_word*)lf[93]+1));}

/* k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1702,2,t0,t1);}
t2=(C_word)C_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1710,a[2]=t4,a[3]=((C_word)li20),tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_i_cdr(t1);
/* for-each */
t7=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,((C_word*)t0)[2],t5,t6);}

/* a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1710(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1710,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1715,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-append */
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],*((C_word*)lf[91]+1),t2);}

/* k1713 in a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1715(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1715,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1721,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1741,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* file-exists? */
t6=*((C_word*)lf[96]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t3);}

/* k1739 in k1713 in a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1741,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1744,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* ##sys#file-info */
t3=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_1721(t2,C_SCHEME_FALSE);}}

/* k1742 in k1739 in k1713 in a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
f_1721(t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
f_1721(t2,C_SCHEME_FALSE);}}

/* k1719 in k1713 in a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1721(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1721,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1738,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k1736 in k1719 in k1713 in a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1738,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1730,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1728 in k1736 in k1719 in k1713 in a1709 in k1700 in k1697 in k1688 in create-directory in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[95],*((C_word*)lf[89]+1),((C_word*)t0)[2]);}

/* set-file-position! in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1622(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1622r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1622r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1622r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[84]);
t8=(C_word)C_i_check_exact_2(t6,lf[84]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1635,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixwin.scm: 1154 ##sys#signal-hook */
t10=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[87],lf[84],lf[88],t3,t2);}
else{
t10=t9;
f_1635(2,t10,C_SCHEME_UNDEFINED);}}

/* k1633 in set-file-position! in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1635,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1641,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1650,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1155 port? */
t4=*((C_word*)lf[83]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1648 in k1633 in set-file-position! in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[81]);
t4=((C_word*)t0)[4];
f_1641(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1641(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixwin.scm: 1159 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[46],lf[84],lf[86],((C_word*)t0)[5]);}}}

/* k1639 in k1633 in set-file-position! in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1641,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1644,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1160 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k1642 in k1639 in k1633 in set-file-position! in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1161 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[84],lf[85],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1582(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1582,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1586,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1601,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1138 port? */
t5=*((C_word*)lf[83]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k1599 in file-position in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1601(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[81]);
t4=((C_word*)t0)[2];
f_1586(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1586(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixwin.scm: 1143 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[46],lf[79],lf[82],((C_word*)t0)[3]);}}}

/* k1584 in file-position in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1586(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1586,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1589,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1595,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1145 ##sys#update-errno */
t4=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1589(2,t3,C_SCHEME_UNDEFINED);}}

/* k1593 in k1584 in file-position in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1595(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1146 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[79],lf[80],((C_word*)t0)[2]);}

/* k1587 in k1584 in file-position in k1578 in k1574 in k1570 in k1566 in k1562 in k1558 in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* stat-type in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1549(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1549,NULL,2,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1551,a[2]=t2,a[3]=((C_word)li16),tmp=(C_word)a,a+=4,tmp));}

/* f_1551 in stat-type in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1551(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1551,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* symbolic-link? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1544(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1544,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[71]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* regular-file? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1521(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1521,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[69]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1528,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1542,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1116 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1540 in regular-file? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1116 ##sys#file-info */
t2=*((C_word*)lf[70]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1526 in regular-file? in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1515(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1515,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1519,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1112 ##sys#stat */
f_1416(t3,t2);}

/* k1517 in file-permissions in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1519(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1509(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1509,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1513,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1111 ##sys#stat */
f_1416(t3,t2);}

/* k1511 in file-owner in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1503(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1503,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1507,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1110 ##sys#stat */
f_1416(t3,t2);}

/* k1505 in file-change-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1507,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1497(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1497,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1501,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1109 ##sys#stat */
f_1416(t3,t2);}

/* k1499 in file-access-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1501,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1491(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1491,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1495,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1108 ##sys#stat */
f_1416(t3,t2);}

/* k1493 in file-modification-time in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1495,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1485(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1485,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1489,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1107 ##sys#stat */
f_1416(t3,t2);}

/* k1487 in file-size in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1454(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_1454r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1454r(t0,t1,t2,t3);}}

static void C_ccall f_1454r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1458,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t5=t4;
f_1458(2,t5,C_SCHEME_FALSE);}
else{
t5=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t5))){
t6=t4;
f_1458(2,t6,(C_word)C_i_car(t3));}
else{
/* ##sys#error */
t6=*((C_word*)lf[62]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[2],t3);}}}

/* k1456 in file-stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1458,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1461,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1101 ##sys#stat */
f_1416(t2,((C_word*)t0)[2]);}

/* k1459 in k1456 in file-stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1461(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1461,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(0),C_fix(0),C_fix(0),C_fix(0)));}

/* ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_fcall f_1416(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1416,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1420,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_1420(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1445,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1449,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1094 ##sys#expand-home-path */
t6=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1095 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[46],lf[60],t2);}}}

/* k1447 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1094 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1443 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_1420(2,t2,(C_word)C_stat(t1));}

/* k1418 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1420(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1420,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1429,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1097 ##sys#update-errno */
t3=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k1427 in k1418 in ##sys#stat in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1098 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[37],lf[59],((C_word*)t0)[2]);}

/* file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1378(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1378,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[52]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1385,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1063 ##sys#make-c-string */
t5=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1383 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1385(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1385,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1388,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1065 string-length */
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k1386 in k1383 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1388(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1388,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1391,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1408,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1067 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_1391(2,t4,C_SCHEME_UNDEFINED);}}

/* k1406 in k1386 in k1383 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1408(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1068 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[52],lf[54],((C_word*)t0)[2]);}

/* k1389 in k1386 in k1383 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1391(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1391,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1398,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1069 ##sys#substring */
t4=*((C_word*)lf[53]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1396 in k1389 in k1386 in k1383 in file-mkstemp in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1069 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1336(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1336r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1336r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1336r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[48]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1343,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1343(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1050 ##sys#signal-hook */
t8=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[46],lf[48],lf[50],t3);}}

/* k1341 in file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1343,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[48]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1352,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1358,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1055 ##sys#update-errno */
t9=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f_1352(2,t8,C_SCHEME_UNDEFINED);}}

/* k1356 in k1341 in file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1056 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[48],lf[49],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1350 in k1341 in file-write in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1352(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1291(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1291r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1291r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1291r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[44]);
t6=(C_word)C_i_check_exact_2(t3,lf[44]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1301,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1301(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixwin.scm: 1037 make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1299 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1301(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1301,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1304,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1304(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1039 ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[46],lf[44],lf[47],t1);}}

/* k1302 in k1299 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1304,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1307,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1316,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1042 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_1307(2,t5,C_SCHEME_UNDEFINED);}}

/* k1314 in k1302 in k1299 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1043 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[37],lf[44],lf[45],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1305 in k1302 in k1299 in file-read in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1307,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1273(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1273,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[41]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1286,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1029 ##sys#update-errno */
t5=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1284 in file-close in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1030 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[37],lf[41],lf[42],((C_word*)t0)[2]);}

/* file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1232(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1232r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1232r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1232r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[36]);
t8=(C_word)C_i_check_exact_2(t3,lf[36]);
t9=(C_word)C_i_check_exact_2(t6,lf[36]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1249,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1265,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1019 ##sys#expand-home-path */
t12=*((C_word*)lf[40]+1);
((C_proc3)C_retrieve_proc(t12))(3,t12,t11,t2);}

/* k1263 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1019 ##sys#make-c-string */
t2=*((C_word*)lf[39]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1247 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1249(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1249,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1252,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1258,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1021 ##sys#update-errno */
t6=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_1252(2,t5,C_SCHEME_UNDEFINED);}}

/* k1256 in k1247 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1022 ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[37],lf[36],lf[38],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1250 in k1247 in file-open in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1186(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1186r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1186r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1186r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1190,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 950  ##sys#update-errno */
t7=*((C_word*)lf[9]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1188 in posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1190,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1197,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1201,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub3(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[8]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1199 in k1188 in posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 951  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[7],t1);}

/* k1195 in k1188 in posix-error in k1172 in k1169 in k1166 in k1163 in k1160 */
static void C_ccall f_1197(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[6]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[458] = {
{"toplevelposixwin.scm",(void*)C_posix_toplevel},
{"f_1162posixwin.scm",(void*)f_1162},
{"f_1165posixwin.scm",(void*)f_1165},
{"f_1168posixwin.scm",(void*)f_1168},
{"f_1171posixwin.scm",(void*)f_1171},
{"f_1174posixwin.scm",(void*)f_1174},
{"f_1560posixwin.scm",(void*)f_1560},
{"f_1564posixwin.scm",(void*)f_1564},
{"f_1568posixwin.scm",(void*)f_1568},
{"f_1572posixwin.scm",(void*)f_1572},
{"f_1576posixwin.scm",(void*)f_1576},
{"f_1580posixwin.scm",(void*)f_1580},
{"f_2809posixwin.scm",(void*)f_2809},
{"f_5063posixwin.scm",(void*)f_5063},
{"f_5060posixwin.scm",(void*)f_5060},
{"f_5053posixwin.scm",(void*)f_5053},
{"f_5047posixwin.scm",(void*)f_5047},
{"f_5041posixwin.scm",(void*)f_5041},
{"f_5035posixwin.scm",(void*)f_5035},
{"f_5029posixwin.scm",(void*)f_5029},
{"f_5023posixwin.scm",(void*)f_5023},
{"f_5017posixwin.scm",(void*)f_5017},
{"f_5011posixwin.scm",(void*)f_5011},
{"f_5005posixwin.scm",(void*)f_5005},
{"f_4999posixwin.scm",(void*)f_4999},
{"f_4993posixwin.scm",(void*)f_4993},
{"f_4987posixwin.scm",(void*)f_4987},
{"f_4981posixwin.scm",(void*)f_4981},
{"f_4975posixwin.scm",(void*)f_4975},
{"f_4969posixwin.scm",(void*)f_4969},
{"f_4963posixwin.scm",(void*)f_4963},
{"f_4957posixwin.scm",(void*)f_4957},
{"f_4951posixwin.scm",(void*)f_4951},
{"f_4945posixwin.scm",(void*)f_4945},
{"f_4939posixwin.scm",(void*)f_4939},
{"f_4933posixwin.scm",(void*)f_4933},
{"f_4927posixwin.scm",(void*)f_4927},
{"f_4921posixwin.scm",(void*)f_4921},
{"f_4915posixwin.scm",(void*)f_4915},
{"f_4909posixwin.scm",(void*)f_4909},
{"f_4903posixwin.scm",(void*)f_4903},
{"f_4897posixwin.scm",(void*)f_4897},
{"f_4891posixwin.scm",(void*)f_4891},
{"f_4885posixwin.scm",(void*)f_4885},
{"f_4879posixwin.scm",(void*)f_4879},
{"f_4873posixwin.scm",(void*)f_4873},
{"f_4867posixwin.scm",(void*)f_4867},
{"f_4861posixwin.scm",(void*)f_4861},
{"f_4855posixwin.scm",(void*)f_4855},
{"f_4849posixwin.scm",(void*)f_4849},
{"f_4843posixwin.scm",(void*)f_4843},
{"f_4837posixwin.scm",(void*)f_4837},
{"f_4831posixwin.scm",(void*)f_4831},
{"f_4825posixwin.scm",(void*)f_4825},
{"f_4819posixwin.scm",(void*)f_4819},
{"f_4813posixwin.scm",(void*)f_4813},
{"f_4807posixwin.scm",(void*)f_4807},
{"f_4801posixwin.scm",(void*)f_4801},
{"f_4795posixwin.scm",(void*)f_4795},
{"f_4569posixwin.scm",(void*)f_4569},
{"f_4726posixwin.scm",(void*)f_4726},
{"f_4732posixwin.scm",(void*)f_4732},
{"f_4721posixwin.scm",(void*)f_4721},
{"f_4716posixwin.scm",(void*)f_4716},
{"f_4571posixwin.scm",(void*)f_4571},
{"f_4703posixwin.scm",(void*)f_4703},
{"f_4711posixwin.scm",(void*)f_4711},
{"f_4578posixwin.scm",(void*)f_4578},
{"f_4691posixwin.scm",(void*)f_4691},
{"f_4588posixwin.scm",(void*)f_4588},
{"f_4590posixwin.scm",(void*)f_4590},
{"f_4609posixwin.scm",(void*)f_4609},
{"f_4677posixwin.scm",(void*)f_4677},
{"f_4684posixwin.scm",(void*)f_4684},
{"f_4671posixwin.scm",(void*)f_4671},
{"f_4624posixwin.scm",(void*)f_4624},
{"f_4658posixwin.scm",(void*)f_4658},
{"f_4644posixwin.scm",(void*)f_4644},
{"f_4656posixwin.scm",(void*)f_4656},
{"f_4652posixwin.scm",(void*)f_4652},
{"f_4636posixwin.scm",(void*)f_4636},
{"f_4634posixwin.scm",(void*)f_4634},
{"f_4695posixwin.scm",(void*)f_4695},
{"f_4554posixwin.scm",(void*)f_4554},
{"f_4564posixwin.scm",(void*)f_4564},
{"f_4523posixwin.scm",(void*)f_4523},
{"f_4549posixwin.scm",(void*)f_4549},
{"f_4534posixwin.scm",(void*)f_4534},
{"f_4538posixwin.scm",(void*)f_4538},
{"f_4542posixwin.scm",(void*)f_4542},
{"f_4546posixwin.scm",(void*)f_4546},
{"f_4511posixwin.scm",(void*)f_4511},
{"f_4508posixwin.scm",(void*)f_4508},
{"f_4448posixwin.scm",(void*)f_4448},
{"f_4475posixwin.scm",(void*)f_4475},
{"f_4485posixwin.scm",(void*)f_4485},
{"f_4469posixwin.scm",(void*)f_4469},
{"f_4436posixwin.scm",(void*)f_4436},
{"f_4356posixwin.scm",(void*)f_4356},
{"f_4373posixwin.scm",(void*)f_4373},
{"f_4368posixwin.scm",(void*)f_4368},
{"f_4363posixwin.scm",(void*)f_4363},
{"f_4358posixwin.scm",(void*)f_4358},
{"f_4276posixwin.scm",(void*)f_4276},
{"f_4293posixwin.scm",(void*)f_4293},
{"f_4288posixwin.scm",(void*)f_4288},
{"f_4283posixwin.scm",(void*)f_4283},
{"f_4278posixwin.scm",(void*)f_4278},
{"f_4214posixwin.scm",(void*)f_4214},
{"f_4270posixwin.scm",(void*)f_4270},
{"f_4274posixwin.scm",(void*)f_4274},
{"f_4235posixwin.scm",(void*)f_4235},
{"f_4238posixwin.scm",(void*)f_4238},
{"f_4249posixwin.scm",(void*)f_4249},
{"f_4243posixwin.scm",(void*)f_4243},
{"f_4216posixwin.scm",(void*)f_4216},
{"f_4225posixwin.scm",(void*)f_4225},
{"f_4095posixwin.scm",(void*)f_4095},
{"f_4099posixwin.scm",(void*)f_4099},
{"f_4190posixwin.scm",(void*)f_4190},
{"f_4102posixwin.scm",(void*)f_4102},
{"f_4158posixwin.scm",(void*)f_4158},
{"f_4162posixwin.scm",(void*)f_4162},
{"f_4166posixwin.scm",(void*)f_4166},
{"f_4170posixwin.scm",(void*)f_4170},
{"f_4174posixwin.scm",(void*)f_4174},
{"f_4037posixwin.scm",(void*)f_4037},
{"f_4041posixwin.scm",(void*)f_4041},
{"f_4151posixwin.scm",(void*)f_4151},
{"f_4131posixwin.scm",(void*)f_4131},
{"f_4135posixwin.scm",(void*)f_4135},
{"f_4139posixwin.scm",(void*)f_4139},
{"f_4029posixwin.scm",(void*)f_4029},
{"f_4000posixwin.scm",(void*)f_4000},
{"f_4017posixwin.scm",(void*)f_4017},
{"f_4021posixwin.scm",(void*)f_4021},
{"f_3994posixwin.scm",(void*)f_3994},
{"f_3973posixwin.scm",(void*)f_3973},
{"f_3977posixwin.scm",(void*)f_3977},
{"f_3989posixwin.scm",(void*)f_3989},
{"f_3970posixwin.scm",(void*)f_3970},
{"f_3883posixwin.scm",(void*)f_3883},
{"f_3907posixwin.scm",(void*)f_3907},
{"f_3902posixwin.scm",(void*)f_3902},
{"f_3897posixwin.scm",(void*)f_3897},
{"f_3885posixwin.scm",(void*)f_3885},
{"f_3889posixwin.scm",(void*)f_3889},
{"f_3796posixwin.scm",(void*)f_3796},
{"f_3820posixwin.scm",(void*)f_3820},
{"f_3815posixwin.scm",(void*)f_3815},
{"f_3810posixwin.scm",(void*)f_3810},
{"f_3798posixwin.scm",(void*)f_3798},
{"f_3802posixwin.scm",(void*)f_3802},
{"f_3781posixwin.scm",(void*)f_3781},
{"f_3785posixwin.scm",(void*)f_3785},
{"f_3748posixwin.scm",(void*)f_3748},
{"f_3755posixwin.scm",(void*)f_3755},
{"f_3758posixwin.scm",(void*)f_3758},
{"f_3775posixwin.scm",(void*)f_3775},
{"f_3761posixwin.scm",(void*)f_3761},
{"f_3764posixwin.scm",(void*)f_3764},
{"f_3771posixwin.scm",(void*)f_3771},
{"f_3698posixwin.scm",(void*)f_3698},
{"f_3710posixwin.scm",(void*)f_3710},
{"f_3729posixwin.scm",(void*)f_3729},
{"f_3681posixwin.scm",(void*)f_3681},
{"f_3664posixwin.scm",(void*)f_3664},
{"f_3585posixwin.scm",(void*)f_3585},
{"f_3628posixwin.scm",(void*)f_3628},
{"f_3659posixwin.scm",(void*)f_3659},
{"f_3656posixwin.scm",(void*)f_3656},
{"f_3590posixwin.scm",(void*)f_3590},
{"f_3594posixwin.scm",(void*)f_3594},
{"f_3599posixwin.scm",(void*)f_3599},
{"f_3623posixwin.scm",(void*)f_3623},
{"f_3612posixwin.scm",(void*)f_3612},
{"f_3470posixwin.scm",(void*)f_3470},
{"f_3476posixwin.scm",(void*)f_3476},
{"f_3497posixwin.scm",(void*)f_3497},
{"f_3574posixwin.scm",(void*)f_3574},
{"f_3501posixwin.scm",(void*)f_3501},
{"f_3504posixwin.scm",(void*)f_3504},
{"f_3507posixwin.scm",(void*)f_3507},
{"f_3514posixwin.scm",(void*)f_3514},
{"f_3516posixwin.scm",(void*)f_3516},
{"f_3533posixwin.scm",(void*)f_3533},
{"f_3543posixwin.scm",(void*)f_3543},
{"f_3547posixwin.scm",(void*)f_3547},
{"f_3491posixwin.scm",(void*)f_3491},
{"f_3411posixwin.scm",(void*)f_3411},
{"f_3415posixwin.scm",(void*)f_3415},
{"f_3421posixwin.scm",(void*)f_3421},
{"f_3395posixwin.scm",(void*)f_3395},
{"f_3383posixwin.scm",(void*)f_3383},
{"f_3355posixwin.scm",(void*)f_3355},
{"f_3362posixwin.scm",(void*)f_3362},
{"f_3275posixwin.scm",(void*)f_3275},
{"f_3279posixwin.scm",(void*)f_3279},
{"f_3285posixwin.scm",(void*)f_3285},
{"f_3307posixwin.scm",(void*)f_3307},
{"f_3304posixwin.scm",(void*)f_3304},
{"f_3294posixwin.scm",(void*)f_3294},
{"f_3242posixwin.scm",(void*)f_3242},
{"f_3246posixwin.scm",(void*)f_3246},
{"f_3223posixwin.scm",(void*)f_3223},
{"f_3214posixwin.scm",(void*)f_3214},
{"f_3149posixwin.scm",(void*)f_3149},
{"f_3155posixwin.scm",(void*)f_3155},
{"f_3159posixwin.scm",(void*)f_3159},
{"f_3167posixwin.scm",(void*)f_3167},
{"f_3193posixwin.scm",(void*)f_3193},
{"f_3197posixwin.scm",(void*)f_3197},
{"f_3185posixwin.scm",(void*)f_3185},
{"f_3129posixwin.scm",(void*)f_3129},
{"f_3137posixwin.scm",(void*)f_3137},
{"f_3112posixwin.scm",(void*)f_3112},
{"f_3123posixwin.scm",(void*)f_3123},
{"f_3127posixwin.scm",(void*)f_3127},
{"f_3082posixwin.scm",(void*)f_3082},
{"f_3089posixwin.scm",(void*)f_3089},
{"f_3098posixwin.scm",(void*)f_3098},
{"f_3092posixwin.scm",(void*)f_3092},
{"f_3047posixwin.scm",(void*)f_3047},
{"f_3051posixwin.scm",(void*)f_3051},
{"f_3080posixwin.scm",(void*)f_3080},
{"f_3066posixwin.scm",(void*)f_3066},
{"f_3060posixwin.scm",(void*)f_3060},
{"f_3033posixwin.scm",(void*)f_3033},
{"f_3045posixwin.scm",(void*)f_3045},
{"f_3019posixwin.scm",(void*)f_3019},
{"f_3031posixwin.scm",(void*)f_3031},
{"f_3001posixwin.scm",(void*)f_3001},
{"f_3005posixwin.scm",(void*)f_3005},
{"f_3017posixwin.scm",(void*)f_3017},
{"f_2964posixwin.scm",(void*)f_2964},
{"f_2972posixwin.scm",(void*)f_2972},
{"f_2955posixwin.scm",(void*)f_2955},
{"f_2949posixwin.scm",(void*)f_2949},
{"f_2943posixwin.scm",(void*)f_2943},
{"f_2919posixwin.scm",(void*)f_2919},
{"f_2941posixwin.scm",(void*)f_2941},
{"f_2937posixwin.scm",(void*)f_2937},
{"f_2929posixwin.scm",(void*)f_2929},
{"f_2889posixwin.scm",(void*)f_2889},
{"f_2917posixwin.scm",(void*)f_2917},
{"f_2913posixwin.scm",(void*)f_2913},
{"f_2905posixwin.scm",(void*)f_2905},
{"f_2833posixwin.scm",(void*)f_2833},
{"f_2843posixwin.scm",(void*)f_2843},
{"f_2820posixwin.scm",(void*)f_2820},
{"f_2811posixwin.scm",(void*)f_2811},
{"f_2735posixwin.scm",(void*)f_2735},
{"f_2739posixwin.scm",(void*)f_2739},
{"f_2751posixwin.scm",(void*)f_2751},
{"f_2742posixwin.scm",(void*)f_2742},
{"f_2715posixwin.scm",(void*)f_2715},
{"f_2719posixwin.scm",(void*)f_2719},
{"f_2725posixwin.scm",(void*)f_2725},
{"f_2729posixwin.scm",(void*)f_2729},
{"f_2695posixwin.scm",(void*)f_2695},
{"f_2699posixwin.scm",(void*)f_2699},
{"f_2705posixwin.scm",(void*)f_2705},
{"f_2709posixwin.scm",(void*)f_2709},
{"f_2671posixwin.scm",(void*)f_2671},
{"f_2675posixwin.scm",(void*)f_2675},
{"f_2686posixwin.scm",(void*)f_2686},
{"f_2690posixwin.scm",(void*)f_2690},
{"f_2680posixwin.scm",(void*)f_2680},
{"f_2647posixwin.scm",(void*)f_2647},
{"f_2651posixwin.scm",(void*)f_2651},
{"f_2662posixwin.scm",(void*)f_2662},
{"f_2666posixwin.scm",(void*)f_2666},
{"f_2656posixwin.scm",(void*)f_2656},
{"f_2628posixwin.scm",(void*)f_2628},
{"f_2632posixwin.scm",(void*)f_2632},
{"f_2635posixwin.scm",(void*)f_2635},
{"f_2592posixwin.scm",(void*)f_2592},
{"f_2623posixwin.scm",(void*)f_2623},
{"f_2613posixwin.scm",(void*)f_2613},
{"f_2606posixwin.scm",(void*)f_2606},
{"f_2556posixwin.scm",(void*)f_2556},
{"f_2587posixwin.scm",(void*)f_2587},
{"f_2577posixwin.scm",(void*)f_2577},
{"f_2570posixwin.scm",(void*)f_2570},
{"f_2538posixwin.scm",(void*)f_2538},
{"f_2542posixwin.scm",(void*)f_2542},
{"f_2554posixwin.scm",(void*)f_2554},
{"f_2532posixwin.scm",(void*)f_2532},
{"f_2520posixwin.scm",(void*)f_2520},
{"f_2163posixwin.scm",(void*)f_2163},
{"f_2510posixwin.scm",(void*)f_2510},
{"f_2309posixwin.scm",(void*)f_2309},
{"f_2496posixwin.scm",(void*)f_2496},
{"f_2485posixwin.scm",(void*)f_2485},
{"f_2492posixwin.scm",(void*)f_2492},
{"f_2339posixwin.scm",(void*)f_2339},
{"f_2478posixwin.scm",(void*)f_2478},
{"f_2457posixwin.scm",(void*)f_2457},
{"f_2474posixwin.scm",(void*)f_2474},
{"f_2463posixwin.scm",(void*)f_2463},
{"f_2470posixwin.scm",(void*)f_2470},
{"f_2381posixwin.scm",(void*)f_2381},
{"f_2454posixwin.scm",(void*)f_2454},
{"f_2433posixwin.scm",(void*)f_2433},
{"f_2450posixwin.scm",(void*)f_2450},
{"f_2439posixwin.scm",(void*)f_2439},
{"f_2446posixwin.scm",(void*)f_2446},
{"f_2387posixwin.scm",(void*)f_2387},
{"f_2430posixwin.scm",(void*)f_2430},
{"f_2426posixwin.scm",(void*)f_2426},
{"f_2419posixwin.scm",(void*)f_2419},
{"f_2415posixwin.scm",(void*)f_2415},
{"f_2394posixwin.scm",(void*)f_2394},
{"f_2398posixwin.scm",(void*)f_2398},
{"f_2375posixwin.scm",(void*)f_2375},
{"f_2362posixwin.scm",(void*)f_2362},
{"f_2346posixwin.scm",(void*)f_2346},
{"f_2350posixwin.scm",(void*)f_2350},
{"f_2354posixwin.scm",(void*)f_2354},
{"f_2333posixwin.scm",(void*)f_2333},
{"f_2320posixwin.scm",(void*)f_2320},
{"f_2316posixwin.scm",(void*)f_2316},
{"f_2303posixwin.scm",(void*)f_2303},
{"f_2170posixwin.scm",(void*)f_2170},
{"f_2289posixwin.scm",(void*)f_2289},
{"f_2177posixwin.scm",(void*)f_2177},
{"f_2179posixwin.scm",(void*)f_2179},
{"f_2186posixwin.scm",(void*)f_2186},
{"f_2261posixwin.scm",(void*)f_2261},
{"f_2270posixwin.scm",(void*)f_2270},
{"f_2258posixwin.scm",(void*)f_2258},
{"f_2192posixwin.scm",(void*)f_2192},
{"f_2239posixwin.scm",(void*)f_2239},
{"f_2227posixwin.scm",(void*)f_2227},
{"f_2235posixwin.scm",(void*)f_2235},
{"f_2231posixwin.scm",(void*)f_2231},
{"f_2208posixwin.scm",(void*)f_2208},
{"f_2216posixwin.scm",(void*)f_2216},
{"f_2212posixwin.scm",(void*)f_2212},
{"f_2107posixwin.scm",(void*)f_2107},
{"f_2116posixwin.scm",(void*)f_2116},
{"f_2140posixwin.scm",(void*)f_2140},
{"f_2152posixwin.scm",(void*)f_2152},
{"f_2158posixwin.scm",(void*)f_2158},
{"f_2146posixwin.scm",(void*)f_2146},
{"f_2122posixwin.scm",(void*)f_2122},
{"f_2128posixwin.scm",(void*)f_2128},
{"f_2114posixwin.scm",(void*)f_2114},
{"f_2096posixwin.scm",(void*)f_2096},
{"f_2091posixwin.scm",(void*)f_2091},
{"f_2040posixwin.scm",(void*)f_2040},
{"f_2044posixwin.scm",(void*)f_2044},
{"f_2053posixwin.scm",(void*)f_2053},
{"f_2056posixwin.scm",(void*)f_2056},
{"f_2013posixwin.scm",(void*)f_2013},
{"f_2038posixwin.scm",(void*)f_2038},
{"f_2034posixwin.scm",(void*)f_2034},
{"f_2020posixwin.scm",(void*)f_2020},
{"f_1853posixwin.scm",(void*)f_1853},
{"f_1961posixwin.scm",(void*)f_1961},
{"f_1969posixwin.scm",(void*)f_1969},
{"f_1956posixwin.scm",(void*)f_1956},
{"f_1855posixwin.scm",(void*)f_1855},
{"f_1862posixwin.scm",(void*)f_1862},
{"f_1865posixwin.scm",(void*)f_1865},
{"f_1868posixwin.scm",(void*)f_1868},
{"f_1955posixwin.scm",(void*)f_1955},
{"f_1872posixwin.scm",(void*)f_1872},
{"f_1889posixwin.scm",(void*)f_1889},
{"f_1899posixwin.scm",(void*)f_1899},
{"f_1911posixwin.scm",(void*)f_1911},
{"f_1921posixwin.scm",(void*)f_1921},
{"f_1881posixwin.scm",(void*)f_1881},
{"f_1826posixwin.scm",(void*)f_1826},
{"f_1851posixwin.scm",(void*)f_1851},
{"f_1847posixwin.scm",(void*)f_1847},
{"f_1839posixwin.scm",(void*)f_1839},
{"f_1799posixwin.scm",(void*)f_1799},
{"f_1824posixwin.scm",(void*)f_1824},
{"f_1820posixwin.scm",(void*)f_1820},
{"f_1812posixwin.scm",(void*)f_1812},
{"f_1686posixwin.scm",(void*)f_1686},
{"f_1690posixwin.scm",(void*)f_1690},
{"f_1761posixwin.scm",(void*)f_1761},
{"f_1778posixwin.scm",(void*)f_1778},
{"f_1770posixwin.scm",(void*)f_1770},
{"f_1699posixwin.scm",(void*)f_1699},
{"f_1702posixwin.scm",(void*)f_1702},
{"f_1710posixwin.scm",(void*)f_1710},
{"f_1715posixwin.scm",(void*)f_1715},
{"f_1741posixwin.scm",(void*)f_1741},
{"f_1744posixwin.scm",(void*)f_1744},
{"f_1721posixwin.scm",(void*)f_1721},
{"f_1738posixwin.scm",(void*)f_1738},
{"f_1730posixwin.scm",(void*)f_1730},
{"f_1622posixwin.scm",(void*)f_1622},
{"f_1635posixwin.scm",(void*)f_1635},
{"f_1650posixwin.scm",(void*)f_1650},
{"f_1641posixwin.scm",(void*)f_1641},
{"f_1644posixwin.scm",(void*)f_1644},
{"f_1582posixwin.scm",(void*)f_1582},
{"f_1601posixwin.scm",(void*)f_1601},
{"f_1586posixwin.scm",(void*)f_1586},
{"f_1595posixwin.scm",(void*)f_1595},
{"f_1589posixwin.scm",(void*)f_1589},
{"f_1549posixwin.scm",(void*)f_1549},
{"f_1551posixwin.scm",(void*)f_1551},
{"f_1544posixwin.scm",(void*)f_1544},
{"f_1521posixwin.scm",(void*)f_1521},
{"f_1542posixwin.scm",(void*)f_1542},
{"f_1528posixwin.scm",(void*)f_1528},
{"f_1515posixwin.scm",(void*)f_1515},
{"f_1519posixwin.scm",(void*)f_1519},
{"f_1509posixwin.scm",(void*)f_1509},
{"f_1513posixwin.scm",(void*)f_1513},
{"f_1503posixwin.scm",(void*)f_1503},
{"f_1507posixwin.scm",(void*)f_1507},
{"f_1497posixwin.scm",(void*)f_1497},
{"f_1501posixwin.scm",(void*)f_1501},
{"f_1491posixwin.scm",(void*)f_1491},
{"f_1495posixwin.scm",(void*)f_1495},
{"f_1485posixwin.scm",(void*)f_1485},
{"f_1489posixwin.scm",(void*)f_1489},
{"f_1454posixwin.scm",(void*)f_1454},
{"f_1458posixwin.scm",(void*)f_1458},
{"f_1461posixwin.scm",(void*)f_1461},
{"f_1416posixwin.scm",(void*)f_1416},
{"f_1449posixwin.scm",(void*)f_1449},
{"f_1445posixwin.scm",(void*)f_1445},
{"f_1420posixwin.scm",(void*)f_1420},
{"f_1429posixwin.scm",(void*)f_1429},
{"f_1378posixwin.scm",(void*)f_1378},
{"f_1385posixwin.scm",(void*)f_1385},
{"f_1388posixwin.scm",(void*)f_1388},
{"f_1408posixwin.scm",(void*)f_1408},
{"f_1391posixwin.scm",(void*)f_1391},
{"f_1398posixwin.scm",(void*)f_1398},
{"f_1336posixwin.scm",(void*)f_1336},
{"f_1343posixwin.scm",(void*)f_1343},
{"f_1358posixwin.scm",(void*)f_1358},
{"f_1352posixwin.scm",(void*)f_1352},
{"f_1291posixwin.scm",(void*)f_1291},
{"f_1301posixwin.scm",(void*)f_1301},
{"f_1304posixwin.scm",(void*)f_1304},
{"f_1316posixwin.scm",(void*)f_1316},
{"f_1307posixwin.scm",(void*)f_1307},
{"f_1273posixwin.scm",(void*)f_1273},
{"f_1286posixwin.scm",(void*)f_1286},
{"f_1232posixwin.scm",(void*)f_1232},
{"f_1265posixwin.scm",(void*)f_1265},
{"f_1249posixwin.scm",(void*)f_1249},
{"f_1258posixwin.scm",(void*)f_1258},
{"f_1252posixwin.scm",(void*)f_1252},
{"f_1186posixwin.scm",(void*)f_1186},
{"f_1190posixwin.scm",(void*)f_1190},
{"f_1201posixwin.scm",(void*)f_1201},
{"f_1197posixwin.scm",(void*)f_1197},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
