// Chip's Workshop - a level editor for Chip's Challenge.
// Copyright 2008-2009 Christopher Elsby <glarbex@glarbex.com>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of version 2 of the GNU General Public License as
// published by the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef CHIPW_LEVELEDITFRAME_H_INCLUDED
#define CHIPW_LEVELEDITFRAME_H_INCLUDED

#include "sdidocframe.h"
#include <map>
#include <vector>

class wxDocManager;

namespace ChipW {

class LevelEditFrame : public SDIDocFrame {
public:
    LevelEditFrame() { }
    LevelEditFrame(wxDocManager* manager, wxFrame* parent = NULL, bool isspare = true) {Create(manager, parent, isspare);}
    LevelEditFrame(wxView* newview, wxFrame* parent = NULL) {Create(newview, parent);}
    virtual ~LevelEditFrame();
    bool Create(wxDocManager* manager, wxFrame* parent = NULL, bool isspare = true);
    bool Create(wxView* newview, wxFrame* parent = NULL);
    void OnExit(wxCommandEvent& event);
    static LevelEditFrame* GetSpareOrNew(wxView* view);
private:
    bool CreateMenuBar();
    void OnCommand(wxCommandEvent& event);
    void OnUpdateUI(wxUpdateUIEvent& event);
    static std::map<wxDocManager*, std::vector<LevelEditFrame*> > spare;
    DECLARE_CLASS(LevelEditFrame)
    DECLARE_EVENT_TABLE()
};

}

#endif // !CHIPW_LEVELEDITFRAME_H_INCLUDED
