/*
 * loader/loader-linux.S
 * 
 * Linux loader.
 * 
 * This needs some major cleanup...
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 */

#include <chos/module.h>
#include <chos/chos.h>
#include <chos/mapfile.h>
#include <chos/address.h>
#include <chos/linux.h>
#include <chos/module.h>

.globl _main

.org    LOADER_OFF
_main:  jmp     load_linux

.org    LOADER_OFF+2
chos_id:	.ascii	"CHO"		! cs:2 = "CHO"
chos_stage:	.byte	BIT_LINUX|0x10	! cs:3 = type
chos_major:	.byte	CHOS_MAJOR	! cs:6 = major version #
chos_minor:	.byte   CHOS_MINOR	! cs:7 = minor version #

vga_mode:	.word	0

load_linux:
// Handle command line stuff
//////////////////////////////
	cmp	byte ptr ask_cmdline,#1
	jne	li_no_ask_cmdline
	
	mov	di,#DEF_CL_OFF		// Read the command line over
	mov	dx,#CL_MAX_LEN		// the loaded default.
	CALL(get_cmdline)
	
li_no_ask_cmdline:
	call	process_cmd_line

	mov	si,image
	
#ifdef SUPPORT_INITRD
// Possibly load initial ramdisk
//////////////////////////////////
	test	word ptr (si+BID_FLAGS_OFF),#LINF_INITRD
	jz	li_no_initrd
	
	// Save first mapsector at 0x7c000
	push	ds
	pop	es
	mov	si,#MAP_OFF
	mov	di,#BSECT_OFF
	mov	cx,#256
	rep	
	movsw
	
	call	li_load_initrd
	
	// Restore first mapsector 
	push	ds
	pop	es
	mov	di,#MAP_OFF
	mov	si,#BSECT_OFF
	mov	cx,#256
	rep	
	movsw
		
	mov	si,image
li_no_initrd:
#endif

	CALL(tell_loading)

	mov	dl,[LI_DRIVE_OFF]	// image is on.
	mov	drive,dl		// save it - we need it later
	// CALL(reset_drive)

// Load Linux floppy bootsector
/////////////////////////////////
	mov	cl,dl	
	mov	ax,[LI_FBSECT_OFF]
	mov	dx,[LI_FBSECT_OFF+2]
	mov	bx,#INITSEG
	mov	es,bx
	xor	bx,bx	
	CALL(read_linear)

// Tell about a command line and set vga mode
///////////////////////////////////////////////
	seg	es
	mov	(CL_MAGIC_ADDR),#CL_MAGIC
	seg	es
	mov	(CL_OFFSET),#CMDLINE_OFF
	cmp	word ptr vga_mode,#0
	je	li_no_set_vga
	mov	ax,vga_mode
	seg	es
	mov	(506),ax
li_no_set_vga:
	CALL(print_period)

// Load linux setup sectors at 0x90200	
////////////////////////////////////////
	CALL(load_next_map)
	mov	di,#SETUPSEG
	mov	es,di
	mov	di,#MAP_OFF
	xor	bx,bx
load_setup:
	mov	cl,drive
	mov	ax,(di)
	mov	dx,(di+2)
	CALL(read_linear)
	jc	setup_done
	add	di,#4
	add	bx,#SECTORSIZE		// setup is always<segment_size
	jmp	load_setup
setup_done:
	mov	si,image
	test	word ptr(si+BID_FLAGS_OFF),#LINF_NEW
	jz	li_not_new
	seg	es
	 mov	LI_LOADER_TYPE_OFF,#LI_LOADER_TYPE_CHOS

#ifdef SUPPORT_INITRD
	// set the pointers...
	test	word ptr(si+BID_FLAGS_OFF),#LINF_INITRD
	jz	li_no_initrd2
	call	li_setup_initrd
	
li_no_initrd2:
#endif
li_not_new:

	mov	byte ptr load_high,#0
#ifdef SUPPORT_BZIMAGE
	mov	si,image
	test	word ptr(si+BID_FLAGS_OFF),#LINF_BIG
	jz	li_not_big
	call	li_setup_big
li_not_big:
#endif /* BZIMAGE */
	CALL(print_period)
	
// Load the kernel either at 0x10000 (zImage) or 0x100000 (bzImage)
//////////////////////////////////////////////////////////////////////
	mov	bx,#SYSSEG
	mov	es,bx
	xor	bx,bx
	add	di,#4
	
	CALL(load_it)
	
	CALL(end_load)

	mov	ax,#INITSEG
	mov	es,ax
	mov	ds,ax
	jmpi	#0,#SETUPSEG		// Here we go...


// bzImage setup stuff
////////////////////////
#ifdef SUPPORT_BZIMAGE
// setup linux setup sector
li_setup_big:
	seg	es
	 mov	dword ptr LI_LOAD_ADDRESS_OFF,#LI_BIG_LOAD_ADDRESS
	seg	es
	 mov	byte ptr LI_LOAD_FLAGS_OFF,#LI_LOAD_FLAG_HIGH
	
	// setup gdt (initrd loader may have modified it)
	mov	word ptr copy_dst_base,#0x00
	mov	byte ptr copy_dst_base+2,#0x10
	mov	byte ptr copy_dst_base24,#0x00
	
	mov	byte ptr load_high,#1
	
	ret
#endif /* BZIMAGE */

// Process the command line.
// Checks command line for stuff like vga=,read-only 'n sets stuff correctly
//  * also removes spaces 'n 'em from the command line 'n copies it to other
// place.
//
// This should really be cleaned up a bit :)
//////////////////////////////////////////////////////////////////////////////

#define	CHAR_SPACE	32
#define	TEXT_VGAIS	0x3d616776	// "vga=" in hex

process_cmd_line:
	mov	bp,#DEF_CL_OFF
	mov	di,#CMDLINE_OFF	
	mov	ax,#INITSEG
	mov	es,ax
	mov	ax,#STAGE2_SEG		// have to use 'seg gs'
	mov	gs,ax			// - 'ss' is default segment for 'bp'
	
process_loop:
	jmp	fnd_done
find_done:
	jmp	check_special		// is it vga= or something else?
li_no_special:				// Ok, ain't special - copy it
	seg	gs
	mov	al,(bp)
	cmp	al,#0
	je	outta_here
	inc	bp
	seg	es
	mov	(di),al
	inc	di
	cmp	al,#CHAR_SPACE
	je	fnd_done
	jmp	li_no_special
	
outta_here:
	cmp	di,#CMDLINE_OFF
	je	cont_out
	seg	es
	cmp	byte ptr (di-1),#CHAR_SPACE
	je	cont_out
	seg	es
	mov	byte ptr (di),#CHAR_SPACE
	inc	di

cont_out:
	
	cld
	
	// Pass "auto" on the command line if automagically booted (not started with space).
	
	cmp	byte ptr ask_cmdline,#1
	je	li_no_auto_boot
	mov	si,#auto_boot_str
	mov	cx,#5
	rep
	 movsb

li_no_auto_boot:
	// set BOOT_IMAGE=image_name
	mov	si,#boot_image_str
	mov	cx,#11
	rep
	 movsb
	mov	si,image
	mov	cx,#BID_NAME_LEN
	cld
	rep
	 movsb
	
	mov	byte ptr (di),#0
	
	ret				// Done.
	
find_next:				// skip until space or 0
	seg	gs
	cmp	byte ptr (bp),#0
	je	outta_here
	seg	gs
	cmp	byte ptr (bp),#CHAR_SPACE
	je	fnd_done
	inc	bp
	jmp	find_next

fnd_done:	
	seg	gs
	cmp	byte ptr (bp),#0
	je	outta_here
	seg	gs
	cmp	byte ptr (bp),#CHAR_SPACE
	jne	find_done
	inc	bp
	jmp	fnd_done


check_special:				// check if the entry is special
	seg	gs
	cmp	dword ptr (bp),#TEXT_VGAIS
	je	do_vga
	jmp	li_no_special

do_vga:					// sets vga mode
	add	bp,#4
	seg	gs
	mov	al,(bp)
	cmp	al,#48			// is a hex number ?
	je	vga_number

	push	di
	mov	di,#vga_tbl-1
vga_loop1:
	push	bp
	dec	bp
vga_loop2:
	inc	bp
	inc	di
	seg	gs
	mov	al,(bp)
	CALL(toupper)
	cmp	al,#0
	je	vga_done
	cmp	al,#CHAR_SPACE
	je	vga_done
	cmp	al,(di)
	je	vga_loop2
		
vga_next:
	pop	bp
	dec	di
next_vga:
	inc	di
	cmp	byte ptr (di),#0
	jne	next_vga
	add	di,#2
	cmp	byte ptr (di+1),#0
	je	vga_error
	jmp	vga_loop1
	
vga_done:
	cmp	byte ptr (di),#0
	jne	vga_next
	
vga_ok:
	mov	ax,(di+1)
	mov	vga_mode,ax
	pop	ax			// =bp
	pop	di
	br	process_loop

vga_error:
	pop	di
vga_err2:
	jmp	find_next

vga_number:
	seg	gs			// vga mode is a hex number...
	cmp	byte ptr (bp+1),#0x78	// is it 'x'
	jne	vga_err2		// nope, not hexadecimal ( or, at least
					// we think so...
	add	bp,#2
	xor	dx,dx
hex_loop:
	seg	gs
	mov	al,(bp)
	cmp	al,#CHAR_SPACE
	je	vga_num_done
	cmp	al,#0
	je	vga_num_done
	call	ascii2hex
	shl	dx,#4
	or	dl,al
	inc	bp
	jmp	hex_loop
vga_num_done:
	mov	vga_mode,dx
	br	process_loop



// Convert ASCii char in AL to hexadecimal. 
// Doesn't check for non-hex characters. :(
/////////////////////////////////////////////
ascii2hex:
	sub	al,#48
	cmp	al,#9
	jna	asc2hex_done
	sub	al,#65-48-10
asc2hex_done:
	and	al,#0xf		
	ret


// Includes
/////////////
#include "initrd.S"

// Data
/////////
vga_tbl:	
	.ascii	"EXTENDED"
	.byte	0
	.word	0xfffe
	.ascii	"ASK"
	.byte	0
	.word	0xfffd
	.ascii	"NORMAL"
	.byte	0
	.word	0xffff
	.byte	0

boot_image_str:
	.ascii	"BOOT_IMAGE="
//	.byte	0x22 // hmm... what was this doing here?
	
auto_boot_str:
	.ascii	"auto "

