use strict;
use warnings;
use Module::Build::CipUX;

use version; our $VERSION = qv('3.4.0.2');

my $builder = Module::Build::CipUX->new(
    module_name   => 'CipUX::CAT::Web',
    license       => 'gpl2',
    dist_author   => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version  => "$VERSION",
    dist_abstract => 'CAT - CipUX administration Tool',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    verbose     => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'Test::Perl::Critic'      => 0,
        'Test::Pod::Coverage'     => '1.04',
        'Module::List::Pluggable' => '0.08',
        'Filesys::DiskFree'       => 0,
        'Sys::Info::OS'           => 0,
        'Sys::Info'               => 0,
        'Sys::MemInfo'            => 0,
    },

    build_requires => {
        'Module::Build'        => 0,
        'Module::Build::CipUX' => '0.3.0',
        'Test::More'           => 0,
        'Test::Pod'            => '1.14',
    },

    requires => {
        'version'            => 0,
        'Carp'               => 0,
        'CGI'                => 0,
        'CGI::FormBuilder'   => 0,
        'Class::Std'         => '0.0.9',
        'CipUX'              => '3.4.0.0',
        'CipUX::RPC::Client' => '3.4.0.6',

        #'Contextual::Return' => 0,
        'Cwd'          => 0,
        'Data::Dumper' => 0,
        'Date::Manip'  => 0,

        #'File::Basename'     => 0,
        #'File::Spec'         => 0,
        'Getopt::Long'              => 0,
        'Locale::Maketext'          => 0,
        'Locale::Maketext::Lexicon' => 0,
        'Log::Log4perl'             => 0,
        'Module::Pluggable'         => 0,
        'Pod::Usage'                => 0,
        'POSIX'                     => 0,
        'Readonly'                  => 0,
        'Scalar::Util::Numeric'     => 0,
        'Template'                  => 0,

        #'Text::ParseWords'   => 0,
        'version' => 0,

    },

    logforperl_files => {
        'usr/share/cipux/etc/cipux-cat-web.log4perl' =>
            'logforperl/cipux-cat-web.log4perl',
    },
    install_path => { logforperl => '/usr/share/cipux/etc', },

    add_to_cleanup => ['CipUX-CAT-Web-*'],
);

# new BUILD and INSTALL target (lib/*/*.po)
# (will install all po files under lib)
$builder->add_build_element('po');
$builder->add_build_element('ini');
$builder->add_build_element('logforperl');

# BUILD target

#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->create_build_script();
