package CipUX::CAT::Web::Module::ExternalLink;

use warnings;
use strict;
use English qw( -no_match_vars);
use Log::Log4perl qw(get_logger :levels);
use base qw(CipUX::CAT::Web::Module CipUX::CAT::Web::L10N);

{

    use version; our $VERSION = qv('3.4.0.2');
    use re 'taint';    # Keep data captured by parentheses tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safer

    Readonly::Scalar my $NAME   => 'externallink';
    Readonly::Scalar my $MODULE => 'externallink.cgi';

    sub register {

        my $self = shift;

        $self->set_module_name_register(
            { class => __PACKAGE__, name => $MODULE } );

        # Merge and set the configuration
        my $cfg_ar = $self->module_cfg;
        $self->set_module_cfg_register(
            { cfg_ar => $cfg_ar, name => $MODULE } );

        return 1;
    }

    sub module_cfg : CUMULATIVE(BASE FIRST) {

        my $self = shift;

        my $sdesc = 'Extarnal link list';
        my $ldesc = 'List external links for convenience. ';

        my $module_hr = {};
        $module_hr->{cipuxName}             = $NAME;
        $module_hr->{cipuxTemplateDir}      = $NAME;
        $module_hr->{cipuxIcon}             = $NAME . '.png';
        $module_hr->{cipuxShortDescription} = $sdesc;
        $module_hr->{cipuxDescription}      = $ldesc;
        $module_hr->{cipuxTask}             = ['NULL'];

        return [$module_hr];
    }

    sub module {

        my ( $self, $arg_r ) = @_;

        my $rpc
            = ( exists $arg_r->{rpc_obj} )
            ? $arg_r->{rpc_obj}
            : $self->perr('rpc_obj');
        my $lh
            = ( exists $arg_r->{lh_obj} )
            ? $arg_r->{lh_obj}
            : $self->perr('lh_obj');
        my $c_hr
            = ( exists $arg_r->{c_hr} )
            ? $arg_r->{c_hr}
            : $self->perr('c_hr');

        my $l = get_logger(__PACKAGE__);
        $l->debug("module [$MODULE]");

        my $path = "tpl/$c_hr->{cat_theme}/$NAME";
        $l->debug("template path [$path]");

        my $data_ar = [
            {
                url  => 'http://www.cipux.org',
                text => 'CipUX Main Website'
            },
            {
                url  => 'http://wiki.debian.org/CipUX',
                text => 'English CipUX Wiki'
            },
            {
                url  => 'http://wiki.skolelinux.de/CipUX',
                text => 'German CipUX Wiki'
            },
            {
                url  => 'http://release.cipux.org',
                text => 'CipUX Release Repository'
            },
        ];

        return {

            layout => "$path/layout.html",

            layout_ar => [
                { begin_html => 1, },
                { body_ar    => [ $lh->maketext('External link list') ] },
                {
                    tt2_hr => {
                        tpl      => "$path/index.html",
                        param_hr => {
                            DATA   => $data_ar,
                            MODULE => $MODULE,
                            PATH   => $path,
                            lh     => $lh,
                        },
                    }
                },
                { footer_hr => { show_index_back => 1, }, },
                { end_html  => 1, },
            ],
        };

    }
}

1;

__END__

=pod

=head1 NAME

CipUX::CAT::Web::Module::ExternalLink - Lists all perl versions of CipUX


=head1 VERSION

This document describes CipUX::CAT::Web::Module::ExternalLink version 3.4.0.2


=head1 SYNOPSIS

This CAT Web module can be used to see installed CipUX Perl module versions.

=head1 DESCRIPTION


This CAT Web module can be used to see installed CipUX Perl module versions.

=head1 INTERFACE

=head2 module

Use this method to start the list.

=head1 DIAGNOSTICS

Throws the error

  To use this module, please install Module::List::Pluggable!

if Module::List::Pluggable is not installed.

=head1 CONFIGURATION AND ENVIRONMENT

CipUX::CAT::Web::Module::ExternalLink requires no configuration files or
environment variables. However it merges its configuration from
CipUX::CAT::Web::Module and itself.


=head1 DEPENDENCIES

 Log::Log4perl
 CipUX::CAT::Web::Module
 Module::List::Pluggable

=head1 INCOMPATIBILITIES

None reported.


=head1 BUGS AND LIMITATIONS

No bugs have been reported.


=head1 AUTHOR

Christian Kuelker  C<< <christian.kuelker@cipworx.org> >>


=head1 LICENCE AND COPYRIGHT

Copyright (C) 2010, Christian Kuelker
C<< <christian.kuelker@cipworx.org> >>. All rights reserved.

This module is free software; you can redistribute it and/or modify it under
the GNU GPL licence version 2 or any later version.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENCE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.

=cut
