# +========================================================================+
# || Copyright (C) 2009 by Christian Kuelker                              ||
# ||                                                                      ||
# || License: GNU General Public License - GNU GPL - version 2            ||
# ||          or (at your opinion) any later version                      ||
# +========================================================================+
#  ID:       $ID$
#  Revision: $Revision$
#  Head URL: $Head URL$
#  Date:     $Date$
#  Source:   $Source$

package CipUX::CAT::Web::Module::ModuleBrowser;

use warnings;
use strict;
use CipUX::CAT::Web::Plugin;
use base qw(CipUX::CAT::Web::Module);

{

    use version; our $VERSION = qv('3.4.0.2');
    use re 'taint';    # Keep data captured by parens tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safer

    # CONST
    Readonly::Scalar my $EMPTY_STRING => q{};
    Readonly::Hash my %MODULE =>
        ( 'module_browser.cgi' => { name => 'module browser', }, );

    # OBJECT
    my %name_of : ATTR( init_arg => 'name' :default('noname') );

    # METHOD
    sub register {

        my $self = shift;

        my $c = __PACKAGE__;    # module class name
        foreach my $m ( sort keys %MODULE ) {
            my $n = $MODULE{$m}->{name};
            $self->set_module_name_register( { class => $c, name => $m } );
            my $c_ar = $self->module_cfg( $self, $m, $n );
            $self->set_module_cfg_register( { cfg_ar => $c_ar, name => $m } );
        }

        return 1;

    }

    sub module_cfg : CUMULATIVE(BASE FIRST) {

        my $self   = shift;    # TODO: sometimes not blessed, why?
        my $module = shift;
        my $name   = shift;

        my $desc = "Browse CAT module data";
        my $ldesc
            = "This module can be use to see technical data concerning modules.";
        my $module_hr = {};
        $module_hr->{cipuxName}             = $name;
        $module_hr->{cipuxTemplateDir}      = 'module_browser';
        $module_hr->{cipuxIcon}             = 'module.png';
        $module_hr->{cipuxDescription}      = $ldesc;
        $module_hr->{cipuxShortDescription} = $desc;
        $module_hr->{cipuxTask}             = 'NULL';

        return [$module_hr];
    }

    sub module {

        my ( $self, $arg_r ) = @_;

        # will be used to differentiate output/usage
        my $module
            = exists $arg_r->{module}
            ? $self->l( $arg_r->{module} )
            : 'module_browser.cgi';
        my $lh
            = ( exists $arg_r->{lh_obj} )
            ? $arg_r->{lh_obj}
            : $self->perr('lh_obj');

        my $c_hr
            = ( exists $arg_r->{c_hr} )
            ? $arg_r->{c_hr}
            : $self->perr('c_hr');

        my $plugin = CipUX::CAT::Web::Module->new();
        $plugin->init();

        # module =module_browser.cgi
        my @tpl_data = ();
        my $p_hr     = $plugin->get_module_name_register();
        my $o_hr     = $plugin->get_module_cfg_register();
        foreach my $o ( sort keys %{$p_hr} ) {

            # to provide all data:
            #$o_hr->{$o}->{name}        = $o;
            #$o_hr->{$o}->{provided_by} = $p_hr->{$o};
            #push @tpl_data, $o_hr->{$o};

            # but we do only provide some
            my $data_hr = {

                #  MODULE $o povided by $p_hr->{$o}
                name        => $o,
                provided_by => $p_hr->{$o},
                task        => $o_hr->{$o}->{cipuxTask},
            };
            push @tpl_data, $data_hr;
        }

        my $path = "tpl/$c_hr->{cat_theme}";

        my $style    = $path . '/form.css';
        my $template = $path . '/module_browser/index.html';
        my $layout   = $path . '/module_browser/layout.html';

        return {
            cookie_hr => {},
            layout    => $layout,
            layout_ar => [
                { begin_html => 1, },
		                { body_ar    => [ $lh->maketext('Module Browser')] },

                {
                    tt2_hr => {
                        tpl      => $template,
                        param_hr => {
                            SHOW_DEBUG => 0,
                            DATA       => \@tpl_data,
                            MODULE     => $name_of{ ident $self},
                            PATH       => $path,
                            lh         => $lh,
                        },

                    }
                },

                #{ formbuilder_hr => { form => $form }, },
                {
                    footer_hr =>
                        { show_index_back => 1, show_script_back => 0 },
                },
                { end_html => 1, },
            ],

        };
    }

}

1;

__END__

